/**
 *	Copy Account ElementValues
 */
DECLARE
	CURSOR Cur_EV IS
		SELECT * FROM C_ElementValue
		WHERE C_Element_ID=100
		AND C_ElementValue_ID > 1000000;
	--
	ToElement_ID 	NUMBER := 100;
	ToClient_ID		NUMBER := 10;
	ToOrg_ID		NUMBER := 0;
	NextNo			NUMBER;
BEGIN
	FOR i IN Cur_EV LOOP
	    AD_Sequence_Next('C_ElementValue', ToClient_ID, NextNo);
		INSERT INTO C_ElementValue
			(C_ElementValue_ID,
			AD_CLIENT_ID, AD_ORG_ID, ISACTIVE, CREATED, CREATEDBY, UPDATED, UPDATEDBY,
			VALUE, NAME, DESCRIPTION, 
			ACCOUNTTYPE, ACCOUNTSIGN, ISDOCCONTROLLED,
			C_ELEMENT_ID,
			ISSUMMARY, VALIDFROM, VALIDTO,
			POSTACTUAL, POSTBUDGET, POSTENCUMBRANCE, POSTSTATISTICAL, 
			ISFOREIGNCURRENCY, C_CURRENCY_ID)
		VALUES
			(NextNo,
			ToClient_ID, ToOrg_ID, i.ISACTIVE, i.CREATED, i.CREATEDBY, i.UPDATED, i.UPDATEDBY,
			i.VALUE || 'x', i.NAME, i.DESCRIPTION, 
			i.ACCOUNTTYPE, i.ACCOUNTSIGN, i.ISDOCCONTROLLED,
			ToElement_ID,
			i.ISSUMMARY, i.VALIDFROM, i.VALIDTO,
			i.POSTACTUAL, i.POSTBUDGET, i.POSTENCUMBRANCE, i.POSTSTATISTICAL, 
			i.ISFOREIGNCURRENCY, i.C_CURRENCY_ID);
		DBMS_OUTPUT.PUT_LINE('added: ' || i.Value || ' ' || i.Name);
	END LOOP;
	COMMIT;
END;
		
