/* Captcha.java

{{IS_NOTE
	Purpose:
		
	Description:
		
	History:
		Tue Oct 22 09:27:29     2008, Created by Flyworld
}}IS_NOTE

Copyright (C) 2008 Potix Corporation. All Rights Reserved.

{{IS_RIGHT
	This program is distributed under GPL Version 3.0 in the hope that
	it will be useful, but WITHOUT ANY WARRANTY.
}}IS_RIGHT
 */
package org.zkoss.zul.api;

import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.WrongValueException;
import org.zkoss.zul.impl.CaptchaEngine;
import java.awt.Font;
import java.util.List;

/**
 * The generic captcha component.
 * 
 * @author henrichen
 * @since 3.5.2
 */
public interface Captcha extends org.zkoss.zul.api.Image {
	/**
	 * Gets fonts list, default provide two fonts.
	 */
	public List getFonts();

	/**
	 * Gets the default font list.
	 */
	public Font[] getDefaultFonts();

	/**
	 * Get nth Font.
	 */
	public Font getFont(int j);

	/**
	 * Add fonts into fonts list. If you did not add fonts, the default
	 * implementation would use the default fonts; i.e. bold Arial 35, and bold
	 * courier 35.
	 */
	public void addFont(Font font);

	/**
	 * Set font color.
	 */
	public void setFontColor(String color);

	/**
	 * Gets font color.
	 */
	public String getFontColor();

	/**
	 * Get the font color in int array (0: red, 1: green, 2:blue).
	 */
	public int getFontRGB();

	/**
	 * Set the background color of the chart.
	 * 
	 * @param color
	 *            in #RRGGBB format (hexdecimal).
	 */
	public void setBgColor(String color);

	/**
	 * Get the background color of the captcha box (in string as #RRGGBB). null
	 * means default.
	 */
	public String getBgColor();

	/**
	 * Get the background color in int array (0: red, 1: green, 2:blue). null
	 * means default.
	 */
	public int getBgRGB();

	/**
	 * Get the captcha int width in pixel; to be used by the derived subclass.
	 */
	public int getIntWidth();

	/**
	 * Get the captcha int height in pixel; to be used by the derived subclass.
	 */
	public int getIntHeight();

	/**
	 * Get the text value of this captcha.
	 */
	public String getValue();

	/**
	 * Set the text value to be shown as the distortion captcha.
	 * 
	 * @param text
	 *            the captcha text value
	 */
	public void setValue(String text) throws WrongValueException;

	/**
	 * Set length of the autogenerated text value; default to 5.
	 */
	public void setLength(int len);

	/**
	 * Get length of the autogenerated text value; default to 5.
	 */
	public int getLength();

	/**
	 * Set exclude characters that will not be generated. Note that only digit
	 * and character is used in generating text value. If you leave exclude
	 * null, the default exclude list will be applied; i.e., 0123456789IilOo
	 * (only character (no digits) are used except I, i, l, O(big O), o(small
	 * o))
	 */
	public void setExclude(String exclude);

	/**
	 * Get exclude characters.
	 */
	public String getExclude();

	/**
	 * Wheather generate noise; default to true.
	 */
	public void setNoise(boolean b);

	/**
	 * Whether generate noise; default to true.
	 */
	public boolean isNoise();

	/**
	 * Regenerates new captcha text value and redraw.
	 */
	public String randomValue();

	/**
	 * Sets the captcha engine by use of a class name. It creates an instance
	 * automatically.
	 */
	public void setEngine(String clsnm) throws ClassNotFoundException,
			NoSuchMethodException, IllegalAccessException,
			InstantiationException, java.lang.reflect.InvocationTargetException;

	/**
	 * Set the captcha engine.
	 */
	public void setEngine(CaptchaEngine engine);

	/**
	 * Get the captcha engine.
	 * 
	 * @exception UiException
	 *                if failed to load the engine.
	 */
	public CaptchaEngine getCaptchaEngine() throws UiException;

}
