/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ddlutils.task;

import java.io.File;
import java.io.FileOutputStream;
import org.apache.ddlutils.Platform;
import org.apache.ddlutils.io.DataWriter;
import org.apache.ddlutils.model.Database;
import org.apache.ddlutils.model.Table;
import org.apache.ddlutils.task.ConvertingDatabaseCommand;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class WriteDataToFileCommand
extends ConvertingDatabaseCommand {
    private File _outputFile;
    private String _encoding;
    private String _destination;

    public void setOutputFile(File outputFile) {
        this._outputFile = outputFile;
    }

    public void setEncoding(String encoding) {
        this._encoding = encoding;
    }

    public void setDestination(String destination) {
        this._destination = destination;
    }

    public void execute(Task task, Database model) throws BuildException {
        try {
            Platform platform = this.getPlatform();
            Table[] tables = new Table[1];
            if (this._outputFile != null) {
                DataWriter writer = new DataWriter(new FileOutputStream(this._outputFile), this._encoding);
                this.registerConverters(writer.getConverterConfiguration());
                writer.writeDocumentStart();
                int idx = 0;
                while (idx < model.getTableCount()) {
                    tables[0] = model.getTable(idx);
                    writer.write(platform.query(model, "select * from " + tables[0].getName(), tables));
                    ++idx;
                }
                writer.writeDocumentEnd();
            } else {
                int idx = 0;
                while (idx < model.getTableCount()) {
                    tables[0] = model.getTable(idx);
                    String outputFile = tables[0].getName();
                    if (this._destination != null) {
                        outputFile = !this._destination.endsWith(File.separator) ? String.valueOf(this._destination) + File.separator + outputFile : String.valueOf(this._destination) + outputFile;
                    }
                    DataWriter writer = new DataWriter(new FileOutputStream(this._outputFile), this._encoding);
                    this.registerConverters(writer.getConverterConfiguration());
                    writer.writeDocumentStart();
                    writer.write(platform.query(model, "select * from " + tables[0].getName(), tables));
                    writer.writeDocumentEnd();
                    ++idx;
                }
            }
        }
        catch (Exception ex) {
            throw new BuildException((Throwable)ex);
        }
    }
}

