/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ddlutils.task;

import java.io.File;
import java.util.ArrayList;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.ddlutils.Platform;
import org.apache.ddlutils.io.DataReader;
import org.apache.ddlutils.io.DataToDatabaseSink;
import org.apache.ddlutils.model.Database;
import org.apache.ddlutils.task.ConvertingDatabaseCommand;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;

public class WriteDataToDatabaseCommand
extends ConvertingDatabaseCommand {
    private File _singleDataFile = null;
    private ArrayList _fileSets = new ArrayList();
    private boolean _ensureFKOrder = true;
    private Boolean _useBatchMode;
    private Integer _batchSize;

    public void addConfiguredFileset(FileSet fileset) {
        this._fileSets.add(fileset);
    }

    public void setDataFile(File dataFile) {
        this._singleDataFile = dataFile;
    }

    public void setBatchSize(int batchSize) {
        this._batchSize = new Integer(batchSize);
    }

    public void setUseBatchMode(boolean useBatchMode) {
        this._useBatchMode = useBatchMode;
    }

    public void setEnsureForeignKeyOrder(boolean ensureFKOrder) {
        this._ensureFKOrder = ensureFKOrder;
    }

    public void execute(Task task, Database model) throws BuildException {
        try {
            Platform platform = this.getPlatform();
            DataToDatabaseSink sink = new DataToDatabaseSink(platform, model);
            DataReader reader = new DataReader();
            sink.setEnsureForeignKeyOrder(this._ensureFKOrder);
            if (this._useBatchMode != null) {
                sink.setUseBatchMode(this._useBatchMode);
                if (this._batchSize != null) {
                    sink.setBatchSize(this._batchSize);
                }
            }
            reader.setModel(model);
            reader.setSink(sink);
            this.registerConverters(reader.getConverterConfiguration());
            if (this._singleDataFile != null && !this._fileSets.isEmpty()) {
                throw new BuildException("Please use either the datafile attribute or the sub fileset element, but not both");
            }
            if (this._singleDataFile != null) {
                this.readSingleDataFile(task, reader, this._singleDataFile);
            } else {
                for (FileSet fileSet : this._fileSets) {
                    File fileSetDir = fileSet.getDir(task.getProject());
                    DirectoryScanner scanner = fileSet.getDirectoryScanner(task.getProject());
                    String[] files = scanner.getIncludedFiles();
                    int idx = 0;
                    while (files != null && idx < files.length) {
                        this.readSingleDataFile(task, reader, new File(fileSetDir, files[idx]));
                        ++idx;
                    }
                }
            }
        }
        catch (Exception ex) {
            if (ex instanceof BuildException) {
                throw (BuildException)ex;
            }
            throw new BuildException((Throwable)ex);
        }
    }

    private void readSingleDataFile(Task task, DataReader reader, File dataFile) {
        if (!dataFile.exists()) {
            task.log("Could not find data file " + dataFile.getAbsolutePath(), 0);
        } else if (!dataFile.isFile()) {
            task.log("Path " + dataFile.getAbsolutePath() + " does not denote a data file", 0);
        } else if (!dataFile.canRead()) {
            task.log("Could not read data file " + dataFile.getAbsolutePath(), 0);
        } else {
            try {
                reader.parse(dataFile);
                task.log("Written data file " + dataFile.getAbsolutePath() + " to database", 2);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                if (this.isFailOnError()) {
                    throw new BuildException("Could not parse or write data file " + dataFile.getAbsolutePath(), (Throwable)ex);
                }
                task.log("Could not parse or write data file " + dataFile.getAbsolutePath() + ":", 0);
                task.log(ExceptionUtils.getFullStackTrace((Throwable)ex));
            }
        }
    }
}

