/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ddlutils.task;

import java.io.File;
import java.util.ArrayList;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.ddlutils.io.ConverterConfiguration;
import org.apache.ddlutils.io.DataReader;
import org.apache.ddlutils.io.DataToFileSink;
import org.apache.ddlutils.model.Database;
import org.apache.ddlutils.task.ConvertingDatabaseCommand;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;

public class SplitDataFileByTable
extends ConvertingDatabaseCommand {
    private String _destination;
    private File _singleDataFile = null;
    private ArrayList _fileSets = new ArrayList();

    public void addConfiguredFileset(FileSet fileset) {
        this._fileSets.add(fileset);
    }

    public void setDataFile(File dataFile) {
        this._singleDataFile = dataFile;
    }

    public void setDestination(String destination) {
        this._destination = destination;
    }

    public void execute(Task task, Database model) throws BuildException {
        ConverterConfiguration converterConf = new ConverterConfiguration();
        this.registerConverters(converterConf);
        DataToFileSink sink = new DataToFileSink(model, converterConf, this._destination);
        DataReader reader = new DataReader();
        reader.setModel(model);
        reader.setSink(sink);
        if (this._singleDataFile != null && !this._fileSets.isEmpty()) {
            throw new BuildException("Please use either the datafile attribute or the sub fileset element, but not both");
        }
        if (this._singleDataFile != null) {
            this.readSingleDataFile(task, reader, this._singleDataFile);
        } else {
            for (FileSet fileSet : this._fileSets) {
                File fileSetDir = fileSet.getDir(task.getProject());
                DirectoryScanner scanner = fileSet.getDirectoryScanner(task.getProject());
                String[] files = scanner.getIncludedFiles();
                int idx = 0;
                while (files != null && idx < files.length) {
                    this.readSingleDataFile(task, reader, new File(fileSetDir, files[idx]));
                    ++idx;
                }
            }
        }
    }

    private void readSingleDataFile(Task task, DataReader reader, File dataFile) {
        if (!dataFile.exists()) {
            task.log("Could not find data file " + dataFile.getAbsolutePath(), 0);
        } else if (!dataFile.isFile()) {
            task.log("Path " + dataFile.getAbsolutePath() + " does not denote a data file", 0);
        } else if (!dataFile.canRead()) {
            task.log("Could not read data file " + dataFile.getAbsolutePath(), 0);
        } else {
            try {
                reader.parse(dataFile);
                task.log("Written data file " + dataFile.getAbsolutePath() + " to database", 2);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                if (this.isFailOnError()) {
                    throw new BuildException("Could not parse or write data file " + dataFile.getAbsolutePath(), (Throwable)ex);
                }
                task.log("Could not parse or write data file " + dataFile.getAbsolutePath() + ":", 0);
                task.log(ExceptionUtils.getFullStackTrace((Throwable)ex));
            }
        }
    }
}

