/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ddlutils.platform.sapdb;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.ddlutils.Platform;
import org.apache.ddlutils.alteration.AddColumnChange;
import org.apache.ddlutils.alteration.AddPrimaryKeyChange;
import org.apache.ddlutils.alteration.ColumnDefaultValueChange;
import org.apache.ddlutils.alteration.ColumnRequiredChange;
import org.apache.ddlutils.alteration.PrimaryKeyChange;
import org.apache.ddlutils.alteration.RemoveColumnChange;
import org.apache.ddlutils.alteration.RemovePrimaryKeyChange;
import org.apache.ddlutils.alteration.TableChange;
import org.apache.ddlutils.model.Column;
import org.apache.ddlutils.model.Database;
import org.apache.ddlutils.model.Table;
import org.apache.ddlutils.platform.SqlBuilder;

public class SapDbBuilder
extends SqlBuilder {
    public SapDbBuilder(Platform platform) {
        super(platform);
        this.addEscapedCharSequence("'", "''");
    }

    public void dropTable(Table table) throws IOException {
        this.print("DROP TABLE ");
        this.printIdentifier(this.getTableName(table));
        this.print(" CASCADE");
        this.printEndOfStatement();
    }

    protected void writeColumnAutoIncrementStmt(Table table, Column column) throws IOException {
        this.print("DEFAULT SERIAL(1)");
    }

    public String getSelectLastIdentityValues(Table table) {
        StringBuffer result = new StringBuffer();
        result.append("SELECT ");
        result.append(this.getDelimitedIdentifier(this.getTableName(table)));
        result.append(".CURRVAL FROM DUAL");
        return result.toString();
    }

    protected void processTableStructureChanges(Database currentModel, Database desiredModel, Table sourceTable, Table targetTable, Map parameters, List changes) throws IOException {
        PrimaryKeyChange pkChange;
        TableChange change;
        Iterator changeIt = changes.iterator();
        while (changeIt.hasNext()) {
            change = (TableChange)changeIt.next();
            if (change instanceof RemovePrimaryKeyChange) {
                this.processChange(currentModel, desiredModel, (RemovePrimaryKeyChange)change);
                change.apply(currentModel, this.getPlatform().isDelimitedIdentifierModeOn());
                changeIt.remove();
                continue;
            }
            if (!(change instanceof PrimaryKeyChange)) continue;
            pkChange = (PrimaryKeyChange)change;
            RemovePrimaryKeyChange removePkChange = new RemovePrimaryKeyChange(pkChange.getChangedTable(), pkChange.getOldPrimaryKeyColumns());
            this.processChange(currentModel, desiredModel, removePkChange);
            removePkChange.apply(currentModel, this.getPlatform().isDelimitedIdentifierModeOn());
        }
        changeIt = changes.iterator();
        while (changeIt.hasNext()) {
            change = (TableChange)changeIt.next();
            if (change instanceof AddColumnChange) {
                AddColumnChange addColumnChange = (AddColumnChange)change;
                if (!addColumnChange.isAtEnd()) continue;
                this.processChange(currentModel, desiredModel, addColumnChange);
                change.apply(currentModel, this.getPlatform().isDelimitedIdentifierModeOn());
                changeIt.remove();
                continue;
            }
            if (change instanceof ColumnDefaultValueChange) {
                this.processChange(currentModel, desiredModel, (ColumnDefaultValueChange)change);
                change.apply(currentModel, this.getPlatform().isDelimitedIdentifierModeOn());
                changeIt.remove();
                continue;
            }
            if (change instanceof ColumnRequiredChange) {
                this.processChange(currentModel, desiredModel, (ColumnRequiredChange)change);
                change.apply(currentModel, this.getPlatform().isDelimitedIdentifierModeOn());
                changeIt.remove();
                continue;
            }
            if (!(change instanceof RemoveColumnChange)) continue;
            this.processChange(currentModel, desiredModel, (RemoveColumnChange)change);
            change.apply(currentModel, this.getPlatform().isDelimitedIdentifierModeOn());
            changeIt.remove();
        }
        changeIt = changes.iterator();
        while (changeIt.hasNext()) {
            change = (TableChange)changeIt.next();
            if (change instanceof AddPrimaryKeyChange) {
                this.processChange(currentModel, desiredModel, (AddPrimaryKeyChange)change);
                change.apply(currentModel, this.getPlatform().isDelimitedIdentifierModeOn());
                changeIt.remove();
                continue;
            }
            if (!(change instanceof PrimaryKeyChange)) continue;
            pkChange = (PrimaryKeyChange)change;
            AddPrimaryKeyChange addPkChange = new AddPrimaryKeyChange(pkChange.getChangedTable(), pkChange.getNewPrimaryKeyColumns());
            this.processChange(currentModel, desiredModel, addPkChange);
            addPkChange.apply(currentModel, this.getPlatform().isDelimitedIdentifierModeOn());
            changeIt.remove();
        }
    }

    protected void processChange(Database currentModel, Database desiredModel, AddColumnChange change) throws IOException {
        this.print("ALTER TABLE ");
        this.printlnIdentifier(this.getTableName(change.getChangedTable()));
        this.printIndent();
        this.print("ADD ");
        this.writeColumn(change.getChangedTable(), change.getNewColumn());
        this.printEndOfStatement();
    }

    protected void processChange(Database currentModel, Database desiredModel, RemoveColumnChange change) throws IOException {
        this.print("ALTER TABLE ");
        this.printlnIdentifier(this.getTableName(change.getChangedTable()));
        this.printIndent();
        this.print("DROP ");
        this.printIdentifier(this.getColumnName(change.getColumn()));
        this.print(" RELEASE SPACE");
        this.printEndOfStatement();
    }

    protected void processChange(Database currentModel, Database desiredModel, RemovePrimaryKeyChange change) throws IOException {
        this.print("ALTER TABLE ");
        this.printlnIdentifier(this.getTableName(change.getChangedTable()));
        this.printIndent();
        this.print("DROP PRIMARY KEY");
        this.printEndOfStatement();
    }

    protected void processChange(Database currentModel, Database desiredModel, ColumnRequiredChange change) throws IOException {
        this.print("ALTER TABLE ");
        this.printlnIdentifier(this.getTableName(change.getChangedTable()));
        this.printIndent();
        this.print("COLUMN ");
        this.printIdentifier(this.getColumnName(change.getChangedColumn()));
        if (change.getChangedColumn().isRequired()) {
            this.print(" DEFAULT NULL");
        } else {
            this.print(" NOT NULL");
        }
        this.printEndOfStatement();
    }

    protected void processChange(Database currentModel, Database desiredModel, ColumnDefaultValueChange change) throws IOException {
        boolean hasDefault;
        this.print("ALTER TABLE ");
        this.printlnIdentifier(this.getTableName(change.getChangedTable()));
        this.printIndent();
        this.print("COLUMN ");
        this.printIdentifier(this.getColumnName(change.getChangedColumn()));
        Table curTable = currentModel.findTable(change.getChangedTable().getName(), this.getPlatform().isDelimitedIdentifierModeOn());
        Column curColumn = curTable.findColumn(change.getChangedColumn().getName(), this.getPlatform().isDelimitedIdentifierModeOn());
        boolean bl = hasDefault = curColumn.getParsedDefaultValue() != null;
        if (this.isValidDefaultValue(change.getNewDefaultValue(), curColumn.getTypeCode())) {
            if (hasDefault) {
                this.print(" ALTER DEFAULT ");
            } else {
                this.print(" ADD DEFAULT ");
            }
            this.printDefaultValue(change.getNewDefaultValue(), curColumn.getTypeCode());
        } else if (hasDefault) {
            this.print(" DROP DEFAULT");
        }
        this.printEndOfStatement();
    }
}

