/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ddlutils.io.converters;

import java.sql.Time;
import java.util.Calendar;
import org.apache.ddlutils.io.converters.ConversionException;
import org.apache.ddlutils.io.converters.SqlTypeConverter;

public class TimeConverter
implements SqlTypeConverter {
    private Calendar _calendar = Calendar.getInstance();

    public TimeConverter() {
        this._calendar.setLenient(false);
    }

    public Object convertFromString(String textRep, int sqlTypeCode) throws ConversionException {
        if (sqlTypeCode != 92) {
            return textRep;
        }
        if (textRep != null) {
            String timeAsText = textRep;
            int hours = 0;
            int minutes = 0;
            int seconds = 0;
            int slashPos = timeAsText.indexOf(58);
            try {
                if (slashPos < 0) {
                    hours = Integer.parseInt(timeAsText);
                } else {
                    hours = Integer.parseInt(timeAsText.substring(0, slashPos));
                    if ((slashPos = (timeAsText = timeAsText.substring(slashPos + 1)).indexOf(58)) < 0) {
                        minutes = Integer.parseInt(timeAsText);
                    } else {
                        minutes = Integer.parseInt(timeAsText.substring(0, slashPos));
                        seconds = Integer.parseInt(timeAsText.substring(slashPos + 1));
                    }
                }
                this._calendar.clear();
                this._calendar.set(11, hours);
                this._calendar.set(12, minutes);
                this._calendar.set(13, seconds);
                return new Time(this._calendar.getTimeInMillis());
            }
            catch (NumberFormatException ex) {
                throw new ConversionException(ex);
            }
            catch (IllegalArgumentException ex) {
                throw new ConversionException(ex);
            }
        }
        return null;
    }

    public String convertToString(Object obj, int sqlTypeCode) throws ConversionException {
        String result = null;
        if (obj != null) {
            if (!(obj instanceof Time)) {
                throw new ConversionException("Expected object of type java.sql.Time, but instead received " + obj.getClass().getName());
            }
            result = obj.toString();
        }
        return result;
    }
}

