/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ddlutils.io.converters;

import java.sql.Date;
import java.util.Calendar;
import org.apache.ddlutils.io.converters.ConversionException;
import org.apache.ddlutils.io.converters.SqlTypeConverter;

public class DateConverter
implements SqlTypeConverter {
    private Calendar _calendar = Calendar.getInstance();

    public DateConverter() {
        this._calendar.setLenient(false);
    }

    public Object convertFromString(String textRep, int sqlTypeCode) throws ConversionException {
        if (sqlTypeCode != 91) {
            return textRep;
        }
        if (textRep != null) {
            String dateAsText = textRep;
            int year = 1970;
            int month = 1;
            int day = 1;
            int slashPos = dateAsText.indexOf(45);
            try {
                if (slashPos < 0) {
                    year = Integer.parseInt(dateAsText);
                } else {
                    year = Integer.parseInt(dateAsText.substring(0, slashPos));
                    if ((slashPos = (dateAsText = dateAsText.substring(slashPos + 1)).indexOf(45)) < 0) {
                        month = Integer.parseInt(dateAsText);
                    } else {
                        month = Integer.parseInt(dateAsText.substring(0, slashPos));
                        day = Integer.parseInt(dateAsText.substring(slashPos + 1));
                    }
                }
                this._calendar.clear();
                this._calendar.set(year, month - 1, day);
                return new Date(this._calendar.getTimeInMillis());
            }
            catch (NumberFormatException ex) {
                throw new ConversionException(ex);
            }
            catch (IllegalArgumentException ex) {
                throw new ConversionException(ex);
            }
        }
        return null;
    }

    public String convertToString(Object obj, int sqlTypeCode) throws ConversionException {
        String result = null;
        if (obj != null) {
            if (!(obj instanceof Date)) {
                throw new ConversionException("Expected object of type java.sql.Date, but instead received " + obj.getClass().getName());
            }
            result = obj.toString();
        }
        return result;
    }
}

