/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ddlutils.io;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class Identity {
    private String _tableName;
    private String _fkName;
    private HashMap _columnValues = new HashMap();

    public Identity(String tableName) {
        this._tableName = tableName.toUpperCase();
    }

    public Identity(String tableName, String fkName) {
        this._tableName = tableName.toUpperCase();
        this._fkName = fkName;
    }

    public String getForeignKeyName() {
        return this._fkName;
    }

    public void setIdentityColumn(String name, Object value) {
        this._columnValues.put(name.toUpperCase(), value);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Identity)) {
            return false;
        }
        Identity otherIdentity = (Identity)obj;
        if (!this._tableName.equals(otherIdentity._tableName)) {
            return false;
        }
        if (this._columnValues.keySet().size() != otherIdentity._columnValues.keySet().size()) {
            return false;
        }
        for (Map.Entry entry : this._columnValues.entrySet()) {
            Object otherValue = otherIdentity._columnValues.get(entry.getKey());
            if (!(entry.getValue() == null ? otherValue != null : !entry.getValue().equals(otherValue))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this._tableName);
        buffer.append(":");
        Iterator it = this._columnValues.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            buffer.append(entry.getKey());
            buffer.append("=");
            buffer.append(entry.getValue());
            if (!it.hasNext()) continue;
            buffer.append(";");
        }
        return buffer.toString();
    }
}

