/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ddlutils.io;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import org.apache.commons.beanutils.DynaBean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ddlutils.DatabaseOperationException;
import org.apache.ddlutils.Platform;
import org.apache.ddlutils.dynabean.SqlDynaClass;
import org.apache.ddlutils.io.DataSink;
import org.apache.ddlutils.io.DataSinkException;
import org.apache.ddlutils.io.Identity;
import org.apache.ddlutils.io.WaitingObject;
import org.apache.ddlutils.model.Column;
import org.apache.ddlutils.model.Database;
import org.apache.ddlutils.model.ForeignKey;
import org.apache.ddlutils.model.Reference;
import org.apache.ddlutils.model.Table;

public class DataToDatabaseSink
implements DataSink {
    private final Log _log = LogFactory.getLog(DataToDatabaseSink.class);
    private Platform _platform;
    private Database _model;
    private Connection _connection;
    private boolean _haltOnErrors = true;
    private boolean _ensureFkOrder = true;
    private boolean _useBatchMode = false;
    private ArrayList _batchQueue = new ArrayList();
    private int _batchSize = 1024;
    private HashMap _processedIdentities = new HashMap();
    private ArrayList _waitingObjects = new ArrayList();

    public DataToDatabaseSink(Platform platform, Database model) {
        this._platform = platform;
        this._model = model;
    }

    public boolean isHaltOnErrors() {
        return this._haltOnErrors;
    }

    public void setHaltOnErrors(boolean haltOnErrors) {
        this._haltOnErrors = haltOnErrors;
    }

    public boolean isEnsureFkOrder() {
        return this._ensureFkOrder;
    }

    public void setEnsureForeignKeyOrder(boolean ensureFkOrder) {
        this._ensureFkOrder = ensureFkOrder;
    }

    public boolean isUseBatchMode() {
        return this._useBatchMode;
    }

    public void setUseBatchMode(boolean useBatchMode) {
        this._useBatchMode = useBatchMode;
    }

    public int getBatchSize() {
        return this._batchSize;
    }

    public void setBatchSize(int batchSize) {
        this._batchSize = batchSize;
    }

    public void end() throws DataSinkException {
        if (!this._waitingObjects.isEmpty()) {
            this.flushWaitingObjects();
        }
        this.purgeBatchQueue();
        try {
            this._connection.close();
        }
        catch (SQLException ex) {
            throw new DataSinkException(ex);
        }
    }

    public void start() throws DataSinkException {
        this._processedIdentities.clear();
        this._waitingObjects.clear();
        if (this._ensureFkOrder) {
            int tableIdx = 0;
            while (tableIdx < this._model.getTableCount()) {
                Table table = this._model.getTable(tableIdx);
                int fkIdx = 0;
                while (fkIdx < table.getForeignKeyCount()) {
                    ForeignKey curFk = table.getForeignKey(fkIdx);
                    if (!this._processedIdentities.containsKey(curFk.getForeignTableName())) {
                        this._processedIdentities.put(curFk.getForeignTableName(), new HashSet());
                    }
                    ++fkIdx;
                }
                ++tableIdx;
            }
        }
        try {
            this._connection = this._platform.borrowConnection();
        }
        catch (DatabaseOperationException ex) {
            throw new DataSinkException((Throwable)((Object)ex));
        }
    }

    private void flushWaitingObjects() {
        Iterator waitingObjIt = this._waitingObjects.iterator();
        while (waitingObjIt.hasNext()) {
            WaitingObject waitingObj = (WaitingObject)waitingObjIt.next();
            waitingObjIt.remove();
            DynaBean bean = waitingObj.getObject();
            Table table = this._model.getDynaClassFor(bean).getTable();
            StringBuffer msg = new StringBuffer();
            msg.append("Defering insertion of bean ");
            msg.append(this.buildIdentityFromPKs(table, bean).toString());
            msg.append(" because it is waiting for:");
            Iterator it = waitingObj.getPendingFKs();
            while (it.hasNext()) {
                msg.append("\n  ");
                msg.append(it.next().toString());
            }
            System.out.println(msg);
        }
    }

    public void addBean(DynaBean bean) throws DataSinkException {
        Table table = this._model.getDynaClassFor(bean).getTable();
        if (this._ensureFkOrder && table.getForeignKeyCount() > 0) {
            WaitingObject waitingObj = new WaitingObject(bean);
            int idx = 0;
            while (idx < table.getForeignKeyCount()) {
                HashSet identitiesForTable;
                ForeignKey fk = table.getForeignKey(idx);
                Identity fkIdentity = this.buildIdentityFromFK(table, fk, bean);
                if (fkIdentity != null && !(identitiesForTable = (HashSet)this._processedIdentities.get(fk.getForeignTableName())).contains(fkIdentity)) {
                    waitingObj.addPendingFK(fkIdentity);
                }
                ++idx;
            }
            if (waitingObj.hasPendingFKs()) {
                if (this._log.isDebugEnabled()) {
                    StringBuffer msg = new StringBuffer();
                    msg.append("Defering insertion of bean ");
                    msg.append(this.buildIdentityFromPKs(table, bean).toString());
                    msg.append(" because it is waiting for:");
                    Iterator it = waitingObj.getPendingFKs();
                    while (it.hasNext()) {
                        msg.append("\n  ");
                        msg.append(it.next().toString());
                    }
                    this._log.debug((Object)msg.toString());
                }
                this._waitingObjects.add(waitingObj);
                return;
            }
        }
        this.insertBeanIntoDatabase(table, bean);
        if (this._ensureFkOrder && this._processedIdentities.containsKey(table.getName())) {
            Identity identity = this.buildIdentityFromPKs(table, bean);
            HashSet identitiesForTable = (HashSet)this._processedIdentities.get(table.getName());
            ArrayList<DynaBean> finishedObjs = new ArrayList<DynaBean>();
            identitiesForTable.add(identity);
            Iterator waitingObjIt = this._waitingObjects.iterator();
            while (waitingObjIt.hasNext()) {
                WaitingObject waitingObj = (WaitingObject)waitingObjIt.next();
                Identity fkIdentity = waitingObj.removePendingFK(identity);
                if (waitingObj.hasPendingFKs()) continue;
                waitingObjIt.remove();
                this.updateFKColumns(waitingObj.getObject(), bean, fkIdentity.getForeignKeyName());
                finishedObjs.add(waitingObj.getObject());
            }
            for (DynaBean finishedObj : finishedObjs) {
                this.addBean(finishedObj);
                if (!this._log.isDebugEnabled()) continue;
                Table waitingObjTable = ((SqlDynaClass)finishedObj.getDynaClass()).getTable();
                this._log.debug((Object)("Inserted deferred bean " + this.buildIdentityFromPKs(waitingObjTable, finishedObj)));
            }
        }
    }

    private void insertBeanIntoDatabase(Table table, DynaBean bean) throws DataSinkException {
        if (this._useBatchMode) {
            this._batchQueue.add(bean);
            if (this._batchQueue.size() >= this._batchSize) {
                this.purgeBatchQueue();
            }
        } else {
            this.insertSingleBeanIntoDatabase(table, bean);
        }
    }

    private void purgeBatchQueue() throws DataSinkException {
        try {
            this._platform.insert(this._connection, this._model, this._batchQueue);
            if (!this._connection.getAutoCommit()) {
                this._connection.commit();
            }
            if (this._log.isDebugEnabled()) {
                this._log.debug((Object)("Inserted " + this._batchQueue.size() + " beans in batch mode "));
            }
        }
        catch (Exception ex) {
            if (this._haltOnErrors) {
                this._platform.returnConnection(this._connection);
                throw new DataSinkException(ex);
            }
            this._log.warn((Object)("Exception while inserting " + this._batchQueue.size() + " beans via batch mode into the database"), (Throwable)ex);
        }
        this._batchQueue.clear();
    }

    private void insertSingleBeanIntoDatabase(Table table, DynaBean bean) throws DataSinkException {
        try {
            this._platform.insert(this._connection, this._model, bean);
            if (!this._connection.getAutoCommit()) {
                this._connection.commit();
            }
            if (this._log.isDebugEnabled()) {
                this._log.debug((Object)("Inserted bean " + this.buildIdentityFromPKs(table, bean).toString()));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            if (this._haltOnErrors) {
                this._platform.returnConnection(this._connection);
                throw new DataSinkException(ex);
            }
            this._log.warn((Object)"Exception while inserting a bean into the database", (Throwable)ex);
        }
    }

    private String getFKName(Table owningTable, ForeignKey fk) {
        if (fk.getName() != null && fk.getName().length() > 0) {
            return fk.getName();
        }
        StringBuffer result = new StringBuffer();
        result.append(owningTable.getName());
        result.append("[");
        int idx = 0;
        while (idx < fk.getReferenceCount()) {
            if (idx > 0) {
                result.append(",");
            }
            result.append(fk.getReference(idx).getLocalColumnName());
            ++idx;
        }
        result.append("]->");
        result.append(fk.getForeignTableName());
        result.append("[");
        idx = 0;
        while (idx < fk.getReferenceCount()) {
            if (idx > 0) {
                result.append(",");
            }
            result.append(fk.getReference(idx).getForeignColumnName());
            ++idx;
        }
        result.append("]");
        return result.toString();
    }

    private Identity buildIdentityFromPKs(Table table, DynaBean bean) {
        Identity identity = new Identity(table.getName());
        Column[] pkColumns = table.getPrimaryKeyColumns();
        int idx = 0;
        while (idx < pkColumns.length) {
            identity.setIdentityColumn(pkColumns[idx].getName(), bean.get(pkColumns[idx].getName()));
            ++idx;
        }
        return identity;
    }

    private Identity buildIdentityFromFK(Table owningTable, ForeignKey fk, DynaBean bean) {
        Identity identity = new Identity(fk.getForeignTableName(), this.getFKName(owningTable, fk));
        int idx = 0;
        while (idx < fk.getReferenceCount()) {
            Reference reference = fk.getReference(idx);
            Object value = bean.get(reference.getLocalColumnName());
            if (value == null) {
                return null;
            }
            identity.setIdentityColumn(reference.getForeignColumnName(), value);
            ++idx;
        }
        return identity;
    }

    private void updateFKColumns(DynaBean referencingBean, DynaBean referencedBean, String fkName) {
        Table sourceTable = ((SqlDynaClass)referencingBean.getDynaClass()).getTable();
        Table targetTable = ((SqlDynaClass)referencedBean.getDynaClass()).getTable();
        ForeignKey fk = null;
        int idx = 0;
        while (idx < sourceTable.getForeignKeyCount()) {
            ForeignKey curFk = sourceTable.getForeignKey(idx);
            if (curFk.getForeignTableName().equalsIgnoreCase(targetTable.getName()) && fkName.equals(this.getFKName(sourceTable, curFk))) {
                fk = curFk;
                break;
            }
            ++idx;
        }
        if (fk != null) {
            idx = 0;
            while (idx < fk.getReferenceCount()) {
                Reference curRef = fk.getReference(idx);
                Column sourceColumn = sourceTable.findColumn(curRef.getLocalColumnName());
                Column targetColumn = targetTable.findColumn(curRef.getForeignColumnName());
                referencingBean.set(sourceColumn.getName(), referencedBean.get(targetColumn.getName()));
                ++idx;
            }
        }
    }
}

