/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.pool;

import java.io.PrintWriter;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Properties;
import javax.naming.BinaryRefAddr;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import javax.naming.spi.ObjectFactory;
import javax.resource.Referenceable;
import javax.sql.DataSource;
import org.firebirdsql.jdbc.FBConnectionHelper;
import org.firebirdsql.pool.BasicAbstractConnectionPool;
import org.firebirdsql.pool.FBConnectionPoolDataSource;
import org.firebirdsql.pool.FirebirdPool;

public class FBWrappingDataSource
implements DataSource,
ObjectFactory,
Referenceable,
Serializable,
FirebirdPool {
    private FBConnectionPoolDataSource pool;
    private Reference reference;
    private String description;
    private static final String REF_BLOCKING_TIMEOUT = "blockingTimeout";
    private static final String REF_DATABASE = "database";
    private static final String REF_DESCRIPTION = "description";
    private static final String REF_MAX_IDLE_TIME = "maxIdleTime";
    private static final String REF_IDLE_TIMEOUT = "idleTimeout";
    private static final String REF_LOGIN_TIMEOUT = "loginTimeout";
    private static final String REF_MAX_POOL_SIZE = "maxPoolSize";
    private static final String REF_MIN_POOL_SIZE = "minPoolSize";
    private static final String REF_MAX_CONNECTIONS = "maxConnections";
    private static final String REF_MIN_CONNECTIONS = "minConnections";
    private static final String REF_PING_INTERVAL = "pingInterval";
    private static final String REF_TYPE = "type";
    private static final String REF_TX_ISOLATION = "transactionIsolationLevel";
    private static final String REF_ISOLATION = "isolation";
    private static final String REF_PROPERTIES = "properties";
    private static final String REF_NON_STANDARD_PROPERTY = "nonStandard";

    private synchronized FBConnectionPoolDataSource getPool() {
        if (this.pool == null) {
            this.pool = new FBConnectionPoolDataSource();
        }
        return this.pool;
    }

    protected void finalize() throws Throwable {
        if (this.pool != null) {
            this.pool.shutdown();
        }
        super.finalize();
    }

    public void shutdown() {
        if (this.pool != null) {
            this.pool.shutdown();
        }
    }

    public Connection getConnection() throws SQLException {
        return this.getPool().getPooledConnection().getConnection();
    }

    public Connection getConnection(String user, String password) throws SQLException {
        return this.getPool().getPooledConnection(user, password).getConnection();
    }

    public int getLoginTimeout() {
        return this.getBlockingTimeout() * 1000;
    }

    public PrintWriter getLogWriter() {
        return this.getPool().getLogWriter();
    }

    public void setLoginTimeout(int seconds) {
        this.setBlockingTimeout(seconds * 1000);
    }

    public void setLogWriter(PrintWriter printWriter) {
        this.getPool().setLogWriter(printWriter);
    }

    public int getBlockingTimeout() {
        return this.getPool().getBlockingTimeout();
    }

    public void setBlockingTimeout(int blockingTimeoutValue) {
        this.getPool().setBlockingTimeout(blockingTimeoutValue);
    }

    public String getDatabase() {
        return this.getPool().getDatabase();
    }

    public void setDatabase(String databaseValue) {
        this.getPool().setDatabase(databaseValue);
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String descriptionValue) {
        this.description = descriptionValue;
    }

    public String getEncoding() {
        return this.getPool().getEncoding();
    }

    public void setEncoding(String encodingValue) {
        this.getPool().setEncoding(encodingValue);
    }

    public String getCharSet() {
        return FBConnectionHelper.getJavaEncoding(this.getEncoding());
    }

    public void setCharSet(String charSet) throws SQLException {
        String iscEncoding = FBConnectionHelper.getIscEncoding(charSet);
        if (iscEncoding == null) {
            throw new SQLException("Unknown character set " + charSet);
        }
        this.setEncoding(iscEncoding);
    }

    public int getMaxIdleTime() {
        return this.getPool().getMaxIdleTime();
    }

    public void setMaxIdleTime(int maxIdleTime) {
        this.getPool().setMaxIdleTime(maxIdleTime);
    }

    public int getIdleTimeout() {
        return this.getPool().getIdleTimeout();
    }

    public void setIdleTimeout(int idleTimeoutValue) {
        this.getPool().setIdleTimeout(idleTimeoutValue);
    }

    public int getMaxStatements() {
        return this.getPool().getMaxStatements();
    }

    public void setMaxStatements(int maxStatements) {
        this.getPool().setMaxStatements(maxStatements);
    }

    public int getMaxPoolSize() {
        return this.getPool().getMaxPoolSize();
    }

    public void setMaxPoolSize(int maxPoolSize) {
        this.getPool().setMaxPoolSize(maxPoolSize);
    }

    public int getMaxConnections() {
        return this.getPool().getMaxConnections();
    }

    public void setMaxConnections(int maxConnections) {
        this.getPool().setMaxConnections(maxConnections);
    }

    public int getMinPoolSize() {
        return this.getPool().getMinPoolSize();
    }

    public void setMinPoolSize(int minPoolSize) {
        this.getPool().setMinPoolSize(minPoolSize);
    }

    public int getMinConnections() {
        return this.getMinPoolSize();
    }

    public void setMinConnections(int minConnections) {
        this.setMinPoolSize(minConnections);
    }

    public boolean isKeepStatements() {
        return this.getPool().isKeepStatements();
    }

    public void setKeepStatements(boolean keepStatements) {
        this.getPool().setKeepStatements(keepStatements);
    }

    public String getPassword() {
        return this.getPool().getPassword();
    }

    public void setPassword(String passwordValue) {
        this.getPool().setPassword(passwordValue);
    }

    public String getTpbMapping() {
        return this.getPool().getTpbMapping();
    }

    public void setTpbMapping(String tpbMappingValue) {
        this.getPool().setTpbMapping(tpbMappingValue);
    }

    public String getUserName() {
        return this.getPool().getUserName();
    }

    public void setUserName(String userNameValue) {
        this.getPool().setUserName(userNameValue);
    }

    public int getBlobBufferSize() {
        return this.getPool().getBlobBufferSize();
    }

    public void setBlobBufferSize(int blobBufferSizeValue) {
        this.getPool().setBlobBufferSize(blobBufferSizeValue);
    }

    public String getType() {
        return this.getPool().getType();
    }

    public void setType(String typeValue) throws SQLException {
        this.getPool().setType(typeValue);
    }

    public int getPingInterval() {
        return this.getPool().getPingInterval();
    }

    public void setPingInterval(int pingIntervalValue) {
        this.getPool().setPingInterval(pingIntervalValue);
    }

    public int getSocketBufferSize() {
        return this.getPool().getSocketBufferSize();
    }

    public void setSocketBufferSize(int socketBufferSize) {
        this.getPool().setSocketBufferSize(socketBufferSize);
    }

    public String getRoleName() {
        return this.getPool().getRoleName();
    }

    public void setRoleName(String roleName) {
        this.getPool().setRoleName(roleName);
    }

    public String getSqlRole() {
        return this.getRoleName();
    }

    public void setSqlRole(String sqlRole) {
        this.setRoleName(sqlRole);
    }

    public String getNonStandardProperty(String key) {
        return this.getPool().getNonStandardProperty(key);
    }

    public void setNonStandardProperty(String key, String value) {
        if (key == null) {
            throw new NullPointerException("Key is null");
        }
        if (value == null) {
            value = "";
        }
        this.getPool().setNonStandardProperty(key, value);
    }

    public void setNonStandardProperty(String propertyMapping) {
        this.getPool().setNonStandardProperty(propertyMapping);
    }

    public boolean getPooling() {
        return this.getPool().isPooling();
    }

    public boolean isPooling() {
        return this.getPool().isPooling();
    }

    public void setPooling(boolean pooling) {
        this.getPool().setPooling(pooling);
    }

    public boolean isStatementPooling() {
        return this.getPool().isStatementPooling();
    }

    public void setStatementPooling(boolean statementPooling) {
        this.getPool().setStatementPooling(statementPooling);
    }

    public int getConnectionCount() throws SQLException {
        return this.getPool().getFreeSize();
    }

    public int getFreeSize() throws SQLException {
        return this.getPool().getFreeSize();
    }

    public int getWorkingSize() throws SQLException {
        return this.getPool().getWorkingSize();
    }

    public int getTotalSize() throws SQLException {
        return this.getPool().getTotalSize();
    }

    public int getTransactionIsolationLevel() {
        return this.getPool().getTransactionIsolationLevel();
    }

    public void setTransactionIsolationLevel(int level) {
        this.getPool().setTransactionIsolationLevel(level);
    }

    public String getIsolation() {
        return this.getPool().getIsolation();
    }

    public void setIsolation(String isolation) throws SQLException {
        this.getPool().setIsolation(isolation);
    }

    public void setProperties(Properties props) {
        this.getPool().setProperties(props);
    }

    public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable environment) throws Exception {
        if (!(obj instanceof Reference)) {
            return null;
        }
        Reference ref = (Reference)obj;
        ref = (Reference)ref.clone();
        if (!this.getClass().getName().equals(ref.getClassName())) {
            return null;
        }
        FBWrappingDataSource ds = new FBWrappingDataSource();
        for (int i = 0; i < ref.size(); ++i) {
            RefAddr element = ref.get(i);
            String type = element.getType();
            if (REF_BLOCKING_TIMEOUT.equals(type)) {
                ds.setBlockingTimeout(Integer.parseInt(element.getContent().toString()));
                continue;
            }
            if (REF_DATABASE.equals(type)) {
                ds.setDatabase(element.getContent().toString());
                continue;
            }
            if (REF_DESCRIPTION.equals(type)) {
                ds.setDescription(element.getContent().toString());
                continue;
            }
            if (REF_IDLE_TIMEOUT.equals(type)) {
                ds.setIdleTimeout(Integer.parseInt(element.getContent().toString()));
                continue;
            }
            if (REF_MAX_IDLE_TIME.equals(type)) {
                ds.setMaxIdleTime(Integer.parseInt(element.getContent().toString()));
                continue;
            }
            if (REF_LOGIN_TIMEOUT.equals(type)) {
                ds.setLoginTimeout(Integer.parseInt(element.getContent().toString()));
                continue;
            }
            if (REF_MAX_POOL_SIZE.equals(type)) {
                ds.setMaxPoolSize(Integer.parseInt(element.getContent().toString()));
                continue;
            }
            if (REF_MIN_POOL_SIZE.equals(type)) {
                ds.setMinPoolSize(Integer.parseInt(element.getContent().toString()));
                continue;
            }
            if (REF_MIN_CONNECTIONS.equals(type)) {
                ds.setMinConnections(Integer.parseInt(element.getContent().toString()));
                continue;
            }
            if (REF_MAX_CONNECTIONS.equals(type)) {
                ds.setMaxConnections(Integer.parseInt(element.getContent().toString()));
                continue;
            }
            if (REF_PING_INTERVAL.equals(type)) {
                ds.setPingInterval(Integer.parseInt(element.getContent().toString()));
                continue;
            }
            if (REF_TYPE.equals(type)) {
                ds.setType(element.getContent().toString());
                continue;
            }
            if (REF_TX_ISOLATION.equals(type)) {
                ds.setTransactionIsolationLevel(Integer.parseInt(element.getContent().toString()));
                continue;
            }
            if (REF_ISOLATION.equals(type)) {
                ds.setIsolation(element.getContent().toString());
                continue;
            }
            if (REF_NON_STANDARD_PROPERTY.equals(type)) {
                ds.setNonStandardProperty(element.getContent().toString());
                continue;
            }
            if (REF_PROPERTIES.equals(type)) {
                byte[] data = (byte[])element.getContent();
                Properties props = (Properties)BasicAbstractConnectionPool.deserialize(data);
                if (props == null) continue;
                ds.setProperties(props);
                continue;
            }
            if (!(element.getContent() instanceof String)) continue;
            ds.setNonStandardProperty(type, element.getContent().toString());
        }
        return ds;
    }

    private String getRefAddr(Reference ref, String type) {
        RefAddr addr = ref.get(type);
        if (addr == null) {
            return null;
        }
        return addr.getContent().toString();
    }

    public Reference getReference() {
        if (this.reference == null) {
            return this.getDefaultReference();
        }
        return this.reference;
    }

    public void setReference(Reference reference) {
        this.reference = reference;
    }

    public Reference getDefaultReference() {
        Reference ref = new Reference(this.getClass().getName(), this.getClass().getName(), null);
        if (this.getBlockingTimeout() != 2147483) {
            ref.add(new StringRefAddr(REF_BLOCKING_TIMEOUT, String.valueOf(this.getBlockingTimeout())));
        }
        if (this.getDatabase() != null) {
            ref.add(new StringRefAddr(REF_DATABASE, this.getDatabase()));
        }
        if (this.getDescription() != null) {
            ref.add(new StringRefAddr(REF_DESCRIPTION, this.getDescription()));
        }
        if (this.getMaxIdleTime() != 2147483) {
            ref.add(new StringRefAddr(REF_MAX_IDLE_TIME, String.valueOf(this.getMaxIdleTime())));
        }
        if (this.getLoginTimeout() != 2147483000) {
            ref.add(new StringRefAddr(REF_LOGIN_TIMEOUT, String.valueOf(this.getLoginTimeout())));
        }
        if (this.getMaxPoolSize() != 10) {
            ref.add(new StringRefAddr(REF_MAX_POOL_SIZE, String.valueOf(this.getMaxPoolSize())));
        }
        if (this.getMinPoolSize() != 0) {
            ref.add(new StringRefAddr(REF_MIN_POOL_SIZE, String.valueOf(this.getMinPoolSize())));
        }
        if (this.getPingInterval() != 5000) {
            ref.add(new StringRefAddr(REF_PING_INTERVAL, String.valueOf(this.getPingInterval())));
        }
        if (this.getType() != null) {
            ref.add(new StringRefAddr(REF_TYPE, this.getType()));
        }
        if (this.getTransactionIsolationLevel() != 2) {
            ref.add(new StringRefAddr(REF_TX_ISOLATION, String.valueOf(this.getTransactionIsolationLevel())));
        }
        byte[] data = BasicAbstractConnectionPool.serialize(this.getPool().getProperties());
        ref.add(new BinaryRefAddr(REF_PROPERTIES, data));
        return ref;
    }
}

