/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jdbc;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.firebirdsql.jdbc.FBSQLParseException;

public class FBEscapedFunctionHelper {
    private static final HashMap FUNCTION_MAP = new HashMap();
    static /* synthetic */ Class array$Ljava$lang$String;
    static /* synthetic */ Class class$org$firebirdsql$jdbc$FBEscapedFunctionHelper;

    private static void checkSyntax(String functionCall) throws FBSQLParseException {
        int parenthesisStart = functionCall.indexOf(40);
        if (parenthesisStart == -1) {
            throw new FBSQLParseException("No opening parenthesis found, not a function call.");
        }
        if (functionCall.charAt(functionCall.length() - 1) != ')') {
            throw new FBSQLParseException("No closing parenthesis found, not a function call.");
        }
    }

    public static String parseFunction(String functionCall) throws FBSQLParseException {
        functionCall = functionCall.trim();
        FBEscapedFunctionHelper.checkSyntax(functionCall);
        int parenthesisStart = functionCall.indexOf(40);
        return functionCall.substring(0, parenthesisStart);
    }

    public static List parseArguments(String functionCall) throws FBSQLParseException {
        functionCall = functionCall.trim();
        FBEscapedFunctionHelper.checkSyntax(functionCall);
        int parenthesisStart = functionCall.indexOf(40);
        String paramsString = functionCall.substring(parenthesisStart + 1, functionCall.length() - 1);
        ArrayList<String> params = new ArrayList<String>();
        StringBuffer sb = new StringBuffer();
        boolean inQuotes = false;
        boolean inDoubleQuotes = false;
        char[] chars = paramsString.toCharArray();
        block6: for (int i = 0; i < chars.length; ++i) {
            switch (chars[i]) {
                case '\'': {
                    sb.append(chars[i]);
                    if (inDoubleQuotes) continue block6;
                    inQuotes = !inQuotes;
                    continue block6;
                }
                case '\"': {
                    sb.append(chars[i]);
                    if (inQuotes) continue block6;
                    inDoubleQuotes = !inDoubleQuotes;
                    continue block6;
                }
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    if (!inQuotes && !inDoubleQuotes) continue block6;
                    sb.append(chars[i]);
                    continue block6;
                }
                case ',': {
                    if (inQuotes || inDoubleQuotes) {
                        sb.append(chars[i]);
                        continue block6;
                    }
                    params.add(sb.toString());
                    sb = new StringBuffer();
                    continue block6;
                }
                default: {
                    sb.append(chars[i]);
                }
            }
        }
        if (sb.length() > 0) {
            params.add(sb.toString());
        }
        if (inQuotes || inDoubleQuotes) {
            throw new FBSQLParseException("String literal is not properly closed.");
        }
        return params;
    }

    public static String convertTemplate(String functionCall, int mode) throws FBSQLParseException {
        String name = FBEscapedFunctionHelper.parseFunction(functionCall);
        Object[] params = FBEscapedFunctionHelper.parseArguments(functionCall).toArray(new String[0]);
        String firebirdTemplate = (String)FUNCTION_MAP.get(name.toUpperCase());
        if (firebirdTemplate != null) {
            return MessageFormat.format(firebirdTemplate, params);
        }
        if (mode == 1) {
            return FBEscapedFunctionHelper.convertUsingStandardUDF(name, (String[])params);
        }
        return null;
    }

    private static String convertUsingStandardUDF(String name, String[] params) throws FBSQLParseException {
        try {
            name = name.toLowerCase();
            if ("char".equals(name)) {
                name = "_char";
            }
            Method method = (class$org$firebirdsql$jdbc$FBEscapedFunctionHelper == null ? (class$org$firebirdsql$jdbc$FBEscapedFunctionHelper = FBEscapedFunctionHelper.class$("org.firebirdsql.jdbc.FBEscapedFunctionHelper")) : class$org$firebirdsql$jdbc$FBEscapedFunctionHelper).getMethod(name.toLowerCase(), array$Ljava$lang$String == null ? (array$Ljava$lang$String = FBEscapedFunctionHelper.class$("[Ljava.lang.String;")) : array$Ljava$lang$String);
            return (String)method.invoke(null, new Object[]{params});
        }
        catch (NoSuchMethodException ex) {
            return null;
        }
        catch (IllegalArgumentException ex) {
            throw new FBSQLParseException("Error when converting function " + name + ". Error " + ex.getClass().getName() + " : " + ex.getMessage());
        }
        catch (IllegalAccessException ex) {
            throw new FBSQLParseException("Error when converting function " + name + ". Error " + ex.getClass().getName() + " : " + ex.getMessage());
        }
        catch (InvocationTargetException ex) {
            throw new FBSQLParseException("Error when converting function " + name + ". Error " + ex.getClass().getName() + " : " + ex.getMessage());
        }
    }

    public static String abs(String[] params) throws FBSQLParseException {
        if (params.length != 1) {
            throw new FBSQLParseException("Incorrect number of parameters of function abs : " + params.length);
        }
        return "abs(" + params[0] + ")";
    }

    public static String acos(String[] params) throws FBSQLParseException {
        if (params.length != 1) {
            throw new FBSQLParseException("Incorrect number of parameters of function acos : " + params.length);
        }
        return "acos(" + params[0] + ")";
    }

    public static String asin(String[] params) throws FBSQLParseException {
        if (params.length != 1) {
            throw new FBSQLParseException("Incorrect number of parameters of function asin : " + params.length);
        }
        return "asin(" + params[0] + ")";
    }

    public static String atan(String[] params) throws FBSQLParseException {
        if (params.length != 1) {
            throw new FBSQLParseException("Incorrect number of parameters of function atan : " + params.length);
        }
        return "atan(" + params[0] + ")";
    }

    public static String atan2(String[] params) throws FBSQLParseException {
        if (params.length != 2) {
            throw new FBSQLParseException("Incorrect number of parameters of function atan2 : " + params.length);
        }
        return "atan2(" + params[0] + ", " + params[1] + ")";
    }

    public static String ceiling(String[] params) throws FBSQLParseException {
        if (params.length != 1) {
            throw new FBSQLParseException("Incorrect number of parameters of function ceiling : " + params.length);
        }
        return "ceiling(" + params[0] + ")";
    }

    public static String cos(String[] params) throws FBSQLParseException {
        if (params.length != 1) {
            throw new FBSQLParseException("Incorrect number of parameters of function cos : " + params.length);
        }
        return "cos(" + params[0] + ")";
    }

    public static String cot(String[] params) throws FBSQLParseException {
        if (params.length != 1) {
            throw new FBSQLParseException("Incorrect number of parameters of function cot : " + params.length);
        }
        return "cot(" + params[0] + ")";
    }

    public static String floor(String[] params) throws FBSQLParseException {
        if (params.length != 1) {
            throw new FBSQLParseException("Incorrect number of parameters of function floor : " + params.length);
        }
        return "floor(" + params[0] + ")";
    }

    public static String log(String[] params) throws FBSQLParseException {
        if (params.length != 1) {
            throw new FBSQLParseException("Incorrect number of parameters of function log : " + params.length);
        }
        return "ln(" + params[0] + ")";
    }

    public static String log10(String[] params) throws FBSQLParseException {
        if (params.length != 1) {
            throw new FBSQLParseException("Incorrect number of parameters of function log10 : " + params.length);
        }
        return "log10(" + params[0] + ")";
    }

    public static String mod(String[] params) throws FBSQLParseException {
        if (params.length != 2) {
            throw new FBSQLParseException("Incorrect number of parameters of function mod : " + params.length);
        }
        return "mod(" + params[0] + ", " + params[1] + ")";
    }

    public static String pi(String[] params) throws FBSQLParseException {
        if (params.length != 0) {
            throw new FBSQLParseException("Incorrect number of parameters of function pi : " + params.length);
        }
        return "pi()";
    }

    public static String rand(String[] params) throws FBSQLParseException {
        if (params.length != 0) {
            throw new FBSQLParseException("Incorrect number of parameters of function rand : " + params.length);
        }
        return "rand()";
    }

    public static String sign(String[] params) throws FBSQLParseException {
        if (params.length != 1) {
            throw new FBSQLParseException("Incorrect number of parameters of function sign : " + params.length);
        }
        return "sign(" + params[0] + ")";
    }

    public static String sin(String[] params) throws FBSQLParseException {
        if (params.length != 1) {
            throw new FBSQLParseException("Incorrect number of parameters of function sin : " + params.length);
        }
        return "sin(" + params[0] + ")";
    }

    public static String sqrt(String[] params) throws FBSQLParseException {
        if (params.length != 1) {
            throw new FBSQLParseException("Incorrect number of parameters of function sqrt : " + params.length);
        }
        return "sqrt(" + params[0] + ")";
    }

    public static String tan(String[] params) throws FBSQLParseException {
        if (params.length != 1) {
            throw new FBSQLParseException("Incorrect number of parameters of function tan : " + params.length);
        }
        return "tan(" + params[0] + ")";
    }

    public static String ascii(String[] params) throws FBSQLParseException {
        if (params.length != 1) {
            throw new FBSQLParseException("Incorrect number of parameters of function ascii : " + params.length);
        }
        if (params[0] == null || params[0].length() < 1) {
            throw new FBSQLParseException("Parameter must not be empty or null");
        }
        return "ascii_val(" + params[0].charAt(0) + ")";
    }

    public static String _char(String[] params) throws FBSQLParseException {
        if (params.length != 1) {
            throw new FBSQLParseException("Incorrect number of parameters of function char : " + params.length);
        }
        return "char(" + params[0] + ")";
    }

    public static String lcase(String[] params) throws FBSQLParseException {
        if (params.length != 1) {
            throw new FBSQLParseException("Incorrect number of parameters of function lcase : " + params.length);
        }
        return "lower(" + params[0] + ")";
    }

    public static String length(String[] params) throws FBSQLParseException {
        if (params.length != 1) {
            throw new FBSQLParseException("Incorrect number of parameters of function length : " + params.length);
        }
        return "strlen(" + params[0] + ")";
    }

    public static String ltrim(String[] params) throws FBSQLParseException {
        if (params.length != 1) {
            throw new FBSQLParseException("Incorrect number of parameters of function ltrim : " + params.length);
        }
        return "ltrim(" + params[0] + ")";
    }

    public static String rtrim(String[] params) throws FBSQLParseException {
        if (params.length != 1) {
            throw new FBSQLParseException("Incorrect number of parameters of function rtrim : " + params.length);
        }
        return "rtrim(" + params[0] + ")";
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        FUNCTION_MAP.put("ABS", null);
        FUNCTION_MAP.put("ACOS", null);
        FUNCTION_MAP.put("ASIN", null);
        FUNCTION_MAP.put("ATAN", null);
        FUNCTION_MAP.put("ATAN2", null);
        FUNCTION_MAP.put("CEILING", null);
        FUNCTION_MAP.put("COS", null);
        FUNCTION_MAP.put("COT", null);
        FUNCTION_MAP.put("DEGREES", null);
        FUNCTION_MAP.put("EXP", null);
        FUNCTION_MAP.put("FLOOR", null);
        FUNCTION_MAP.put("LOG", null);
        FUNCTION_MAP.put("LOG10", null);
        FUNCTION_MAP.put("MOD", null);
        FUNCTION_MAP.put("PI", null);
        FUNCTION_MAP.put("POWER", null);
        FUNCTION_MAP.put("RADIANS", null);
        FUNCTION_MAP.put("RAND", null);
        FUNCTION_MAP.put("ROUND", null);
        FUNCTION_MAP.put("SIGN", null);
        FUNCTION_MAP.put("SIN", null);
        FUNCTION_MAP.put("SQRT", null);
        FUNCTION_MAP.put("TAN", null);
        FUNCTION_MAP.put("TRUNCATE", null);
        FUNCTION_MAP.put("ASCII", null);
        FUNCTION_MAP.put("CHAR", null);
        FUNCTION_MAP.put("CONCAT", "{0}||{1}");
        FUNCTION_MAP.put("DIFFERENCE", null);
        FUNCTION_MAP.put("INSERT", null);
        FUNCTION_MAP.put("LCASE", null);
        FUNCTION_MAP.put("LEFT", "SUBSTRING({0} FROM 1 FOR {1}");
        FUNCTION_MAP.put("LENGTH", null);
        FUNCTION_MAP.put("LOCATE", null);
        FUNCTION_MAP.put("LTRIM", null);
        FUNCTION_MAP.put("REPEAT", null);
        FUNCTION_MAP.put("REPLACE", null);
        FUNCTION_MAP.put("RIGHT", null);
        FUNCTION_MAP.put("RTRIM", null);
        FUNCTION_MAP.put("SOUNDEX", null);
        FUNCTION_MAP.put("SPACE", null);
        FUNCTION_MAP.put("SUBSTRING", "SUBSTRING({0} FROM {1} FOR {2})");
        FUNCTION_MAP.put("UCASE", "UPPER({0})");
        FUNCTION_MAP.put("CURDATE", "CURRENT_DATE");
        FUNCTION_MAP.put("CURTIME", "CURRENT_TIME");
        FUNCTION_MAP.put("DAYNAME", null);
        FUNCTION_MAP.put("DAYOFMONTH", "EXTRACT(DAY FROM {0})");
        FUNCTION_MAP.put("DAYOFWEEK", null);
        FUNCTION_MAP.put("DAYOFYEAR", null);
        FUNCTION_MAP.put("HOUR", "EXTRACT(HOUR FROM {0})");
        FUNCTION_MAP.put("MINUTE", "EXTRACT(MINUTE FROM {0})");
        FUNCTION_MAP.put("MONTH", "EXTRACT(MONTH FROM {0})");
        FUNCTION_MAP.put("MONTHNAME", null);
        FUNCTION_MAP.put("NOW", "CURRENT_TIMESTAMP");
        FUNCTION_MAP.put("QUARTER", null);
        FUNCTION_MAP.put("SECOND", "EXTRACT(SECOND FROM {0})");
        FUNCTION_MAP.put("TIMESTAMPADD", null);
        FUNCTION_MAP.put("TIMESTAMPDIFF", null);
        FUNCTION_MAP.put("WEEK", null);
        FUNCTION_MAP.put("YEAR", "EXTRACT(YEAR FROM {0})");
        FUNCTION_MAP.put("DATABASE", null);
        FUNCTION_MAP.put("IFNULL", "COALESCE({0}, {1})");
        FUNCTION_MAP.put("CONVERT", "CAST({0} AS {1})");
    }
}

