/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jdbc;

import java.sql.CallableStatement;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.resource.ResourceException;
import org.firebirdsql.gds.DatabaseParameterBuffer;
import org.firebirdsql.gds.GDS;
import org.firebirdsql.gds.GDSException;
import org.firebirdsql.gds.GDSType;
import org.firebirdsql.gds.isc_blob_handle;
import org.firebirdsql.gds.isc_db_handle;
import org.firebirdsql.gds.isc_stmt_handle;
import org.firebirdsql.jca.FBLocalTransaction;
import org.firebirdsql.jca.FBManagedConnection;
import org.firebirdsql.jca.FBResourceException;
import org.firebirdsql.jca.FBTpb;
import org.firebirdsql.jca.FBTpbMapper;
import org.firebirdsql.jdbc.AbstractPreparedStatement;
import org.firebirdsql.jdbc.AbstractStatement;
import org.firebirdsql.jdbc.FBBlob;
import org.firebirdsql.jdbc.FBCallableStatement;
import org.firebirdsql.jdbc.FBDatabaseMetaData;
import org.firebirdsql.jdbc.FBDriverNotCapableException;
import org.firebirdsql.jdbc.FBEscapedParser;
import org.firebirdsql.jdbc.FBPreparedStatement;
import org.firebirdsql.jdbc.FBSQLException;
import org.firebirdsql.jdbc.FBSQLWarning;
import org.firebirdsql.jdbc.FBStatement;
import org.firebirdsql.jdbc.FirebirdBlob;
import org.firebirdsql.jdbc.FirebirdConnection;

public abstract class AbstractConnection
implements FirebirdConnection {
    private boolean autoTransaction = false;
    private boolean invalid = false;
    protected FBManagedConnection mc;
    private FBLocalTransaction localTransaction = null;
    private FBDatabaseMetaData metaData = null;
    private SQLWarning firstWarning = null;
    private HashSet activeStatements = new HashSet();

    public AbstractConnection(FBManagedConnection mc) {
        this.mc = mc;
    }

    private void checkValidity() throws SQLException {
        if (this.invalid || this.isClosed()) {
            throw new FBSQLException("This connection is closed and cannot be used now.", "08003");
        }
    }

    void notifyStatementClosed(AbstractStatement stmt) {
        if (!this.activeStatements.remove(stmt)) {
            throw new IllegalArgumentException("Specified statement was not created by this connection.");
        }
    }

    private void freeStatements() throws SQLException {
        Set statements = (Set)this.activeStatements.clone();
        Iterator iter = statements.iterator();
        SQLException e = null;
        while (iter.hasNext()) {
            try {
                Statement stmt = (Statement)iter.next();
                stmt.close();
            }
            catch (SQLException ex) {
                if (e != null) {
                    e.setNextException(ex);
                    continue;
                }
                e = ex;
            }
        }
        if (e != null) {
            throw e;
        }
    }

    public void setManagedConnection(FBManagedConnection mc) {
        if (this.mc != mc && this.metaData != null) {
            this.metaData.close();
            this.metaData = null;
        }
        this.mc = mc;
    }

    public isc_db_handle getIscDBHandle() throws GDSException {
        return this.mc.getIscDBHandle();
    }

    public GDS getInternalAPIHandler() {
        return this.mc.getInternalAPIHandler();
    }

    public DatabaseParameterBuffer getDatabaseParameterBuffer() {
        return this.mc.getConnectionRequestInfo().getDpb();
    }

    public void setTransactionParameters(int isolationLevel, int[] parameters) throws SQLException {
        try {
            FBTpb tpb = this.mc.getTpb();
            FBTpbMapper tpbMapper = tpb.getMapper();
            HashSet<Integer> tpbParams = new HashSet<Integer>();
            for (int i = 0; i < parameters.length; ++i) {
                tpbParams.add(new Integer(parameters[i]));
            }
            tpbMapper.setMapping(isolationLevel, tpbParams);
            tpb.setMapper(tpbMapper);
        }
        catch (FBResourceException ex) {
            throw new FBSQLException(ex);
        }
    }

    public synchronized Statement createStatement() throws SQLException {
        return this.createStatement(1003, 1007);
    }

    public synchronized PreparedStatement prepareStatement(String sql) throws SQLException {
        return this.prepareStatement(sql, 1003, 1007);
    }

    public synchronized CallableStatement prepareCall(String sql) throws SQLException {
        return this.prepareCall(sql, 1003, 1007);
    }

    public synchronized String nativeSQL(String sql) throws SQLException {
        DatabaseParameterBuffer dpb = this.getDatabaseParameterBuffer();
        int mode = 0;
        if (dpb.hasArgument(134)) {
            mode = 1;
        }
        return new FBEscapedParser(mode).parse(sql);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setAutoCommit(boolean autoCommit) throws SQLException {
        this.checkValidity();
        FBManagedConnection fBManagedConnection = this.mc;
        synchronized (fBManagedConnection) {
            if (this.mc.autoCommit != autoCommit) {
                try {
                    if (this.inTransaction()) {
                        this.getLocalTransaction().internalCommit();
                    }
                    this.mc.autoCommit = autoCommit;
                }
                catch (ResourceException ge) {
                    throw new FBSQLException(ge);
                }
            }
        }
    }

    public boolean getAutoCommit() throws SQLException {
        if (this.isClosed()) {
            throw new FBSQLException("You cannot getAutomcommit on an unassociated closed connection.");
        }
        return this.mc.autoCommit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void commit() throws SQLException {
        if (this.isClosed()) {
            throw new FBSQLException("You cannot commit a closed connection.", "08003");
        }
        if (this.getAutoCommit() && this.getInternalAPIHandler().getType() != GDSType.ORACLE_MODE) {
            throw new FBSQLException("commit called with AutoCommit true!");
        }
        FBManagedConnection fBManagedConnection = this.mc;
        synchronized (fBManagedConnection) {
            try {
                if (this.inTransaction()) {
                    this.getLocalTransaction().internalCommit();
                }
            }
            catch (ResourceException ge) {
                throw new FBSQLException(ge);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void rollback() throws SQLException {
        if (this.getAutoCommit() && this.getInternalAPIHandler().getType() != GDSType.ORACLE_MODE) {
            throw new FBSQLException("Rollback called with AutoCommit true!");
        }
        if (this.isClosed()) {
            throw new FBSQLException("You cannot rollback closed connection.", "08003");
        }
        FBManagedConnection fBManagedConnection = this.mc;
        synchronized (fBManagedConnection) {
            try {
                if (this.inTransaction()) {
                    this.getLocalTransaction().internalRollback();
                }
            }
            catch (ResourceException ex) {
                throw new FBSQLException(ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void close() throws SQLException {
        block17: {
            FBManagedConnection fBManagedConnection;
            try {
                this.freeStatements();
                Object var2_1 = null;
                if (this.mc == null) break block17;
                fBManagedConnection = this.mc;
            }
            catch (Throwable throwable) {
                block21: {
                    Object var2_2 = null;
                    if (this.mc == null) break block21;
                    FBManagedConnection fBManagedConnection2 = this.mc;
                    synchronized (fBManagedConnection2) {
                        if (!this.getAutoCommit()) {
                            block20: {
                                try {
                                    if (!this.inTransaction()) break block20;
                                    this.getLocalTransaction().internalRollback();
                                }
                                catch (ResourceException ge) {
                                    try {}
                                    catch (Throwable throwable2) {
                                        this.setAutoCommit(true);
                                        throw throwable2;
                                    }
                                    throw new FBSQLException(ge);
                                }
                            }
                            this.setAutoCommit(true);
                        }
                        this.mc.close(this);
                    }
                    this.mc = null;
                }
                throw throwable;
            }
            synchronized (fBManagedConnection) {
                if (!this.getAutoCommit()) {
                    try {
                        if (this.inTransaction()) {
                            this.getLocalTransaction().internalRollback();
                        }
                    }
                    catch (ResourceException ge) {
                        throw new FBSQLException(ge);
                    }
                    finally {
                        this.setAutoCommit(true);
                    }
                }
                this.mc.close(this);
            }
            this.mc = null;
            {
            }
        }
    }

    public boolean isClosed() {
        return this.mc == null;
    }

    public synchronized DatabaseMetaData getMetaData() throws SQLException {
        if (this.metaData == null) {
            this.metaData = new FBDatabaseMetaData(this);
        }
        return this.metaData;
    }

    public synchronized void setReadOnly(boolean readOnly) throws SQLException {
        this.mc.setReadOnly(readOnly);
    }

    public boolean isReadOnly() throws SQLException {
        return this.mc.isReadOnly();
    }

    public synchronized void setCatalog(String catalog) throws SQLException {
    }

    public String getCatalog() throws SQLException {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setTransactionIsolation(int level) throws SQLException {
        if (this.isClosed()) {
            throw new FBSQLException("Connection has being closed.", "08003");
        }
        if (this.getTransactionIsolation() != level) {
            FBManagedConnection fBManagedConnection = this.mc;
            synchronized (fBManagedConnection) {
                try {
                    if (this.inTransaction()) {
                        this.getLocalTransaction().internalCommit();
                    }
                    this.mc.setTransactionIsolation(level);
                }
                catch (ResourceException re) {
                    throw new FBSQLException(re);
                }
            }
        }
    }

    public int getTransactionIsolation() throws SQLException {
        try {
            return this.mc.getTransactionIsolation();
        }
        catch (ResourceException e) {
            throw new FBSQLException(e);
        }
    }

    public SQLWarning getWarnings() throws SQLException {
        SQLWarning warning = this.firstWarning;
        SQLWarning iscWarning = this.getIscWarnings();
        if (warning == null) {
            warning = iscWarning;
        } else if (iscWarning != null) {
            warning.setNextWarning(iscWarning);
        }
        return warning;
    }

    public void clearWarnings() throws SQLException {
        this.firstWarning = null;
        this.clearIscWarnings();
    }

    public synchronized Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        if (resultSetType == 1005 || resultSetConcurrency != 1007) {
            this.addWarning(new FBSQLWarning("Unsupported type and/or concurrency"));
            if (resultSetType == 1005) {
                resultSetType = 1004;
            }
            resultSetConcurrency = 1007;
        }
        FBStatement stmt = new FBStatement(this, resultSetType, resultSetConcurrency);
        this.activeStatements.add(stmt);
        return stmt;
    }

    public synchronized PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        if (resultSetType == 1005 && resultSetConcurrency != 1007) {
            this.addWarning(new FBSQLWarning("resultSetType or resultSetConcurrency changed"));
            if (resultSetType == 1005) {
                resultSetType = 1004;
            }
            resultSetConcurrency = 1007;
        }
        FBPreparedStatement stmt = new FBPreparedStatement(this, sql, resultSetType, resultSetConcurrency);
        this.activeStatements.add(stmt);
        return stmt;
    }

    public synchronized CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        if (resultSetType == 1005 && resultSetConcurrency != 1007) {
            this.addWarning(new FBSQLWarning("resultSetType or resultSetConcurrency changed"));
            if (resultSetType == 1005) {
                resultSetType = 1004;
            }
            resultSetConcurrency = 1007;
        }
        FBCallableStatement stmt = new FBCallableStatement(this, sql, resultSetType, resultSetConcurrency);
        this.activeStatements.add(stmt);
        return stmt;
    }

    public Map getTypeMap() throws SQLException {
        return new HashMap();
    }

    public synchronized void setTypeMap(Map map) throws SQLException {
        throw new FBDriverNotCapableException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized FBLocalTransaction getLocalTransaction() {
        FBManagedConnection fBManagedConnection = this.mc;
        synchronized (fBManagedConnection) {
            if (this.localTransaction == null) {
                this.localTransaction = new FBLocalTransaction(this.mc, this);
            }
            return this.localTransaction;
        }
    }

    public synchronized FirebirdBlob createBlob() throws SQLException {
        if (!this.getAutoCommit()) {
            this.ensureInTransaction();
        }
        return new FBBlob(this);
    }

    public boolean inTransaction() {
        return this.mc.inTransaction();
    }

    String getDatabase() {
        return this.mc.getDatabase();
    }

    String getUserName() {
        return this.mc.getUserName();
    }

    public String getIscEncoding() {
        return this.mc.getIscEncoding();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void ensureInTransaction() throws SQLException {
        FBManagedConnection fBManagedConnection = this.mc;
        synchronized (fBManagedConnection) {
            try {
                if (this.inTransaction()) {
                    this.autoTransaction = false;
                    return;
                }
                this.getLocalTransaction().begin();
                this.autoTransaction = true;
            }
            catch (ResourceException re) {
                throw new FBSQLException(re);
            }
        }
    }

    public synchronized boolean willEndTransaction() throws SQLException {
        return this.getAutoCommit() && this.autoTransaction;
    }

    public synchronized void checkEndTransaction() throws SQLException {
        this.checkEndTransaction(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void checkEndTransaction(boolean commit) throws SQLException {
        if (this.willEndTransaction()) {
            this.autoTransaction = false;
            FBManagedConnection fBManagedConnection = this.mc;
            synchronized (fBManagedConnection) {
                try {
                    if (commit) {
                        this.getLocalTransaction().internalCommit();
                    } else {
                        this.getLocalTransaction().internalRollback();
                    }
                }
                catch (ResourceException ge) {
                    throw new FBSQLException(ge);
                }
            }
        }
    }

    protected synchronized void addWarning(SQLWarning warning) {
        if (this.firstWarning == null) {
            this.firstWarning = warning;
        } else {
            SQLWarning lastWarning = this.firstWarning;
            while (lastWarning.getNextWarning() != null) {
                lastWarning = lastWarning.getNextWarning();
            }
            lastWarning.setNextWarning(warning);
        }
    }

    private SQLWarning getIscWarnings() {
        FBSQLWarning firstWarning = null;
        SQLWarning lastWarning = null;
        Iterator iter = this.mc.getWarnings().iterator();
        while (iter.hasNext()) {
            GDSException item = (GDSException)iter.next();
            FBSQLWarning warning = new FBSQLWarning(item);
            if (firstWarning == null) {
                firstWarning = warning;
                lastWarning = firstWarning;
                continue;
            }
            lastWarning.setNextWarning(warning);
            lastWarning = warning;
        }
        return firstWarning;
    }

    private void clearIscWarnings() {
        this.mc.clearWarnings();
    }

    private void checkManagedConnection() throws GDSException {
        if (this.mc == null) {
            throw new GDSException(1, 335544363);
        }
    }

    public isc_stmt_handle getAllocatedStatement() throws GDSException {
        this.checkManagedConnection();
        return this.mc.getAllocatedStatement();
    }

    public void executeStatement(isc_stmt_handle stmt, boolean sendOutSqlda) throws GDSException {
        this.checkManagedConnection();
        if (stmt == null || !stmt.isValid()) {
            throw new GDSException(335544327);
        }
        this.mc.executeStatement(stmt, sendOutSqlda);
    }

    public void closeStatement(isc_stmt_handle stmt, boolean deallocate) throws GDSException {
        this.checkManagedConnection();
        if (stmt == null || !stmt.isValid()) {
            throw new GDSException(335544327);
        }
        this.mc.closeStatement(stmt, deallocate);
    }

    public void prepareSQL(isc_stmt_handle stmt, String sql, boolean describeBind) throws GDSException, SQLException {
        this.checkManagedConnection();
        this.mc.prepareSQL(stmt, sql, describeBind);
    }

    public void registerStatement(AbstractStatement fbStatement) {
        this.mc.registerStatement(fbStatement.fixedStmt);
    }

    public void fetch(isc_stmt_handle stmt, int fetchSize) throws GDSException {
        this.checkManagedConnection();
        if (stmt == null || !stmt.isValid()) {
            throw new GDSException(335544327);
        }
        this.mc.fetch(stmt, fetchSize);
    }

    public void setCursorName(isc_stmt_handle stmt, String cursorName) throws GDSException {
        this.checkManagedConnection();
        if (stmt == null || !stmt.isValid()) {
            throw new GDSException(335544327);
        }
        this.mc.setCursorName(stmt, cursorName);
    }

    public void getSqlCounts(isc_stmt_handle stmt) throws GDSException {
        this.checkManagedConnection();
        if (stmt == null || !stmt.isValid()) {
            throw new GDSException(335544327);
        }
        this.mc.getSqlCounts(stmt);
    }

    public String getDatabaseProductName() {
        return this.mc.getDatabaseProductName();
    }

    public String getDatabaseProductVersion() {
        return this.mc.getDatabaseProductVersion();
    }

    public int getDatabaseProductMajorVersion() {
        return this.mc.getDatabaseProductMajorVersion();
    }

    public int getDatabaseProductMinorVersion() {
        return this.mc.getDatabaseProductMinorVersion();
    }

    public Integer getBlobBufferLength() {
        return this.mc.getBlobBufferLength();
    }

    public isc_blob_handle openBlobHandle(long blob_id, boolean segmented) throws GDSException {
        this.checkManagedConnection();
        return this.mc.openBlobHandle(blob_id, segmented);
    }

    public byte[] getBlobSegment(isc_blob_handle blob, int len) throws GDSException {
        this.checkManagedConnection();
        return this.mc.getBlobSegment(blob, len);
    }

    public void closeBlob(isc_blob_handle blob) throws GDSException {
        this.checkManagedConnection();
        this.mc.closeBlob(blob);
    }

    public isc_blob_handle createBlobHandle(boolean segmented) throws GDSException {
        this.checkManagedConnection();
        return this.mc.createBlobHandle(segmented);
    }

    public void putBlobSegment(isc_blob_handle blob, byte[] buf) throws GDSException {
        this.checkManagedConnection();
        this.mc.putBlobSegment(blob, buf);
    }

    public String getJavaEncoding() {
        return this.getDatabaseParameterBuffer().getArgumentAsString(135);
    }

    public String getMappingPath() {
        return this.getDatabaseParameterBuffer().getArgumentAsString(136);
    }

    private AbstractPreparedStatement getStatement(String sql, HashMap statements) throws SQLException {
        AbstractPreparedStatement s = (AbstractPreparedStatement)statements.get(sql);
        if (s == null) {
            s = (AbstractPreparedStatement)this.prepareStatement(sql);
            statements.put(sql, s);
        }
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized ResultSet doQuery(String sql, List params, HashMap statements) throws SQLException {
        AbstractPreparedStatement s = this.getStatement(sql, statements);
        for (int i = 0; i < params.size(); ++i) {
            s.setStringForced(i + 1, (String)params.get(i));
        }
        ResultSet rs = null;
        rs = s.executeMetaDataQuery();
        return rs;
    }

    protected void finalize() throws Throwable {
        this.close();
    }
}

