/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.query;

import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Blob;
import java.sql.Clob;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.lucene.document.Document;
import org.apache.lucene.search.Hits;
import org.apache.lucene.search.Searcher;
import org.hibernate.HibernateException;
import org.hibernate.ScrollableResults;
import org.hibernate.Session;
import org.hibernate.search.engine.DocumentBuilder;
import org.hibernate.search.event.FullTextIndexEventListener;
import org.hibernate.search.query.EntityInfo;
import org.hibernate.type.Type;

public class ScrollableResultsImpl
implements ScrollableResults {
    private final Searcher searcher;
    private final Hits hits;
    private final int first;
    private final int max;
    private int current;
    private final Session session;
    private final FullTextIndexEventListener listener;
    private EntityInfo[] entityInfos;

    public ScrollableResultsImpl(Searcher searcher, Hits hits, int first, int max, Session session, FullTextIndexEventListener listener) {
        this.searcher = searcher;
        this.hits = hits;
        this.first = first;
        this.max = max;
        this.current = first;
        this.session = session;
        this.listener = listener;
        this.entityInfos = new EntityInfo[max - first + 1];
    }

    public boolean next() throws HibernateException {
        return ++this.current <= this.max;
    }

    public boolean previous() throws HibernateException {
        return --this.current >= this.first;
    }

    public boolean scroll(int i) throws HibernateException {
        this.current += i;
        return this.current >= this.first && this.current <= this.max;
    }

    public boolean last() throws HibernateException {
        this.current = this.max;
        return this.max >= this.first;
    }

    public boolean first() throws HibernateException {
        this.current = this.first;
        return this.max >= this.first;
    }

    public void beforeFirst() throws HibernateException {
        this.current = this.first - 1;
    }

    public void afterLast() throws HibernateException {
        this.current = this.max + 1;
    }

    public boolean isFirst() throws HibernateException {
        return this.current == this.first;
    }

    public boolean isLast() throws HibernateException {
        return this.current == this.max;
    }

    public void close() throws HibernateException {
        try {
            this.searcher.close();
        }
        catch (IOException e) {
            throw new HibernateException("Unable to close Lucene searcher", (Throwable)e);
        }
    }

    public Object[] get() throws HibernateException {
        if (this.current < this.first || this.current > this.max) {
            return null;
        }
        EntityInfo info = this.entityInfos[this.current - this.first];
        if (info == null) {
            info = new EntityInfo();
            Document document = null;
            try {
                document = this.hits.doc(this.current);
            }
            catch (IOException e) {
                throw new HibernateException("Unable to read Lucene hits[" + this.current + "]", (Throwable)e);
            }
            info.clazz = DocumentBuilder.getDocumentClass(document);
            info.id = DocumentBuilder.getDocumentId(this.listener, info.clazz, document);
            this.entityInfos[this.current - this.first] = info;
        }
        return new Object[]{this.session.get(info.clazz, info.id)};
    }

    public Object get(int i) throws HibernateException {
        throw new UnsupportedOperationException("Lucene does not work on columns");
    }

    public Type getType(int i) {
        throw new UnsupportedOperationException("Lucene does not work on columns");
    }

    public Integer getInteger(int col) throws HibernateException {
        throw new UnsupportedOperationException("Lucene does not work on columns");
    }

    public Long getLong(int col) throws HibernateException {
        throw new UnsupportedOperationException("Lucene does not work on columns");
    }

    public Float getFloat(int col) throws HibernateException {
        throw new UnsupportedOperationException("Lucene does not work on columns");
    }

    public Boolean getBoolean(int col) throws HibernateException {
        throw new UnsupportedOperationException("Lucene does not work on columns");
    }

    public Double getDouble(int col) throws HibernateException {
        throw new UnsupportedOperationException("Lucene does not work on columns");
    }

    public Short getShort(int col) throws HibernateException {
        throw new UnsupportedOperationException("Lucene does not work on columns");
    }

    public Byte getByte(int col) throws HibernateException {
        throw new UnsupportedOperationException("Lucene does not work on columns");
    }

    public Character getCharacter(int col) throws HibernateException {
        throw new UnsupportedOperationException("Lucene does not work on columns");
    }

    public byte[] getBinary(int col) throws HibernateException {
        throw new UnsupportedOperationException("Lucene does not work on columns");
    }

    public String getText(int col) throws HibernateException {
        throw new UnsupportedOperationException("Lucene does not work on columns");
    }

    public Blob getBlob(int col) throws HibernateException {
        throw new UnsupportedOperationException("Lucene does not work on columns");
    }

    public Clob getClob(int col) throws HibernateException {
        throw new UnsupportedOperationException("Lucene does not work on columns");
    }

    public String getString(int col) throws HibernateException {
        throw new UnsupportedOperationException("Lucene does not work on columns");
    }

    public BigDecimal getBigDecimal(int col) throws HibernateException {
        throw new UnsupportedOperationException("Lucene does not work on columns");
    }

    public BigInteger getBigInteger(int col) throws HibernateException {
        throw new UnsupportedOperationException("Lucene does not work on columns");
    }

    public Date getDate(int col) throws HibernateException {
        throw new UnsupportedOperationException("Lucene does not work on columns");
    }

    public Locale getLocale(int col) throws HibernateException {
        throw new UnsupportedOperationException("Lucene does not work on columns");
    }

    public Calendar getCalendar(int col) throws HibernateException {
        throw new UnsupportedOperationException("Lucene does not work on columns");
    }

    public TimeZone getTimeZone(int col) throws HibernateException {
        throw new UnsupportedOperationException("Lucene does not work on columns");
    }

    public int getRowNumber() throws HibernateException {
        if (this.max < this.first) {
            return -1;
        }
        return this.current - this.first;
    }

    public boolean setRowNumber(int rowNumber) throws HibernateException {
        this.current = rowNumber >= 0 ? this.first + rowNumber : this.max + rowNumber + 1;
        return this.current >= this.first && this.current <= this.max;
    }
}

