/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record;

import org.apache.poi.hssf.record.LinkedDataFormulaField;
import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.RecordFormatException;
import org.apache.poi.hssf.record.RecordInputStream;
import org.apache.poi.util.BitField;
import org.apache.poi.util.BitFieldFactory;
import org.apache.poi.util.HexDump;
import org.apache.poi.util.LittleEndian;

public class LinkedDataRecord
extends Record {
    public static final short sid = 4177;
    private byte field_1_linkType;
    public static final byte LINK_TYPE_TITLE_OR_TEXT = 0;
    public static final byte LINK_TYPE_VALUES = 1;
    public static final byte LINK_TYPE_CATEGORIES = 2;
    private byte field_2_referenceType;
    public static final byte REFERENCE_TYPE_DEFAULT_CATEGORIES = 0;
    public static final byte REFERENCE_TYPE_DIRECT = 1;
    public static final byte REFERENCE_TYPE_WORKSHEET = 2;
    public static final byte REFERENCE_TYPE_NOT_USED = 3;
    public static final byte REFERENCE_TYPE_ERROR_REPORTED = 4;
    private short field_3_options;
    private BitField customNumberFormat = BitFieldFactory.getInstance(1);
    private short field_4_indexNumberFmtRecord;
    private LinkedDataFormulaField field_5_formulaOfLink;

    public LinkedDataRecord() {
    }

    public LinkedDataRecord(RecordInputStream in) {
        super(in);
    }

    protected void validateSid(short id) {
        if (id != 4177) {
            throw new RecordFormatException("Not a LinkedData record");
        }
    }

    protected void fillFields(RecordInputStream in) {
        this.field_1_linkType = in.readByte();
        this.field_2_referenceType = in.readByte();
        this.field_3_options = in.readShort();
        this.field_4_indexNumberFmtRecord = in.readShort();
        this.field_5_formulaOfLink = new LinkedDataFormulaField();
        this.field_5_formulaOfLink.fillField(in);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[AI]\n");
        buffer.append("    .linkType             = ").append("0x").append(HexDump.toHex(this.getLinkType())).append(" (").append(this.getLinkType()).append(" )");
        buffer.append(System.getProperty("line.separator"));
        buffer.append("    .referenceType        = ").append("0x").append(HexDump.toHex(this.getReferenceType())).append(" (").append(this.getReferenceType()).append(" )");
        buffer.append(System.getProperty("line.separator"));
        buffer.append("    .options              = ").append("0x").append(HexDump.toHex(this.getOptions())).append(" (").append(this.getOptions()).append(" )");
        buffer.append(System.getProperty("line.separator"));
        buffer.append("         .customNumberFormat       = ").append(this.isCustomNumberFormat()).append('\n');
        buffer.append("    .indexNumberFmtRecord = ").append("0x").append(HexDump.toHex(this.getIndexNumberFmtRecord())).append(" (").append(this.getIndexNumberFmtRecord()).append(" )");
        buffer.append(System.getProperty("line.separator"));
        buffer.append("    .formulaOfLink        = ").append(" (").append(this.getFormulaOfLink()).append(" )");
        buffer.append(System.getProperty("line.separator"));
        buffer.append("[/AI]\n");
        return buffer.toString();
    }

    public int serialize(int offset, byte[] data) {
        int pos = 0;
        LittleEndian.putShort(data, 0 + offset, (short)4177);
        LittleEndian.putShort(data, 2 + offset, (short)(this.getRecordSize() - 4));
        data[4 + offset + pos] = this.field_1_linkType;
        data[5 + offset + pos] = this.field_2_referenceType;
        LittleEndian.putShort(data, 6 + offset + pos, this.field_3_options);
        LittleEndian.putShort(data, 8 + offset + pos, this.field_4_indexNumberFmtRecord);
        pos += this.field_5_formulaOfLink.serializeField(pos + 10 + offset, data);
        return this.getRecordSize();
    }

    public int getRecordSize() {
        return 10 + this.field_5_formulaOfLink.getSize();
    }

    public short getSid() {
        return 4177;
    }

    public Object clone() {
        LinkedDataRecord rec = new LinkedDataRecord();
        rec.field_1_linkType = this.field_1_linkType;
        rec.field_2_referenceType = this.field_2_referenceType;
        rec.field_3_options = this.field_3_options;
        rec.field_4_indexNumberFmtRecord = this.field_4_indexNumberFmtRecord;
        rec.field_5_formulaOfLink = (LinkedDataFormulaField)this.field_5_formulaOfLink.clone();
        return rec;
    }

    public byte getLinkType() {
        return this.field_1_linkType;
    }

    public void setLinkType(byte field_1_linkType) {
        this.field_1_linkType = field_1_linkType;
    }

    public byte getReferenceType() {
        return this.field_2_referenceType;
    }

    public void setReferenceType(byte field_2_referenceType) {
        this.field_2_referenceType = field_2_referenceType;
    }

    public short getOptions() {
        return this.field_3_options;
    }

    public void setOptions(short field_3_options) {
        this.field_3_options = field_3_options;
    }

    public short getIndexNumberFmtRecord() {
        return this.field_4_indexNumberFmtRecord;
    }

    public void setIndexNumberFmtRecord(short field_4_indexNumberFmtRecord) {
        this.field_4_indexNumberFmtRecord = field_4_indexNumberFmtRecord;
    }

    public LinkedDataFormulaField getFormulaOfLink() {
        return this.field_5_formulaOfLink;
    }

    public void setFormulaOfLink(LinkedDataFormulaField field_5_formulaOfLink) {
        this.field_5_formulaOfLink = field_5_formulaOfLink;
    }

    public void setCustomNumberFormat(boolean value) {
        this.field_3_options = this.customNumberFormat.setShortBoolean(this.field_3_options, value);
    }

    public boolean isCustomNumberFormat() {
        return this.customNumberFormat.isSet(this.field_3_options);
    }
}

