/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.utils.repositories;

import java.io.Serializable;

public class Vector_boolean
implements Serializable {
    int increment_size = 1000;
    protected int current_item = 0;
    int max_size = 250;
    private boolean[] items = new boolean[this.max_size];

    public Vector_boolean() {
    }

    protected int incrementSize(int increment_size) {
        increment_size = increment_size < 8000 ? (increment_size *= 4) : (increment_size < 16000 ? (increment_size *= 2) : (increment_size += 2000));
        return increment_size;
    }

    public Vector_boolean(int number) {
        this.max_size = number;
        this.items = new boolean[this.max_size];
    }

    public final boolean[] get() {
        return this.items;
    }

    public final void setElementAt(boolean new_name, int id) {
        if (id >= this.max_size) {
            this.checkSize(id);
        }
        this.items[id] = new_name;
    }

    public final int size() {
        return this.items.length;
    }

    public final void addElement(boolean value) {
        this.checkSize(this.current_item);
        this.items[this.current_item] = value;
        ++this.current_item;
    }

    public final void set(boolean[] new_items) {
        this.items = new_items;
    }

    public final void removeElementAt(int id) {
        if (id >= 0) {
            System.arraycopy(this.items, id + 1, this.items, id, this.max_size - 2 - id);
            this.items[this.max_size - 1] = false;
        } else {
            this.items[0] = false;
        }
        --this.current_item;
    }

    public final void clear() {
        if (this.current_item > 0) {
            int i = 0;
            while (i < this.current_item) {
                this.items[i] = false;
                ++i;
            }
        } else {
            int i = 0;
            while (i < this.max_size) {
                this.items[i] = false;
                ++i;
            }
        }
        this.current_item = 0;
    }

    public final boolean elementAt(int id) {
        if (id >= this.max_size) {
            return false;
        }
        return this.items[id];
    }

    public final void insertElementAt(boolean new_name, int id) {
        this.current_item = this.items.length;
        this.checkSize(this.current_item + 1);
        int i = this.current_item;
        while (i > id) {
            this.items[i + 1] = this.items[i];
            --i;
        }
        this.items[id] = new_name;
        ++this.current_item;
    }

    private final void checkSize(int i) {
        if (i >= this.max_size) {
            int old_size = this.max_size;
            this.max_size += this.increment_size;
            if (this.max_size <= i) {
                this.max_size = i + this.increment_size + 2;
            }
            boolean[] temp = this.items;
            this.items = new boolean[this.max_size];
            System.arraycopy(temp, 0, this.items, 0, old_size);
            this.increment_size = this.incrementSize(this.increment_size);
        }
    }

    public void trim() {
        boolean[] newItems = new boolean[this.current_item];
        System.arraycopy(this.items, 0, newItems, 0, this.current_item);
        this.items = newItems;
        this.max_size = this.current_item;
    }

    public void setSize(int currentItem) {
        this.current_item = currentItem;
    }
}

