/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.utils.repositories;

import java.io.Serializable;

public class Vector_String
implements Serializable {
    int increment_size = 1000;
    protected int current_item = 0;
    int max_size = 250;
    private String[] items = new String[this.max_size];

    public Vector_String(int number) {
        this.max_size = number;
        this.items = new String[this.max_size];
    }

    public Vector_String() {
    }

    protected int incrementSize(int increment_size) {
        increment_size = increment_size < 8000 ? (increment_size *= 4) : (increment_size < 16000 ? (increment_size *= 2) : (increment_size += 2000));
        return increment_size;
    }

    public final String[] get() {
        return this.items;
    }

    public final String elementAt(int id) {
        String value = null;
        if (id < this.max_size) {
            value = this.items[id];
        }
        if (value == null) {
            value = "";
        }
        return value;
    }

    public final boolean contains(String value) {
        boolean flag = false;
        int i = 0;
        while (i < this.current_item) {
            if (this.items[i].equals(value)) {
                i = this.current_item + 1;
                flag = true;
            }
            ++i;
        }
        return flag;
    }

    public final void merge(int master, int child, String separator) {
        this.items[master] = String.valueOf(this.items[master]) + separator + this.items[child];
        this.items[child] = null;
    }

    public final void clear() {
        if (this.current_item > 0) {
            int i = 0;
            while (i < this.current_item) {
                this.items[i] = null;
                ++i;
            }
        } else {
            int i = 0;
            while (i < this.max_size) {
                this.items[i] = null;
                ++i;
            }
        }
        this.current_item = 0;
    }

    public final void removeElementAt(int id) {
        if (id >= 0) {
            System.arraycopy(this.items, id + 1, this.items, id, this.current_item - 1 - id);
            this.items[this.current_item - 1] = "";
        } else {
            this.items[0] = "";
        }
        --this.current_item;
    }

    public final void set(String[] new_items) {
        this.items = new_items;
    }

    public final void addElement(String value) {
        this.checkSize(this.current_item);
        this.items[this.current_item] = value;
        ++this.current_item;
    }

    public final int size() {
        return this.current_item + 1;
    }

    public final void setElementAt(String new_name, int id) {
        if (id >= this.max_size) {
            this.checkSize(id);
        }
        this.items[id] = new_name;
    }

    private final void checkSize(int i) {
        if (i >= this.max_size) {
            int old_size = this.max_size;
            this.max_size += this.increment_size;
            if (this.max_size <= i) {
                this.max_size = i + this.increment_size + 2;
            }
            String[] temp = this.items;
            this.items = new String[this.max_size];
            System.arraycopy(temp, 0, this.items, 0, old_size);
            this.increment_size = this.incrementSize(this.increment_size);
        }
    }

    public void trim() {
        String[] newItems = new String[this.current_item];
        System.arraycopy(this.items, 0, newItems, 0, this.current_item);
        this.items = newItems;
        this.max_size = this.current_item;
    }

    public void setSize(int currentItem) {
        this.current_item = currentItem;
    }
}

