/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.utils.repositories;

import java.io.Serializable;

public class Vector_Int
implements Serializable {
    int increment_size = 1000;
    protected int current_item = 0;
    int max_size = 250;
    protected int[] items = new int[this.max_size];
    protected int defaultValue = 0;
    private int checkPoint = -1;

    public Vector_Int() {
    }

    protected int incrementSize(int increment_size) {
        increment_size = increment_size < 8000 ? (increment_size *= 4) : (increment_size < 16000 ? (increment_size *= 2) : (increment_size += 2000));
        return increment_size;
    }

    public Vector_Int(int number) {
        this.max_size = number;
        this.items = new int[this.max_size];
    }

    public final synchronized int elementAt(int id) {
        if (id >= this.max_size) {
            return 0;
        }
        return this.items[id];
    }

    public final int[] get() {
        return this.items;
    }

    public final void setElementAt(int new_name, int id) {
        if (id >= this.max_size) {
            this.checkSize(id);
        }
        this.items[id] = new_name;
    }

    public final void set(int[] new_items) {
        this.items = new_items;
    }

    public final void keep_larger(int master, int child) {
        if (this.items[master] < this.items[child]) {
            this.items[master] = this.items[child];
        }
    }

    public final void keep_smaller(int master, int child) {
        if (this.items[master] > this.items[child]) {
            this.items[master] = this.items[child];
        }
    }

    public final void clear() {
        this.checkPoint = -1;
        this.items = null;
        this.items = new int[this.max_size];
        if (this.defaultValue != 0) {
            int i = 0;
            while (i < this.max_size) {
                this.items[i] = this.defaultValue;
                ++i;
            }
        } else if (this.current_item > 0) {
            int i = 0;
            while (i < this.current_item) {
                this.items[i] = 0;
                ++i;
            }
        } else {
            int i = 0;
            while (i < this.max_size) {
                this.items[i] = 0;
                ++i;
            }
        }
        this.current_item = 0;
    }

    public final synchronized int size() {
        return this.current_item + 1;
    }

    public final synchronized int getCapacity() {
        return this.items.length;
    }

    public final void removeElementAt(int id) {
        if (id >= 0) {
            System.arraycopy(this.items, id + 1, this.items, id, this.current_item - 1 - id);
            this.items[this.current_item - 1] = 0;
        } else {
            this.items[0] = 0;
        }
        --this.current_item;
    }

    public final synchronized void deleteElementWithValue(int id) {
        int currentSize = this.items.length;
        int[] newItems = new int[currentSize - 1];
        int counter = 0;
        int i = 0;
        while (i < currentSize) {
            if (this.items[i] != id) {
                newItems[counter] = this.items[i];
                ++counter;
            }
            ++i;
        }
        this.items = newItems;
        --this.current_item;
    }

    public String toString() {
        String returnString = "{";
        int i = 0;
        while (i < this.items.length) {
            returnString = String.valueOf(returnString) + ' ' + this.items[i];
            ++i;
        }
        return String.valueOf(returnString) + "} " + this.current_item;
    }

    public final boolean contains(int value) {
        boolean flag = false;
        int i = 0;
        while (i < this.current_item) {
            if (this.items[i] == value) {
                i = this.current_item + 1;
                flag = true;
            }
            ++i;
        }
        return flag;
    }

    public final int pull() {
        if (this.current_item > 0) {
            --this.current_item;
        }
        return this.items[this.current_item];
    }

    public final void push(int value) {
        this.checkSize(this.current_item);
        this.items[this.current_item] = value;
        ++this.current_item;
        this.checkSize(this.current_item);
    }

    public final void addElement(int value) {
        this.checkSize(this.current_item);
        this.items[this.current_item] = value;
        ++this.current_item;
        this.checkSize(this.current_item);
    }

    public final void add_together(int master, int child) {
        this.items[master] = this.items[master] + this.items[child];
    }

    private final void checkSize(int i) {
        if (i >= this.max_size) {
            int old_size = this.max_size;
            this.max_size += this.increment_size;
            if (this.max_size <= i) {
                this.max_size = i + this.increment_size + 2;
            }
            int[] temp = this.items;
            this.items = new int[this.max_size];
            int i1 = 0;
            if (this.defaultValue != 0) {
                i1 = old_size;
                while (i1 < this.max_size) {
                    this.items[i1] = this.defaultValue;
                    ++i1;
                }
            }
            System.arraycopy(temp, 0, this.items, 0, old_size);
            this.increment_size = this.incrementSize(this.increment_size);
        }
    }

    public final void reuse() {
        this.current_item = 0;
    }

    public void trim() {
        int[] newItems = new int[this.current_item];
        System.arraycopy(this.items, 0, newItems, 0, this.current_item);
        this.items = newItems;
        this.max_size = this.current_item;
    }

    public void setSize(int currentItem) {
        this.current_item = currentItem;
    }

    public void resetToCheckpoint() {
        if (this.checkPoint != -1) {
            this.current_item = this.checkPoint;
        }
        this.checkPoint = -1;
    }

    public void setCheckpoint() {
        if (this.checkPoint == -1) {
            this.current_item = this.checkPoint = this.current_item;
        }
    }
}

