/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.utils;

import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.Map;
import org.jpedal.gui.ShowGUIMessage;
import org.jpedal.utils.TimeNow;

public class LogWriter {
    public static boolean debug = false;
    public static String log_name = null;
    private static int debug_level = 0;
    public static boolean testing = false;
    private static boolean verbose = false;

    public static final void resetLogFile() {
        if (log_name != null) {
            PrintWriter log_file = null;
            try {
                log_file = new PrintWriter(new FileWriter(log_name, false));
                log_file.println(String.valueOf(TimeNow.getTimeNow()) + " Running Storypad");
                log_file.flush();
                log_file.close();
            }
            catch (Exception e) {
                System.err.println("Exception " + e + " attempting to write to log file " + log_name);
            }
        }
    }

    public static final void writeLog(String message) {
        if (verbose) {
            System.out.println(message);
        }
        if (log_name != null) {
            PrintWriter log_file = null;
            try {
                log_file = new PrintWriter(new FileWriter(log_name, true));
                if (!testing) {
                    log_file.println(String.valueOf(TimeNow.getTimeNow()) + ' ' + message);
                }
                log_file.println(message);
                log_file.flush();
                log_file.close();
            }
            catch (Exception e) {
                System.err.println("Exception " + e + " attempting to write to log file " + log_name);
            }
            Object var1_1 = null;
        }
    }

    public static final void debugFile(String message) {
        PrintWriter log_file = null;
        try {
            log_file = new PrintWriter(new FileWriter("D://debug.txt", true));
            log_file.println(message);
            log_file.flush();
            log_file.close();
        }
        catch (Exception e) {
            System.err.println("Exception " + e + " attempting to write to log file " + log_name);
        }
        log_file = null;
    }

    public static final boolean testLogFileWriteable() {
        boolean failed = false;
        File test_log = null;
        try {
            test_log = new File(log_name);
        }
        catch (Exception e) {
            ShowGUIMessage.showGUIMessage("Exception " + e + " testing log. Check logdir exists.", "Problem with logfile");
            System.err.println("Exception " + e + " testing log. Check logdir exists.");
        }
        if (!test_log.exists()) {
            try {
                PrintWriter log_file = new PrintWriter(new FileWriter(log_name, true));
                if (!testing) {
                    log_file.println(String.valueOf(TimeNow.getTimeNow()) + " Log created");
                }
                log_file.flush();
                log_file.close();
            }
            catch (Exception e) {
                System.err.println("Exception " + e + " attempting to write to log file " + test_log);
            }
        }
        if (test_log.exists() && !test_log.canWrite()) {
            System.err.println("Log " + log_name + " exists, but cannot written - Check permissions");
            failed = true;
        }
        return failed;
    }

    public static final void setupLogFile(boolean internal, int current_debug_level, String version, String command_line_values, boolean showMessages) {
        if (version.length() == 0) {
            version = "3.31b05STD";
        }
        if ((debug_level = current_debug_level) > 0) {
            debug = true;
        }
        if (command_line_values != null) {
            if (command_line_values.indexOf(118) != -1) {
                verbose = true;
                LogWriter.writeLog("Verbose on");
            } else {
                verbose = false;
            }
            if (command_line_values.indexOf(105) != -1) {
                verbose = true;
                LogWriter.writeLog("Software version - " + version);
                System.exit(0);
            }
        }
        if (!testing) {
            LogWriter.writeLog("Software version - " + version);
            LogWriter.writeLog("Software started - " + TimeNow.getTimeNow());
        }
        LogWriter.writeLog("=======================================================");
    }

    public static final void writeLogWithoutCR(String message) {
        PrintWriter log_file = null;
        try {
            log_file = new PrintWriter(new FileWriter(log_name, true));
            log_file.print(message);
            if (verbose) {
                System.out.print(message);
            }
            log_file.flush();
        }
        catch (Exception e) {
            System.err.println("Exception " + e + " attempting to write to log file " + log_name);
        }
        log_file = null;
    }

    public static final void noLogging() {
        verbose = false;
        log_name = null;
    }

    public static final void writeMethod(String message) {
        long free = Runtime.getRuntime().freeMemory() / 1024L;
        long total = Runtime.getRuntime().totalMemory() / 1024L;
        long used = total - free;
        message = String.valueOf(message) + " MEM=" + used + " ( " + total + " - " + free + ')';
        LogWriter.writeLog(message);
    }

    public static final void writeMethod(String message, int level) {
        if (debug_level > level) {
            LogWriter.writeLog(message);
        }
    }

    public static final void write(Map m, int level) {
        if (debug_level > level) {
            for (Map.Entry me : m.entrySet()) {
                LogWriter.writeLog(String.valueOf(me.getKey().toString()) + '=' + me.getValue().toString());
            }
        }
    }

    public static void writeFormLog(String message, boolean print) {
        if (print) {
            System.out.println("[forms] " + message);
        }
        LogWriter.writeLog("[forms] " + message);
    }
}

