/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.storypad;

import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.jpedal.utils.TimeNow;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Configuration {
    protected String configDir = "";
    protected String sectionName = "general";
    boolean debug = false;
    Map values = new HashMap();
    private static boolean flagged = false;

    public Configuration() {
    }

    public Configuration(String configDir) {
        this.debug = System.getProperty("dev") != null && System.getProperty("dev").toLowerCase().equals("true");
        boolean fileExists = this.loadValues(configDir);
        if (!fileExists) {
            this.saveValues();
        }
        this.loadValues(configDir);
        if (this.debug) {
            if (!flagged) {
                flagged = true;
                System.out.println("{WARNING} Hard-coded values on DEV version");
            }
            this.values.remove("targetTXTOutputDir");
            this.values.remove("custom_output");
        }
    }

    public boolean saveValues() {
        if (this.debug) {
            System.out.println("NOT ALLOWED IN DEV VERSION");
            System.exit(1);
        }
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document doc = db.newDocument();
            Element root = doc.createElement(this.sectionName);
            Comment creation = doc.createComment("Created " + TimeNow.getShortTimeNow());
            doc.appendChild(creation);
            doc.appendChild(root);
            for (String currentKey : this.getKeysAsOrderedList()) {
                Element section = doc.createElement(currentKey);
                section.setAttribute("value", String.valueOf(this.values.get(currentKey)));
                root.appendChild(section);
            }
            InputStream stylesheet = this.getClass().getResourceAsStream("/res/xmlstyle.xslt");
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer(new StreamSource(stylesheet));
            transformer.transform(new DOMSource(doc), new StreamResult(String.valueOf(this.configDir) + this.sectionName + ".xml"));
            System.out.println("Created " + this.configDir + this.sectionName + ".xml");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return true;
    }

    protected boolean loadValues(String configDir) {
        this.configDir = configDir;
        File testDirExists = new File(configDir);
        if (!testDirExists.exists()) {
            testDirExists.mkdir();
        }
        boolean isLoaded = false;
        File testForFile = new File(String.valueOf(configDir) + this.sectionName + ".xml");
        if (testForFile.exists()) {
            try {
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                Document doc = factory.newDocumentBuilder().parse(new File(String.valueOf(configDir) + this.sectionName + ".xml"));
                NodeList Allnodes = doc.getChildNodes();
                NodeList nodes = doc.getElementsByTagName(this.sectionName);
                Element currentElement = (Element)nodes.item(0);
                NodeList catNodes = currentElement.getChildNodes();
                List catValues = this.getChildValues(catNodes);
                int size = catValues.size();
                int i = 0;
                while (i < size) {
                    Element next = (Element)catValues.get(i);
                    String key = next.getNodeName();
                    String value = next.getAttribute("value");
                    this.setValue(key, value);
                    ++i;
                }
                isLoaded = true;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return isLoaded;
    }

    public List getKeysAsOrderedList() {
        List<Object> ret = Arrays.asList(this.values.keySet().toArray());
        Collections.sort(ret);
        return ret;
    }

    protected List getChildValues(NodeList catNodes) {
        ArrayList<Node> catValues = new ArrayList<Node>();
        int items = catNodes.getLength();
        int i = 0;
        while (i < items) {
            Node next = catNodes.item(i);
            if (next instanceof Element) {
                catValues.add(next);
            }
            ++i;
        }
        return catValues;
    }

    public String getValue(String key) {
        return (String)this.values.get(key);
    }

    public void setValue(String key, String value) {
        this.values.put(key, value);
    }

    public String getConfig() {
        return this.configDir;
    }
}

