/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.render;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Rectangle2D;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import javax.imageio.ImageIO;
import javax.media.jai.InterpolationNearest;
import javax.media.jai.JAI;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import org.jpedal.PdfDecoder;
import org.jpedal.color.ColorSpaces;
import org.jpedal.color.PdfColor;
import org.jpedal.color.PdfPaint;
import org.jpedal.exception.PdfException;
import org.jpedal.external.ImageHandler;
import org.jpedal.fonts.PdfFont;
import org.jpedal.fonts.glyph.GlyphFactory;
import org.jpedal.fonts.glyph.PdfGlyph;
import org.jpedal.fonts.glyph.PdfGlyphs;
import org.jpedal.fonts.glyph.PdfJavaGlyphs;
import org.jpedal.io.ColorSpaceConvertor;
import org.jpedal.io.JAIHelper;
import org.jpedal.io.ObjectStore;
import org.jpedal.objects.GraphicsState;
import org.jpedal.parser.FontFactory;
import org.jpedal.render.TextObject;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.Messages;
import org.jpedal.utils.repositories.Vector_Double;
import org.jpedal.utils.repositories.Vector_Float;
import org.jpedal.utils.repositories.Vector_Int;
import org.jpedal.utils.repositories.Vector_Object;
import org.jpedal.utils.repositories.Vector_Rectangle;
import org.jpedal.utils.repositories.Vector_Shape;

public final class DynamicVectorRenderer {
    private int pageNumber = 0;
    private String rawKey = null;
    private PdfPaint fillCol = null;
    private PdfPaint strokeCol = null;
    private static boolean flagException = false;
    private int pageX1 = 9999;
    private int pageX2 = -9999;
    private int pageY1 = -9999;
    private int pageY2 = 9999;
    private ImageHandler customImageHandler = null;
    BufferedImage singleImage = null;
    int imageCount = 0;
    int defaultSize = 5000;
    int endItem = -1;
    public static boolean debugPaint = false;
    private boolean useHiResImageForDisplay = false;
    private static RenderingHints hints = null;
    private ObjectStore objectStoreRef;
    private boolean isPrinting;
    private static Map cachedWidths = new HashMap();
    private static Map cachedHeights = new HashMap();
    private Map fonts = new HashMap();
    private Map fontsUsed = new HashMap();
    protected GlyphFactory factory = null;
    private PdfGlyphs glyphs;
    private int displayMode = 1;
    private boolean isType3Font = false;
    private Map imageID = new HashMap();
    private Map imageIDtoName = new HashMap();
    private String currentImageFile = null;
    private int w = 0;
    private int h = 0;
    private Color backgroundColor = Color.white;
    private float[] x_coord;
    private float[] y_coord;
    private Map largeImages = new WeakHashMap();
    private Vector_Object text_color;
    private Vector_Object stroke_color;
    private Vector_Object fill_color;
    private Vector_Object stroke;
    private Vector_Object pageObjects;
    private Vector_Int shapeType;
    private Vector_Rectangle areas;
    private Vector_Double af1;
    private Vector_Double af2;
    private Vector_Double af3;
    private Vector_Double af4;
    private Vector_Int imageOptions;
    private Vector_Int TRvalues;
    private Vector_Int fs;
    private Vector_Int lw;
    private Vector_Shape clips;
    private Vector_Int objectType;
    private Vector_Object javaObjects;
    private Vector_Int textFillType;
    private Vector_Float opacity;
    private static final int TEXT = 1;
    private static final int SHAPE = 2;
    private static final int IMAGE = 3;
    public static final int TRUETYPE = 4;
    public static final int TYPE1C = 5;
    public static final int TYPE3 = 6;
    public static final int CLIP = 7;
    public static final int COLOR = 8;
    public static final int AF = 9;
    public static final int TEXTCOLOR = 10;
    public static final int FILLCOLOR = 11;
    public static final int STROKECOLOR = 12;
    public static final int STROKE = 14;
    public static final int TR = 15;
    public static final int STRING = 16;
    public static final int STROKEOPACITY = 17;
    public static final int FILLOPACITY = 18;
    public static final int STROKEDSHAPE = 19;
    public static final int FILLEDSHAPE = 20;
    public static final int FONTSIZE = 21;
    public static final int LINEWIDTH = 22;
    public static final int MARKER = 200;
    public static final boolean debugStreams = false;
    private boolean addBackground = true;
    private int currentItem = 0;
    private int lastFillTextCol;
    private int lastFillCol;
    private int lastStrokeCol;
    private Stroke lastStroke = null;
    private double[] lastAf = new double[4];
    private int lastTR = 2;
    private int lastFS = -1;
    private int lastLW = -1;
    private boolean resetTextColors = true;
    private boolean fillSet = false;
    private boolean strokeSet = false;
    int xx = 0;
    int yy = 0;
    private double minX = -1.0;
    private double minY = -1.0;
    private double maxX = -1.0;
    private double maxY = -1.0;
    private AffineTransform aff = new AffineTransform();
    private int rotation = 0;
    private boolean colorsLocked;
    private boolean optimiseDrawing;
    private boolean renderFailed;
    private JFrame frame = null;
    private static boolean userAlerted;
    private int paintThreadCount = 0;
    private int paintThreadID = 0;
    boolean hasClips = false;
    Area lastClip = null;
    private double cropX;
    private double cropH;
    private float scaling;
    public boolean needsHorizontalInvert = false;
    public boolean needsVerticalInvert = false;

    static {
        hints = new RenderingHints(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        hints.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        userAlerted = false;
    }

    public DynamicVectorRenderer(int pageNumber, boolean addBackground, int defaultSize, ObjectStore newObjectRef) {
        this.pageNumber = pageNumber;
        this.objectStoreRef = newObjectRef;
        this.addBackground = addBackground;
        this.setupArrays(defaultSize);
    }

    private void setupArrays(int defaultSize) {
        this.x_coord = new float[defaultSize];
        this.y_coord = new float[defaultSize];
        this.text_color = new Vector_Object(defaultSize);
        this.textFillType = new Vector_Int(defaultSize);
        this.stroke_color = new Vector_Object(defaultSize);
        this.fill_color = new Vector_Object(defaultSize);
        this.stroke = new Vector_Object(defaultSize);
        this.pageObjects = new Vector_Object(defaultSize);
        this.javaObjects = new Vector_Object(defaultSize);
        this.shapeType = new Vector_Int(defaultSize);
        this.areas = new Vector_Rectangle(defaultSize);
        this.af1 = new Vector_Double(defaultSize);
        this.af2 = new Vector_Double(defaultSize);
        this.af3 = new Vector_Double(defaultSize);
        this.af4 = new Vector_Double(defaultSize);
        this.clips = new Vector_Shape(defaultSize);
        this.objectType = new Vector_Int(defaultSize);
    }

    public DynamicVectorRenderer(int pageNumber, ObjectStore newObjectRef, boolean isPrinting) {
        this.pageNumber = pageNumber;
        this.objectStoreRef = newObjectRef;
        this.isPrinting = isPrinting;
        this.setupArrays(this.defaultSize);
    }

    public void setDisplayView(int displayMode) {
        this.displayMode = displayMode;
    }

    public final void renderText(int type, Area transformedGlyph2, Graphics2D g2, boolean isHighlighted, PdfPaint strokePaint, PdfPaint textFillCol, float strokeOpacity, float fillOpacity, Rectangle currentArea) {
        if (isHighlighted && strokePaint instanceof Color) {
            Color currentCol = (Color)((Object)strokePaint);
            if (currentCol == null) {
                currentCol = (Color)((Object)textFillCol);
            }
            Color altCol = this.setHighlightedColor(currentCol, g2);
            g2.fill(currentArea);
            g2.setPaint(altCol);
        } else {
            Composite comp = g2.getComposite();
            if ((type & 2) == 2) {
                textFillCol.setScaling(this.cropX, this.cropH, this.scaling);
                g2.setPaint(textFillCol);
                if (isHighlighted) {
                    Color currentCol = (Color)((Object)textFillCol);
                    Color altCol = this.setHighlightedColor(currentCol, g2);
                    g2.fill(currentArea);
                    g2.setPaint(altCol);
                } else {
                    g2.setPaint(textFillCol);
                }
                if (fillOpacity != 1.0f) {
                    g2.setComposite(AlphaComposite.getInstance(3, fillOpacity));
                }
                g2.fill(transformedGlyph2);
                g2.setComposite(comp);
            }
            if ((type & 1) == 1) {
                if (strokePaint != null) {
                    strokePaint.setScaling(this.cropX, this.cropH, this.scaling);
                }
                g2.setPaint(strokePaint);
                if (strokeOpacity != 1.0f) {
                    g2.setComposite(AlphaComposite.getInstance(3, strokeOpacity));
                }
                g2.draw(transformedGlyph2);
                g2.setComposite(comp);
            }
        }
    }

    public final void renderEmbeddedText(GraphicsState gs, int text_fill_type, Object rawglyph, int glyphType, Graphics2D g2, AffineTransform glyphAT, boolean isHighlighted, PdfPaint strokePaint, PdfPaint fillPaint, float strokeOpacity, float fillOpacity, Rectangle currentArea, int lineWidth) {
        boolean renderDirect = gs != null;
        PdfGlyph glyph = FontFactory.chooseGlpyh(glyphType, rawglyph);
        if (renderDirect) {
            int fontSize = (int)gs.CTM[1][1];
            if (fontSize < 0) {
                fontSize = -fontSize;
            }
            if (fontSize == 0) {
                fontSize = (int)gs.CTM[0][1];
            }
            if (fontSize < 0) {
                fontSize = -fontSize;
            }
            this.areas.addElement(new Rectangle((int)gs.CTM[2][0], (int)gs.CTM[2][1], fontSize, fontSize));
        }
        AffineTransform at = g2.getTransform();
        if (glyph != null) {
            Stroke currentStoke = g2.getStroke();
            if (lineWidth != 0) {
                g2.setStroke(new BasicStroke(lineWidth));
            }
            Color currentCol = null;
            if (strokePaint != null && strokePaint instanceof Color) {
                currentCol = (Color)((Object)strokePaint);
            } else if (strokePaint == null && fillPaint instanceof Color) {
                currentCol = (Color)((Object)fillPaint);
            }
            if (currentCol != null && isHighlighted && glyphType != 6) {
                Color altCol = this.setHighlightedColor(currentCol, g2);
                g2.fill(currentArea);
                g2.setPaint(altCol);
                g2.transform(glyphAT);
                try {
                    glyph.render(text_fill_type, g2, false, this.scaling);
                }
                catch (Exception e) {
                    System.out.println("Exception " + e + " rendering glyph");
                    e.printStackTrace();
                }
            } else {
                g2.transform(glyphAT);
                Composite comp = g2.getComposite();
                if ((text_fill_type & 2) == 2) {
                    fillPaint.setScaling(this.cropX, this.cropH, this.scaling);
                    g2.setPaint(fillPaint);
                    if (fillOpacity != 1.0f) {
                        g2.setComposite(AlphaComposite.getInstance(3, fillOpacity));
                    }
                    glyph.render(2, g2, false, this.scaling);
                    g2.setComposite(comp);
                } else if ((text_fill_type & 1) == 1) {
                    if (strokePaint != null) {
                        strokePaint.setScaling(this.cropX, this.cropH, this.scaling);
                    }
                    g2.setPaint(strokePaint);
                    if (strokeOpacity != 1.0f) {
                        g2.setComposite(AlphaComposite.getInstance(3, strokeOpacity));
                    }
                    try {
                        glyph.render(1, g2, false, this.scaling);
                    }
                    catch (Exception e) {
                        System.out.println("Exception " + e + " rendering glyph");
                        e.printStackTrace();
                    }
                    g2.setComposite(comp);
                }
            }
            g2.setTransform(at);
            if (lineWidth != 0) {
                g2.setStroke(currentStoke);
            }
        }
    }

    private Color setHighlightedColor(Color currentCol, Graphics2D g2) {
        int b;
        int g;
        Color altCol = null;
        int r = 255 - currentCol.getRed();
        if (r < 0) {
            r = -r;
        }
        if ((g = 255 - currentCol.getGreen()) < 0) {
            g = -g;
        }
        if ((b = 255 - currentCol.getBlue()) < 0) {
            b = -b;
        }
        if (r > 120 && r < 136 && g > 120 && g < 136 && b > 120 & b < 136) {
            g2.setPaint(Color.black);
            altCol = Color.white;
        } else {
            g2.setPaint(currentCol);
            altCol = new Color(r, g, b);
        }
        return altCol;
    }

    public final void renderImage(AffineTransform imageAf, BufferedImage image, float alpha, GraphicsState currentGraphicsState, Graphics2D g2, float x, float y, int optionsApplied) {
        float dpi;
        boolean renderDirect;
        boolean bl = renderDirect = currentGraphicsState != null;
        if (image == null) {
            return;
        }
        int w = image.getWidth();
        int h = image.getHeight();
        AffineTransform upside_down = new AffineTransform();
        boolean applyTransform = false;
        float[][] CTM = new float[3][3];
        if (currentGraphicsState != null) {
            CTM = currentGraphicsState.CTM;
        }
        if (renderDirect || this.useHiResImageForDisplay) {
            if (renderDirect) {
                if ((optionsApplied & 1) != 1) {
                    image = this.invertImage(CTM, image);
                }
                upside_down = new AffineTransform(CTM[0][0] / (float)w, CTM[0][1] / (float)w, CTM[1][0] / (float)h, CTM[1][1] / (float)h, CTM[2][0], CTM[2][1]);
            } else {
                upside_down = imageAf;
            }
            applyTransform = true;
        } else if (h > 1 && (dpi = (float)PdfDecoder.dpi) != 72.0f) {
            upside_down.scale(72.0f / dpi, 72.0f / dpi);
            upside_down.translate(0.0, (float)h * (dpi / 72.0f - 1.0f));
            applyTransform = true;
        }
        Composite c = g2.getComposite();
        Shape clip = g2.getClip();
        if (this.colorsLocked) {
            int[] maskCol = new int[4];
            int foreground = this.fillCol.getRGB();
            maskCol[0] = foreground >> 16 & 0xFF;
            maskCol[1] = foreground >> 8 & 0xFF;
            maskCol[2] = foreground & 0xFF;
            maskCol[3] = 255;
            if (maskCol[0] != 0 || maskCol[1] != 0 || maskCol[2] != 0) {
                BufferedImage img = new BufferedImage(image.getWidth(), image.getHeight(), image.getType());
                WritableRaster src = image.getRaster();
                WritableRaster dest = img.getRaster();
                int yy = 0;
                while (yy < image.getHeight()) {
                    int xx = 0;
                    while (xx < image.getWidth()) {
                        int[] values = new int[4];
                        src.getPixel(xx, yy, values);
                        if (values[3] > 2) {
                            dest.setPixel(xx, yy, maskCol);
                        }
                        ++xx;
                    }
                    ++yy;
                }
                image = img;
            }
        }
        if (renderDirect || this.useHiResImageForDisplay) {
            try {
                boolean useCustomRenderer;
                double[] values = new double[6];
                upside_down.getMatrix(values);
                boolean bl2 = useCustomRenderer = this.customImageHandler != null;
                if (useCustomRenderer) {
                    useCustomRenderer = this.customImageHandler.drawImageOnscreen(image, optionsApplied, upside_down, this.currentImageFile, g2, renderDirect, this.objectStoreRef, this.isPrinting);
                }
                if (useCustomRenderer) {
                    g2.setComposite(c);
                    return;
                }
                boolean isSlightlyRotated = values[0] * values[1] != 0.0 || values[2] * values[3] != 0.0;
                g2.drawImage(image, upside_down, null);
            }
            catch (Exception values) {}
        } else {
            AffineTransformOp invert = new AffineTransformOp(upside_down, ColorSpaces.hints);
            try {
                if (this.isType3Font) {
                    // empty if block
                }
                if (applyTransform) {
                    image = invert.filter(image, null);
                }
                g2.translate(x, y);
                g2.drawImage((Image)image, 0, 0, null);
                g2.translate(-x, -y);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (PdfDecoder.isRunningOnMac && clip != null) {
            g2.setClip(clip);
        }
        g2.setComposite(c);
    }

    public final void renderShape(int fillType, PdfPaint strokeCol, PdfPaint fillCol, Stroke shapeStroke, Shape currentShape, Graphics2D g2, float strokeOpacity, float fillOpacity) {
        Composite comp = g2.getComposite();
        if (fillType == 2 | fillType == 3) {
            fillCol.setScaling(this.cropX, this.cropH, this.scaling);
            g2.setPaint(fillCol);
            if (fillOpacity != 1.0f) {
                g2.setComposite(AlphaComposite.getInstance(3, fillOpacity));
            }
            g2.fill(currentShape);
            g2.setComposite(comp);
        }
        if (fillType == 1 | fillType == 3) {
            Shape clip;
            Stroke currentStroke = g2.getStroke();
            if (currentShape.getBounds2D().getWidth() < 1.0 && ((BasicStroke)shapeStroke).getLineWidth() > 10.0f) {
                g2.setStroke(new BasicStroke(1.0f));
            } else {
                g2.setStroke(shapeStroke);
            }
            strokeCol.setScaling(this.cropX, this.cropH, this.scaling);
            g2.setPaint(strokeCol);
            if (strokeOpacity != 1.0f) {
                g2.setComposite(AlphaComposite.getInstance(3, strokeOpacity));
            }
            if ((clip = g2.getClip()) != null && (clip.getBounds2D().getHeight() < 1.0 || clip.getBounds2D().getWidth() < 1.0)) {
                g2.setClip(null);
            }
            g2.draw(currentShape);
            g2.setClip(clip);
            g2.setStroke(currentStroke);
            g2.setComposite(comp);
        }
    }

    public void flush() {
        this.singleImage = null;
        this.imageCount = 0;
        if (this.shapeType != null) {
            this.shapeType.clear();
            this.pageObjects.clear();
            this.objectType.clear();
            this.areas.clear();
            this.clips.clear();
            this.x_coord = new float[this.defaultSize];
            this.y_coord = new float[this.defaultSize];
            this.textFillType.clear();
            this.text_color.clear();
            this.fill_color.clear();
            this.stroke_color.clear();
            this.stroke.clear();
            if (this.TRvalues != null) {
                this.TRvalues.clear();
            }
            if (this.imageOptions != null) {
                this.imageOptions.clear();
            }
            if (this.fs != null) {
                this.fs.clear();
            }
            if (this.lw != null) {
                this.lw.clear();
            }
            this.af1.clear();
            this.af2.clear();
            this.af3.clear();
            this.af4.clear();
            if (this.opacity != null) {
                this.opacity.clear();
            }
            if (this.isPrinting) {
                this.largeImages.clear();
            }
            this.endItem = -1;
        }
        this.lastFillTextCol = 0;
        this.lastFillCol = 0;
        this.lastStrokeCol = 0;
        this.lastClip = null;
        this.hasClips = false;
        this.lastStroke = null;
        this.lastAf = new double[4];
        this.currentItem = 0;
        this.fillSet = false;
        this.strokeSet = false;
        this.fonts.clear();
        this.fontsUsed.clear();
        this.imageID.clear();
        this.pageX1 = 9999;
        this.pageX2 = -9999;
        this.pageY1 = -9999;
        this.pageY2 = 9999;
    }

    public void setBackgroundColor(Color background) {
        if (background == null) {
            this.addBackground = false;
        } else {
            this.backgroundColor = background;
        }
    }

    public void paint(Graphics2D g2, Rectangle[] highlights, int myx, int myy) {
        this.xx = myx < 0 ? myx : 0;
        this.yy = myy < 0 ? myy : 0;
        this.paint(g2, highlights, null, null, false, false);
    }

    public void setInset(int x, int y) {
        this.xx = x;
        this.yy = y;
    }

    public Rectangle paint(Graphics2D g2, Rectangle[] highlights, AffineTransform viewScaling, Rectangle userAnnot, boolean drawJustHighlights, boolean isScreen) {
        Shape rawClip;
        int currentThreadID = ++this.paintThreadID;
        if (isScreen) {
            ++this.paintThreadCount;
        }
        if (isScreen && this.paintThreadCount > 1) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            if (currentThreadID != this.paintThreadID) {
                --this.paintThreadCount;
                return null;
            }
        }
        boolean debug = false;
        int paintedCount = 0;
        Rectangle dirtyRegion = null;
        int[] objectTypes = this.objectType.get();
        int[] textFill = this.textFillType.get();
        int count = this.currentItem;
        Area[] pageClips = this.clips.get();
        double[] afValues1 = this.af1.get();
        int[] fsValues = null;
        if (this.fs != null) {
            fsValues = this.fs.get();
        }
        int[] lwValues = null;
        if (this.lw != null) {
            lwValues = this.lw.get();
        }
        double[] afValues2 = this.af2.get();
        double[] afValues3 = this.af3.get();
        double[] afValues4 = this.af4.get();
        Object[] text_color = this.text_color.get();
        Object[] fill_color = this.fill_color.get();
        Object[] stroke_color = this.stroke_color.get();
        Object[] pageObjects = this.pageObjects.get();
        Object[] javaObjects = this.javaObjects.get();
        Object[] stroke = this.stroke.get();
        int[] fillType = this.shapeType.get();
        float[] opacity = null;
        if (this.opacity != null) {
            opacity = this.opacity.get();
        }
        int[] TRvalues = null;
        if (this.TRvalues != null) {
            TRvalues = this.TRvalues.get();
        }
        int[] imageOptions = null;
        if (this.imageOptions != null) {
            imageOptions = this.imageOptions.get();
        }
        if ((rawClip = g2.getClip()) != null) {
            dirtyRegion = rawClip.getBounds();
        }
        boolean isInitialised = false;
        Shape defaultClip = g2.getClip();
        Area clipToUse = null;
        boolean newClip = false;
        if (!drawJustHighlights) {
            this.paintBackground(g2, dirtyRegion);
        }
        AffineTransform rawScaling = g2.getTransform();
        if (viewScaling != null) {
            g2.transform(viewScaling);
            defaultClip = g2.getClip();
        }
        this.minX = -1.0;
        this.minY = -1.0;
        this.maxX = -1.0;
        this.maxY = -1.0;
        int type = 0;
        int textFillType = 0;
        int currentTR = 2;
        int lineWidth = 0;
        float fillOpacity = 1.0f;
        float strokeOpacity = 1.0f;
        float x = 0.0f;
        float y = 0.0f;
        int iCount = 0;
        int cCount = 0;
        int sCount = 0;
        int etCount = 0;
        int fsCount = -1;
        int lwCount = 0;
        int afCount = -1;
        int tCount = 0;
        int stCount = 0;
        int fillCount = 0;
        int strokeCount = 0;
        int trCount = 0;
        int opCount = 0;
        int stringCount = 0;
        PdfPaint textStrokeCol = null;
        PdfPaint textFillCol = null;
        PdfPaint fillCol = null;
        PdfPaint strokeCol = null;
        Stroke currentStroke = null;
        if (this.colorsLocked) {
            strokeCol = this.strokeCol;
            fillCol = this.fillCol;
        }
        int i = 0;
        while (i < count) {
            boolean ignoreItem = false;
            boolean isHighlighted = false;
            type = objectTypes[i];
            Rectangle currentArea = null;
            if (isScreen && currentThreadID != this.paintThreadID) {
                --this.paintThreadCount;
                return null;
            }
            if (type > 0) {
                x = this.x_coord[i];
                y = this.y_coord[i];
                Object currentObject = null;
                currentObject = pageObjects[i];
                if (currentArea == null) {
                    if (afValues1 != null && type == 3) {
                        BufferedImage img = (BufferedImage)pageObjects[i];
                        if (img != null) {
                            currentArea = new Rectangle((int)x, (int)y, img.getWidth(), img.getHeight());
                        }
                    } else if (afValues1 != null && type == 2) {
                        currentArea = ((Shape)pageObjects[i]).getBounds();
                    } else if (type == 1 && afCount > -1) {
                        int x1 = ((Area)currentObject).getBounds().x;
                        int y1 = ((Area)currentObject).getBounds().y;
                        currentArea = this.getAreaForGlyph(new float[][]{{(float)afValues1[afCount], (float)afValues2[afCount], 0.0f}, {(float)afValues3[afCount], (float)afValues4[afCount], 0.0f}, {x1, y1, 1.0f}});
                    } else if (fsCount != -1 && afValues1 != null) {
                        currentArea = new Rectangle((int)x, (int)y, fsValues[fsCount], fsValues[fsCount]);
                    }
                }
                if (ignoreItem = false) {
                    switch (type) {
                        case 2: {
                            ++sCount;
                            break;
                        }
                        case 3: {
                            ++iCount;
                            break;
                        }
                        case 7: {
                            ++cCount;
                        }
                        case 4: {
                            ++etCount;
                            break;
                        }
                        case 5: {
                            ++etCount;
                            break;
                        }
                        case 6: {
                            ++etCount;
                            break;
                        }
                        case 9: {
                            ++afCount;
                            break;
                        }
                        case 21: {
                            ++fsCount;
                            break;
                        }
                        case 22: {
                            ++lwCount;
                            break;
                        }
                        case 10: {
                            ++tCount;
                            break;
                        }
                        case 11: {
                            ++fillCount;
                            break;
                        }
                        case 12: {
                            ++strokeCount;
                            break;
                        }
                        case 14: {
                            ++stCount;
                            break;
                        }
                        case 15: {
                            ++trCount;
                        }
                    }
                } else {
                    if (!isInitialised) {
                        g2.setRenderingHints(hints);
                        isInitialised = true;
                    }
                    ++paintedCount;
                    switch (type) {
                        case 2: {
                            if (!drawJustHighlights) {
                                if (newClip) {
                                    this.renderClip(clipToUse, dirtyRegion, defaultClip, g2);
                                    newClip = false;
                                }
                                this.renderShape(fillType[sCount], strokeCol, fillCol, currentStroke, (Shape)currentObject, g2, strokeOpacity, fillOpacity);
                            }
                            ++sCount;
                            break;
                        }
                        case 1: {
                            if (newClip) {
                                this.renderClip(clipToUse, dirtyRegion, defaultClip, g2);
                                newClip = false;
                            }
                            if (highlights != null) {
                                isHighlighted = this.setHighlightForGlyph(currentArea, objectTypes, highlights, i, isHighlighted);
                            }
                            if (drawJustHighlights && !isHighlighted) break;
                            this.renderText(currentTR, (Area)currentObject, g2, isHighlighted, textStrokeCol, textFillCol, strokeOpacity, fillOpacity, currentArea);
                            break;
                        }
                        case 4: {
                            if (newClip) {
                                this.renderClip(clipToUse, dirtyRegion, defaultClip, g2);
                                newClip = false;
                            }
                            if (highlights != null) {
                                isHighlighted = this.setHighlightForGlyph(currentArea, objectTypes, highlights, i, isHighlighted);
                            }
                            this.aff = new AffineTransform(afValues1[afCount], afValues2[afCount], afValues3[afCount], afValues4[afCount], (double)x, (double)y);
                            if (!drawJustHighlights || isHighlighted) {
                                this.renderEmbeddedText(null, currentTR, currentObject, 4, g2, this.aff, isHighlighted, textStrokeCol, textFillCol, strokeOpacity, fillOpacity, currentArea, lineWidth);
                            }
                            ++etCount;
                            break;
                        }
                        case 5: {
                            if (newClip) {
                                this.renderClip(clipToUse, dirtyRegion, defaultClip, g2);
                                newClip = false;
                            }
                            if (highlights != null) {
                                isHighlighted = this.setHighlightForGlyph(currentArea, objectTypes, highlights, i, isHighlighted);
                            }
                            this.aff = new AffineTransform(afValues1[afCount], afValues2[afCount], afValues3[afCount], afValues4[afCount], (double)x, (double)y);
                            if (!drawJustHighlights || isHighlighted) {
                                this.renderEmbeddedText(null, currentTR, currentObject, 5, g2, this.aff, isHighlighted, textStrokeCol, textFillCol, strokeOpacity, fillOpacity, currentArea, lineWidth);
                            }
                            ++etCount;
                            break;
                        }
                        case 6: {
                            if (newClip) {
                                this.renderClip(clipToUse, dirtyRegion, defaultClip, g2);
                                newClip = false;
                            }
                            if (highlights != null) {
                                isHighlighted = this.setHighlightForGlyph(currentArea, objectTypes, highlights, i, isHighlighted);
                            }
                            this.aff = new AffineTransform(afValues1[afCount], afValues2[afCount], afValues3[afCount], afValues4[afCount], (double)x, (double)y);
                            if (!drawJustHighlights || isHighlighted) {
                                this.renderEmbeddedText(null, currentTR, currentObject, 6, g2, this.aff, isHighlighted, textStrokeCol, textFillCol, strokeOpacity, fillOpacity, currentArea, lineWidth);
                            }
                            ++etCount;
                            break;
                        }
                        case 3: {
                            int currentImageOption = 0;
                            if (imageOptions != null) {
                                currentImageOption = imageOptions[iCount];
                            }
                            this.currentImageFile = this.rawKey == null ? String.valueOf(this.pageNumber) + "_HIRES_" + i : String.valueOf(this.pageNumber) + "_HIRES_" + i + '_' + this.rawKey;
                            if (!drawJustHighlights) {
                                if (newClip) {
                                    this.renderClip(clipToUse, dirtyRegion, defaultClip, g2);
                                    newClip = false;
                                }
                                if (!this.useHiResImageForDisplay) {
                                    this.renderImage(null, (BufferedImage)currentObject, fillOpacity, null, g2, x, y, currentImageOption);
                                }
                            }
                            ++iCount;
                            break;
                        }
                        case 7: {
                            clipToUse = pageClips[cCount];
                            newClip = true;
                            ++cCount;
                            break;
                        }
                        case 9: {
                            ++afCount;
                            break;
                        }
                        case 21: {
                            ++fsCount;
                            break;
                        }
                        case 22: {
                            lineWidth = lwValues[lwCount];
                            ++lwCount;
                            break;
                        }
                        case 10: {
                            textFillType = textFill[tCount];
                            if (textFillType == 1) {
                                textStrokeCol = (PdfPaint)text_color[tCount];
                            } else {
                                textFillCol = (PdfPaint)text_color[tCount];
                            }
                            ++tCount;
                            break;
                        }
                        case 11: {
                            if (!this.colorsLocked) {
                                fillCol = (PdfPaint)fill_color[fillCount];
                            }
                            ++fillCount;
                            break;
                        }
                        case 12: {
                            if (!this.colorsLocked) {
                                strokeCol = (PdfPaint)stroke_color[strokeCount];
                                strokeCol.setScaling(this.cropX, this.cropH, this.scaling);
                            }
                            ++strokeCount;
                            break;
                        }
                        case 14: {
                            currentStroke = (Stroke)stroke[stCount];
                            ++stCount;
                            break;
                        }
                        case 15: {
                            currentTR = TRvalues[trCount];
                            ++trCount;
                            break;
                        }
                        case 17: {
                            strokeOpacity = opacity[opCount];
                            ++opCount;
                            break;
                        }
                        case 18: {
                            fillOpacity = opacity[opCount];
                            ++opCount;
                            break;
                        }
                        case 16: {
                            if (drawJustHighlights) break;
                            try {
                                AffineTransform defaultAf = g2.getTransform();
                                String displayValue = (String)currentObject;
                                double[] af = new double[6];
                                g2.getTransform().getMatrix(af);
                                if (af[2] != 0.0) {
                                    af[2] = -af[2];
                                }
                                if (af[3] != 0.0) {
                                    af[3] = -af[3];
                                }
                                g2.setTransform(new AffineTransform(af));
                                Font javaFont = (Font)javaObjects[stringCount];
                                g2.setFont(javaFont);
                                if ((currentTR & 2) == 2) {
                                    if (textFillCol != null) {
                                        textFillCol.setScaling(this.cropX, this.cropH, this.scaling);
                                    }
                                    g2.setPaint(textFillCol);
                                }
                                if ((currentTR & 1) == 1) {
                                    if (textStrokeCol != null) {
                                        textStrokeCol.setScaling(this.cropX, this.cropH, this.scaling);
                                    }
                                    g2.setPaint(textStrokeCol);
                                }
                                g2.drawString(displayValue, x, y);
                                g2.setTransform(defaultAf);
                                ++stringCount;
                                break;
                            }
                            catch (Exception e) {
                                System.err.println(currentObject + "<>" + i);
                                e.printStackTrace();
                                System.exit(1);
                            }
                        }
                    }
                }
            }
            ++i;
        }
        g2.setClip(defaultClip);
        g2.setTransform(rawScaling);
        if (debugPaint) {
            System.err.println("Painted " + paintedCount);
        }
        if (this.frame != null && this.renderFailed && !userAlerted) {
            userAlerted = true;
            if (PdfDecoder.showErrorMessages) {
                String status = String.valueOf(Messages.getMessage("PdfViewer.ImageDisplayError")) + Messages.getMessage("PdfViewer.ImageDisplayError1") + Messages.getMessage("PdfViewer.ImageDisplayError2") + Messages.getMessage("PdfViewer.ImageDisplayError3") + Messages.getMessage("PdfViewer.ImageDisplayError4") + Messages.getMessage("PdfViewer.ImageDisplayError5") + Messages.getMessage("PdfViewer.ImageDisplayError6") + Messages.getMessage("PdfViewer.ImageDisplayError7");
                JOptionPane.showMessageDialog(this.frame, status);
                this.frame.invalidate();
                this.frame.repaint();
            }
        }
        if (isScreen) {
            --this.paintThreadCount;
        }
        if (this.minX == -1.0) {
            return null;
        }
        return new Rectangle((int)this.minX, (int)this.minY, (int)(this.maxX - this.minX), (int)(this.maxY - this.minY));
    }

    private Rectangle getAreaForGlyph(float[][] trm) {
        int w = (int)Math.sqrt(trm[0][0] * trm[0][0] + trm[1][0] * trm[1][0]);
        int h = (int)Math.sqrt(trm[1][1] * trm[1][1] + trm[0][1] * trm[0][1]);
        return new Rectangle((int)trm[2][0], (int)trm[2][1], w, h);
    }

    public void setMessageFrame(JFrame frame) {
        this.frame = frame;
    }

    public void paintBackground(Graphics2D g2, Rectangle dirtyRegion) {
        if (this.addBackground) {
            g2.setColor(this.backgroundColor);
            if (dirtyRegion == null) {
                g2.fill(new Rectangle(this.xx, this.yy, (int)((float)this.w * this.scaling), (int)((float)this.h * this.scaling)));
            } else {
                g2.fill(dirtyRegion);
            }
        }
    }

    public void renderClip(Area clip, Rectangle dirtyRegion, Shape defaultClip, Graphics2D g2) {
        if (clip != null) {
            g2.setClip(clip);
            if (dirtyRegion != null) {
                g2.clip(dirtyRegion);
            }
        } else {
            g2.setClip(defaultClip);
        }
    }

    private boolean setHighlightForGlyph(Rectangle area, int[] objectTypes, Rectangle[] highlights, int i, boolean isHighlighted) {
        int hcount = highlights.length;
        int i2 = 0;
        while (i2 < hcount) {
            int objectType = objectTypes[i];
            if (area != null && objectType == 1 | objectType == 4 | objectType == 5 | objectType == 6 && highlights[i2] != null && highlights[i2].intersects(area) && highlights[i2].getMinX() <= area.getMinX() && highlights[i2].getMinY() <= area.getMinY()) {
                i2 = hcount;
                isHighlighted = true;
                Rectangle2D bounds = area.getBounds2D();
                if (this.minX == -1.0) {
                    this.minX = bounds.getMinX();
                    this.minY = bounds.getMinY();
                    this.maxX = bounds.getMaxX();
                    this.maxY = bounds.getMaxY();
                } else {
                    double tmp = bounds.getMinX();
                    if (tmp < this.minX) {
                        this.minX = tmp;
                    }
                    if ((tmp = bounds.getMinY()) < this.minY) {
                        this.minY = tmp;
                    }
                    if ((tmp = bounds.getMaxX()) > this.maxX) {
                        this.maxX = tmp;
                    }
                    if ((tmp = bounds.getMaxY()) > this.maxY) {
                        this.maxY = tmp;
                    }
                }
            }
            ++i2;
        }
        return isHighlighted;
    }

    public final void drawText(float[][] Trm, Object transformedGlyph2, GraphicsState currentGraphicsState) {
        int newCol;
        int text_fill_type;
        double[] nextAf;
        PdfPaint currentCol = null;
        if (Trm != null && (this.lastAf[0] != (nextAf = new double[]{Trm[0][0], Trm[0][1], Trm[1][0], Trm[1][1], Trm[2][0], Trm[2][1]})[0] || this.lastAf[1] != nextAf[1] || this.lastAf[2] != nextAf[2] || this.lastAf[3] != nextAf[3])) {
            this.drawAffine(nextAf);
            this.lastAf[0] = nextAf[0];
            this.lastAf[1] = nextAf[1];
            this.lastAf[2] = nextAf[2];
            this.lastAf[3] = nextAf[3];
        }
        if (((text_fill_type = currentGraphicsState.getTextRenderType()) & 2) == 2) {
            currentCol = currentGraphicsState.getNonstrokeColor();
            if (currentCol.isPattern()) {
                this.drawColor(currentCol, 2);
                this.resetTextColors = true;
            } else {
                newCol = currentCol.getRGB();
                if (this.resetTextColors || this.lastFillTextCol != newCol) {
                    this.lastFillTextCol = newCol;
                    this.drawColor(currentCol, 2);
                }
            }
        }
        if ((text_fill_type & 1) == 1) {
            currentCol = currentGraphicsState.getStrokeColor();
            if (currentCol.isPattern()) {
                this.drawColor(currentCol, 1);
                this.resetTextColors = true;
            } else {
                newCol = currentCol.getRGB();
                if (this.resetTextColors || this.lastStrokeCol != newCol) {
                    this.lastStrokeCol = newCol;
                    this.drawColor(currentCol, 1);
                }
            }
        }
        if (transformedGlyph2 instanceof Area) {
            this.drawFontSize((int)((Area)transformedGlyph2).getBounds().getWidth());
            this.pageObjects.addElement(transformedGlyph2);
            this.areas.addElement(((Area)transformedGlyph2).getBounds());
            this.checkWidth(((Area)transformedGlyph2).getBounds());
            this.objectType.addElement(1);
        } else {
            this.pageObjects.addElement(transformedGlyph2);
            this.areas.addElement(null);
            this.objectType.addElement(-1);
        }
        this.x_coord = this.checkSize(this.x_coord, this.currentItem);
        this.y_coord = this.checkSize(this.y_coord, this.currentItem);
        this.x_coord[this.currentItem] = Trm[2][0];
        this.y_coord[this.currentItem] = Trm[2][1];
        ++this.currentItem;
        this.resetTextColors = false;
    }

    public final void drawText(float[][] Trm, String text, GraphicsState currentGraphicsState, float x, float y, Font javaFont) {
        int newCol;
        int text_fill_type;
        double[] nextAf;
        PdfPaint currentCol = null;
        if (Trm != null && (this.lastAf[0] != (nextAf = new double[]{Trm[0][0], Trm[0][1], Trm[1][0], Trm[1][1], Trm[2][0], Trm[2][1]})[0] || this.lastAf[1] != nextAf[1] || this.lastAf[2] != nextAf[2] || this.lastAf[3] != nextAf[3])) {
            this.drawAffine(nextAf);
            this.lastAf[0] = nextAf[0];
            this.lastAf[1] = nextAf[1];
            this.lastAf[2] = nextAf[2];
            this.lastAf[3] = nextAf[3];
        }
        if (((text_fill_type = currentGraphicsState.getTextRenderType()) & 2) == 2) {
            currentCol = currentGraphicsState.getNonstrokeColor();
            if (currentCol.isPattern()) {
                this.drawColor(currentCol, 2);
                this.resetTextColors = true;
            } else {
                newCol = currentCol.getRGB();
                if (this.resetTextColors || this.lastFillTextCol != newCol) {
                    this.lastFillTextCol = newCol;
                    this.drawColor(currentCol, 2);
                }
            }
        }
        if ((text_fill_type & 1) == 1) {
            currentCol = currentGraphicsState.getStrokeColor();
            if (currentCol.isPattern()) {
                this.drawColor(currentCol, 1);
                this.resetTextColors = true;
            } else {
                newCol = currentCol.getRGB();
                if (this.resetTextColors || this.lastStrokeCol != newCol) {
                    this.lastStrokeCol = newCol;
                    this.drawColor(currentCol, 1);
                }
            }
        }
        this.pageObjects.addElement(text);
        this.javaObjects.addElement(javaFont);
        this.objectType.addElement(16);
        this.areas.addElement(null);
        this.x_coord = this.checkSize(this.x_coord, this.currentItem);
        this.y_coord = this.checkSize(this.y_coord, this.currentItem);
        this.x_coord[this.currentItem] = x;
        this.y_coord[this.currentItem] = y;
        ++this.currentItem;
        this.resetTextColors = false;
    }

    private float[] checkSize(float[] array, int currentItem) {
        int size = array.length;
        if (size <= currentItem) {
            int newSize = size * 2;
            float[] newArray = new float[newSize];
            System.arraycopy(array, 0, newArray, 0, size);
            array = newArray;
        }
        return array;
    }

    public Rectangle getCombinedAreas(Rectangle targetRectangle, boolean justText) {
        Rectangle combinedRectangle = null;
        if (this.areas != null) {
            Rectangle target = targetRectangle.getBounds();
            int x2 = target.x;
            int y2 = target.y;
            int x1 = x2 + target.width;
            int y1 = y2 + target.height;
            boolean matchFound = false;
            Rectangle[] currentAreas = this.areas.get();
            int count = currentAreas.length;
            int i = 0;
            while (i < count) {
                if (currentAreas[i] != null && targetRectangle.contains(currentAreas[i])) {
                    int newY;
                    matchFound = true;
                    int newX = currentAreas[i].x;
                    if (x1 > newX) {
                        x1 = newX;
                    }
                    if (x2 < (newX = currentAreas[i].x + currentAreas[i].width)) {
                        x2 = newX;
                    }
                    if (y1 > (newY = currentAreas[i].y)) {
                        y1 = newY;
                    }
                    if (y2 < (newY = currentAreas[i].y + currentAreas[i].height)) {
                        y2 = newY;
                    }
                }
                ++i;
            }
            if (matchFound) {
                combinedRectangle = new Rectangle(x1 - 1, y1 + 1, x2 - x1 + 2, y2 - y1 + 2);
            }
        }
        return combinedRectangle;
    }

    public final void init(int x, int y, int rawRotation) {
        this.w = x;
        this.h = y;
        this.rotation = rawRotation;
    }

    public final BufferedImage getPageAsImage(float scaling, int cropX, int cropY, int cropW, int cropH, int page, AffineTransform af_scaling, int type) {
        if (cropW < 0) {
            cropW = this.w;
            cropH = this.h;
        } else {
            cropW = (int)((float)cropW * scaling);
            cropH = (int)((float)cropH * scaling);
        }
        BufferedImage image = new BufferedImage(cropW, cropH, type);
        Graphics2D g2 = image.createGraphics();
        if (type == 1) {
            g2.setColor(Color.white);
            g2.fillRect(0, 0, cropW, cropH);
        }
        AffineTransform af = g2.getTransform();
        if (af_scaling != null) {
            g2.transform(af_scaling);
        }
        this.paint(g2, null, cropX, cropY);
        g2.setTransform(af);
        return image;
    }

    public static final boolean isRotated(float[][] CTM) {
        return CTM[0][0] == 0.0f && CTM[1][1] == 0.0f && CTM[0][1] * CTM[1][0] < 0.0f;
    }

    public final void drawImage(int pageNumber, BufferedImage image, GraphicsState currentGraphicsState, boolean alreadyCached, String name, int optionsApplied) {
        this.pageNumber = pageNumber;
        float[][] CTM = currentGraphicsState.CTM;
        float x = currentGraphicsState.x;
        float y = currentGraphicsState.y;
        String key = this.rawKey == null ? String.valueOf(pageNumber) + "_" + (this.currentItem + 1) : String.valueOf(this.rawKey) + '_' + (this.currentItem + 1);
        if (this.imageOptions == null) {
            this.imageOptions = new Vector_Int(this.defaultSize);
        }
        this.imageOptions.addElement(optionsApplied);
        if (!alreadyCached && image.getHeight() > 1 && (optionsApplied & 1) != 1) {
            image = this.invertImage(CTM, image);
        }
        this.x_coord = this.checkSize(this.x_coord, this.currentItem);
        this.y_coord = this.checkSize(this.y_coord, this.currentItem);
        this.x_coord[this.currentItem] = x;
        this.y_coord[this.currentItem] = y;
        this.objectType.addElement(3);
        float WidthModifier = 1.0f;
        float HeightModifier = 1.0f;
        if (this.useHiResImageForDisplay) {
            if (!alreadyCached) {
                WidthModifier = image.getWidth();
                HeightModifier = image.getHeight();
            } else {
                WidthModifier = ((Integer)cachedWidths.get(key)).intValue();
                HeightModifier = ((Integer)cachedHeights.get(key)).intValue();
            }
        }
        this.w = (int)(CTM[0][0] * WidthModifier);
        if (this.w == 0) {
            this.w = (int)(CTM[0][1] * WidthModifier);
        }
        this.h = (int)(CTM[1][1] * HeightModifier);
        if (this.h == 0) {
            this.h = (int)(CTM[1][0] * HeightModifier);
        }
        this.areas.addElement(new Rectangle((int)currentGraphicsState.x, (int)currentGraphicsState.y, this.w, this.h));
        this.checkWidth(new Rectangle((int)currentGraphicsState.x, (int)currentGraphicsState.y, this.w, this.h));
        if (this.useHiResImageForDisplay) {
            this.pageObjects.addElement(null);
        } else {
            this.pageObjects.addElement(image);
        }
        this.imageID.put(name, new Integer(this.currentItem));
        ++this.currentItem;
    }

    public static boolean isInverted(float[][] CTM) {
        return CTM[0][0] > 0.0f && CTM[1][1] > 0.0f || CTM[0][0] < 0.0f && CTM[1][1] < 0.0f || CTM[0][0] * CTM[1][1] < 0.0f || CTM[0][1] * CTM[1][0] != 0.0f && CTM[2][1] >= 0.0f;
    }

    private BufferedImage invertImage(float[][] CTM, BufferedImage image) {
        boolean isInverted = false;
        isInverted = CTM == null ? true : DynamicVectorRenderer.isInverted(CTM);
        if (isInverted) {
            AffineTransform image_at2 = new AffineTransform();
            image_at2.scale(1.0, -1.0);
            image_at2.translate(0.0, -image.getHeight());
            AffineTransformOp invert3 = new AffineTransformOp(image_at2, ColorSpaces.hints);
            boolean imageProcessed = false;
            if (JAIHelper.isJAIused()) {
                imageProcessed = true;
                try {
                    image = JAI.create((String)"affine", (RenderedImage)image, (Object)image_at2, (Object)new InterpolationNearest()).getAsBufferedImage();
                }
                catch (Exception ee) {
                    imageProcessed = false;
                    ee.printStackTrace();
                }
                catch (Error err) {
                    imageProcessed = false;
                    err.printStackTrace();
                }
                if (!imageProcessed) {
                    LogWriter.writeLog("Unable to use JAI for image inversion");
                }
            }
            if (!imageProcessed) {
                if (image.getType() == 12) {
                    BufferedImage source = image;
                    image = new BufferedImage(source.getWidth(), source.getHeight(), source.getType());
                    invert3.filter(source, image);
                } else {
                    image = invert3.filter(image, null);
                }
            }
        }
        return image;
    }

    private BufferedImage invertImageBeforeSave(BufferedImage image, boolean horizontal) {
        AffineTransform image_at2 = new AffineTransform();
        if (horizontal) {
            image_at2.scale(-1.0, 1.0);
            image_at2.translate(-image.getWidth(), 0.0);
        } else {
            image_at2.scale(1.0, -1.0);
            image_at2.translate(0.0, -image.getHeight());
        }
        AffineTransformOp invert3 = new AffineTransformOp(image_at2, ColorSpaces.hints);
        boolean imageProcessed = false;
        if (JAIHelper.isJAIused()) {
            imageProcessed = true;
            try {
                image = JAI.create((String)"affine", (RenderedImage)image, (Object)image_at2, (Object)new InterpolationNearest()).getAsBufferedImage();
            }
            catch (Exception ee) {
                imageProcessed = false;
                ee.printStackTrace();
            }
            catch (Error err) {
                imageProcessed = false;
                err.printStackTrace();
            }
            if (!imageProcessed) {
                LogWriter.writeLog("Unable to use JAI for image inversion");
            }
        }
        if (!imageProcessed) {
            if (image.getType() == 12) {
                BufferedImage source = image;
                image = new BufferedImage(source.getWidth(), source.getHeight(), source.getType());
                invert3.filter(source, image);
            } else {
                image = invert3.filter(image, null);
            }
        }
        return image;
    }

    public final void drawImage(BufferedImage image) {
        int h = image.getHeight();
        if (h > 1) {
            AffineTransform flip = new AffineTransform();
            flip.translate(0.0, h);
            flip.scale(1.0, -1.0);
            AffineTransformOp invert = new AffineTransformOp(flip, ColorSpaces.hints);
            image = invert.filter(image, null);
        }
        this.x_coord = this.checkSize(this.x_coord, this.currentItem);
        this.y_coord = this.checkSize(this.y_coord, this.currentItem);
        this.x_coord[this.currentItem] = 0.0f;
        this.y_coord[this.currentItem] = 0.0f;
        this.objectType.addElement(3);
        this.areas.addElement(new Rectangle(0, 0, image.getWidth(), image.getHeight()));
        if (this.useHiResImageForDisplay) {
            this.pageObjects.addElement(null);
        } else {
            this.pageObjects.addElement(image);
        }
        ++this.currentItem;
    }

    private void checkWidth(Rectangle rect) {
        int x1 = rect.getBounds().x;
        int y2 = rect.getBounds().y;
        int y1 = y2 + rect.getBounds().height;
        int x2 = x1 + rect.getBounds().width;
        if (x1 < this.pageX1) {
            this.pageX1 = x1;
        }
        if (x2 > this.pageX2) {
            this.pageX2 = x2;
        }
        if (y1 > this.pageY1) {
            this.pageY1 = y1;
        }
        if (y2 < this.pageY2) {
            this.pageY2 = y2;
        }
    }

    public Rectangle getOccupiedArea() {
        return new Rectangle(this.pageX1, this.pageY1, this.pageX2 - this.pageY1, this.pageY1 - this.pageY2);
    }

    public final void drawShape(Shape currentShape, GraphicsState currentGraphicsState) {
        int newCol;
        PdfPaint currentCol;
        int fillType = currentGraphicsState.getFillType();
        if (currentShape.getBounds().getWidth() == 1.0 && currentShape.getBounds().getHeight() == 1.0) {
            currentShape = new Rectangle(0, 0, 1, 1);
        }
        if (fillType == 2 | fillType == 3) {
            currentCol = currentGraphicsState.getNonstrokeColor();
            if (currentCol.isPattern()) {
                this.drawFillColor(currentCol);
                this.fillSet = true;
            } else {
                newCol = currentCol.getRGB();
                if (!this.fillSet || this.lastFillCol != newCol) {
                    this.lastFillCol = newCol;
                    this.drawFillColor(currentCol);
                    this.fillSet = true;
                }
            }
        }
        if (fillType == 1 | fillType == 3) {
            currentCol = currentGraphicsState.getStrokeColor();
            if (currentCol instanceof Color) {
                newCol = currentCol.getRGB();
                if (!this.strokeSet || this.lastStrokeCol != newCol) {
                    this.lastStrokeCol = newCol;
                    this.drawStrokeColor(currentCol);
                    this.strokeSet = true;
                }
            } else {
                this.drawStrokeColor(currentCol);
                this.strokeSet = true;
            }
        }
        Stroke newStroke = currentGraphicsState.getStroke();
        if (this.lastStroke == null || !this.lastStroke.equals(newStroke)) {
            this.lastStroke = newStroke;
            this.drawStroke(newStroke);
        }
        this.pageObjects.addElement(currentShape);
        this.objectType.addElement(2);
        this.areas.addElement(currentShape.getBounds());
        this.checkWidth(currentShape.getBounds());
        this.x_coord = this.checkSize(this.x_coord, this.currentItem);
        this.y_coord = this.checkSize(this.y_coord, this.currentItem);
        this.x_coord[this.currentItem] = currentGraphicsState.x;
        this.y_coord[this.currentItem] = currentGraphicsState.y;
        this.shapeType.addElement(fillType);
        ++this.currentItem;
        this.resetTextColors = true;
    }

    public final void drawColor(PdfPaint currentCol, int type) {
        this.areas.addElement(null);
        this.pageObjects.addElement(null);
        this.objectType.addElement(10);
        this.textFillType.addElement(type);
        this.text_color.addElement(currentCol);
        this.x_coord = this.checkSize(this.x_coord, this.currentItem);
        this.y_coord = this.checkSize(this.y_coord, this.currentItem);
        this.x_coord[this.currentItem] = 0.0f;
        this.y_coord[this.currentItem] = 0.0f;
        ++this.currentItem;
        this.strokeSet = false;
        this.fillSet = false;
    }

    public void resetOnColorspaceChange() {
        this.fillSet = false;
        this.strokeSet = false;
    }

    public final void drawFillColor(PdfPaint currentCol) {
        this.pageObjects.addElement(null);
        this.objectType.addElement(11);
        this.areas.addElement(null);
        this.fill_color.addElement(currentCol);
        this.x_coord = this.checkSize(this.x_coord, this.currentItem);
        this.y_coord = this.checkSize(this.y_coord, this.currentItem);
        this.x_coord[this.currentItem] = 0.0f;
        this.y_coord[this.currentItem] = 0.0f;
        ++this.currentItem;
        this.lastFillCol = currentCol.getRGB();
    }

    public final void setGraphicsState(int fillType, float value) {
        if (value != 1.0f) {
            if (this.opacity == null) {
                this.opacity = new Vector_Float(this.defaultSize);
            }
            this.pageObjects.addElement(null);
            if (fillType == 1) {
                this.objectType.addElement(17);
            } else {
                this.objectType.addElement(18);
            }
            this.opacity.addElement(value);
            this.x_coord = this.checkSize(this.x_coord, this.currentItem);
            this.y_coord = this.checkSize(this.y_coord, this.currentItem);
            this.x_coord[this.currentItem] = 0.0f;
            this.y_coord[this.currentItem] = 0.0f;
            ++this.currentItem;
        }
    }

    public final void drawAdditionalObjectsOverPage(int[] type, Color[] colors, Object[] obj) throws PdfException {
        if (this.endItem == -1) {
            this.endItem = this.currentItem;
            this.objectType.setCheckpoint();
            this.shapeType.setCheckpoint();
            this.pageObjects.setCheckpoint();
            this.areas.setCheckpoint();
            this.clips.setCheckpoint();
            this.textFillType.setCheckpoint();
            this.text_color.setCheckpoint();
            this.fill_color.setCheckpoint();
            this.stroke_color.setCheckpoint();
            this.stroke.setCheckpoint();
            if (this.imageOptions != null) {
                this.imageOptions.setCheckpoint();
            }
            if (this.TRvalues != null) {
                this.TRvalues.setCheckpoint();
            }
            if (this.fs != null) {
                this.fs.setCheckpoint();
            }
            if (this.lw != null) {
                this.lw.setCheckpoint();
            }
            this.af1.setCheckpoint();
            this.af2.setCheckpoint();
            this.af3.setCheckpoint();
            this.af4.setCheckpoint();
        }
        if (obj == null) {
            if (this.endItem != -1) {
                this.currentItem = this.endItem;
            }
            this.endItem = -1;
            this.objectType.resetToCheckpoint();
            this.shapeType.resetToCheckpoint();
            this.pageObjects.resetToCheckpoint();
            this.areas.resetToCheckpoint();
            this.clips.resetToCheckpoint();
            this.textFillType.resetToCheckpoint();
            this.text_color.resetToCheckpoint();
            this.fill_color.resetToCheckpoint();
            this.stroke_color.resetToCheckpoint();
            this.stroke.resetToCheckpoint();
            if (this.imageOptions != null) {
                this.imageOptions.resetToCheckpoint();
            }
            if (this.TRvalues != null) {
                this.TRvalues.resetToCheckpoint();
            }
            if (this.fs != null) {
                this.fs.resetToCheckpoint();
            }
            if (this.lw != null) {
                this.lw.resetToCheckpoint();
            }
            this.af1.resetToCheckpoint();
            this.af2.resetToCheckpoint();
            this.af3.resetToCheckpoint();
            this.af4.resetToCheckpoint();
            if (this.opacity != null) {
                this.opacity.clear();
            }
            this.objectType.resetToCheckpoint();
            this.endItem = -1;
            this.lastFillTextCol = 0;
            this.lastFillCol = 0;
            this.lastStrokeCol = 0;
            this.lastClip = null;
            this.hasClips = false;
            this.lastStroke = null;
            this.lastAf = new double[4];
            this.fillSet = false;
            this.strokeSet = false;
            return;
        }
        int count = type.length;
        int i = 0;
        while (i < count) {
            int currentType = type[i];
            switch (currentType) {
                case 18: {
                    this.setGraphicsState(2, ((Float)obj[i]).floatValue());
                    break;
                }
                case 17: {
                    this.setGraphicsState(1, ((Float)obj[i]).floatValue());
                    break;
                }
                case 19: {
                    GraphicsState gs = new GraphicsState();
                    gs.setFillType(1);
                    gs.setStrokeColor(new PdfColor(colors[i].getRed(), colors[i].getGreen(), colors[i].getBlue()));
                    this.drawShape((Shape)obj[i], gs);
                    break;
                }
                case 20: {
                    GraphicsState gs = new GraphicsState();
                    gs.setFillType(2);
                    gs.setNonstrokeColor(new PdfColor(colors[i].getRed(), colors[i].getGreen(), colors[i].getBlue()));
                    this.drawShape((Shape)obj[i], gs);
                    break;
                }
                case 16: {
                    TextObject textObj = (TextObject)obj[i];
                    GraphicsState gs = new GraphicsState();
                    float fontSize = textObj.font.getSize();
                    double[] afValues = new double[]{fontSize, 0.0, 0.0, fontSize, 0.0, 0.0};
                    this.drawAffine(afValues);
                    this.drawTR(2);
                    gs.setTextRenderType(2);
                    gs.setNonstrokeColor(new PdfColor(colors[i].getRed(), colors[i].getGreen(), colors[i].getBlue()));
                    this.drawText(null, textObj.text, gs, textObj.x, -textObj.y, textObj.font);
                    break;
                }
                default: {
                    throw new PdfException("Unrecognised type " + currentType);
                }
            }
            ++i;
        }
    }

    public final void drawStrokeColor(Paint currentCol) {
        this.pageObjects.addElement(null);
        this.objectType.addElement(12);
        this.areas.addElement(null);
        this.stroke_color.addElement(currentCol);
        this.x_coord = this.checkSize(this.x_coord, this.currentItem);
        this.y_coord = this.checkSize(this.y_coord, this.currentItem);
        this.x_coord[this.currentItem] = 0.0f;
        this.y_coord[this.currentItem] = 0.0f;
        ++this.currentItem;
        this.strokeSet = false;
        this.fillSet = false;
        this.resetTextColors = true;
    }

    public final void drawTR(int value) {
        if (value != this.lastTR) {
            if (this.TRvalues == null) {
                this.TRvalues = new Vector_Int(this.defaultSize);
            }
            this.lastTR = value;
            this.pageObjects.addElement(null);
            this.objectType.addElement(15);
            this.areas.addElement(null);
            this.TRvalues.addElement(value);
            this.x_coord = this.checkSize(this.x_coord, this.currentItem);
            this.y_coord = this.checkSize(this.y_coord, this.currentItem);
            this.x_coord[this.currentItem] = 0.0f;
            this.y_coord[this.currentItem] = 0.0f;
            ++this.currentItem;
        }
    }

    public final void drawStroke(Stroke current) {
        this.pageObjects.addElement(null);
        this.objectType.addElement(14);
        this.areas.addElement(null);
        this.stroke.addElement(current);
        this.x_coord = this.checkSize(this.x_coord, this.currentItem);
        this.y_coord = this.checkSize(this.y_coord, this.currentItem);
        this.x_coord[this.currentItem] = 0.0f;
        this.y_coord[this.currentItem] = 0.0f;
        ++this.currentItem;
    }

    public final void drawClip(GraphicsState currentGraphicsState) {
        Area clip = currentGraphicsState.getClippingShape();
        if (!this.hasClips || this.lastClip != null || clip != null) {
            this.pageObjects.addElement(null);
            this.objectType.addElement(7);
            this.areas.addElement(null);
            this.lastClip = clip;
            if (clip == null) {
                this.clips.addElement(null);
            } else {
                this.clips.addElement((Area)clip.clone());
            }
            this.x_coord = this.checkSize(this.x_coord, this.currentItem);
            this.y_coord = this.checkSize(this.y_coord, this.currentItem);
            this.x_coord[this.currentItem] = currentGraphicsState.x;
            this.y_coord[this.currentItem] = currentGraphicsState.y;
            ++this.currentItem;
        }
        this.hasClips = true;
    }

    public void drawEmbeddedText(float[][] Trm, int fontSize, PdfGlyph glyph, int type, GraphicsState currentGraphicsState, AffineTransform at, float currentLineWidth) {
        int newCol;
        PdfPaint currentCol;
        int text_fill_type = currentGraphicsState.getTextRenderType();
        if ((text_fill_type & 2) == 2) {
            currentCol = currentGraphicsState.getNonstrokeColor();
            if (currentCol.isPattern()) {
                this.drawColor(currentCol, 2);
            } else {
                newCol = currentCol.getRGB();
                if (this.lastFillTextCol != newCol) {
                    this.lastFillTextCol = newCol;
                    this.drawColor(currentCol, 2);
                }
            }
        }
        if ((text_fill_type & 1) == 1 && this.lastStrokeCol != (newCol = (currentCol = currentGraphicsState.getStrokeColor()).getRGB())) {
            this.lastStrokeCol = newCol;
            this.drawColor(currentCol, 1);
        }
        this.drawFontSize(fontSize);
        double[] nextAf = new double[6];
        at.getMatrix(nextAf);
        if (this.lastAf[0] != nextAf[0] || this.lastAf[1] != nextAf[1] || this.lastAf[2] != nextAf[2] || this.lastAf[3] != nextAf[3]) {
            this.drawAffine(nextAf);
            this.lastAf[0] = nextAf[0];
            this.lastAf[1] = nextAf[1];
            this.lastAf[2] = nextAf[2];
            this.lastAf[3] = nextAf[3];
        }
        this.pageObjects.addElement(glyph);
        this.objectType.addElement(type);
        this.x_coord = this.checkSize(this.x_coord, this.currentItem);
        this.y_coord = this.checkSize(this.y_coord, this.currentItem);
        this.x_coord[this.currentItem] = (float)at.getTranslateX();
        this.y_coord[this.currentItem] = (float)at.getTranslateY();
        Rectangle area = new Rectangle((int)Trm[2][0], (int)Trm[2][1], fontSize, fontSize);
        this.areas.addElement(area);
        this.checkWidth(area);
        ++this.currentItem;
    }

    public void drawAffine(double[] afValues) {
        this.pageObjects.addElement(null);
        this.objectType.addElement(9);
        this.areas.addElement(null);
        this.af1.addElement(afValues[0]);
        this.af2.addElement(afValues[1]);
        this.af3.addElement(afValues[2]);
        this.af4.addElement(afValues[3]);
        this.x_coord = this.checkSize(this.x_coord, this.currentItem);
        this.y_coord = this.checkSize(this.y_coord, this.currentItem);
        this.x_coord[this.currentItem] = (float)afValues[4];
        this.y_coord[this.currentItem] = (float)afValues[5];
        ++this.currentItem;
    }

    public void drawFontSize(int fontSize) {
        if (fontSize != this.lastFS) {
            this.pageObjects.addElement(null);
            this.objectType.addElement(21);
            this.areas.addElement(null);
            if (this.fs == null) {
                this.fs = new Vector_Int(this.defaultSize);
            }
            this.fs.addElement(fontSize);
            this.x_coord = this.checkSize(this.x_coord, this.currentItem);
            this.y_coord = this.checkSize(this.y_coord, this.currentItem);
            this.x_coord[this.currentItem] = 0.0f;
            this.y_coord[this.currentItem] = 0.0f;
            ++this.currentItem;
            this.lastFS = fontSize;
        }
    }

    public void setLineWidth(int lineWidth) {
        if (lineWidth == this.lastLW) {
            // empty if block
        }
        this.pageObjects.addElement(null);
        this.objectType.addElement(22);
        if (this.lw == null) {
            this.lw = new Vector_Int(this.defaultSize);
        }
        this.lw.addElement(lineWidth);
        this.x_coord = this.checkSize(this.x_coord, this.currentItem);
        this.y_coord = this.checkSize(this.y_coord, this.currentItem);
        this.x_coord[this.currentItem] = 0.0f;
        this.y_coord[this.currentItem] = 0.0f;
        ++this.currentItem;
        this.lastLW = lineWidth;
    }

    public void renderAffine(AffineTransform at) {
        this.aff = at;
    }

    public boolean addBackground() {
        return this.addBackground;
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public void lockColors(PdfPaint strokePaint, PdfPaint nonstrokePaint) {
        this.colorsLocked = true;
        Color strokeColor = Color.white;
        Color nonstrokeColor = Color.white;
        if (!strokePaint.isPattern()) {
            strokeColor = (Color)((Object)strokePaint);
        }
        this.strokeCol = new PdfColor(strokeColor.getRed(), strokeColor.getGreen(), strokeColor.getBlue());
        if (!nonstrokePaint.isPattern()) {
            nonstrokeColor = (Color)((Object)nonstrokePaint);
        }
        this.fillCol = new PdfColor(nonstrokeColor.getRed(), nonstrokeColor.getGreen(), nonstrokeColor.getBlue());
    }

    public void setHiResImageForDisplayMode(boolean useHiResImageForDisplay) {
    }

    public void setOptimiseDrawing(boolean optimiseDrawing) {
        this.optimiseDrawing = optimiseDrawing;
    }

    public void setScalingValues(double cropX, double cropH, float scaling) {
        this.cropX = cropX;
        this.cropH = cropH;
        this.scaling = scaling;
    }

    public boolean isImageCached(int pageNumber) {
        if (this.rawKey == null) {
            return this.objectStoreRef.isImageCached(String.valueOf(pageNumber) + "_HIRES_" + (this.currentItem + 1));
        }
        return this.objectStoreRef.isImageCached(String.valueOf(pageNumber) + "_HIRES_" + (this.currentItem + 1) + '_' + this.rawKey);
    }

    public DynamicVectorRenderer(byte[] stream, Map fonts) {
        try {
            this.fonts = fonts;
            ByteArrayInputStream bis = new ByteArrayInputStream(stream);
            int version = bis.read();
            if (version != 1) {
                throw new PdfException("Unknown version in serialised object " + version);
            }
            int isHires = bis.read();
            this.useHiResImageForDisplay = isHires == 1;
            this.pageNumber = bis.read();
            this.x_coord = (float[])this.restoreFromStream(bis);
            this.y_coord = (float[])this.restoreFromStream(bis);
            this.text_color = (Vector_Object)this.restoreFromStream(bis);
            this.textFillType = (Vector_Int)this.restoreFromStream(bis);
            this.stroke_color = new Vector_Object();
            this.stroke_color.restoreFromStream(bis);
            this.fill_color = new Vector_Object();
            this.fill_color.restoreFromStream(bis);
            this.stroke = new Vector_Object();
            this.stroke.restoreFromStream(bis);
            this.pageObjects = new Vector_Object();
            this.pageObjects.restoreFromStream(bis);
            this.javaObjects = (Vector_Object)this.restoreFromStream(bis);
            this.shapeType = (Vector_Int)this.restoreFromStream(bis);
            this.af1 = (Vector_Double)this.restoreFromStream(bis);
            this.af2 = (Vector_Double)this.restoreFromStream(bis);
            this.af3 = (Vector_Double)this.restoreFromStream(bis);
            this.af4 = (Vector_Double)this.restoreFromStream(bis);
            this.clips = new Vector_Shape();
            this.clips.restoreFromStream(bis);
            this.objectType = (Vector_Int)this.restoreFromStream(bis);
            this.opacity = (Vector_Float)this.restoreFromStream(bis);
            this.imageOptions = (Vector_Int)this.restoreFromStream(bis);
            this.TRvalues = (Vector_Int)this.restoreFromStream(bis);
            this.fs = (Vector_Int)this.restoreFromStream(bis);
            this.lw = (Vector_Int)this.restoreFromStream(bis);
            int fontCount = (Integer)this.restoreFromStream(bis);
            int ii = 0;
            while (ii < fontCount) {
                Object key = this.restoreFromStream(bis);
                Object glyphs = this.restoreFromStream(bis);
                fonts.put(key, glyphs);
                ++ii;
            }
            int alteredFontCount = (Integer)this.restoreFromStream(bis);
            int ii2 = 0;
            while (ii2 < alteredFontCount) {
                Object key = this.restoreFromStream(bis);
                PdfJavaGlyphs updatedFont = (PdfJavaGlyphs)fonts.get(key);
                updatedFont.setDisplayValues((Map)this.restoreFromStream(bis));
                updatedFont.setCharGlyphs((Map)this.restoreFromStream(bis));
                updatedFont.setEmbeddedEncs((Map)this.restoreFromStream(bis));
                ++ii2;
            }
            bis.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public byte[] serializeToByteArray(Set fontsAlreadyOnClient) throws IOException {
        int end;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        bos.write(1);
        if (this.useHiResImageForDisplay) {
            bos.write(1);
        } else {
            bos.write(0);
        }
        bos.write(this.pageNumber);
        this.text_color.trim();
        this.stroke_color.trim();
        this.fill_color.trim();
        this.stroke.trim();
        this.pageObjects.trim();
        this.javaObjects.trim();
        this.stroke.trim();
        this.pageObjects.trim();
        this.javaObjects.trim();
        this.shapeType.trim();
        this.af1.trim();
        this.af2.trim();
        this.af3.trim();
        this.af4.trim();
        this.clips.trim();
        this.objectType.trim();
        if (this.opacity != null) {
            this.opacity.trim();
        }
        if (this.imageOptions != null) {
            this.imageOptions.trim();
        }
        if (this.TRvalues != null) {
            this.TRvalues.trim();
        }
        if (this.fs != null) {
            this.fs.trim();
        }
        if (this.lw != null) {
            this.lw.trim();
        }
        this.writeToStream(bos, this.x_coord, "x_coord");
        this.writeToStream(bos, this.y_coord, "y_coord");
        this.writeToStream(bos, this.text_color, "text_color");
        this.writeToStream(bos, this.textFillType, "textFillType");
        this.stroke_color.writeToStream(bos);
        this.fill_color.writeToStream(bos);
        int start = bos.size();
        this.stroke.writeToStream(bos);
        start = end = bos.size();
        this.pageObjects.writeToStream(bos);
        end = bos.size();
        this.writeToStream(bos, this.javaObjects, "javaObjects");
        this.writeToStream(bos, this.shapeType, "shapeType");
        this.writeToStream(bos, this.af1, "af1");
        this.writeToStream(bos, this.af2, "af2");
        this.writeToStream(bos, this.af3, "af3");
        this.writeToStream(bos, this.af4, "af4");
        start = bos.size();
        this.clips.writeToStream(bos);
        end = bos.size();
        this.writeToStream(bos, this.objectType, "objectType");
        this.writeToStream(bos, this.opacity, "opacity");
        this.writeToStream(bos, this.imageOptions, "imageOptions");
        this.writeToStream(bos, this.TRvalues, "TRvalues");
        this.writeToStream(bos, this.fs, "fs");
        this.writeToStream(bos, this.lw, "lw");
        int fontCount = 0;
        int updateCount = 0;
        HashMap fontsAlreadySent = new HashMap();
        HashMap newFontsToSend = new HashMap();
        for (Object fontUsed : this.fontsUsed.keySet()) {
            if (!fontsAlreadyOnClient.contains(fontUsed)) {
                ++fontCount;
                newFontsToSend.put(fontUsed, "x");
                continue;
            }
            ++updateCount;
            fontsAlreadySent.put(fontUsed, "x");
        }
        this.writeToStream(bos, new Integer(fontCount), "new Integer(fontCount)");
        for (Object key : newFontsToSend.keySet()) {
            this.writeToStream(bos, key, "key");
            this.writeToStream(bos, this.fonts.get(key), "font");
            fontsAlreadyOnClient.add(key);
        }
        this.writeToStream(bos, new Integer(updateCount), "new Integer(existingfontCount)");
        for (Object key : fontsAlreadySent.keySet()) {
            this.writeToStream(bos, key, "key");
            PdfJavaGlyphs aa = (PdfJavaGlyphs)this.fonts.get(key);
            this.writeToStream(bos, aa.getDisplayValues(), "display");
            this.writeToStream(bos, aa.getCharGlyphs(), "char");
            this.writeToStream(bos, aa.getEmbeddedEncs(), "emb");
        }
        bos.close();
        this.fontsUsed.clear();
        return bos.toByteArray();
    }

    public Object restoreFromStream(ByteArrayInputStream bis) throws IOException, ClassNotFoundException {
        ObjectInputStream os = new ObjectInputStream(bis);
        return os.readObject();
    }

    public void writeToStream(ByteArrayOutputStream bos, Object obj, String string2) throws IOException {
        int start = bos.size();
        ObjectOutputStream os = new ObjectOutputStream(bos);
        os.writeObject(obj);
        int end = bos.size();
        os.close();
    }

    public void checkFontSaved(Object glyph, String name, PdfFont currentFontData) {
        this.pageObjects.addElement(glyph);
        this.objectType.addElement(200);
        ++this.currentItem;
        if (this.fontsUsed.get(name) == null || currentFontData.isFontSubsetted()) {
            this.fonts.put(name, currentFontData.getGlyphData());
            this.fontsUsed.put(name, "x");
        }
    }

    public boolean hasObjectsBehind(float[][] CTM) {
        double h;
        boolean hasObject = false;
        double x = CTM[2][0];
        double y = CTM[2][1];
        double w = CTM[0][0];
        if (w == 0.0) {
            w = CTM[0][1];
        }
        if ((h = (double)CTM[1][1]) == 0.0) {
            h = CTM[1][0];
        }
        Rectangle[] areas = this.areas.get();
        int count = areas.length;
        int i = 0;
        while (i < count) {
            if (areas[i] != null) {
                if (h < 0.0) {
                    h = (y += h) - h;
                }
                if (w < 0.0) {
                    w = (x += w) - w;
                }
                Rectangle large = areas[i];
                Rectangle small = new Rectangle((int)x, (int)y, (int)w, (int)h);
                if (w * h > (double)(areas[i].width * areas[i].height)) {
                    large = new Rectangle((int)x, (int)y, (int)w, (int)h);
                    small = areas[i];
                }
                if (small.intersects(large) || large.contains(small)) {
                    i = count;
                    hasObject = true;
                }
            }
            ++i;
        }
        return hasObject;
    }

    public Rectangle getArea(int i) {
        return this.areas.elementAt(i);
    }

    public boolean rectangleContains(Rectangle area, int x, int y, int i) {
        int temp;
        int lowX = area.x;
        int hiX = area.x + area.width;
        int lowY = area.y;
        int hiY = area.y + area.height;
        boolean containsPoint = false;
        if (lowX > hiX) {
            temp = lowX;
            lowX = hiX;
            hiX = temp;
        }
        if (lowY > hiY) {
            temp = lowY;
            lowY = hiY;
            hiY = temp;
        }
        if (lowY < y && y < hiY && lowX < x && x < hiX) {
            containsPoint = true;
        }
        return containsPoint;
    }

    public int isInsideImage(int x, int y) {
        int outLine = -1;
        Rectangle[] areas = this.areas.get();
        Rectangle possArea = null;
        int count = areas.length;
        int[] types = this.objectType.get();
        int i = 0;
        while (i < count) {
            if (areas[i] != null && this.rectangleContains(areas[i], x, y, i) && types[i] == 3) {
                if (possArea != null) {
                    int area2 = areas[i].height * areas[i].width;
                    int area1 = possArea.height * possArea.width;
                    if (area2 < area1) {
                        possArea = areas[i];
                    }
                    outLine = i;
                } else {
                    possArea = areas[i];
                    outLine = i;
                }
            }
            ++i;
        }
        return outLine;
    }

    public void setObjectStoreRef(ObjectStore objectStoreRef) {
        this.objectStoreRef = objectStoreRef;
    }

    public void setType3Glyph(String pKey) {
        this.rawKey = pKey;
        this.isType3Font = true;
    }

    public BufferedImage getLoresImage(String imageName) {
        Object id;
        int idx = imageName.indexOf(45);
        if (idx != -1) {
            imageName = imageName.substring(idx + 1, imageName.length());
        }
        if ((id = this.imageID.get(imageName)) == null) {
            return null;
        }
        BufferedImage source = (BufferedImage)this.pageObjects.elementAt((Integer)id);
        AffineTransform image_at2 = new AffineTransform();
        image_at2.scale(1.0, -1.0);
        image_at2.translate(0.0, -source.getHeight());
        AffineTransformOp invert3 = new AffineTransformOp(image_at2, ColorSpaces.hints);
        BufferedImage image = new BufferedImage(source.getWidth(), source.getHeight(), source.getType());
        invert3.filter(source, image);
        return image;
    }

    public void saveImage(int id, String des, String type) {
        String name = (String)this.imageIDtoName.get(new Integer(id));
        BufferedImage image = null;
        image = this.useHiResImageForDisplay ? this.objectStoreRef.loadStoredImage(name) : (BufferedImage)this.pageObjects.elementAt(id);
        if (image != null) {
            if (((image = this.invertImage(null, image)).getType() == 0 || type.equals("jpg") && image.getType() == 2) && (image = ColorSpaceConvertor.convertToRGB(image)).getType() == 0) {
                JOptionPane.showMessageDialog(null, "This is a custom Image, Java's standard libraries may not be able to save the image as a jpg correctly.\nEnabling JAI will ensure correct output. \n\nFor information on how to do this please go to http://www.jpedal.org/flags.php");
            }
            if (this.needsHorizontalInvert) {
                image = this.invertImageBeforeSave(image, true);
            }
            if (this.needsVerticalInvert) {
                image = this.invertImageBeforeSave(image, false);
            }
            if (JAIHelper.isJAIused() && type.toLowerCase().startsWith("tif")) {
                JAI.create((String)"filestore", (RenderedImage)image, (Object)des, (Object)type);
            } else if (type.toLowerCase().startsWith("tif")) {
                JOptionPane.showMessageDialog(null, "Please setup JAI library for Tiffs");
            } else {
                try {
                    ImageIO.write((RenderedImage)image, type, new File(des));
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
        }
    }

    public void setCustomImageHandler(ImageHandler customImageHandler) {
        this.customImageHandler = customImageHandler;
    }
}

