/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.parser;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.color.ColorSpace;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import org.jpedal.PdfDecoder;
import org.jpedal.color.ColorSpaces;
import org.jpedal.color.ColorspaceDecoder;
import org.jpedal.color.DeviceCMYKColorSpace;
import org.jpedal.color.DeviceGrayColorSpace;
import org.jpedal.color.DeviceRGBColorSpace;
import org.jpedal.color.GenericColorSpace;
import org.jpedal.color.PdfColor;
import org.jpedal.color.PdfPaint;
import org.jpedal.exception.PdfException;
import org.jpedal.exception.PdfFontException;
import org.jpedal.external.ImageHandler;
import org.jpedal.fonts.FontMappings;
import org.jpedal.fonts.PdfFont;
import org.jpedal.fonts.PdfHeightTable;
import org.jpedal.fonts.StandardFonts;
import org.jpedal.fonts.glyph.GlyphFactory;
import org.jpedal.fonts.glyph.PdfGlyph;
import org.jpedal.fonts.glyph.PdfJavaGlyphs;
import org.jpedal.fonts.glyph.T1GlyphFactory;
import org.jpedal.fonts.glyph.T3Size;
import org.jpedal.function.FunctionFactory;
import org.jpedal.function.PDFFunction;
import org.jpedal.grouping.PdfGroupingAlgorithms;
import org.jpedal.images.ImageOps;
import org.jpedal.images.ImageTransformer;
import org.jpedal.images.ImageTransformerDouble;
import org.jpedal.io.ColorSpaceConvertor;
import org.jpedal.io.JAIHelper;
import org.jpedal.io.ObjectStore;
import org.jpedal.io.PdfArray;
import org.jpedal.io.PdfObjectReader;
import org.jpedal.io.StatusBar;
import org.jpedal.objects.GraphicsState;
import org.jpedal.objects.PageLines;
import org.jpedal.objects.PdfData;
import org.jpedal.objects.PdfImageData;
import org.jpedal.objects.PdfPageData;
import org.jpedal.objects.PdfShape;
import org.jpedal.objects.StoryData;
import org.jpedal.objects.TextState;
import org.jpedal.objects.structuredtext.StructuredContentHandler;
import org.jpedal.parser.Cmd;
import org.jpedal.parser.FontFactory;
import org.jpedal.parser.StreamDecoder;
import org.jpedal.render.DynamicVectorRenderer;
import org.jpedal.utils.Fonts;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.Matrix;
import org.jpedal.utils.Strip;
import org.jpedal.utils.repositories.Vector_Object;

public class PdfStreamDecoder
implements StreamDecoder {
    private boolean showTextAsRotated = false;
    public static boolean useShading = true;
    private boolean TRFlagged = false;
    ImageHandler customImageHandler = null;
    boolean rejectSuperimposedImages = false;
    private int optionsApplied = 0;
    private boolean generateGlyphOnRender = false;
    static final int[] prefixes = new int[]{60, 40};
    static final int[] suffixes = new int[]{62, 41};
    boolean isMask = true;
    private boolean pageSuccessful = true;
    private String pageErrorMessages = "";
    private StringBuffer textData;
    private StatusBar statusBar = null;
    public static float currentThreshold = 0.6f;
    public static Map currentThresholdValues;
    private Map rawColorspaceValues = new HashMap();
    private Map colorspaceObjects = new HashMap();
    private int textPrint = 0;
    private Map rawShadingValues = new HashMap();
    protected boolean multipleTJs = false;
    private PdfObjectReader currentPdfFile;
    private boolean isClip = false;
    private static final float THOUSAND = 1000.0f;
    private boolean renderText = false;
    private boolean renderImages = false;
    private boolean renderPage = false;
    private boolean rawImagesExtracted = true;
    private boolean finalImagesExtracted = true;
    private boolean xFormMetadata = true;
    private boolean clippedImagesExtracted = true;
    private boolean markedContentExtracted = false;
    private StructuredContentHandler contentHandler;
    private boolean textExtracted = true;
    private boolean textColorExtracted = false;
    private boolean colorExtracted = false;
    private static final String[] hex;
    private PdfData pdfData = new PdfData();
    private String font_as_string = "";
    protected GenericColorSpace strokeColorSpace = new DeviceRGBColorSpace();
    protected GenericColorSpace nonstrokeColorSpace = new DeviceRGBColorSpace();
    private boolean createScaledVersion = true;
    private PdfImageData pdfImages = new PdfImageData();
    private int tokenNumber = 0;
    private boolean isPageContent = true;
    private boolean isStackInitialised = false;
    private Vector_Object graphicsStateStack;
    private Vector_Object strokeColorStateStack;
    private Vector_Object nonstrokeColorStateStack;
    private Vector_Object clipStack;
    private Vector_Object textStateStack;
    private PageLines pageLines = new PageLines();
    private PdfShape currentDrawShape = new PdfShape();
    private static final int MAXOPS = 50;
    private int currentOp = 0;
    private int operandCount = 0;
    private String[] operand = new String[50];
    private int[] opStart = new int[50];
    private int[] opEnd = new int[50];
    protected int moveCommand = 0;
    private String currentFont = "";
    private String currentImage = "";
    private Map currentXObjectValues = new Hashtable();
    private Map localXObjects = new Hashtable();
    private Map currentPatternValues = new Hashtable();
    protected float charSpacing = 0.0f;
    protected GraphicsState currentGraphicsState = new GraphicsState();
    protected TextState currentTextState = new TextState();
    protected PdfFont currentFontData;
    private Map fonts = new Hashtable();
    private int textLength = 0;
    private boolean useHiResImageForDisplay = false;
    private float x1;
    private float y1;
    private float x2;
    private float y2;
    private PdfPageData pageData = new PdfPageData();
    protected DynamicVectorRenderer current;
    static final double radiansToDegrees = 57.29577951308232;
    double rotationAsRadians = 0.0;
    protected GlyphFactory factory = null;
    private int pageNum;
    private static String fontsInFile;
    private String currentColor = "<color C='1' M='1' Y='1' K='1'>";
    private int T3maxWidth;
    private int T3maxHeight;
    private boolean legacyTextMode = false;
    private boolean extractRawCMYK = false;
    protected boolean renderDirectly;
    protected Graphics2D g2;
    private Shape defaultClip;
    private boolean hasEmbeddedFonts = false;
    private boolean includeImagesInData = false;
    protected int lastFontSize = -1;
    public boolean ignoreColors = false;
    private static String ellipsis;
    private boolean isPrinting;
    private String fileName = "";
    private ObjectStore objectStoreStreamRef;
    private String lastFormID = null;
    private int pageH;
    private int formLevel = 0;
    private boolean requestExit = false;
    private boolean exited = false;
    private Map gs_state = new HashMap();
    private boolean imagesProcessedFully;
    private boolean keepRaw = false;
    public static boolean runningStoryPad;
    private static boolean testFontSupport;
    private Map scalings = new HashMap();
    private boolean isType3Font;
    private Map TRPDFfunctionsCache = new HashMap();
    private Map imposedImages;
    public static boolean showInvisibleText;
    public static boolean useTextPrintingForNonEmbeddedFonts;
    private int currentRotation = 0;
    float unRotatedY = -1.0f;
    float lastHeight = -1.0f;
    private float rotatedY;
    public static boolean includeRotation;
    private Map lines = new HashMap();

    static {
        hex = new String[]{"&#0;", "&#1;", "&#2;", "&#3;", "&#4;", "&#5;", "&#6;", "&#7;", "&#8;", "&#9;", "&#10;", "&#11;", "&#12;", "&#13;", "&#14;", "&#15;", "&#16;", "&#17;", "&#18;", "&#19;", "&#20;", "&#21;", "&#22;", "&#23;", "&#24;", "&#25;", "&#26;", "&#27;", "&#28;", "&#29;", "&#30;", "&#31;"};
        ellipsis = String.valueOf((char)Integer.parseInt("2026", 16));
        runningStoryPad = false;
        showInvisibleText = false;
        useTextPrintingForNonEmbeddedFonts = false;
        includeRotation = false;
    }

    public void setName(String name) {
        if (name != null) {
            this.fileName = name.toLowerCase();
            int sep = this.fileName.lastIndexOf(47);
            if (sep != -1) {
                this.fileName = this.fileName.substring(sep + 1);
            }
            if ((sep = this.fileName.lastIndexOf(92)) != -1) {
                this.fileName = this.fileName.substring(sep + 1);
            }
            if ((sep = this.fileName.lastIndexOf(46)) != -1) {
                this.fileName = this.fileName.substring(0, sep);
            }
        }
    }

    public void setStore(ObjectStore newObjectRef) {
        this.objectStoreStreamRef = newObjectRef;
        this.current = new DynamicVectorRenderer(this.pageNum, this.objectStoreStreamRef, this.isPrinting);
        this.current.setHiResImageForDisplayMode(this.useHiResImageForDisplay);
        if (this.customImageHandler != null && this.current != null) {
            this.current.setCustomImageHandler(this.customImageHandler);
        }
    }

    public PdfStreamDecoder(PdfObjectReader currentPdfFile, boolean useHires, boolean isType3Font) {
        StandardFonts.checkLoaded(1);
        if (this.factory == null) {
            this.factory = new T1GlyphFactory();
        }
        this.currentPdfFile = currentPdfFile;
        this.useHiResImageForDisplay = useHires;
        this.isType3Font = isType3Font;
        String operlapValue = System.getProperty("org.jpedal.rejectsuperimposedimages");
        this.rejectSuperimposedImages = operlapValue != null && operlapValue.toLowerCase().indexOf("true") != -1;
    }

    public PdfStreamDecoder(PdfObjectReader currentPdfFile) {
        StandardFonts.checkLoaded(1);
        if (this.factory == null) {
            this.factory = new T1GlyphFactory();
        }
        this.currentPdfFile = currentPdfFile;
        String operlapValue = System.getProperty("org.jpedal.rejectsuperimposedimages");
        this.rejectSuperimposedImages = operlapValue != null && operlapValue.toLowerCase().indexOf("true") != -1;
    }

    public PdfStreamDecoder() {
        String operlapValue;
        StandardFonts.checkLoaded(1);
        if (this.factory == null) {
            this.factory = new T1GlyphFactory();
        }
        this.rejectSuperimposedImages = (operlapValue = System.getProperty("org.jpedal.rejectsuperimposedimages")) != null && operlapValue.toLowerCase().indexOf("true") != -1;
    }

    public void print(Graphics2D g2, AffineTransform scaling, boolean showImageable) {
        if (showImageable) {
            this.current.setBackgroundColor(null);
        }
        this.current.paint(g2, null, scaling, null, false, false);
    }

    public PdfStreamDecoder(boolean useHiResImageForDisplay) {
        String operlapValue;
        StandardFonts.checkLoaded(1);
        if (this.factory == null) {
            this.factory = new T1GlyphFactory();
        }
        this.rejectSuperimposedImages = (operlapValue = System.getProperty("org.jpedal.rejectsuperimposedimages")) != null && operlapValue.toLowerCase().indexOf("true") != -1;
    }

    public void setDefaultColors(PdfPaint strokeCol, PdfPaint nonstrokeCol) {
        this.strokeColorSpace.setColor(strokeCol);
        this.nonstrokeColorSpace.setColor(nonstrokeCol);
        this.currentGraphicsState.setStrokeColor(strokeCol);
        this.currentGraphicsState.setNonstrokeColor(nonstrokeCol);
    }

    public void optimiseDisplayForPrinting() {
        this.isPrinting = true;
    }

    public PdfData getText() {
        return this.pdfData;
    }

    public PdfImageData getImages() {
        return this.pdfImages;
    }

    private final BufferedImage processImageXObject(String image_name, Map values, boolean createScaledVersion, byte[] objectData) throws PdfException {
        String value;
        Map heightObj;
        Object indirectHeight;
        LogWriter.writeMethod("{processImageXObject}" + values, 0);
        boolean imageMask = false;
        String decodeArray = "";
        BufferedImage image = null;
        image_name = String.valueOf(this.fileName) + '-' + image_name;
        String image_filter = this.currentPdfFile.getValue((String)values.get("Filter"));
        String raw_colorspace_name = (String)values.get("ColorSpace");
        if (raw_colorspace_name != null) {
            raw_colorspace_name = Strip.removeArrayDeleminators(raw_colorspace_name);
        }
        int width = Integer.parseInt((String)values.get("Width"));
        String rawHeight = (String)values.get("Height");
        if (rawHeight.indexOf(82) != -1 && (indirectHeight = (heightObj = this.currentPdfFile.readObject(rawHeight, false, null)).get("rawValue")) != null) {
            rawHeight = (String)indirectHeight;
        }
        int height = Integer.parseInt(rawHeight);
        int depth = 1;
        String rawDepth = (String)values.get("BitsPerComponent");
        if (rawDepth != null) {
            depth = Integer.parseInt(rawDepth);
        }
        if ((value = (String)values.get("Decode")) != null) {
            decodeArray = value;
        }
        if ((value = (String)values.get("ImageMask")) != null) {
            imageMask = Boolean.valueOf(value);
            this.isMask = true;
        } else {
            this.isMask = false;
        }
        GenericColorSpace decodeColorData = new GenericColorSpace();
        if (raw_colorspace_name != null) {
            if (raw_colorspace_name.startsWith("/")) {
                decodeColorData = ColorspaceDecoder.getColorSpaceInstance(this.isPrinting, this.currentGraphicsState.CTM, raw_colorspace_name, null, this.currentPdfFile);
            } else {
                Map colorspaceValues = this.currentPdfFile.getSubDictionary(raw_colorspace_name);
                raw_colorspace_name = (String)colorspaceValues.get("rawValue");
                decodeColorData = ColorspaceDecoder.getColorSpaceInstance(this.isPrinting, this.currentGraphicsState.CTM, raw_colorspace_name, colorspaceValues, this.currentPdfFile);
            }
        }
        value = (String)values.get("Intent");
        decodeColorData.setIntent(value);
        if (raw_colorspace_name == null) {
            raw_colorspace_name = "/RGB (Default)";
        }
        LogWriter.writeLog("Processing XObject: " + image_name + " width=" + width + " Height=" + height + " Depth=" + depth + " filter=" + image_filter + " colorspace=" + raw_colorspace_name);
        if (this.customImageHandler != null) {
            values.put("stream", objectData);
            image = this.customImageHandler.processImageData(values, this.currentGraphicsState);
        }
        if (this.customImageHandler == null || image == null && !this.customImageHandler.alwaysIgnoreGenericHandler()) {
            image = this.processImage(decodeColorData, raw_colorspace_name, objectData, image_name, width, height, depth, image_filter, decodeArray, imageMask, createScaledVersion, values);
        }
        return image;
    }

    private final BufferedImage processImage(GenericColorSpace decodeColorData, String colorspaceName, byte[] data, String name, int w, int h, int d, String filter, String decodeArray, boolean imageMask, boolean createScaledVersion, Map decodeParams) throws PdfException {
        Object blend;
        Map params;
        Object raw;
        String TR;
        if (LogWriter.debug) {
            LogWriter.writeMethod("{process_image}");
        }
        boolean removed = false;
        BufferedImage image = null;
        String type = "jpg";
        int colorspaceID = decodeColorData.getID();
        byte[] maskCol = new byte[4];
        if (imageMask) {
            this.getMaskColor(maskCol);
        }
        if (decodeArray.length() != 0 && (filter == null || filter.indexOf("JPXDecode") == -1 && filter.indexOf("DCT") == -1)) {
            this.applyDecodeArray(data, d, decodeArray, colorspaceID);
        }
        if (imageMask) {
            if (w == 1 && h == 1) {
                float iw;
                float ih = this.currentGraphicsState.CTM[1][1];
                if (ih == 0.0f) {
                    ih = this.currentGraphicsState.CTM[1][0];
                }
                if (ih < 0.0f) {
                    ih = -ih;
                }
                if ((iw = this.currentGraphicsState.CTM[0][0]) == 0.0f) {
                    iw = this.currentGraphicsState.CTM[0][1];
                }
                if (iw < 0.0f) {
                    iw = -iw;
                }
                if (iw < 1.0f) {
                    iw = 1.0f;
                }
                if (ih < 1.0f) {
                    ih = 1.0f;
                }
                image = new BufferedImage((int)iw, (int)ih, 2);
                Graphics2D img2g = image.createGraphics();
                img2g.setPaint(this.nonstrokeColorSpace.getColor());
                img2g.fillRect(0, 0, (int)iw, (int)ih);
            } else {
                boolean hasObjectBehind = this.current.hasObjectsBehind(this.currentGraphicsState.CTM);
                if (maskCol[0] == 0 && maskCol[1] == 0 && maskCol[2] == 0 && !hasObjectBehind && !this.isType3Font) {
                    WritableRaster raster = Raster.createPackedRaster(new DataBufferByte(data, data.length), w, h, 1, null);
                    image = new BufferedImage(w, h, 12);
                    image.setData(raster);
                } else {
                    byte[] index = new byte[]{maskCol[0], maskCol[1], maskCol[2], -1, -1, -1};
                    image = this.convertIndexedToFlat(decodeColorData.getID(), 1, w, h, data, index, index.length, true);
                }
            }
        } else if (filter == null) {
            LogWriter.writeLog("Image " + name + ' ' + w + "W * " + h + "H with No Compression at BPC " + d + " and Colorspace=" + colorspaceName);
            image = this.makeImage(decodeColorData, w, h, d, data);
        } else if (filter.indexOf("DCT") != -1) {
            LogWriter.writeLog("JPeg Image " + name + ' ' + w + "W * " + h + 'H');
            if (colorspaceID == 3 && this.extractRawCMYK) {
                LogWriter.writeLog("Raw CMYK image " + name + " saved.");
                if (!this.objectStoreStreamRef.saveRawCMYKImage(data, name)) {
                    this.addPageFailureMessage("Problem saving Raw CMYK image " + name);
                }
            }
            try {
                image = decodeColorData.JPEGToRGBImage(data, w, h, decodeArray);
                removed = ColorSpaceConvertor.wasRemoved;
            }
            catch (Exception e) {
                this.addPageFailureMessage("Problem converting " + name + " to JPEG");
                e.printStackTrace();
                image = null;
            }
            type = "jpg";
        } else if (filter.indexOf("JPXDecode") != -1) {
            LogWriter.writeLog("JPeg 2000 Image " + name + ' ' + w + "W * " + h + 'H');
            if (JAIHelper.isJAIused()) {
                image = decodeColorData.JPEG2000ToRGBImage(data);
                type = "jpg";
            } else {
                LogWriter.writeLog("JPeg 2000 Image needs JAI on classpath and enabled in JPedal");
            }
        } else {
            LogWriter.writeLog(String.valueOf(name) + ' ' + w + "W * " + h + "H  with " + filter + " BPC=" + d + " CS=" + colorspaceName);
            image = this.makeImage(decodeColorData, w, h, d, data);
            if (d == 8 | this.nonstrokeColorSpace.getID() == 2 | this.nonstrokeColorSpace.getID() == 7) {
                type = "jpg";
            }
        }
        if (image != null) {
            Map maskValues;
            String mask = (String)decodeParams.get("Mask");
            Object smask = decodeParams.get("SMask");
            if (smask != null) {
                Map maskParams;
                maskValues = null;
                String ref = "";
                if (smask instanceof Map) {
                    maskValues = (Map)smask;
                } else {
                    ref = (String)smask;
                    maskValues = this.currentPdfFile.readObject(ref, false, null);
                }
                byte[] objectData = this.currentPdfFile.readStream(maskValues, ref, true, true, this.keepRaw, false, false);
                if (!(objectData == null || (maskParams = (Map)maskValues.get("DecodeParms")) != null && maskParams.containsKey("Colors") && maskParams.containsKey("Predictor") && !maskParams.get("Predictor").equals("15"))) {
                    BufferedImage smaskImage = this.processImageXObject(name, maskValues, false, objectData);
                    image = this.applySmask(image, smaskImage, (String)maskValues.get("ColorSpace"));
                }
            } else if (mask != null) {
                byte[] objectData;
                if (mask.indexOf(91) != -1) {
                    mask = Strip.removeArrayDeleminators(mask);
                    int colorComponents = decodeColorData.getColorComponentCount();
                    byte[] index = decodeColorData.getIndexedMap();
                    if (index != null) {
                        StringTokenizer rawValues = new StringTokenizer(mask);
                        StringBuffer newValue = new StringBuffer();
                        int itemCount = rawValues.countTokens();
                        while (rawValues.hasMoreTokens()) {
                            int indexValue = Integer.parseInt(rawValues.nextToken());
                            int i = 0;
                            while (i < colorComponents) {
                                newValue.append(String.valueOf(index[indexValue * colorComponents + i] & 0xFF));
                                newValue.append(' ');
                                ++i;
                            }
                        }
                        mask = newValue.toString();
                    }
                    StringTokenizer colValues = new StringTokenizer(mask);
                    int numberColors = colValues.countTokens() / colorComponents;
                    int[][] matches = new int[numberColors][colorComponents];
                    int currentCol = 0;
                    while (currentCol < numberColors) {
                        int comp = 0;
                        while (comp < colorComponents) {
                            int value = Integer.parseInt(colValues.nextToken());
                            if (colorComponents == 1) {
                                matches[currentCol][0] = value;
                                matches[currentCol][1] = value;
                                matches[currentCol][2] = value;
                            } else if (colorComponents == 3) {
                                matches[currentCol][comp] = value;
                            }
                            ++comp;
                        }
                        ++currentCol;
                    }
                    image = this.convertPixelsToTransparent(image, colorComponents, numberColors, matches);
                } else if (mask.endsWith(" R") && (objectData = this.currentPdfFile.readStream(maskValues = this.currentPdfFile.readObject(mask, false, null), mask, true, true, this.keepRaw, false, false)) != null) {
                    image = this.overlayImage(image, objectData);
                }
            }
            if (colorspaceID == 3 && this.currentGraphicsState.getNonStrokeOP() && this.currentGraphicsState.getOPM() == 1.0f && (image = this.simulateOP(image)) == null) {
                return null;
            }
            data = null;
            if (image.getSampleModel().getNumBands() == 1) {
                type = "tif";
            }
            if (this.isPageContent && (this.clippedImagesExtracted || this.finalImagesExtracted || this.rawImagesExtracted)) {
                if (this.currentPdfFile.isExtractionAllowed()) {
                    if (!runningStoryPad) {
                        this.objectStoreStreamRef.saveStoredImage(name, this.addBackgroundToMask(image), false, createScaledVersion, type);
                    }
                } else if (PdfDecoder.dpi != 72) {
                    int imageType = image.getType();
                    if (imageType == 0) {
                        imageType = 1;
                    }
                    BufferedImage newImage = new BufferedImage(image.getWidth(), image.getHeight(), imageType);
                    newImage.createGraphics().drawImage(image, null, null);
                    float s = (float)PdfDecoder.dpi / 72.0f;
                    AffineTransform scale = new AffineTransform();
                    scale.scale(s, s);
                    AffineTransformOp scalingOp = new AffineTransformOp(scale, ColorSpaces.hints);
                    newImage = scalingOp.filter(newImage, null);
                    this.objectStoreStreamRef.saveStoredImage(name, this.addBackgroundToMask(newImage), false, createScaledVersion, type);
                } else {
                    this.objectStoreStreamRef.saveStoredImage(name, this.addBackgroundToMask(image), false, createScaledVersion, type);
                }
            }
        }
        if (image == null && !removed) {
            this.imagesProcessedFully = false;
        }
        if ((TR = this.currentGraphicsState.getTR()) != null && TR.endsWith("R")) {
            image = this.applyTR(image, TR);
        }
        if (decodeParams != null && this.current.hasObjectsBehind(this.currentGraphicsState.CTM) && (raw = decodeParams.get("DecodeParms")) instanceof Map && (params = (Map)raw) != null && (blend = params.get("Blend")) != null) {
            image = this.makeBlackandWhiteTransparent(image);
        }
        return image;
    }

    private BufferedImage overlayImage(BufferedImage image, byte[] maskData) {
        WritableRaster ras = image.getRaster();
        int width = (image = ColorSpaceConvertor.convertToARGB(image)).getWidth();
        int lineBytes = width;
        if ((lineBytes & 7) != 0) {
            lineBytes += 8;
        }
        lineBytes >>= 3;
        int bytes = 0;
        int[] nArray = new int[4];
        nArray[2] = 255;
        int[] transparentPixel = nArray;
        int[] nArray2 = new int[8];
        nArray2[1] = 2;
        nArray2[2] = 4;
        nArray2[3] = 8;
        nArray2[4] = 16;
        nArray2[5] = 32;
        nArray2[6] = 64;
        nArray2[7] = 128;
        int[] bit = nArray2;
        int y = 0;
        while (y < image.getHeight()) {
            int x = 0;
            while (x < width) {
                boolean isTransparent;
                int xOffset = x >> 3;
                byte b = maskData[bytes + xOffset];
                boolean bl = isTransparent = (b & bit[x & 7]) == 0;
                if (!isTransparent) {
                    image.getRaster().setPixel(x, y, transparentPixel);
                }
                ++x;
            }
            bytes += lineBytes;
            ++y;
        }
        return image;
    }

    private BufferedImage convertPixelsToTransparent(BufferedImage image, int colorComponents, int numberColors, int[][] matches) {
        WritableRaster ras = image.getRaster();
        image = ColorSpaceConvertor.convertToARGB(image);
        int[] nArray = new int[4];
        nArray[0] = 255;
        int[] transparentPixel = nArray;
        int y = 0;
        while (y < image.getHeight()) {
            int x = 0;
            while (x < image.getWidth()) {
                int[] values = new int[4];
                ras.getPixel(x, y, values);
                boolean noMatch = true;
                int currentCol = 0;
                while (currentCol < numberColors) {
                    noMatch = false;
                    int comp = 0;
                    while (comp < colorComponents) {
                        if (matches[currentCol][comp] != values[comp]) {
                            comp = colorComponents;
                            noMatch = true;
                        }
                        ++comp;
                    }
                    if (!noMatch) {
                        image.getRaster().setPixel(x, y, transparentPixel);
                        currentCol = numberColors;
                    }
                    ++currentCol;
                }
                ++x;
            }
            ++y;
        }
        return image;
    }

    private BufferedImage simulateOP(BufferedImage image) {
        WritableRaster ras = image.getRaster();
        image = ColorSpaceConvertor.convertToARGB(image);
        boolean hasNoTransparent = false;
        int[] nArray = new int[4];
        nArray[0] = 255;
        int[] transparentPixel = nArray;
        int y = 0;
        while (y < image.getHeight()) {
            int x = 0;
            while (x < image.getWidth()) {
                boolean transparent;
                int[] values = new int[4];
                ras.getPixel(x, y, values);
                boolean bl = transparent = values[1] == 0 && values[2] == 0 && values[3] == 0;
                if (transparent) {
                    image.getRaster().setPixel(x, y, transparentPixel);
                } else {
                    hasNoTransparent = true;
                }
                ++x;
            }
            ++y;
        }
        if (hasNoTransparent) {
            return image;
        }
        return null;
    }

    private BufferedImage makeBlackandWhiteTransparent(BufferedImage image) {
        WritableRaster ras = image.getRaster();
        BufferedImage newImage = new BufferedImage(image.getWidth(), image.getHeight(), 2);
        boolean validPixelsFound = false;
        int[] nArray = new int[4];
        nArray[0] = 255;
        int[] transparentPixel = nArray;
        int y = 0;
        while (y < image.getHeight()) {
            int x = 0;
            while (x < image.getWidth()) {
                boolean isBlack;
                int[] values = new int[3];
                ras.getPixel(x, y, values);
                boolean transparent = values[0] > 245 && values[1] > 245 && values[2] > 245;
                boolean bl = isBlack = values[0] < 10 && values[1] < 10 && values[2] < 10;
                if (transparent || isBlack) {
                    newImage.getRaster().setPixel(x, y, transparentPixel);
                } else {
                    validPixelsFound = true;
                    int[] newPixel = new int[]{255, values[0], values[1], values[2]};
                    newImage.getRaster().setPixel(x, y, newPixel);
                }
                ++x;
            }
            ++y;
        }
        if (validPixelsFound) {
            return newImage;
        }
        return null;
    }

    private BufferedImage applyTR(BufferedImage image, String TR) {
        PDFFunction[] functions;
        Object TRPDFFunctions = this.TRPDFfunctionsCache.get(TR);
        if (TRPDFFunctions != null) {
            functions = (PDFFunction[])TRPDFFunctions;
        } else {
            functions = new PDFFunction[4];
            int count = 0;
            StringTokenizer objValues = new StringTokenizer(TR, "R");
            while (objValues.hasMoreTokens()) {
                String ref = (String.valueOf(objValues.nextToken()) + 'R').trim();
                Map TRfunction = this.currentPdfFile.readObject(ref, false, null);
                if (TRfunction != null) {
                    int functionType = Integer.parseInt((String)TRfunction.get("FunctionType"));
                    float[] functionDomain = null;
                    float[] range = null;
                    String value = (String)TRfunction.get("Domain");
                    if (value != null) {
                        functionDomain = PdfArray.convertToFloatArray(value);
                    }
                    if ((value = (String)TRfunction.get("Range")) != null) {
                        range = PdfArray.convertToFloatArray(value);
                    }
                    byte[] stream = null;
                    stream = ref != null ? this.currentPdfFile.readStream(ref, true) : (byte[])TRfunction.get("DecodedStream");
                    functions[count] = FunctionFactory.getFunction(stream, TRfunction, functionDomain, range, functionType, this.currentPdfFile);
                }
                ++count;
            }
            this.TRPDFfunctionsCache.put(TR, functions);
        }
        WritableRaster ras = image.getRaster();
        int y = 0;
        while (y < image.getHeight()) {
            int x = 0;
            while (x < image.getWidth()) {
                int[] values = new int[4];
                ras.getPixel(x, y, values);
                int a = 0;
                while (a < 3) {
                    float[] raw = new float[]{(float)values[a] / 255.0f};
                    float[] processed = functions[a].compute(raw);
                    values[a] = (int)(255.0f * processed[0]);
                    ++a;
                }
                image.getRaster().setPixel(x, y, values);
                ++x;
            }
            ++y;
        }
        return image;
    }

    private BufferedImage applySmask(BufferedImage image, BufferedImage smask, String colorspace) {
        int[] gray = new int[1];
        int[] val = new int[4];
        int[] transparentPixel = new int[4];
        if (colorspace != null && colorspace.equals("/DeviceGray")) {
            smask = ColorSpaceConvertor.convertColorspace(smask, 10);
            val = gray;
        }
        WritableRaster ras = image.getRaster();
        WritableRaster mask = smask.getRaster();
        image = ColorSpaceConvertor.convertToARGB(image);
        int colorComponents = smask.getColorModel().getNumComponents();
        int y = 0;
        while (y < image.getHeight()) {
            int x = 0;
            while (x < image.getWidth()) {
                int[] values = new int[colorComponents];
                mask.getPixel(x, y, values);
                boolean noMatch = true;
                noMatch = false;
                if (colorComponents == 1) {
                    if (values[0] > 127) {
                        noMatch = true;
                    }
                } else {
                    int comp = 0;
                    while (comp < colorComponents) {
                        if (values[comp] != val[comp]) {
                            comp = colorComponents;
                            noMatch = true;
                        }
                        ++comp;
                    }
                }
                if (!noMatch) {
                    image.getRaster().setPixel(x, y, transparentPixel);
                }
                ++x;
            }
            ++y;
        }
        return image;
    }

    private void getMaskColor(byte[] maskCol) {
        int foreground = this.nonstrokeColorSpace.getColor().getRGB();
        maskCol[0] = (byte)(foreground >> 16 & 0xFF);
        maskCol[1] = (byte)(foreground >> 8 & 0xFF);
        maskCol[2] = (byte)(foreground & 0xFF);
    }

    private void applyDecodeArray(byte[] data, int d, String decodeArray, int type) {
        StringTokenizer components = new StringTokenizer(decodeArray, "[ ]");
        int count = components.countTokens();
        int i = 0;
        float[] array = new float[count];
        int maxValue = 0;
        while (components.hasMoreTokens()) {
            array[i] = Float.parseFloat(components.nextToken());
            if ((float)maxValue < array[i]) {
                maxValue = (int)array[i];
            }
            ++i;
        }
        boolean isIdentify = true;
        int compCount = array.length;
        int comp = 0;
        while (comp < compCount) {
            if (array[comp] != 0.0f || array[comp + 1] != 1.0f && array[comp + 1] != 255.0f) {
                isIdentify = false;
                comp = compCount;
            }
            comp += 2;
        }
        if (isIdentify) {
            return;
        }
        if (d == 1) {
            int byteCount = data.length;
            int ii = 0;
            while (ii < byteCount) {
                data[ii] = ~data[ii];
                ++ii;
            }
        } else if (d == 8 && maxValue > 1 && (type == 2 || type == 5 || type == 3)) {
            int j = 0;
            int ii = 0;
            while (ii < data.length) {
                int currentByte = data[ii] & 0xFF;
                if ((float)currentByte < array[j]) {
                    currentByte = (int)array[j];
                } else if ((float)currentByte > array[j + 1]) {
                    currentByte = (int)array[j + 1];
                }
                if ((j += 2) == array.length) {
                    j = 0;
                }
                data[ii] = (byte)currentByte;
                ++ii;
            }
        } else {
            maxValue = d << 1;
            int divisor = maxValue - 1;
            int ii = 0;
            while (ii < data.length) {
                byte currentByte = data[ii];
                int dd = 0;
                int newByte = 0;
                int min = 0;
                int max = 1;
                int bits = 7;
                while (bits > -1) {
                    int current = currentByte >> bits & 1;
                    if ((current = (int)(array[min] + (float)current * ((array[max] - array[min]) / (float)divisor))) > maxValue) {
                        current = maxValue;
                    }
                    if (current < 0) {
                        current = 0;
                    }
                    current = (current & 1) << bits;
                    newByte += current;
                    if ((dd += 2) == count) {
                        dd = 0;
                        min = 0;
                        max = 1;
                    } else {
                        min += 2;
                        max += 2;
                    }
                    --bits;
                }
                data[ii] = (byte)newByte;
                ++ii;
            }
        }
    }

    public void init(boolean isPageContent, boolean renderPage, int renderMode, int extractionMode, PdfPageData currentPageData, int pageNumber, DynamicVectorRenderer current, PdfObjectReader currentPdfFile, Map globalRes, Map resValue) throws PdfException {
        if (current != null) {
            this.current = current;
        }
        this.pageNum = pageNumber;
        this.pageData = currentPageData;
        this.isPageContent = isPageContent;
        this.currentPdfFile = currentPdfFile;
        if (this.customImageHandler != null && current != null) {
            current.setCustomImageHandler(this.customImageHandler);
        }
        this.pageH = this.pageData.getMediaBoxHeight(pageNumber);
        this.pageLines.setMaxWidth(this.pageData.getCropBoxWidth(pageNumber) - this.pageData.getCropBoxX(pageNumber), this.pageData.getCropBoxHeight(pageNumber) - this.pageData.getCropBoxY(pageNumber));
        this.textExtracted = (extractionMode & 1) == 1;
        this.renderPage = renderPage;
        this.renderText = renderPage && (renderMode & 1) == 1;
        this.renderImages = renderPage && (renderMode & 2) == 2;
        this.clippedImagesExtracted = (extractionMode & 0x80) == 128;
        this.extractRawCMYK = this.clippedImagesExtracted;
        this.rawImagesExtracted = (extractionMode & 2) == 2;
        this.clippedImagesExtracted = (extractionMode & 0x20) == 32;
        this.finalImagesExtracted = (extractionMode & 4) == 4;
        this.xFormMetadata = (extractionMode & 0x100) == 256;
        this.textColorExtracted = (extractionMode & 0x40) == 64;
        boolean bl = this.colorExtracted = (extractionMode & 0x200) == 512;
        if (this.legacyTextMode && this.textExtracted && PdfDecoder.currentHeightLookupData == null) {
            PdfDecoder.currentHeightLookupData = new PdfHeightTable();
        }
        if (this.textColorExtracted) {
            this.pdfData.enableTextColorDataExtraction();
        }
        this.createScaledVersion = this.finalImagesExtracted | this.renderImages;
        this.currentFontData = new PdfFont(currentPdfFile);
        this.strokeColorSpace = new DeviceRGBColorSpace();
        this.nonstrokeColorSpace = new DeviceRGBColorSpace();
        if (globalRes != null) {
            this.readResources(true, globalRes, true);
        }
        if (resValue != null) {
            this.readResources(true, resValue, true);
        }
    }

    private final BufferedImage makeImage(GenericColorSpace decodeColorData, int w, int h, int d, byte[] rawData) {
        int temp;
        byte[] processedData;
        boolean isRotated;
        LogWriter.writeMethod("{makeImage}", 0);
        int byteCount = rawData.length;
        byte[] data = new byte[byteCount];
        System.arraycopy(rawData, 0, data, 0, byteCount);
        ColorSpace cs = decodeColorData.getColorSpace();
        int ID = decodeColorData.getID();
        int comp = cs.getNumComponents();
        BufferedImage image = null;
        byte[] index = decodeColorData.getIndexedMap();
        this.optionsApplied = 0;
        boolean isInverted = (this.renderDirectly || this.useHiResImageForDisplay) && DynamicVectorRenderer.isInverted(this.currentGraphicsState.CTM);
        boolean bl = isRotated = (this.renderDirectly || this.useHiResImageForDisplay) && DynamicVectorRenderer.isRotated(this.currentGraphicsState.CTM);
        if (isRotated && isInverted) {
            if (this.currentGraphicsState.CTM[0][1] > 0.0f && this.currentGraphicsState.CTM[1][0] < 0.0f) {
                isInverted = false;
                isRotated = false;
            } else if (this.currentGraphicsState.CTM[0][1] < 0.0f && this.currentGraphicsState.CTM[1][0] > 0.0f) {
                isRotated = false;
                isInverted = true;
            }
        }
        if (isInverted && isRotated) {
            processedData = ImageOps.rotateImage(data, w, h, d, comp, index);
            if (processedData != null && (processedData = ImageOps.rotateImage(processedData, w = (temp = h), h = w, d, comp, index)) != null) {
                temp = h;
                h = w;
                w = temp;
            }
            if (processedData == null) {
                isInverted = false;
            } else {
                data = processedData;
                ++this.optionsApplied;
            }
        } else if (isInverted) {
            processedData = ImageOps.invertImage(data, w, h, d, comp, index);
            if (processedData == null) {
                isInverted = false;
            } else {
                data = processedData;
                ++this.optionsApplied;
            }
        }
        if (isRotated) {
            processedData = ImageOps.rotateImage(data, w, h, d, comp, index);
            if (processedData == null) {
                isRotated = false;
            } else {
                data = processedData;
                this.optionsApplied += 2;
                temp = h;
                h = w;
                w = temp;
            }
        }
        DataBufferByte db = new DataBufferByte(data, data.length);
        if (index != null) {
            if (comp == 4) {
                comp = 3;
            }
            index = decodeColorData.convertIndexToRGB(index);
            int size = decodeColorData.getIndexSize() + 1;
            if (d == 4 && size > 16) {
                size = 16;
            }
            image = this.convertIndexedToFlat(decodeColorData.getID(), d, w, h, data, index, size, false);
        } else if (d == 1) {
            WritableRaster raster = Raster.createPackedRaster(db, w, h, d, null);
            image = new BufferedImage(w, h, 12);
            image.setData(raster);
        } else if (ID == 10 | ID == 11) {
            LogWriter.writeLog("Converting Separation/DeviceN colorspace to sRGB ");
            image = decodeColorData.dataToRGB(data, w, h);
        } else if (ID == 6) {
            LogWriter.writeLog("Converting lab colorspace to sRGB ");
            image = decodeColorData.dataToRGB(data, w, h);
        } else if (comp == 4) {
            image = ID == 3 ? ColorSpaceConvertor.algorithmicConvertCMYKImageToRGB(data, w, h) : ColorSpaceConvertor.convertFromICCCMYK(w, h, data, cs);
        } else if (comp == 3) {
            if (w * h == data.length) {
                if (d == 8 && index != null) {
                    image = this.convertIndexedToFlat(decodeColorData.getID(), d, w, h, data, index, index.length, false);
                } else {
                    int[] bands = new int[1];
                    image = new BufferedImage(w, h, 10);
                    WritableRaster raster = Raster.createInterleavedRaster(db, w, h, w, 1, bands, null);
                    image.setData(raster);
                }
            } else {
                int[] nArray = new int[3];
                nArray[1] = 1;
                nArray[2] = 2;
                int[] bands = nArray;
                image = new BufferedImage(w, h, 1);
                WritableRaster raster = Raster.createInterleavedRaster(db, w, h, w * 3, 3, bands, null);
                image.setData(raster);
            }
        } else if (comp == 1 && (d == 8 || d == 4)) {
            if (d == 4) {
                int origSize = data.length;
                int newSize = w * h;
                byte[] newData = new byte[newSize];
                int ptr = 0;
                int currentLine = 0;
                boolean oddValues = (w & 1) == 1;
                int ii = 0;
                while (ii < origSize) {
                    byte rawByte = data[ii];
                    newData[ptr] = (byte)(rawByte & 0xF0);
                    ++ptr;
                    if (oddValues && (currentLine += 2) > w) {
                        currentLine = 0;
                    } else {
                        newData[ptr] = (byte)((rawByte & 0xF) << 4);
                        ++ptr;
                    }
                    if (ptr == newSize) {
                        ii = origSize;
                    }
                    ++ii;
                }
                db = new DataBufferByte(newData, newData.length);
            }
            image = new BufferedImage(w, h, 10);
            int[] bands = new int[1];
            WritableRaster raster = Raster.createInterleavedRaster(db, w, h, w, 1, bands, null);
            image.setData(raster);
        } else {
            LogWriter.writeLog("Image " + cs.getType() + " not currently supported with components " + comp);
        }
        return image;
    }

    private BufferedImage convertIndexedToFlat(int ID, int d, int w, int h, byte[] data, byte[] index, int size, boolean isARGB) {
        int[] bands;
        int[] nArray = new int[3];
        nArray[1] = 1;
        nArray[2] = 2;
        int[] bandsRGB = nArray;
        int[] nArray2 = new int[4];
        nArray2[1] = 1;
        nArray2[2] = 2;
        nArray2[3] = 3;
        int[] bandsARGB = nArray2;
        int components = 3;
        int pt = 0;
        if (isARGB) {
            bands = bandsARGB;
            components = 4;
        } else {
            bands = bandsRGB;
        }
        int length = w * h * components;
        byte[] newData = new byte[length];
        if (d == 8) {
            int ii = 0;
            while (ii < data.length - 1) {
                int id = (data[ii] & 0xFF) * 3;
                if (pt < length) {
                    newData[pt++] = index[id];
                    newData[pt++] = index[id + 1];
                    newData[pt++] = index[id + 2];
                    if (isARGB) {
                        newData[pt++] = id == 0 ? -1 : 0;
                    }
                    ++ii;
                    continue;
                }
                break;
            }
        } else if (d == 4) {
            int[] nArray3 = new int[2];
            nArray3[0] = 4;
            int[] shift = nArray3;
            int widthReached = 0;
            int ii = 0;
            while (ii < data.length) {
                int samples = 0;
                while (samples < 2) {
                    int id1 = (data[ii] >> shift[samples] & 0xF) * 3;
                    if (pt >= length) break;
                    newData[pt++] = index[id1];
                    newData[pt++] = index[id1 + 1];
                    newData[pt++] = index[id1 + 2];
                    if (isARGB) {
                        newData[pt++] = id1 == 0 ? (byte)0 : 0;
                    }
                    if (++widthReached == w) {
                        widthReached = 0;
                        samples = 8;
                    }
                    ++samples;
                }
                ++ii;
            }
        } else if (d == 1) {
            int widthReached = 0;
            int ii = 0;
            while (ii < data.length - 1) {
                int bits = 0;
                while (bits < 8) {
                    int id = (data[ii] >> 7 - bits & 1) * 3;
                    if (pt >= length) break;
                    newData[pt++] = index[id];
                    newData[pt++] = index[id + 1];
                    newData[pt++] = index[id + 2];
                    if (isARGB) {
                        newData[pt++] = id == 0 ? -1 : 0;
                    }
                    if (++widthReached == w) {
                        widthReached = 0;
                        bits = 8;
                    }
                    ++bits;
                }
                ++ii;
            }
        } else if (d == 2) {
            int ii = 0;
            while (ii < data.length - 1) {
                int bits = 0;
                while (bits < 8) {
                    int id = (data[ii] & 3 << bits >> bits) * 3;
                    if (isARGB) {
                        newData[pt++] = id == 0 ? -1 : 0;
                    }
                    if (pt >= length) break;
                    newData[pt++] = index[id];
                    newData[pt++] = index[id + 1];
                    newData[pt++] = index[id + 2];
                    bits += 2;
                }
                ++ii;
            }
        }
        DataBufferByte db = new DataBufferByte(newData, newData.length);
        BufferedImage image = isARGB ? new BufferedImage(w, h, 2) : new BufferedImage(w, h, 1);
        WritableRaster raster = Raster.createInterleavedRaster(db, w, h, w * components, components, bands, null);
        image.setData(raster);
        return image;
    }

    private final void processXObjects(Map rawValues, boolean isGlobal) {
        LogWriter.writeMethod("{processXObjects}", 0);
        String X_name2 = "";
        for (String X_name2 : rawValues.keySet()) {
            Object xObjectTester = rawValues.get(X_name2);
            if (xObjectTester instanceof Map) {
                if (isGlobal) {
                    this.currentXObjectValues.put(X_name2, xObjectTester);
                    continue;
                }
                this.localXObjects.put(X_name2, xObjectTester);
                continue;
            }
            if (isGlobal) {
                this.currentXObjectValues.put(X_name2, xObjectTester);
                continue;
            }
            this.localXObjects.put(X_name2, xObjectTester);
        }
    }

    private final void processPatterns(Map rawValues) {
        LogWriter.writeMethod("{processPatterns}", 0);
        String name2 = "";
        String object = "";
        for (String name2 : rawValues.keySet()) {
            object = (String)rawValues.get(name2);
            this.currentPatternValues.put(name2, object);
        }
    }

    private final void readFonts(boolean resetList, Map rawValues, boolean canBeSubstituted) throws PdfException {
        LogWriter.writeMethod("{readFonts}", 0);
        Map values = new HashMap();
        String font_id2 = "";
        if (resetList) {
            fontsInFile = "";
        }
        rawValues.remove("PageNumber");
        for (String font_id2 : rawValues.keySet()) {
            Object objectID = rawValues.get(font_id2);
            if (objectID instanceof String) {
                values = this.currentPdfFile != null ? this.currentPdfFile.readObject((String)rawValues.get(font_id2), false, null) : rawValues;
            } else if (objectID instanceof Map) {
                values = (Map)objectID;
            }
            PdfFont currentFontData = this.createFont(values, font_id2, canBeSubstituted);
            if (currentFontData == null) continue;
            this.fonts.put(font_id2, currentFontData);
        }
    }

    private PdfFont createFont(Map values, String font_id, boolean canBeSubstituted) throws PdfException {
        LogWriter.writeMethod("{createFont}", 0);
        String subtype = "";
        String type = (String)values.get("Type");
        String subFont = null;
        if (type == null) {
            return null;
        }
        if (type.equals("/Font")) {
            Object desc;
            subtype = (String)values.get("Subtype");
            Map descFontValues = null;
            boolean hasEmbeddedFont = false;
            if (FontMappings.fontSubstitutionTable != null) {
                Object raw = null;
                Object value = values.get("DescendantFonts");
                if (value != null) {
                    Map CIDvalues = this.readDescendantFontObject(value, values);
                    raw = CIDvalues.get("FontDescriptor");
                } else {
                    raw = values.get("FontDescriptor");
                }
                Map descValues = new HashMap();
                if (raw instanceof Map) {
                    descValues = raw;
                } else if (raw instanceof String) {
                    descValues = this.currentPdfFile.readObject(raw, false, null);
                }
                if (descValues != null) {
                    boolean bl = hasEmbeddedFont = descValues.get("FontFile") != null || descValues.get("FontFile2") != null || descValues.get("FontFile3") != null;
                }
            }
            if (FontMappings.fontSubstitutionTable != null && !hasEmbeddedFont && canBeSubstituted) {
                String testFont;
                String newSubtype;
                int pointer;
                String rawFont = (String)values.get("BaseFont");
                if (rawFont == null) {
                    rawFont = (String)values.get("Name");
                }
                if (rawFont == null) {
                    rawFont = font_id;
                } else if (rawFont.startsWith("/")) {
                    rawFont = rawFont.substring(1);
                }
                String baseFont = rawFont.toLowerCase();
                if (baseFont.startsWith("/")) {
                    baseFont = baseFont.substring(1);
                }
                if ((pointer = baseFont.indexOf(43)) == 6) {
                    baseFont = baseFont.substring(7);
                }
                if ((newSubtype = (String)FontMappings.fontSubstitutionTable.get(testFont = baseFont.toLowerCase())) == null) {
                    String nextFont;
                    HashMap<String, String> fontsMapped = new HashMap<String, String>();
                    while ((nextFont = (String)FontMappings.fontSubstitutionAliasTable.get(testFont)) != null) {
                        testFont = nextFont;
                        if (fontsMapped.containsKey(testFont)) {
                            StringBuffer errorMessage = new StringBuffer("[PDF] Circular font mapping for fonts");
                            Iterator i = fontsMapped.keySet().iterator();
                            while (i.hasNext()) {
                                errorMessage.append(' ');
                                errorMessage.append(i.next());
                            }
                            throw new PdfException(errorMessage.toString());
                        }
                        fontsMapped.put(nextFont, "x");
                    }
                    if (testFont != null) {
                        newSubtype = (String)FontMappings.fontSubstitutionTable.get(testFont);
                    }
                }
                if (newSubtype != null) {
                    subtype = newSubtype;
                    subFont = (String)FontMappings.fontSubstitutionLocation.get(testFont);
                } else if (PdfDecoder.enforceFontSubstitution) {
                    LogWriter.writeLog("baseFont=" + baseFont + " fonts added= " + FontMappings.fontSubstitutionTable);
                    throw new PdfFontException("No substitute Font found for " + baseFont);
                }
            }
            int fontType = 0;
            Object descFont = null;
            boolean isCID = false;
            if (subtype.equals("/Type1") || subtype.equals("/Type1C") || subtype.equals("/MMType1")) {
                fontType = 1;
            } else if (subtype.equals("/TrueType")) {
                fontType = 2;
            } else if (subtype.equals("/Type3")) {
                fontType = 3;
            } else if (subtype.equals("/Type0")) {
                isCID = true;
                Object value = values.get("DescendantFonts");
                if (value == null) {
                    LogWriter.writeLog("[PDF] No Descender font for CID font");
                } else {
                    descFontValues = this.readDescendantFontObject(value, values);
                    subtype = (String)descFontValues.get("Subtype");
                    fontType = subtype.equals("/CIDFontType0") ? 4 : 5;
                }
            } else {
                LogWriter.writeLog("Font type " + subtype + " not supported");
                this.currentFontData = new PdfFont(this.currentPdfFile);
            }
            if (fontType == 1 && (desc = values.get("FontDescriptor")) != null) {
                byte[] stream;
                Map descValues = null;
                descValues = desc instanceof Map ? (Map)desc : this.currentPdfFile.readObject((String)desc, false, null);
                Object rawFontStream = descValues.get("FontFile3");
                if (rawFontStream != null && (stream = rawFontStream instanceof String ? this.currentPdfFile.readStream((String)rawFontStream, true) : (byte[])((Map)rawFontStream).get("DecodedStream")).length > 3 && stream[0] == 79 && stream[1] == 84 && stream[2] == 84 && stream[3] == 79) {
                    fontType = 2;
                }
            }
            try {
                this.currentFontData = FontFactory.createFont(this.currentGraphicsState, subtype, fontType, this.currentPdfFile, subFont);
                if (PdfDecoder.defaultFont != null) {
                    this.currentFontData.setDefaultDisplayFont(PdfDecoder.defaultFont);
                }
                this.currentFontData.createFont(values, font_id, this.renderPage, descFontValues, this.objectStoreStreamRef);
            }
            catch (Exception e) {
                LogWriter.writeLog("[PDF] Problem " + e + " reading Font  type " + subtype + " in " + this.fileName);
                this.addPageFailureMessage("Problem " + e + " reading Font type " + subtype + " in " + this.fileName);
            }
            if (fontsInFile == null) {
                fontsInFile = "";
            }
            if (this.currentFontData.isFontSubstituted()) {
                fontsInFile = String.valueOf(font_id) + "  " + this.currentFontData.getFontName() + "  " + subtype.substring(1) + "  Substituted (" + subFont + ' ' + subtype + ")\n" + fontsInFile;
            } else if (this.currentFontData.isFontEmbedded) {
                this.hasEmbeddedFonts = true;
                fontsInFile = this.currentFontData.is1C() ? String.valueOf(font_id) + "  " + this.currentFontData.getFontName() + " Type1C  Embedded\n" + fontsInFile : String.valueOf(font_id) + "  " + this.currentFontData.getFontName() + "  " + subtype.substring(1) + "  Embedded\n" + fontsInFile;
            } else {
                fontsInFile = String.valueOf(font_id) + "  " + this.currentFontData.getFontName() + "  " + subtype.substring(1) + '\n' + fontsInFile;
            }
        } else {
            LogWriter.writeLog("Not a font object");
        }
        return this.currentFontData;
    }

    private Map readDescendantFontObject(Object value, Map values) {
        Map descFontValues;
        LogWriter.writeMethod("{readDescendantFontObject}" + value + ' ' + values, 0);
        if (value instanceof String) {
            String descFont = (String)values.get("DescendantFonts");
            if (descFont.startsWith("[")) {
                descFont = Strip.removeArrayDeleminators(descFont);
            }
            descFontValues = descFont.indexOf("<<") != -1 ? this.currentPdfFile.directValuesToMap(descFont, false) : this.currentPdfFile.readObject(descFont, false, null);
        } else {
            descFontValues = (Map)((Map)value).get("rawValue");
        }
        String direct = (String)descFontValues.get("rawValue");
        if (direct != null) {
            descFontValues = this.currentPdfFile.readObject(Strip.removeArrayDeleminators(direct), false, null);
        }
        return descFontValues;
    }

    public final void readResources(boolean resetList, Map resource_values, boolean isGlobal) throws PdfException {
        Map values;
        LogWriter.writeMethod("{readResources}", 0);
        Object obj = resource_values.get("ColorSpace");
        if (obj != null && (values = this.currentPdfFile.getSubDictionary(obj)) != null) {
            this.readColorSpaceSettings(values);
        }
        if ((obj = resource_values.get("Font")) != null && (values = this.currentPdfFile.getSubDictionary(obj)) != null) {
            this.readFonts(resetList, values, true);
        }
        if ((obj = resource_values.get("XObject")) != null && (values = this.currentPdfFile.getSubDictionary(obj)) != null) {
            this.processXObjects(values, isGlobal);
        }
        try {
            obj = resource_values.get("Shading");
            if (obj != null && (values = this.currentPdfFile.getSubDictionary(obj)) != null) {
                this.readShadingSettings(values);
            }
            if ((obj = resource_values.get("Pattern")) != null && (values = this.currentPdfFile.getSubDictionary(obj)) != null) {
                this.processPatterns(values);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if ((obj = resource_values.get("ExtGState")) != null) {
            try {
                values = this.currentPdfFile.getSubDictionary(obj);
                if (values != null) {
                    this.readGraphicsState(values);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public final void readResourcesForForm(Map resource_values) throws PdfException {
        LogWriter.writeMethod("{readResourcesForForm}", 0);
        Map values = (Map)resource_values.get("ColorSpace");
        if (values != null) {
            this.readColorSpaceSettings(values);
        }
        if ((values = (Map)resource_values.get("Font")) != null) {
            this.readFonts(false, values, false);
        }
        if ((values = (Map)resource_values.get("XObject")) != null) {
            this.processXObjects(values, true);
        }
        try {
            values = (Map)resource_values.get("Shading");
            if (values != null) {
                this.readShadingSettings(values);
            }
            if ((values = (Map)resource_values.get("Pattern")) != null) {
                this.processPatterns(values);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            values = this.currentPdfFile.getSubDictionary(resource_values.get("ExtGState"));
            if (values != null) {
                this.readGraphicsState(values);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private final void readColorSpaceSettings(Map rawValues) {
        LogWriter.writeMethod("{readColorSpaces}", 0);
        String col_id2 = "";
        String currentRawValue = "";
        for (String col_id2 : rawValues.keySet()) {
            currentRawValue = (String)rawValues.get(col_id2);
            this.rawColorspaceValues.put(col_id2, currentRawValue);
        }
    }

    private Object getObjectFromCache(Map objectCache, Map objectRefs, String id) {
        Object cachedObject = objectCache.get(id);
        if (cachedObject == null) {
            String currentRawValue = (String)objectRefs.get(id);
            cachedObject = currentRawValue != null && currentRawValue.endsWith(" R") ? this.currentPdfFile.readObject(currentRawValue, false, null) : currentRawValue;
            objectCache.put(currentRawValue, cachedObject);
        }
        return cachedObject;
    }

    private final void readShadingSettings(Map rawValues) {
        LogWriter.writeMethod("{readShadingSettings}", 0);
        String id2 = "";
        String currentRawValue = "";
        for (String id2 : rawValues.keySet()) {
            currentRawValue = rawValues.get(id2);
            Map rawShadingValue = currentRawValue instanceof String && currentRawValue.toString().endsWith(" R") ? this.currentPdfFile.readObject(currentRawValue, false, null) : (Map)((Object)currentRawValue);
            this.rawShadingValues.put(id2, rawShadingValue);
        }
    }

    public final T3Size decodePageContent(String contents, int minX, int minY, GraphicsState newGS) throws PdfException {
        byte[] b_data;
        LogWriter.writeMethod("{decodePageContent " + contents + '}', 0);
        this.requestExit = false;
        this.exited = false;
        this.imagesProcessedFully = true;
        if (!this.renderDirectly && this.statusBar != null) {
            this.statusBar.percentageDone = 0.0f;
        }
        this.currentGraphicsState = newGS != null ? newGS : new GraphicsState(minX, minY);
        if (this.renderPage) {
            if (this.current == null) {
                throw new PdfException("DynamicVectorRenderer not setup PdfStreamDecoder setStore(...) should be called");
            }
            if (this.renderDirectly) {
                this.current.renderClip(this.currentGraphicsState.getClippingShape(), null, this.defaultClip, this.g2);
            } else {
                this.current.drawClip(this.currentGraphicsState);
            }
        }
        if ((b_data = this.readPageIntoStream(contents)).length > 0) {
            this.decodeStreamIntoObjects(b_data);
        }
        if (this.requestExit) {
            this.current.flush();
            this.exited = true;
        }
        T3Size t3 = new T3Size();
        t3.x = this.T3maxWidth;
        t3.y = this.T3maxHeight;
        return t3;
    }

    public final void decodeStreamIntoObjects(byte[] characterStream) {
        int streamSize;
        LogWriter.writeMethod("{decodeStreamIntoObjects}", 0);
        boolean debug = false;
        int count = prefixes.length;
        int start = 0;
        int end = 0;
        int sLen = characterStream.length;
        if (!this.renderDirectly && this.statusBar != null) {
            this.statusBar.percentageDone = 0.0f;
            this.statusBar.resetStatus("stream");
        }
        if (this.requestExit) {
            this.exited = true;
            return;
        }
        int charCount = streamSize = characterStream.length;
        int initSize = 255;
        int dataPointer = 0;
        int startCommand = 0;
        if (characterStream.length == 0) {
            return;
        }
        int current = 0;
        int nextChar = characterStream[0];
        int commandID = -1;
        do {
            if (!this.renderDirectly && this.statusBar != null) {
                this.statusBar.percentageDone = 100 * dataPointer / streamSize;
            }
            if (this.requestExit) {
                this.exited = true;
                return;
            }
            current = nextChar;
            if (current == 13 || current == 10 || current == 32) {
                ++dataPointer;
                while (dataPointer != charCount && ((current = characterStream[dataPointer]) == 13 || current == 10 || current == 32)) {
                    ++dataPointer;
                }
            }
            if (dataPointer == charCount) break;
            boolean matchFound = false;
            int type = 0;
            type = current == 60 && characterStream[dataPointer + 1] == 60 ? 1 : (current == 91 ? 2 : (current >= 97 && current <= 122 ? 3 : (current >= 65 && current <= 90 ? 3 : (current == 39 || current == 34 ? 3 : (current == 32 ? 4 : 0)))));
            if (type == 3) {
                start = dataPointer;
                while (++dataPointer != sLen && (current = characterStream[dataPointer]) != 13 && current != 10 && current != 32 && current != 40 && current != 47 && current != 91) {
                }
                end = dataPointer - 1;
                byte endC = characterStream[end];
                if (endC == 47 || endC == 91) {
                    --end;
                }
                commandID = -1;
                if (end - start < 3) {
                    int key = 0;
                    int x = 0;
                    int i2 = end;
                    while (i2 > start - 1) {
                        key += characterStream[i2] << x;
                        x += 8;
                        --i2;
                    }
                    commandID = Cmd.getCommandID(key);
                }
                if (commandID == -1) {
                    this.opStart[this.currentOp] = start;
                    this.opEnd[this.currentOp] = end;
                    ++this.currentOp;
                    if (this.currentOp == 50) {
                        this.currentOp = 0;
                    }
                    ++this.operandCount;
                } else {
                    if (this.requestExit) {
                        this.exited = true;
                        return;
                    }
                    try {
                        startCommand = dataPointer = this.processToken(commandID, characterStream, startCommand, dataPointer);
                    }
                    catch (Exception e) {
                        LogWriter.writeLog("[PDF] " + e);
                        LogWriter.writeLog("Processing token >" + Cmd.getCommandAsString(commandID) + "<>" + this.fileName + " <" + this.pageNum);
                    }
                    catch (OutOfMemoryError ee) {
                        this.addPageFailureMessage("Memory error decoding token stream");
                        LogWriter.writeLog("[MEMORY] Memory error - trying to recover");
                    }
                    this.currentOp = 0;
                    this.operandCount = 0;
                }
            } else if (type != 4) {
                byte next;
                start = dataPointer;
                if (type == 1 || type == 2) {
                    boolean isBreak;
                    boolean inStream = false;
                    matchFound = true;
                    int last = 32;
                    do {
                        last = last == 92 && current == 92 ? 120 : current;
                        if (++dataPointer == sLen) break;
                        current = characterStream[dataPointer];
                        if (current == 13 || current == 10) {
                            current = 32;
                        }
                        isBreak = false;
                        if (current == 62 && last == 62 && type == 1) {
                            isBreak = true;
                        }
                        if (type != 2) continue;
                        if (current == 40 && last != 92) {
                            inStream = true;
                        } else if (current == 41 && last != 92) {
                            inStream = false;
                        }
                        if (inStream || current != 93 || last == 92) continue;
                        isBreak = true;
                    } while (!isBreak);
                    end = dataPointer;
                }
                if (!matchFound) {
                    int last = 32;
                    int startChars = 0;
                    while (startChars < count) {
                        if (current == prefixes[startChars]) {
                            matchFound = true;
                            start = dataPointer;
                            int numOfPrefixs = 0;
                            while (true) {
                                last = last == 92 && current == 92 ? 120 : current;
                                if (++dataPointer == sLen) break;
                                current = characterStream[dataPointer];
                                if (current == 13 | current == 10) {
                                    current = 32;
                                }
                                if (current == prefixes[startChars] && last != 92) {
                                    ++numOfPrefixs;
                                }
                                if (current != suffixes[startChars] || last == 92) continue;
                                if (numOfPrefixs == 0) break;
                                --numOfPrefixs;
                            }
                            startChars = count;
                        }
                        ++startChars;
                    }
                    end = dataPointer;
                }
                if (!matchFound) {
                    start = dataPointer;
                    while (++dataPointer != sLen && (current = characterStream[dataPointer]) != 13 && current != 10 && current != 32 && current != 40 && current != 47 && current != 91) {
                    }
                    end = dataPointer;
                }
                if (end >= characterStream.length || (next = characterStream[end]) == 47 || next == 91) {
                    // empty if block
                }
                this.opStart[this.currentOp] = start;
                this.opEnd[this.currentOp] = --end;
                ++this.currentOp;
                if (this.currentOp == 50) {
                    this.currentOp = 0;
                }
                ++this.operandCount;
            }
            if (dataPointer >= charCount || (nextChar = characterStream[dataPointer]) == 47 || nextChar == 40 || nextChar == 91 || ++dataPointer >= charCount) continue;
            nextChar = characterStream[dataPointer];
        } while (charCount > dataPointer);
    }

    private final void d1(float urX, float llX, float wX, float urY, float llY, float wY) {
        this.ignoreColors = true;
        this.T3maxWidth = (int)wX;
        this.T3maxWidth = wX == 0.0f ? (int)(llX - urX) : (int)wX;
        this.T3maxHeight = (int)wY;
        this.T3maxHeight = wY == 0.0f ? (int)(urY - llY) : (int)wY;
    }

    private final void d0(int w, int y) {
        this.ignoreColors = false;
        this.T3maxWidth = w;
        this.T3maxHeight = y;
    }

    private final void TD(boolean isLowerCase, float x, float y) {
        this.relativeMove(x, y);
        if (!isLowerCase) {
            float TL = -y;
            this.currentTextState.setLeading(TL);
        }
        this.multipleTJs = false;
    }

    private final byte[] readPageIntoStream(String contents) {
        LogWriter.writeMethod("{readPageIntoStream}", 0);
        byte[] binary_data = new byte[]{};
        byte[] decoded_stream_data = null;
        this.currentTextState = new TextState();
        if (contents != null && !contents.startsWith("[")) {
            Map objValues = this.currentPdfFile.readObject(contents, false, null);
            decoded_stream_data = this.currentPdfFile.readStream(objValues, contents, true, true, false, false, false);
            if (decoded_stream_data == null) {
                contents = (String)objValues.get("rawValue");
            } else {
                binary_data = decoded_stream_data;
            }
        }
        if (contents != null && decoded_stream_data == null) {
            contents = Strip.removeArrayDeleminators(contents).trim();
            StringTokenizer initial_values = new StringTokenizer(contents, "R");
            while (initial_values.hasMoreTokens()) {
                String current_page_value = initial_values.nextToken().trim();
                if (current_page_value.length() == 0) break;
                decoded_stream_data = this.currentPdfFile.readStream(String.valueOf(current_page_value) + " R", true);
                if (decoded_stream_data == null) continue;
                int current_length = binary_data.length + 1;
                int processed_length = decoded_stream_data.length;
                if (processed_length <= 0) continue;
                while (decoded_stream_data[processed_length - 1] == 0) {
                    --processed_length;
                }
                byte[] temp = new byte[current_length];
                System.arraycopy(binary_data, 0, temp, 0, current_length - 1);
                temp[current_length - 1] = 32;
                binary_data = new byte[current_length + processed_length];
                System.arraycopy(temp, 0, binary_data, 0, current_length);
                System.arraycopy(decoded_stream_data, 0, binary_data, current_length, processed_length);
            }
        }
        return binary_data;
    }

    private String generateOpAsString(int p, byte[] dataStream) {
        String s = "";
        int start = this.opStart[p];
        int end = this.opEnd[p];
        while (dataStream[end] == 32 || dataStream[end] == 13 || dataStream[end] == 10) {
            --end;
        }
        int count = end - start + 1;
        int spaces = 0;
        int ii = 0;
        while (ii < count) {
            if (!(ii <= 0 || dataStream[start + ii] != 32 && dataStream[start + ii] != 13 && dataStream[start + ii] != 10 || dataStream[start + ii - 1] != 32 && dataStream[start + ii - 1] != 13 && dataStream[start + ii - 1] != 10)) {
                ++spaces;
            }
            ++ii;
        }
        char[] charString = new char[count - spaces];
        int pos = 0;
        int ii2 = 0;
        while (ii2 < count) {
            if (ii2 <= 0 || dataStream[start + ii2] != 32 && dataStream[start + ii2] != 13 && dataStream[start + ii2] != 10 || dataStream[start + ii2 - 1] != 32 && dataStream[start + ii2 - 1] != 13 && dataStream[start + ii2 - 1] != 10) {
                charString[pos] = dataStream[start + ii2] == 10 || dataStream[start + ii2] == 13 ? 32 : (char)dataStream[start + ii2];
                ++pos;
            }
            ++ii2;
        }
        s = String.copyValueOf(charString);
        return s;
    }

    private final void BT() {
        this.currentTextState.resetTm();
        this.currentTextState.setTMAtLineStart();
        this.currentFont = this.currentTextState.getFontName();
        this.currentTextState.setCurrentFontSize(0);
        this.lastFontSize = -1;
        if (this.renderPage) {
            if (this.renderDirectly) {
                this.current.renderClip(this.currentGraphicsState.getClippingShape(), null, this.defaultClip, this.g2);
            } else {
                this.current.drawClip(this.currentGraphicsState);
                this.current.drawTR(2);
            }
        }
    }

    private final void restoreGraphicsState() {
        if (!this.isStackInitialised) {
            LogWriter.writeLog("No GraphicsState saved to retrieve");
        } else {
            this.currentGraphicsState = (GraphicsState)this.graphicsStateStack.pull();
            this.currentTextState = (TextState)this.textStateStack.pull();
            this.strokeColorSpace = (GenericColorSpace)this.strokeColorStateStack.pull();
            this.nonstrokeColorSpace = (GenericColorSpace)this.nonstrokeColorStateStack.pull();
            Object currentClip = this.clipStack.pull();
            if (currentClip == null) {
                this.currentGraphicsState.setClippingShape(null);
            } else {
                this.currentGraphicsState.setClippingShape((Area)currentClip);
            }
            if (this.renderPage) {
                if (this.renderDirectly) {
                    this.current.renderClip(this.currentGraphicsState.getClippingShape(), null, this.defaultClip, this.g2);
                } else {
                    this.current.drawClip(this.currentGraphicsState);
                    this.current.resetOnColorspaceChange();
                    this.current.drawFillColor(this.currentGraphicsState.getNonstrokeColor());
                    this.current.drawStrokeColor(this.currentGraphicsState.getStrokeColor());
                    this.current.setGraphicsState(2, this.currentGraphicsState.getNonStrokeAlpha());
                    this.current.setGraphicsState(1, this.currentGraphicsState.getStrokeAlpha());
                }
            }
        }
    }

    private final void L(float x, float y) {
        this.currentDrawShape.lineTo(x, y);
    }

    private final void F(boolean isStar) {
        if (isStar) {
            this.currentDrawShape.setEVENODDWindingRule();
        } else {
            this.currentDrawShape.setNONZEROWindingRule();
        }
        this.currentDrawShape.closeShape();
        Shape currentShape = this.currentDrawShape.generateShapeFromPath(this.currentGraphicsState.getClippingShape(), this.currentGraphicsState.CTM, this.isClip, this.pageLines, true, this.nonstrokeColorSpace.getColor(), this.currentGraphicsState.getLineWidth(), this.pageData.getCropBoxWidth(1));
        if (this.renderPage && currentShape != null) {
            this.currentGraphicsState.setStrokeColor(this.strokeColorSpace.getColor());
            this.currentGraphicsState.setNonstrokeColor(this.nonstrokeColorSpace.getColor());
            this.currentGraphicsState.setFillType(2);
            if (this.renderDirectly) {
                this.current.renderShape(this.currentGraphicsState.getFillType(), this.currentGraphicsState.getStrokeColor(), this.currentGraphicsState.getNonstrokeColor(), this.currentGraphicsState.getStroke(), currentShape, this.g2, this.currentGraphicsState.getStrokeAlpha(), this.currentGraphicsState.getNonStrokeAlpha());
            } else {
                this.current.drawShape(currentShape, this.currentGraphicsState);
            }
        }
        this.isClip = false;
        this.currentDrawShape.resetPath();
    }

    private final void TC(float tc) {
        this.currentTextState.setCharacterSpacing(tc);
    }

    private final void CM(float[][] Trm) {
        this.currentGraphicsState.CTM = Matrix.multiply(Trm, this.currentGraphicsState.CTM);
        this.multipleTJs = false;
    }

    protected final void relativeMove(float new_x, float new_y) {
        float[][] temp = new float[3][3];
        this.currentTextState.Tm = this.currentTextState.getTMAtLineStart();
        temp[0][0] = 1.0f;
        temp[0][1] = 0.0f;
        temp[0][2] = 0.0f;
        temp[1][0] = 0.0f;
        temp[1][1] = 1.0f;
        temp[1][2] = 0.0f;
        temp[2][0] = new_x;
        temp[2][1] = new_y;
        temp[2][2] = 1.0f;
        this.currentTextState.Tm = Matrix.multiply(temp, this.currentTextState.Tm);
        this.currentTextState.setTMAtLineStart();
        if (this.currentRotation != 0) {
            float[][] temp2 = new float[3][3];
            this.currentTextState.TmNoRotation = this.currentTextState.getTMAtLineStartNoRotation();
            temp2[0][0] = 1.0f;
            temp2[0][1] = 0.0f;
            temp2[0][2] = 0.0f;
            temp2[1][0] = 0.0f;
            temp2[1][1] = 1.0f;
            temp2[1][2] = 0.0f;
            temp2[2][0] = new_x;
            temp2[2][1] = new_y;
            temp2[2][2] = 1.0f;
            this.currentTextState.TmNoRotation = Matrix.multiply(temp2, this.currentTextState.TmNoRotation);
            float plusX = new_x;
            float plusY = new_y;
            if (plusX < 0.0f) {
                plusX = -new_x;
            }
            if (plusY < 0.0f) {
                plusY = -new_y;
            }
            if (plusX > this.currentTextState.Tm[0][0] && plusY > this.currentTextState.Tm[1][1]) {
                this.convertToUnrotated(this.currentTextState.Tm);
            }
            this.currentTextState.setTMAtLineStartNoRotation();
        }
        this.moveCommand = 2;
    }

    private void convertToUnrotated(float[][] trm) {
        boolean showCommands = false;
        if (trm[0][1] == 0.0f || trm[1][0] == 0.0f) {
            return;
        }
        this.rotationAsRadians = -Math.asin(trm[1][0] / trm[0][0]);
        float[][] rotation = new float[3][3];
        rotation[0][0] = (float)Math.cos(-this.rotationAsRadians);
        rotation[0][1] = (float)Math.sin(-this.rotationAsRadians);
        rotation[0][2] = 0.0f;
        rotation[1][0] = (float)(-Math.sin(-this.rotationAsRadians));
        rotation[1][1] = (float)Math.cos(-this.rotationAsRadians);
        rotation[1][2] = 0.0f;
        rotation[2][0] = 0.0f;
        rotation[2][1] = 0.0f;
        rotation[2][2] = 1.0f;
        int yy = 0;
        while (yy < 3) {
            int xx = 0;
            while (xx < 3) {
                if ((double)rotation[xx][yy] > 0.99 & rotation[xx][yy] < 1.0f) {
                    rotation[xx][yy] = 1.0f;
                }
                ++xx;
            }
            ++yy;
        }
        float[][] pt = new float[3][3];
        pt[0][0] = trm[2][0];
        pt[1][1] = trm[2][1];
        pt[2][2] = 1.0f;
        pt = Matrix.multiply(rotation, pt);
        float[][] unrotatedTrm = Matrix.multiply(rotation, trm);
        float diffY = pt[1][0];
        float newY = pt[1][1] - diffY;
        float convertedY = this.currentTextState.Tm[2][1];
        Integer key = new Integer((int)((double)newY + 0.5));
        Float mappedY = (Float)this.lines.get(key);
        if (mappedY == null) {
            mappedY = (Float)this.lines.get(new Integer((int)(newY + 1.0f)));
        }
        if (mappedY == null) {
            this.lines.put(key, new Float(this.currentTextState.Tm[2][1]));
        } else {
            convertedY = mappedY.floatValue();
        }
        unrotatedTrm[2][1] = convertedY;
        this.currentTextState.TmNoRotation = unrotatedTrm;
        if (this.unRotatedY == -1.0f) {
            this.unRotatedY = this.currentTextState.TmNoRotation[2][1];
            this.rotatedY = this.currentTextState.Tm[2][1];
        }
        this.lastHeight = this.currentTextState.TmNoRotation[1][1];
        this.currentTextState.TmNoRotation[0][1] = 0.0f;
        this.currentTextState.TmNoRotation[1][0] = 0.0f;
    }

    private final void S(boolean isLowerCase) {
        Shape currentShape;
        if (isLowerCase) {
            this.currentDrawShape.closeShape();
        }
        if ((currentShape = this.currentDrawShape.generateShapeFromPath(null, this.currentGraphicsState.CTM, this.isClip, this.pageLines, false, null, this.currentGraphicsState.getLineWidth(), this.pageData.getCropBoxWidth(1))) != null) {
            if (currentShape.getBounds().getWidth() <= 1.0) {
                currentShape = currentShape.getBounds2D();
            }
            if (this.renderPage) {
                this.currentGraphicsState.setStrokeColor(this.strokeColorSpace.getColor());
                this.currentGraphicsState.setNonstrokeColor(this.nonstrokeColorSpace.getColor());
                this.currentGraphicsState.setFillType(1);
                if (this.renderDirectly) {
                    this.current.renderShape(this.currentGraphicsState.getFillType(), this.currentGraphicsState.getStrokeColor(), this.currentGraphicsState.getNonstrokeColor(), this.currentGraphicsState.getStroke(), currentShape, this.g2, this.currentGraphicsState.getStrokeAlpha(), this.currentGraphicsState.getNonStrokeAlpha());
                } else {
                    this.current.drawShape(currentShape, this.currentGraphicsState);
                }
            }
        }
        this.isClip = false;
        this.currentDrawShape.resetPath();
    }

    private final void I() {
    }

    private final void D(byte[] characterStream) {
        String values = "";
        int items = this.operandCount;
        if (items == 1) {
            values = this.generateOpAsString(0, characterStream);
        } else {
            StringBuffer list = new StringBuffer();
            int i = items - 1;
            while (i > -1) {
                list.append(this.generateOpAsString(i, characterStream));
                list.append(' ');
                --i;
            }
            values = list.toString();
        }
        if (values.equals("[ ] 0 ") || values.equals("[]0") || values.equals("[] 0 ")) {
            this.currentGraphicsState.setDashPhase(0);
            this.currentGraphicsState.setDashArray(new float[0]);
        } else {
            int pointer = values.indexOf(93);
            String dash = values.substring(0, pointer);
            int phase = (int)Float.parseFloat(values.substring(pointer + 1, values.length()).trim());
            float[] dash_array = PdfArray.convertToFloatArray(dash);
            this.currentGraphicsState.setDashArray(dash_array);
            this.currentGraphicsState.setDashPhase(phase);
        }
    }

    private final void SCN(boolean isLowerCase, byte[] stream) {
        if (isLowerCase) {
            if (this.nonstrokeColorSpace.getID() == 9) {
                this.nonstrokeColorSpace.setColor(this.getValuesAsString(this.operandCount, stream), this.operandCount);
            } else {
                this.nonstrokeColorSpace.setColor(this.getValuesAsFloat(this.operandCount, stream), this.operandCount);
            }
        } else if (this.strokeColorSpace.getID() == 9) {
            this.strokeColorSpace.setColor(this.getValuesAsString(this.operandCount, stream), this.operandCount);
        } else {
            this.strokeColorSpace.setColor(this.getValuesAsFloat(this.operandCount, stream), this.operandCount);
        }
    }

    private final void B(boolean isStar, boolean isLowerCase) {
        if (isStar) {
            this.currentDrawShape.setEVENODDWindingRule();
        } else {
            this.currentDrawShape.setNONZEROWindingRule();
        }
        if (isLowerCase) {
            this.currentDrawShape.closeShape();
        }
        Shape currentShape = this.currentDrawShape.generateShapeFromPath(null, this.currentGraphicsState.CTM, this.isClip, this.pageLines, false, null, this.currentGraphicsState.getLineWidth(), this.pageData.getCropBoxWidth(1));
        if (this.renderPage && currentShape != null) {
            this.currentGraphicsState.setStrokeColor(this.strokeColorSpace.getColor());
            this.currentGraphicsState.setNonstrokeColor(this.nonstrokeColorSpace.getColor());
            this.currentGraphicsState.setFillType(3);
            if (this.renderDirectly) {
                this.current.renderShape(this.currentGraphicsState.getFillType(), this.currentGraphicsState.getStrokeColor(), this.currentGraphicsState.getNonstrokeColor(), this.currentGraphicsState.getStroke(), currentShape, this.g2, this.currentGraphicsState.getStrokeAlpha(), this.currentGraphicsState.getNonStrokeAlpha());
            } else {
                this.current.drawShape(currentShape, this.currentGraphicsState);
            }
        }
        this.isClip = false;
        this.currentDrawShape.resetPath();
    }

    private final void mm(int mitre_limit) {
        this.currentGraphicsState.setMitreLimit(mitre_limit);
    }

    private final void M(float x, float y) {
        this.currentDrawShape.moveTo(x, y);
    }

    private final void J(boolean isLowerCase, int value) {
        int style = 0;
        if (!isLowerCase) {
            if (value == 0) {
                style = 0;
            }
            if (value == 1) {
                style = 1;
            }
            if (value == 2) {
                style = 2;
            }
            this.currentGraphicsState.setJoinStyle(style);
        } else {
            if (value == 0) {
                style = 0;
            }
            if (value == 1) {
                style = 1;
            }
            if (value == 2) {
                style = 2;
            }
            this.currentGraphicsState.setCapStyle(style);
        }
    }

    private final void RG(boolean isLowerCase, byte[] stream) {
        this.current.resetOnColorspaceChange();
        boolean isStroke = !isLowerCase;
        float[] operand = this.getValuesAsFloat(this.operandCount, stream);
        if (isStroke) {
            if (this.strokeColorSpace.getID() != 2) {
                this.strokeColorSpace = new DeviceRGBColorSpace();
            }
            this.strokeColorSpace.setColor(operand, this.operandCount);
        } else {
            if (this.nonstrokeColorSpace.getID() != 2) {
                this.nonstrokeColorSpace = new DeviceRGBColorSpace();
            }
            this.nonstrokeColorSpace.setColor(operand, this.operandCount);
        }
    }

    private final void Y(float x3, float y3, float x, float y) {
        this.currentDrawShape.addBezierCurveY(x, y, x3, y3);
    }

    private final void TZ(float tz) {
        this.currentTextState.setHorizontalScaling(tz / 100.0f);
    }

    private final void RE(float x, float y, float w, float h) {
        this.currentDrawShape.appendRectangle(x, y, w, h);
    }

    private final void ET() {
        this.current.resetOnColorspaceChange();
    }

    private final void pushGraphicsState() {
        if (!this.isStackInitialised) {
            this.isStackInitialised = true;
            this.graphicsStateStack = new Vector_Object(10);
            this.textStateStack = new Vector_Object(10);
            this.strokeColorStateStack = new Vector_Object(20);
            this.nonstrokeColorStateStack = new Vector_Object(20);
            this.clipStack = new Vector_Object(20);
        }
        this.graphicsStateStack.push(this.currentGraphicsState.clone());
        Area currentClip = this.currentGraphicsState.getClippingShape();
        if (currentClip == null) {
            this.clipStack.push(null);
        } else {
            this.clipStack.push(currentClip.clone());
        }
        this.textStateStack.push(this.currentTextState.clone());
        this.nonstrokeColorStateStack.push(this.nonstrokeColorSpace.clone());
        this.strokeColorStateStack.push(this.strokeColorSpace.clone());
        this.current.resetOnColorspaceChange();
    }

    private final void MP() {
        if (this.markedContentExtracted) {
            this.contentHandler.MP();
        }
    }

    private final void DP(int startCommand, int dataPointer, byte[] raw, String op) {
        if (this.markedContentExtracted) {
            Map rootObject = new HashMap();
            if (op.endsWith(" R")) {
                rootObject = this.currentPdfFile.readObject(op, false, null);
            } else {
                this.currentPdfFile.readDictionary("", 0, rootObject, startCommand - 1, raw, false, new HashMap(), dataPointer);
            }
            this.contentHandler.DP(rootObject);
        }
    }

    private final void EMC() {
        if (this.markedContentExtracted) {
            this.contentHandler.EMC();
        }
    }

    private final void TJ(byte[] characterStream, int startCommand, int dataPointer) {
        StringBuffer current_value = this.processTextArray(characterStream, startCommand, dataPointer);
        if (current_value != null && this.isPageContent) {
            if (!this.markedContentExtracted) {
                if (this.textColorExtracted) {
                    this.currentColor = (this.currentGraphicsState.getTextRenderType() & 2) == 2 ? this.nonstrokeColorSpace.getXMLColorToken() : this.strokeColorSpace.getXMLColorToken();
                }
                if (this.textExtracted) {
                    this.pdfData.addRawTextElement(this.charSpacing * 1000.0f, this.currentTextState.writingMode, this.font_as_string, this.currentFontData.getCurrentFontSpaceWidth(), this.currentTextState, this.x1, this.y1, this.x2, this.y2, this.moveCommand, current_value, this.tokenNumber, this.textLength, this.currentColor, this.currentRotation);
                }
            } else {
                this.contentHandler.setText(current_value, this.x1, this.y1, this.x2, this.y2);
            }
        }
        this.moveCommand = -1;
    }

    private final void G(boolean isLowerCase, byte[] stream) {
        this.current.resetOnColorspaceChange();
        boolean isStroke = !isLowerCase;
        float[] operand = this.getValuesAsFloat(1, stream);
        if (isStroke) {
            if (this.strokeColorSpace.getID() != 1) {
                this.strokeColorSpace = new DeviceGrayColorSpace();
            }
            this.strokeColorSpace.setColor(operand, this.operandCount);
        } else {
            if (this.nonstrokeColorSpace.getID() != 1) {
                this.nonstrokeColorSpace = new DeviceGrayColorSpace();
            }
            this.nonstrokeColorSpace.setColor(operand, this.operandCount);
        }
    }

    private void TL(float tl) {
        this.currentTextState.setLeading(tl);
    }

    public void readGraphicsState(Map rawValues) {
        for (String id : rawValues.keySet()) {
            Object object = rawValues.get(id);
            Map values = object instanceof String ? this.currentPdfFile.readObject((String)object, false, null) : (Map)object;
            this.gs_state.put(String.valueOf('/') + id, values);
        }
    }

    private void BDC(int startCommand, int dataPointer, byte[] raw, String op) {
        if (this.markedContentExtracted) {
            Map rootObject = new HashMap();
            if (op.endsWith(" R")) {
                rootObject = this.currentPdfFile.readObject(op, false, null);
            } else {
                this.currentPdfFile.readDictionary("", 0, rootObject, startCommand - 1, raw, false, new HashMap(), dataPointer);
            }
            this.contentHandler.BDC(rootObject);
        }
    }

    private void BMC(String op) {
        if (this.markedContentExtracted) {
            this.contentHandler.BMC(op);
        }
    }

    final float parseFloat(int id, byte[] stream) {
        int charCount;
        float f = 0.0f;
        float dec = 0.0f;
        float num = 0.0f;
        int start = this.opStart[id];
        int floatptr = charCount = this.opEnd[id] - start;
        int intStart = 0;
        boolean isMinus = false;
        int j = charCount - 1;
        while (j > -1) {
            if (stream[start + j] == 46) {
                floatptr = j;
                break;
            }
            --j;
        }
        int intChars = floatptr;
        if (stream[start] == 43) {
            --intChars;
            ++intStart;
        } else if (stream[start] == 45) {
            ++intStart;
            isMinus = true;
        }
        int intNumbers = intChars - intStart;
        int decNumbers = charCount - floatptr;
        if (intNumbers > 3) {
            isMinus = false;
            f = Float.parseFloat(this.generateOpAsString(id, stream));
        } else {
            int c;
            float units = 0.0f;
            float tens = 0.0f;
            float hundreds = 0.0f;
            float tenths = 0.0f;
            float hundredths = 0.0f;
            float thousands = 0.0f;
            float tenthousands = 0.0f;
            float hunthousands = 0.0f;
            if (intNumbers > 2) {
                c = stream[start + intStart] - 48;
                switch (c) {
                    case 1: {
                        hundreds = 100.0f;
                        break;
                    }
                    case 2: {
                        hundreds = 200.0f;
                        break;
                    }
                    case 3: {
                        hundreds = 300.0f;
                        break;
                    }
                    case 4: {
                        hundreds = 400.0f;
                        break;
                    }
                    case 5: {
                        hundreds = 500.0f;
                        break;
                    }
                    case 6: {
                        hundreds = 600.0f;
                        break;
                    }
                    case 7: {
                        hundreds = 700.0f;
                        break;
                    }
                    case 8: {
                        hundreds = 800.0f;
                        break;
                    }
                    case 9: {
                        hundreds = 900.0f;
                    }
                }
                ++intStart;
            }
            if (intNumbers > 1) {
                c = stream[start + intStart] - 48;
                switch (c) {
                    case 1: {
                        tens = 10.0f;
                        break;
                    }
                    case 2: {
                        tens = 20.0f;
                        break;
                    }
                    case 3: {
                        tens = 30.0f;
                        break;
                    }
                    case 4: {
                        tens = 40.0f;
                        break;
                    }
                    case 5: {
                        tens = 50.0f;
                        break;
                    }
                    case 6: {
                        tens = 60.0f;
                        break;
                    }
                    case 7: {
                        tens = 70.0f;
                        break;
                    }
                    case 8: {
                        tens = 80.0f;
                        break;
                    }
                    case 9: {
                        tens = 90.0f;
                    }
                }
                ++intStart;
            }
            if (intNumbers > 0) {
                c = stream[start + intStart] - 48;
                switch (c) {
                    case 1: {
                        units = 1.0f;
                        break;
                    }
                    case 2: {
                        units = 2.0f;
                        break;
                    }
                    case 3: {
                        units = 3.0f;
                        break;
                    }
                    case 4: {
                        units = 4.0f;
                        break;
                    }
                    case 5: {
                        units = 5.0f;
                        break;
                    }
                    case 6: {
                        units = 6.0f;
                        break;
                    }
                    case 7: {
                        units = 7.0f;
                        break;
                    }
                    case 8: {
                        units = 8.0f;
                        break;
                    }
                    case 9: {
                        units = 9.0f;
                    }
                }
            }
            if (decNumbers > 1) {
                c = stream[start + ++floatptr] - 48;
                switch (c) {
                    case 1: {
                        tenths = 0.1f;
                        break;
                    }
                    case 2: {
                        tenths = 0.2f;
                        break;
                    }
                    case 3: {
                        tenths = 0.3f;
                        break;
                    }
                    case 4: {
                        tenths = 0.4f;
                        break;
                    }
                    case 5: {
                        tenths = 0.5f;
                        break;
                    }
                    case 6: {
                        tenths = 0.6f;
                        break;
                    }
                    case 7: {
                        tenths = 0.7f;
                        break;
                    }
                    case 8: {
                        tenths = 0.8f;
                        break;
                    }
                    case 9: {
                        tenths = 0.9f;
                    }
                }
            }
            if (decNumbers > 2) {
                c = stream[start + ++floatptr] - 48;
                switch (c) {
                    case 1: {
                        hundredths = 0.01f;
                        break;
                    }
                    case 2: {
                        hundredths = 0.02f;
                        break;
                    }
                    case 3: {
                        hundredths = 0.03f;
                        break;
                    }
                    case 4: {
                        hundredths = 0.04f;
                        break;
                    }
                    case 5: {
                        hundredths = 0.05f;
                        break;
                    }
                    case 6: {
                        hundredths = 0.06f;
                        break;
                    }
                    case 7: {
                        hundredths = 0.07f;
                        break;
                    }
                    case 8: {
                        hundredths = 0.08f;
                        break;
                    }
                    case 9: {
                        hundredths = 0.09f;
                    }
                }
            }
            if (decNumbers > 3) {
                c = stream[start + ++floatptr] - 48;
                switch (c) {
                    case 1: {
                        thousands = 0.001f;
                        break;
                    }
                    case 2: {
                        thousands = 0.002f;
                        break;
                    }
                    case 3: {
                        thousands = 0.003f;
                        break;
                    }
                    case 4: {
                        thousands = 0.004f;
                        break;
                    }
                    case 5: {
                        thousands = 0.005f;
                        break;
                    }
                    case 6: {
                        thousands = 0.006f;
                        break;
                    }
                    case 7: {
                        thousands = 0.007f;
                        break;
                    }
                    case 8: {
                        thousands = 0.008f;
                        break;
                    }
                    case 9: {
                        thousands = 0.009f;
                    }
                }
            }
            if (decNumbers > 4) {
                c = stream[start + ++floatptr] - 48;
                switch (c) {
                    case 1: {
                        tenthousands = 1.0E-4f;
                        break;
                    }
                    case 2: {
                        tenthousands = 2.0E-4f;
                        break;
                    }
                    case 3: {
                        tenthousands = 3.0E-4f;
                        break;
                    }
                    case 4: {
                        tenthousands = 4.0E-4f;
                        break;
                    }
                    case 5: {
                        tenthousands = 5.0E-4f;
                        break;
                    }
                    case 6: {
                        tenthousands = 6.0E-4f;
                        break;
                    }
                    case 7: {
                        tenthousands = 7.0E-4f;
                        break;
                    }
                    case 8: {
                        tenthousands = 8.0E-4f;
                        break;
                    }
                    case 9: {
                        tenthousands = 9.0E-4f;
                    }
                }
            }
            if (decNumbers > 5) {
                c = stream[start + ++floatptr] - 48;
                switch (c) {
                    case 1: {
                        hunthousands = 1.0E-5f;
                        break;
                    }
                    case 2: {
                        hunthousands = 2.0E-5f;
                        break;
                    }
                    case 3: {
                        hunthousands = 3.0E-5f;
                        break;
                    }
                    case 4: {
                        hunthousands = 4.0E-5f;
                        break;
                    }
                    case 5: {
                        hunthousands = 5.0E-5f;
                        break;
                    }
                    case 6: {
                        hunthousands = 6.0E-5f;
                        break;
                    }
                    case 7: {
                        hunthousands = 7.0E-5f;
                        break;
                    }
                    case 8: {
                        hunthousands = 8.0E-5f;
                        break;
                    }
                    case 9: {
                        hunthousands = 9.0E-5f;
                    }
                }
            }
            dec = tenths + hundredths + thousands + tenthousands + hunthousands;
            num = hundreds + tens + units;
            f = num + dec;
        }
        if (isMinus) {
            return -f;
        }
        return f;
    }

    private final void TM() {
        if (includeRotation) {
            float[][] trm = this.currentTextState.Tm;
            if (trm[1][0] == 0.0f && trm[0][1] == 0.0f) {
                this.currentRotation = 0;
                this.unRotatedY = -1.0f;
            } else if (trm[0][1] == 0.0f || trm[1][0] == 0.0f) {
                this.currentRotation = 0;
                this.unRotatedY = -1.0f;
            } else {
                this.rotationAsRadians = -Math.asin(trm[1][0] / trm[0][0]);
                int newRotation = (int)(this.rotationAsRadians * 57.29577951308232);
                if (newRotation == 0) {
                    this.currentRotation = 0;
                    this.unRotatedY = -1.0f;
                } else {
                    this.currentRotation = newRotation;
                    this.convertToUnrotated(trm);
                }
            }
        }
        this.currentTextState.setTMAtLineStart();
        this.currentTextState.setTMAtLineStartNoRotation();
        this.multipleTJs = false;
        this.moveCommand = 1;
    }

    private final void H() {
        this.currentDrawShape.closeShape();
    }

    private final void TR(int value) {
        if (value == 0) {
            value = 2;
        } else if (value == 1) {
            value = 1;
        } else if (value == 2) {
            value = 3;
        } else if (value == 3) {
            value = 4;
            if (showInvisibleText) {
                value = 2;
            }
        } else if (value == 7) {
            value = 7;
        }
        this.currentGraphicsState.setTextRenderType(value);
        if (this.renderPage && !this.renderDirectly) {
            this.current.drawTR(value);
        }
    }

    private final void Q(boolean isLowerCase) {
        if (isLowerCase) {
            this.pushGraphicsState();
        } else {
            this.restoreGraphicsState();
            String fontID = this.currentTextState.getFontID();
            Object restoredFont = this.fonts.get(fontID);
            if (restoredFont != null) {
                this.currentFontData = (PdfFont)restoredFont;
            }
        }
    }

    private final int ID(byte[] characterStream, int dataPointer) throws Exception {
        this.isMask = false;
        BufferedImage image = null;
        boolean hasCustomHandler = this.customImageHandler != null;
        String filter_value = null;
        boolean inline_imageMask = false;
        String inline_decodeArray = "";
        String inline_colorspace = "/DeviceRGB";
        int inline_start_pointer = dataPointer + 1;
        int inline_image_width = 0;
        int inline_image_height = 0;
        int inline_image_depth = 0;
        int i = inline_start_pointer;
        int streamLength = characterStream.length;
        while ((streamLength - i <= 3 || characterStream[i] != 32 && characterStream[i] != 10 && characterStream[i] != 13 || characterStream[i + 1] != 69 || characterStream[i + 2] != 73 || characterStream[i + 3] != 32 && characterStream[i + 3] != 10 && characterStream[i + 3] != 13) && ++i != streamLength) {
        }
        if (this.renderImages | this.finalImagesExtracted | this.clippedImagesExtracted | this.rawImagesExtracted) {
            ArrayList<String> processed_values = new ArrayList<String>();
            if (this.operandCount > 0) {
                String[] orderedOps = new String[50];
                int[] orderedOpStart = new int[50];
                int[] orderedOpEnd = new int[50];
                int opid = 0;
                int jj = this.currentOp - 1;
                while (jj > -1) {
                    orderedOpStart[opid] = this.opStart[jj];
                    orderedOpEnd[opid] = this.opEnd[jj];
                    if (opid == this.operandCount) {
                        jj = -1;
                    }
                    ++opid;
                    --jj;
                }
                if (opid == this.operandCount) {
                    --this.currentOp;
                    jj = 50 - 1;
                    while (jj > this.currentOp) {
                        orderedOpStart[opid] = this.opStart[jj];
                        orderedOpEnd[opid] = this.opEnd[jj];
                        if (opid == this.operandCount) {
                            jj = this.currentOp;
                        }
                        ++opid;
                        --jj;
                    }
                    ++this.currentOp;
                }
                this.opStart = orderedOpStart;
                this.opEnd = orderedOpEnd;
            }
            int items = this.operandCount;
            StringBuffer raw_values = new StringBuffer();
            int ii = 0;
            while (ii < items) {
                int i1 = this.generateOpAsString(ii, characterStream).indexOf("<<");
                if (i1 > 0) {
                    raw_values.append(this.generateOpAsString(ii, characterStream).substring(0, i1));
                    raw_values.append(' ');
                    raw_values.append(this.generateOpAsString(ii, characterStream).substring(i1));
                } else {
                    i1 = this.generateOpAsString(ii, characterStream).indexOf(">>");
                    if (i1 != -1 && this.generateOpAsString(ii, characterStream).indexOf(" >>") == -1) {
                        raw_values.append(this.generateOpAsString(ii, characterStream).substring(0, i1));
                        raw_values.append(' ');
                        raw_values.append(this.generateOpAsString(ii, characterStream).substring(i1));
                    } else {
                        raw_values.append(this.generateOpAsString(ii, characterStream));
                    }
                }
                raw_values.append(' ');
                ++ii;
            }
            StringTokenizer values = new StringTokenizer(raw_values.toString().trim(), "[]/ ", true);
            while (values.hasMoreTokens()) {
                String token = values.nextToken();
                if (token.equals("/")) {
                    processed_values.add(String.valueOf(token) + values.nextToken());
                    continue;
                }
                if (token.equals("[")) {
                    while (token.indexOf(93) == -1) {
                        String next = values.nextToken();
                        token = next.equals("/") ? String.valueOf(token) + ' ' + next : String.valueOf(token) + next;
                    }
                    processed_values.add(token);
                    continue;
                }
                if (token.equals(" ")) continue;
                processed_values.add(token);
            }
            ArrayList<String> operand = processed_values;
            Hashtable<String, Object> objData = new Hashtable<String, Object>();
            items = operand.size();
            int ii2 = 0;
            while (ii2 < items) {
                String currentValue = (String)operand.get(ii2);
                if (currentValue.equals("/W") || currentValue.equals("/Width")) {
                    inline_image_width = Integer.parseInt((String)operand.get(++ii2));
                    if (hasCustomHandler) {
                        objData.put("Width", operand.get(ii2));
                    }
                } else if (currentValue.equals("/IM")) {
                    if (((String)operand.get(++ii2)).indexOf("true") != -1) {
                        inline_imageMask = true;
                        this.isMask = true;
                    }
                    if (hasCustomHandler) {
                        objData.put("ImageMask", operand.get(ii2));
                    }
                } else if (currentValue.equals("/D") || currentValue.equals("/Decode")) {
                    inline_decodeArray = (String)operand.get(++ii2);
                    if (hasCustomHandler) {
                        objData.put("Decode", operand.get(ii2));
                    }
                } else if (currentValue.equals("/H") || currentValue.equals("/Height")) {
                    inline_image_height = Integer.parseInt((String)operand.get(++ii2));
                    if (hasCustomHandler) {
                        objData.put("Height", operand.get(ii2));
                    }
                } else if (currentValue.equals("/BPC") || currentValue.equals("/BitsPerComponent")) {
                    inline_image_depth = Integer.parseInt((String)operand.get(++ii2));
                    if (hasCustomHandler) {
                        objData.put("BitsPerComponent", operand.get(ii2));
                    }
                } else if (currentValue.equals("/CS") || currentValue.equals("/ColorSpace")) {
                    if ((inline_colorspace = (String)operand.get(++ii2)).startsWith("[")) {
                        while (!inline_colorspace.endsWith("]")) {
                            inline_colorspace = String.valueOf(inline_colorspace) + operand.get(ii2);
                            ++ii2;
                        }
                        inline_colorspace = Strip.removeArrayDeleminators(inline_colorspace);
                    }
                    if (hasCustomHandler) {
                        objData.put("ColorSpace", inline_colorspace);
                    }
                } else if (currentValue.equals("/F") || currentValue.equals("/Filter")) {
                    filter_value = "";
                    if ((filter_value = (String)operand.get(++ii2)).indexOf(91) != -1) {
                        while (filter_value.indexOf(93) == -1) {
                            String filter_name = (String)operand.get(++ii2);
                            filter_value = String.valueOf(filter_value) + ' ' + filter_name;
                        }
                        filter_value = Strip.removeArrayDeleminators(filter_value);
                    }
                    if (hasCustomHandler) {
                        objData.put("Filter", filter_value);
                    }
                } else if (currentValue.equals("/DP") || currentValue.equals("/DecodeParms")) {
                    String params = (String)operand.get(++ii2);
                    Hashtable objValues = new Hashtable();
                    if (params.startsWith("[")) {
                        while (params.indexOf(93) == -1) {
                            params = String.valueOf(params) + ' ' + operand.get(++ii2);
                        }
                        objData.put("DecodeParms", params);
                    }
                    if (params.startsWith("<<")) {
                        String key;
                        ++ii2;
                        while (!(key = (String)operand.get(ii2)).equals(">>")) {
                            if (key.startsWith("/")) {
                                objValues.put(key.substring(1), operand.get(ii2 + 1));
                                ++ii2;
                            }
                            ++ii2;
                        }
                        objData.put("DecodeParms", objValues);
                    }
                }
                ++ii2;
            }
            String inline_filter_value = filter_value;
            String image_name = String.valueOf(this.fileName) + "-IN-" + this.tokenNumber;
            byte[] image_data = new byte[i - inline_start_pointer];
            System.arraycopy(characterStream, inline_start_pointer, image_data, 0, i - inline_start_pointer);
            if (this.customImageHandler != null) {
                objData.put("Stream", image_data);
                image = this.customImageHandler.processImageData(objData, this.currentGraphicsState);
            }
            if (inline_filter_value != null && !inline_filter_value.startsWith("/JPXDecode") && !inline_filter_value.startsWith("/DCT")) {
                image_data = this.currentPdfFile.decodeFilters(image_data, inline_filter_value, objData, inline_image_width, inline_image_height, false, null);
            }
            GenericColorSpace decodeColorData = new GenericColorSpace();
            if (inline_colorspace != null) {
                Object colorspaceValues;
                String colorspaceObject = null;
                if (inline_colorspace.startsWith("/")) {
                    colorspaceObject = inline_colorspace.substring(1);
                }
                decodeColorData = (colorspaceValues = this.getObjectFromCache(this.colorspaceObjects, this.rawColorspaceValues, colorspaceObject)) == null ? ColorspaceDecoder.getColorSpaceInstance(this.isPrinting, this.currentGraphicsState.CTM, inline_colorspace, null, this.currentPdfFile) : (colorspaceValues instanceof String ? ColorspaceDecoder.getColorSpaceInstance(this.isPrinting, this.currentGraphicsState.CTM, (String)colorspaceValues, null, this.currentPdfFile) : ColorspaceDecoder.getColorSpaceInstance(this.isPrinting, this.currentGraphicsState.CTM, null, (Map)colorspaceValues, this.currentPdfFile));
            }
            if (image_data != null) {
                boolean alreadyCached = !this.isType3Font && this.useHiResImageForDisplay && this.current.isImageCached(this.pageNum);
                this.optionsApplied = 0;
                if (!alreadyCached && (this.customImageHandler == null || image == null && !this.customImageHandler.alwaysIgnoreGenericHandler())) {
                    image = this.processImage(decodeColorData, inline_colorspace, image_data, image_name, inline_image_width, inline_image_height, inline_image_depth, inline_filter_value, inline_decodeArray, inline_imageMask, this.createScaledVersion, objData);
                }
                this.currentImage = image_name;
                if (image != null || alreadyCached) {
                    if (this.renderDirectly | this.useHiResImageForDisplay) {
                        this.currentGraphicsState.x = this.currentGraphicsState.CTM[2][0];
                        this.currentGraphicsState.y = this.currentGraphicsState.CTM[2][1];
                        if (this.renderDirectly) {
                            this.current.renderImage(null, image, this.currentGraphicsState.getNonStrokeAlpha(), this.currentGraphicsState, this.g2, this.currentGraphicsState.x, this.currentGraphicsState.y, this.optionsApplied);
                        } else {
                            this.current.drawImage(this.pageNum, image, this.currentGraphicsState, alreadyCached, image_name, this.optionsApplied);
                        }
                    } else if (this.clippedImagesExtracted) {
                        this.generateTransformedImage(image, image_name);
                    } else {
                        this.generateTransformedImageSingle(image, image_name);
                    }
                    if (image != null) {
                        image.flush();
                    }
                }
            }
        }
        dataPointer = i + 3;
        return dataPointer;
    }

    private final void TS(float ts) {
        this.currentTextState.setTextRise(ts);
    }

    private final void double_quote(byte[] characterStream, int startCommand, int dataPointer, float tc, float tw) {
        this.currentTextState.setCharacterSpacing(tc);
        this.currentTextState.setWordSpacing(tw);
        this.TSTAR();
        this.TJ(characterStream, startCommand, dataPointer);
    }

    private void TSTAR() {
        this.relativeMove(0.0f, -this.currentTextState.getLeading());
        this.moveCommand = 0;
        this.multipleTJs = false;
    }

    private final void K(boolean isLowerCase, byte[] stream) {
        boolean isStroke;
        this.current.resetOnColorspaceChange();
        boolean bl = isStroke = !isLowerCase;
        if (this.operandCount > 3) {
            float[] operand = this.getValuesAsFloat(this.operandCount, stream);
            if (isStroke) {
                if (this.strokeColorSpace.getID() != 3) {
                    this.strokeColorSpace = new DeviceCMYKColorSpace();
                }
                this.strokeColorSpace.setColor(operand, this.operandCount);
            } else {
                if (this.nonstrokeColorSpace.getID() != 3) {
                    this.nonstrokeColorSpace = new DeviceCMYKColorSpace();
                }
                this.nonstrokeColorSpace.setColor(operand, this.operandCount);
            }
        }
    }

    private String[] getValuesAsString(int count, byte[] dataStream) {
        String[] op = new String[count];
        int i = 0;
        while (i < count) {
            op[i] = this.generateOpAsString(i, dataStream);
            ++i;
        }
        return op;
    }

    private float[] getValuesAsFloat(int count, byte[] dataStream) {
        float[] op = new float[count];
        int i = 0;
        while (i < count) {
            op[i] = this.parseFloat(i, dataStream);
            ++i;
        }
        return op;
    }

    private final void W(boolean isStar) {
        if (isStar) {
            this.currentDrawShape.setEVENODDWindingRule();
        } else {
            this.currentDrawShape.setNONZEROWindingRule();
        }
        this.isClip = true;
    }

    private final void width(float w) {
        this.currentGraphicsState.setLineWidth(w);
    }

    private final void one_quote(byte[] characterStream, int startCommand, int dataPointer) {
        this.TSTAR();
        this.TJ(characterStream, startCommand, dataPointer);
    }

    private void N() {
        if (this.isClip) {
            this.currentDrawShape.closeShape();
            this.currentGraphicsState.updateClip(new Area(this.currentDrawShape.generateShapeFromPath(null, this.currentGraphicsState.CTM, false, null, false, null, 0.0f, 0.0f)));
            this.currentGraphicsState.checkWholePageClip(this.pageData.getMediaBoxHeight(this.pageNum) + this.pageData.getMediaBoxY(this.pageNum));
            this.isClip = false;
            if (this.renderPage) {
                if (this.renderDirectly) {
                    Stroke newStroke = this.currentGraphicsState.getStroke();
                    this.g2.setStroke(newStroke);
                    this.current.renderClip(this.currentGraphicsState.getClippingShape(), null, this.defaultClip, this.g2);
                } else {
                    this.current.drawClip(this.currentGraphicsState);
                }
            }
        }
        this.currentDrawShape.resetPath();
    }

    private final void sh(String shadingObject) {
        ColorspaceDecoder.unsupportPatterns = true;
    }

    private final void TW(float tw) {
        this.currentTextState.setWordSpacing(tw);
    }

    private final void CS(boolean isLowerCase, String colorspaceObject) {
        Map raw;
        String indirect;
        boolean isStroke;
        Object colorspaceValues;
        this.current.resetOnColorspaceChange();
        if (colorspaceObject.startsWith("/")) {
            colorspaceObject = colorspaceObject.substring(1);
        }
        if ((colorspaceValues = this.getObjectFromCache(this.colorspaceObjects, this.rawColorspaceValues, colorspaceObject)) == null) {
            colorspaceValues = colorspaceObject;
        }
        boolean bl = isStroke = !isLowerCase;
        GenericColorSpace newColorSpace = colorspaceValues instanceof String ? ColorspaceDecoder.getColorSpaceInstance(this.isPrinting, this.currentGraphicsState.CTM, (String)colorspaceValues, null, this.currentPdfFile) : ((indirect = (String)(raw = (Map)colorspaceValues).get("rawValue")) == null || indirect.indexOf("<<") == -1 ? ColorspaceDecoder.getColorSpaceInstance(this.isPrinting, this.currentGraphicsState.CTM, null, raw, this.currentPdfFile) : ColorspaceDecoder.getColorSpaceInstance(this.isPrinting, this.currentGraphicsState.CTM, indirect, null, this.currentPdfFile));
        if (newColorSpace.getID() == 9) {
            newColorSpace.setPattern(this.currentPatternValues, this.pageH);
            newColorSpace.setGS(this.currentGraphicsState);
        }
        if (isStroke) {
            this.strokeColorSpace = newColorSpace;
        } else {
            this.nonstrokeColorSpace = newColorSpace;
        }
    }

    private final void V(float x3, float y3, float x2, float y2) {
        this.currentDrawShape.addBezierCurveV(x2, y2, x3, y3);
    }

    private final void TF(float Tfs, String fontID) {
        this.currentTextState.setFontTfs(Tfs);
        Object newFont = this.fonts.get(fontID);
        if (newFont != null) {
            this.currentFontData = (PdfFont)newFont;
        }
        this.currentFont = this.currentFontData.getFontName();
        this.currentTextState.setFont(this.currentFont, fontID);
        this.font_as_string = Fonts.createFontToken(this.currentFont, this.currentTextState.getCurrentFontSize());
    }

    private final int processToken(int commandID, byte[] characterStream, int startCommand, int dataPointer) throws Exception {
        if (this.operandCount > 0) {
            int[] orderedOpStart = new int[50];
            int[] orderedOpEnd = new int[50];
            int opid = 0;
            int jj = this.currentOp - 1;
            while (jj > -1) {
                orderedOpStart[opid] = this.opStart[jj];
                orderedOpEnd[opid] = this.opEnd[jj];
                if (opid == this.operandCount) {
                    jj = -1;
                }
                ++opid;
                --jj;
            }
            if (opid == this.operandCount) {
                --this.currentOp;
                jj = 50 - 1;
                while (jj > this.currentOp) {
                    orderedOpStart[opid] = this.opStart[jj];
                    orderedOpEnd[opid] = this.opEnd[jj];
                    if (opid == this.operandCount) {
                        jj = this.currentOp;
                    }
                    ++opid;
                    --jj;
                }
                ++this.currentOp;
            }
            this.opStart = orderedOpStart;
            this.opEnd = orderedOpEnd;
        }
        boolean notFound = true;
        if (this.renderText || this.textExtracted) {
            notFound = false;
            switch (commandID) {
                case 21603: {
                    this.TC(this.parseFloat(0, characterStream));
                    break;
                }
                case 21623: {
                    this.TW(this.parseFloat(0, characterStream));
                    break;
                }
                case 21626: {
                    this.TZ(this.parseFloat(0, characterStream));
                    break;
                }
                case 21580: {
                    this.TL(this.parseFloat(0, characterStream));
                    break;
                }
                case 21606: {
                    this.TF(this.parseFloat(0, characterStream), this.generateOpAsString(1, characterStream).substring(1));
                    break;
                }
                case 21618: {
                    this.TR(Integer.parseInt(this.generateOpAsString(0, characterStream)));
                    break;
                }
                case 21619: {
                    this.TS(this.parseFloat(0, characterStream));
                    break;
                }
                case 21572: {
                    this.TD(false, this.parseFloat(1, characterStream), this.parseFloat(0, characterStream));
                    break;
                }
                case 21604: {
                    this.TD(true, this.parseFloat(1, characterStream), this.parseFloat(0, characterStream));
                    break;
                }
                case 21613: {
                    this.currentTextState.Tm[0][0] = this.parseFloat(5, characterStream);
                    this.currentTextState.Tm[0][1] = this.parseFloat(4, characterStream);
                    this.currentTextState.Tm[0][2] = 0.0f;
                    this.currentTextState.Tm[1][0] = this.parseFloat(3, characterStream);
                    this.currentTextState.Tm[1][1] = this.parseFloat(2, characterStream);
                    this.currentTextState.Tm[1][2] = 0.0f;
                    this.currentTextState.Tm[2][0] = this.parseFloat(1, characterStream);
                    this.currentTextState.Tm[2][1] = this.parseFloat(0, characterStream);
                    this.currentTextState.Tm[2][2] = 1.0f;
                    this.currentTextState.TmNoRotation[0][0] = this.currentTextState.Tm[0][0];
                    this.currentTextState.TmNoRotation[0][1] = this.currentTextState.Tm[0][1];
                    this.currentTextState.TmNoRotation[0][2] = 0.0f;
                    this.currentTextState.TmNoRotation[1][0] = this.currentTextState.Tm[1][0];
                    this.currentTextState.TmNoRotation[1][1] = this.currentTextState.Tm[1][1];
                    this.currentTextState.TmNoRotation[1][2] = 0.0f;
                    this.currentTextState.TmNoRotation[2][0] = this.currentTextState.Tm[2][0];
                    this.currentTextState.TmNoRotation[2][1] = this.currentTextState.Tm[2][1];
                    this.currentTextState.TmNoRotation[2][2] = 1.0f;
                    this.TM();
                    break;
                }
                case 21546: {
                    this.TSTAR();
                    break;
                }
                case 21610: {
                    this.TJ(characterStream, startCommand, dataPointer);
                    break;
                }
                case 21578: {
                    this.TJ(characterStream, startCommand, dataPointer);
                    break;
                }
                case 39: {
                    this.one_quote(characterStream, startCommand, dataPointer);
                    break;
                }
                case 34: {
                    this.double_quote(characterStream, startCommand, dataPointer, this.parseFloat(1, characterStream), this.parseFloat(2, characterStream));
                    break;
                }
                default: {
                    notFound = true;
                }
            }
        }
        if (this.renderPage || this.textColorExtracted || this.colorExtracted) {
            notFound = false;
            switch (commandID) {
                case 29287: {
                    this.RG(true, characterStream);
                    break;
                }
                case 21063: {
                    this.RG(false, characterStream);
                    break;
                }
                case 5456718: {
                    this.SCN(false, characterStream);
                    break;
                }
                case 7562094: {
                    this.SCN(true, characterStream);
                    break;
                }
                case 21315: {
                    this.SCN(false, characterStream);
                    break;
                }
                case 29539: {
                    this.SCN(true, characterStream);
                    break;
                }
                case 25459: {
                    this.CS(true, this.generateOpAsString(0, characterStream));
                    break;
                }
                case 17235: {
                    this.CS(false, this.generateOpAsString(0, characterStream));
                    break;
                }
                case 103: {
                    this.G(true, characterStream);
                    break;
                }
                case 71: {
                    this.G(false, characterStream);
                    break;
                }
                case 107: {
                    this.K(true, characterStream);
                    break;
                }
                case 75: {
                    this.K(false, characterStream);
                    break;
                }
                case 29544: {
                    this.sh(this.generateOpAsString(0, characterStream).substring(1));
                    break;
                }
                default: {
                    notFound = true;
                }
            }
        }
        if (notFound) {
            switch (commandID) {
                case 18756: {
                    dataPointer = this.ID(characterStream, dataPointer);
                    break;
                }
                case 66: {
                    this.B(false, false);
                    break;
                }
                case 98: {
                    this.B(false, true);
                    break;
                }
                case 25130: {
                    this.B(true, true);
                    break;
                }
                case 16938: {
                    this.B(true, false);
                    break;
                }
                case 99: {
                    float x3 = this.parseFloat(1, characterStream);
                    float y3 = this.parseFloat(0, characterStream);
                    float x2 = this.parseFloat(3, characterStream);
                    float y2 = this.parseFloat(2, characterStream);
                    float x = this.parseFloat(5, characterStream);
                    float y = this.parseFloat(4, characterStream);
                    this.currentDrawShape.addBezierCurveC(x, y, x2, y2, x3, y3);
                    break;
                }
                case 100: {
                    this.D(characterStream);
                    break;
                }
                case 70: {
                    this.F(false);
                    break;
                }
                case 102: {
                    this.F(false);
                    break;
                }
                case 17962: {
                    this.F(true);
                    break;
                }
                case 26154: {
                    this.F(true);
                    break;
                }
                case 104: {
                    this.H();
                    break;
                }
                case 108: {
                    this.L(this.parseFloat(1, characterStream), this.parseFloat(0, characterStream));
                    break;
                }
                case 109: {
                    this.M(this.parseFloat(1, characterStream), this.parseFloat(0, characterStream));
                    break;
                }
                case 110: {
                    this.N();
                    break;
                }
                case 83: {
                    this.S(false);
                    break;
                }
                case 115: {
                    this.S(true);
                    break;
                }
                case 118: {
                    this.V(this.parseFloat(1, characterStream), this.parseFloat(0, characterStream), this.parseFloat(3, characterStream), this.parseFloat(2, characterStream));
                    break;
                }
                case 22314: {
                    this.W(true);
                    break;
                }
                case 87: {
                    this.W(false);
                    break;
                }
                case 121: {
                    this.Y(this.parseFloat(1, characterStream), this.parseFloat(0, characterStream), this.parseFloat(3, characterStream), this.parseFloat(2, characterStream));
                    break;
                }
                case 29285: {
                    this.RE(this.parseFloat(3, characterStream), this.parseFloat(2, characterStream), this.parseFloat(1, characterStream), this.parseFloat(0, characterStream));
                    break;
                }
                case 25453: {
                    float[][] Trm = new float[3][3];
                    Trm[0][0] = this.parseFloat(5, characterStream);
                    Trm[0][1] = this.parseFloat(4, characterStream);
                    Trm[0][2] = 0.0f;
                    Trm[1][0] = this.parseFloat(3, characterStream);
                    Trm[1][1] = this.parseFloat(2, characterStream);
                    Trm[1][2] = 0.0f;
                    Trm[2][0] = this.parseFloat(1, characterStream);
                    Trm[2][1] = this.parseFloat(0, characterStream);
                    Trm[2][2] = 1.0f;
                    this.CM(Trm);
                    break;
                }
                case 26483: {
                    this.gs(this.gs_state.get(this.generateOpAsString(0, characterStream)));
                    break;
                }
                case 105: {
                    this.I();
                    break;
                }
                case 74: {
                    this.J(false, Integer.parseInt(this.generateOpAsString(0, characterStream)));
                    break;
                }
                case 106: {
                    this.J(true, Integer.parseInt(this.generateOpAsString(0, characterStream)));
                    break;
                }
                case 113: {
                    this.Q(true);
                    break;
                }
                case 81: {
                    this.Q(false);
                    break;
                }
                case 19792: {
                    this.MP();
                    break;
                }
                case 17488: {
                    this.DP(startCommand, dataPointer, characterStream, this.generateOpAsString(0, characterStream));
                    break;
                }
                case 0x424443: {
                    this.BDC(startCommand, dataPointer, characterStream, this.generateOpAsString(0, characterStream));
                    break;
                }
                case 4345155: {
                    this.BMC(this.generateOpAsString(0, characterStream));
                    break;
                }
                case 25648: {
                    this.d0((int)this.parseFloat(0, characterStream), (int)this.parseFloat(1, characterStream));
                    break;
                }
                case 25649: {
                    this.d1(this.parseFloat(1, characterStream), this.parseFloat(3, characterStream), this.parseFloat(5, characterStream), this.parseFloat(0, characterStream), this.parseFloat(2, characterStream), this.parseFloat(4, characterStream));
                    break;
                }
                case 4541763: {
                    this.EMC();
                    break;
                }
                case 16980: {
                    this.BT();
                    break;
                }
                case 17748: {
                    this.ET();
                    break;
                }
                case 17519: {
                    this.DO(this.generateOpAsString(0, characterStream));
                    break;
                }
                case 77: {
                    this.mm((int)this.parseFloat(0, characterStream));
                    break;
                }
                case 119: {
                    this.width(this.parseFloat(0, characterStream));
                }
            }
        }
        this.currentOp = 0;
        this.operandCount = 0;
        ++this.tokenNumber;
        return dataPointer;
    }

    private void gs(Object values) {
        this.currentGraphicsState.setMode(values);
        this.current.setGraphicsState(2, this.currentGraphicsState.getNonStrokeAlpha());
        this.current.setGraphicsState(1, this.currentGraphicsState.getStrokeAlpha());
    }

    private final void DO(String name) throws PdfException {
        block35: {
            Map currentValues;
            name = name.substring(1);
            if (this.rejectSuperimposedImages) {
                String key;
                if (this.imposedImages == null) {
                    this.imposedImages = new HashMap();
                }
                if (this.imposedImages.get(key = String.valueOf((int)this.currentGraphicsState.CTM[2][0]) + "-" + (int)this.currentGraphicsState.CTM[2][1] + '-' + (int)this.currentGraphicsState.CTM[0][0] + '-' + (int)this.currentGraphicsState.CTM[1][1] + '-' + (int)this.currentGraphicsState.CTM[0][1] + '-' + (int)this.currentGraphicsState.CTM[1][0]) == null) {
                    this.imposedImages.put(key, "x");
                } else {
                    return;
                }
            }
            this.currentImage = String.valueOf(this.fileName) + '-' + name;
            Object rawObject = this.localXObjects.get(name);
            if (rawObject == null) {
                rawObject = this.currentXObjectValues.get(name);
            }
            String objectRef = null;
            if (rawObject == null) {
                currentValues = null;
            } else if (rawObject instanceof Map) {
                currentValues = (Map)rawObject;
            } else {
                objectRef = (String)rawObject;
                currentValues = this.currentPdfFile.readObject(objectRef, false, null);
            }
            if (this.requestExit) {
                this.exited = true;
                return;
            }
            try {
                if (currentValues == null) break block35;
                String subtype = (String)currentValues.get("Subtype");
                if (subtype.equals("/Form")) {
                    if (this.xFormMetadata) {
                        this.lastFormID = name;
                        HashMap xFormData = new HashMap();
                        String[] requiredKeys = new String[]{"OPI", "BBox", "Matrix"};
                        int count = requiredKeys.length;
                        int j = 0;
                        while (j < count) {
                            Object value = currentValues.get(requiredKeys[j]);
                            if (value != null) {
                                xFormData.put(requiredKeys[j], value);
                            }
                            ++j;
                        }
                        HashMap newValues = new HashMap();
                        HashMap<String, String> textFields = new HashMap<String, String>();
                        textFields.put("F", "x");
                        this.currentPdfFile.flattenValuesInObject(false, false, xFormData, newValues, textFields, null, objectRef);
                        this.pdfImages.setXformData(this.lastFormID, newValues);
                    }
                    if (!this.renderDirectly && this.statusBar != null) {
                        this.statusBar.inSubroutine(true);
                    }
                    byte[] objectData = this.currentPdfFile.readStream(currentValues, objectRef, true, true, this.keepRaw, false, false);
                    this.currentOp = 0;
                    this.operandCount = 0;
                    if (objectData != null) {
                        this.processXForm(currentValues, objectData);
                    }
                    if (!this.renderDirectly && this.statusBar != null) {
                        this.statusBar.inSubroutine(false);
                    }
                    this.lastFormID = null;
                    break block35;
                }
                if (subtype.equals("/Image")) {
                    byte[] objectData;
                    if (!this.markedContentExtracted && this.contentHandler != null) {
                        this.contentHandler.setImageName(name);
                    }
                    if (!(this.renderImages | this.clippedImagesExtracted | this.finalImagesExtracted | this.rawImagesExtracted) || (objectData = this.currentPdfFile.readStream(currentValues, objectRef, true, true, this.keepRaw, false, false)) == null) break block35;
                    boolean alreadyCached = this.useHiResImageForDisplay && this.current.isImageCached(this.pageNum);
                    BufferedImage image = null;
                    this.optionsApplied = 0;
                    if (!alreadyCached) {
                        image = this.processImageXObject(name, currentValues, this.createScaledVersion, objectData);
                    }
                    if (this.requestExit) {
                        this.exited = true;
                        return;
                    }
                    if (image == null && !alreadyCached) break block35;
                    if (this.renderDirectly || this.useHiResImageForDisplay) {
                        if (PdfDecoder.isRunningOnMac && !alreadyCached) {
                            image = this.clipForMac(image);
                        }
                        if (this.requestExit) {
                            this.exited = true;
                            return;
                        }
                        this.currentGraphicsState.x = this.currentGraphicsState.CTM[2][0];
                        this.currentGraphicsState.y = this.currentGraphicsState.CTM[2][1];
                        if (this.renderDirectly) {
                            this.current.renderImage(null, image, this.currentGraphicsState.getNonStrokeAlpha(), this.currentGraphicsState, this.g2, this.currentGraphicsState.x, this.currentGraphicsState.y, this.optionsApplied);
                        } else if (image != null || alreadyCached) {
                            this.current.drawImage(this.pageNum, image, this.currentGraphicsState, alreadyCached, name, this.optionsApplied);
                        }
                    } else if (this.clippedImagesExtracted) {
                        this.generateTransformedImage(image, name);
                    } else {
                        try {
                            this.generateTransformedImageSingle(image, name);
                        }
                        catch (Exception e) {
                            LogWriter.writeLog("Exception " + e + " on tansforming image in file");
                        }
                    }
                    if (image != null) {
                        image.flush();
                    }
                    break block35;
                }
                LogWriter.writeLog("[PDF] " + subtype + " not supported");
            }
            catch (Error e) {
                e.printStackTrace();
                this.imagesProcessedFully = false;
                this.addPageFailureMessage("Error " + e + " in DO with image " + currentValues + " isPrinting=" + this.isPrinting + " useHiResImageForDisplay=" + this.useHiResImageForDisplay);
            }
        }
    }

    private void processXForm(Map currentValues, byte[] formData) throws PdfException {
        String matrix = this.currentPdfFile.getValue((String)currentValues.get("Matrix"));
        float[] matches = new float[]{1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f};
        float[] transformMatrix = new float[6];
        boolean isIdentity = true;
        if (matrix != null) {
            StringTokenizer match = new StringTokenizer(matrix, "[ ]");
            int ii = 0;
            while (ii < 6) {
                float value;
                transformMatrix[ii] = value = Float.parseFloat(match.nextToken());
                if (value != matches[ii]) {
                    isIdentity = false;
                }
                ++ii;
            }
        }
        float[][] CTM = null;
        if (matrix != null && !isIdentity) {
            this.scalings.put(new Integer(this.formLevel), CTM);
            CTM = this.currentGraphicsState.CTM;
            Object scaleFactor = new float[][]{{transformMatrix[0], transformMatrix[1], 0.0f}, {transformMatrix[2], transformMatrix[3], 0.0f}, {transformMatrix[4], transformMatrix[5], 1.0f}};
            scaleFactor = Matrix.multiply(scaleFactor, CTM);
            this.currentGraphicsState.CTM = scaleFactor;
        }
        ++this.formLevel;
        GenericColorSpace mainStrokeColorData = (GenericColorSpace)this.strokeColorSpace.clone();
        GenericColorSpace mainnonStrokeColorData = (GenericColorSpace)this.nonstrokeColorSpace.clone();
        Map old_gs_state = this.gs_state;
        this.gs_state = new HashMap();
        for (Object key : old_gs_state.keySet()) {
            this.gs_state.put(key, old_gs_state.get(key));
        }
        Map rawFonts = this.fonts;
        this.fonts = new HashMap();
        Map resValue = this.currentPdfFile.getSubDictionary(currentValues.get("Resources"));
        if (resValue != null) {
            this.readResources(false, resValue, false);
        }
        if (formData.length > 0) {
            this.decodeStreamIntoObjects(formData);
        }
        --this.formLevel;
        CTM = (float[][])this.scalings.get(new Integer(this.formLevel));
        if (CTM != null) {
            this.currentGraphicsState.CTM = CTM;
        }
        if (this.formLevel == 0) {
            this.localXObjects.clear();
        }
        this.strokeColorSpace = mainStrokeColorData;
        this.nonstrokeColorSpace = mainnonStrokeColorData;
        this.fonts = rawFonts;
        this.gs_state = old_gs_state;
    }

    private final void generateTransformedImageSingle(BufferedImage image, String image_name) {
        LogWriter.writeMethod("{generateTransformedImageSingle}", 0);
        float x = 0.0f;
        float y = 0.0f;
        float w = 0.0f;
        float h = 0.0f;
        if (image != null) {
            boolean ignore_image;
            Area clipping_shape = this.currentGraphicsState.getClippingShape();
            ImageTransformer image_transformation = new ImageTransformer(PdfDecoder.dpi, this.currentGraphicsState, image, true, PdfDecoder.isDraft);
            if (this.requestExit) {
                this.exited = true;
                return;
            }
            x = image_transformation.getImageX();
            y = image_transformation.getImageY();
            w = image_transformation.getImageW();
            h = image_transformation.getImageH();
            image = image_transformation.getImage();
            if (image != null && clipping_shape != null && clipping_shape.getBounds().getWidth() > 1.0 && clipping_shape.getBounds().getHeight() > 1.0 && this.customImageHandler != null && !this.customImageHandler.imageHasBeenScaled() && !(ignore_image = clipping_shape.contains(x, y, w, h))) {
                image_transformation.clipImage(clipping_shape);
                x = image_transformation.getImageX();
                y = image_transformation.getImageY();
                w = image_transformation.getImageW();
                h = image_transformation.getImageH();
            }
            image = image_transformation.getImage();
            image_transformation = null;
            if (this.requestExit) {
                this.exited = true;
                return;
            }
            if (image != null) {
                if (this.finalImagesExtracted | this.rawImagesExtracted) {
                    this.pdfImages.setImageInfo(this.currentImage, this.pageNum, x, y, w, h, this.lastFormID);
                    if (this.includeImagesInData) {
                        float xx = x;
                        float yy = y;
                        if (clipping_shape != null) {
                            int minX = (int)clipping_shape.getBounds().getMinX();
                            int maxX = (int)clipping_shape.getBounds().getMaxX();
                            int minY = (int)clipping_shape.getBounds().getMinY();
                            int maxY = (int)clipping_shape.getBounds().getMaxY();
                            if (xx > 0.0f && xx < (float)minX || xx < 0.0f) {
                                xx = minX;
                            }
                            float currentW = xx + w;
                            if (xx < 0.0f) {
                                currentW = w;
                            }
                            if ((float)maxX < currentW) {
                                w = (float)maxX - xx;
                            }
                            if (yy > 0.0f && yy < (float)minY) {
                                yy = minY;
                            }
                            if ((float)maxY < yy + h) {
                                h = (float)maxY - yy;
                            }
                        }
                        this.pdfData.addImageElement(xx, yy, w, h, this.currentImage);
                    }
                }
                if ((this.renderImages || !this.isPageContent) && image != null) {
                    this.currentGraphicsState.x = x;
                    this.currentGraphicsState.y = y;
                    if (this.renderDirectly) {
                        this.current.renderImage(null, image, this.currentGraphicsState.getNonStrokeAlpha(), this.currentGraphicsState, this.g2, this.currentGraphicsState.x, this.currentGraphicsState.y, this.optionsApplied);
                    } else {
                        this.current.drawImage(this.pageNum, image, this.currentGraphicsState, false, image_name, this.optionsApplied);
                    }
                }
                if (this.isPageContent & this.finalImagesExtracted && this.currentPdfFile.isExtractionAllowed() && !runningStoryPad) {
                    String image_type = this.objectStoreStreamRef.getImageType(this.currentImage);
                    this.objectStoreStreamRef.saveStoredImage(this.currentImage, this.addBackgroundToMask(image), false, false, image_type);
                }
            }
        } else {
            LogWriter.writeLog("NO image written");
        }
    }

    private BufferedImage addBackgroundToMask(BufferedImage image) {
        if (this.isMask) {
            int cw = image.getWidth();
            int ch = image.getHeight();
            BufferedImage background = new BufferedImage(cw, ch, 1);
            Graphics2D g2 = background.createGraphics();
            g2.setColor(Color.white);
            g2.fillRect(0, 0, cw, ch);
            g2.drawImage((Image)image, 0, 0, null);
            image = background;
        }
        return image;
    }

    public void setStatusBar(StatusBar statusBar) {
        this.statusBar = statusBar;
    }

    private final BufferedImage clipForMac(BufferedImage image) {
        LogWriter.writeMethod("{clipForMac}", 0);
        if (image != null) {
            ImageTransformerDouble image_transformation = new ImageTransformerDouble(PdfDecoder.dpi, this.currentGraphicsState, image, this.createScaledVersion, false);
            if (this.requestExit) {
                this.exited = true;
                return null;
            }
            image_transformation.doubleScaleTransformShear(true);
            if (this.requestExit) {
                this.exited = true;
                return null;
            }
            image = image_transformation.getImage();
        }
        return image;
    }

    private final void generateTransformedImage(BufferedImage image, String image_name) {
        LogWriter.writeMethod("{generateTransformedImage}", 0);
        float x = 0.0f;
        float y = 0.0f;
        float w = 0.0f;
        float h = 0.0f;
        if (image != null) {
            ImageTransformerDouble image_transformation = new ImageTransformerDouble(PdfDecoder.dpi, this.currentGraphicsState, image, this.createScaledVersion, true);
            image_transformation.doubleScaleTransformShear(false);
            if (this.requestExit) {
                this.exited = true;
                return;
            }
            image = image_transformation.getImage();
            String image_type = this.objectStoreStreamRef.getImageType(this.currentImage);
            if (image_type == null) {
                image_type = "tif";
            }
            if (this.requestExit) {
                this.exited = true;
                return;
            }
            if (this.objectStoreStreamRef.saveStoredImage("CLIP_" + this.currentImage, this.addBackgroundToMask(image), false, false, image_type)) {
                this.addPageFailureMessage("Problem saving " + image);
            }
            if (this.finalImagesExtracted | this.renderImages) {
                image_transformation.doubleScaleTransformScale();
            }
            image_transformation.completeImage();
            x = image_transformation.getImageX();
            y = image_transformation.getImageY();
            w = image_transformation.getImageW();
            h = image_transformation.getImageH();
            image = image_transformation.getImage();
            image_transformation = null;
            if (image != null) {
                if (this.finalImagesExtracted | this.clippedImagesExtracted | this.rawImagesExtracted) {
                    this.pdfImages.setImageInfo(this.currentImage, this.pageNum, x, y, w, h, this.lastFormID);
                    if (this.includeImagesInData) {
                        this.pdfData.addImageElement(x, y, w, h, this.currentImage);
                    }
                }
                if ((this.renderImages || !this.isPageContent) && image != null) {
                    this.currentGraphicsState.x = x;
                    this.currentGraphicsState.y = y;
                    if (this.renderDirectly) {
                        this.current.renderImage(null, image, this.currentGraphicsState.getNonStrokeAlpha(), this.currentGraphicsState, this.g2, this.currentGraphicsState.x, this.currentGraphicsState.y, this.optionsApplied);
                    } else {
                        this.current.drawImage(this.pageNum, image, this.currentGraphicsState, false, image_name, this.optionsApplied);
                    }
                }
                if (!this.renderDirectly && this.isPageContent && this.finalImagesExtracted && this.currentPdfFile.isExtractionAllowed()) {
                    image_type = this.objectStoreStreamRef.getImageType(this.currentImage);
                    this.objectStoreStreamRef.saveStoredImage(this.currentImage, this.addBackgroundToMask(image), false, false, image_type);
                }
            }
        } else {
            LogWriter.writeLog("NO image written");
        }
    }

    private final StringBuffer processTextArray(byte[] stream, int startCommand, int dataPointer) {
        float y;
        float x;
        float TFS;
        boolean hasContent = false;
        boolean isMultiple = false;
        boolean firstTime = true;
        while (stream[startCommand] == 91 || stream[startCommand] == 10 || stream[startCommand] == 13 || stream[startCommand] == 32) {
            if (stream[startCommand] == 91) {
                isMultiple = true;
            }
            ++startCommand;
        }
        float currentThreshold = PdfStreamDecoder.currentThreshold;
        if (currentThreshold < 0.0f) {
            Float specificSetting = (Float)currentThresholdValues.get(this.currentFontData.getFontName());
            currentThreshold = specificSetting == null ? -currentThreshold : specificSetting.floatValue();
        }
        this.textLength = 0;
        int Tmode = this.currentGraphicsState.getTextRenderType();
        int orientation = 0;
        boolean isHorizontal = true;
        boolean inText = false;
        float[][] TrmWithRotationRemoved = new float[3][3];
        float[][] Trm = new float[3][3];
        float[][] temp = new float[3][3];
        float[][] TrmBeforeSpace = new float[3][3];
        float[][] TrmBeforeSpaceWithRotationRemoved = new float[3][3];
        char rawChar = ' ';
        char lastChar = ' ';
        char openChar = ' ';
        char lastTextChar = 'x';
        int fontSize = 0;
        int rawInt = 0;
        float width = 0.0f;
        float fontScale = 1.0f;
        float lastWidth = 0.0f;
        float currentWidth = 0.0f;
        float leading = 0.0f;
        String displayValue = "";
        float rawTFS = TFS = this.currentTextState.getTfs();
        if (TFS < 0.0f) {
            TFS = -TFS;
        }
        int type = this.currentFontData.getFontType();
        float spaceWidth = this.currentFontData.getCurrentFontSpaceWidth();
        String unicodeValue = "";
        this.textData = new StringBuffer(50);
        float currentGap = 0.0f;
        boolean isCID = this.currentFontData.isCIDFont();
        if (this.renderText && Tmode != 4) {
            this.currentGraphicsState.setStrokeColor(this.strokeColorSpace.getColor());
            this.currentGraphicsState.setNonstrokeColor(this.nonstrokeColorSpace.getColor());
            if (this.showTextAsRotated && this.currentRotation != 0) {
                this.currentGraphicsState.setStrokeColor(new PdfColor(0, 0, 255));
                this.currentGraphicsState.setNonstrokeColor(new PdfColor(0, 0, 255));
            }
        }
        int charSize = 2;
        if (isCID) {
            charSize = 4;
        }
        Trm = Matrix.multiply(this.currentTextState.Tm, this.currentGraphicsState.CTM);
        if (this.currentRotation != 0) {
            TrmWithRotationRemoved = Matrix.multiply(this.currentTextState.TmNoRotation, this.currentGraphicsState.CTM);
        }
        if (rawTFS < 0.0f) {
            Trm[2][0] = Trm[2][0] - Trm[0][0] / 2.0f;
            Trm[2][1] = Trm[2][1] - Trm[1][1] / 2.0f;
            if (this.currentRotation != 0) {
                TrmWithRotationRemoved[2][0] = TrmWithRotationRemoved[2][0] - TrmWithRotationRemoved[0][0] / 2.0f;
                TrmWithRotationRemoved[2][1] = Trm[2][1] - TrmWithRotationRemoved[1][1] / 2.0f;
            }
        }
        this.charSpacing = this.currentTextState.getCharacterSpacing() / TFS;
        float wordSpacing = this.currentTextState.getWordSpacing() / TFS;
        if (this.multipleTJs) {
            Trm[2][0] = this.currentTextState.Tm[2][0];
            Trm[2][1] = this.currentTextState.Tm[2][1];
            if (this.currentRotation != 0) {
                TrmWithRotationRemoved[2][0] = this.currentTextState.TmNoRotation[2][0];
                TrmWithRotationRemoved[2][1] = this.currentTextState.TmNoRotation[2][1];
            }
        }
        temp[0][0] = rawTFS * this.currentTextState.getHorizontalScaling();
        temp[1][1] = rawTFS;
        temp[2][1] = this.currentTextState.getTextRise();
        temp[2][2] = 1.0f;
        Trm = Matrix.multiply(temp, Trm);
        if (this.currentRotation != 0) {
            TrmWithRotationRemoved = Matrix.multiply(temp, TrmWithRotationRemoved);
        }
        if (isMultiple && stream[startCommand] != 60 && stream[startCommand] != 40 && stream[startCommand] != 93) {
            float offset = 0.0f;
            while (stream[startCommand] != 40) {
                StringBuffer kerning = new StringBuffer();
                while (stream[startCommand] != 40 && stream[startCommand] != 32) {
                    kerning.append((char)stream[startCommand]);
                    ++startCommand;
                }
                offset += Float.parseFloat(kerning.toString());
                while (stream[startCommand] == 32) {
                    ++startCommand;
                }
            }
            offset = Trm[0][0] * offset / 1000.0f;
            Trm[2][0] = Trm[2][0] - offset;
            if (this.currentRotation != 0) {
                TrmWithRotationRemoved[2][0] = TrmWithRotationRemoved[2][0] - offset;
            }
        }
        this.multipleTJs = true;
        if (Trm[1][1] != 0.0f) {
            isHorizontal = true;
            orientation = 0;
            fontSize = Math.round(Trm[1][1]);
            if (fontSize == 0) {
                fontSize = Math.round(Trm[0][1]);
            }
            fontScale = Trm[0][0];
        } else {
            isHorizontal = false;
            fontSize = Math.round(Trm[1][0]);
            if (fontSize == 0) {
                fontSize = Math.round(Trm[0][0]);
            }
            if (fontSize < 0) {
                fontSize = -fontSize;
                orientation = 3;
            } else {
                orientation = 2;
            }
            fontScale = Trm[0][1];
        }
        if (fontSize == 0) {
            fontSize = 1;
        }
        Font javaFont = null;
        if ((useTextPrintingForNonEmbeddedFonts || this.textPrint != 0) && this.isPrinting) {
            javaFont = this.currentFontData.getJavaFontX(fontSize);
        }
        if (this.currentRotation == 0) {
            x = Trm[2][0];
            y = Trm[2][1];
        } else {
            x = TrmWithRotationRemoved[2][0];
            y = TrmWithRotationRemoved[2][1];
        }
        float max_height = fontSize;
        if (type == 3 && fontSize > 10) {
            max_height = 10.0f;
        }
        if (isCID) {
            max_height = Trm[1][1];
        }
        int i = startCommand;
        int numOfPrefixes = 0;
        while (i < dataPointer) {
            while (true) {
                lastChar = lastChar == '\\' && rawChar == '\\' ? (char)'x' : rawChar;
                rawInt = stream[i];
                if (rawInt < 0) {
                    rawInt += 256;
                }
                if ((rawChar = (char)((char)rawInt)) == '\\' && stream[i + 1] == 13 | stream[i + 1] == 10) {
                    if ((rawInt = stream[++i]) < 0) {
                        rawInt += 256;
                    }
                    rawChar = (char)rawInt;
                }
                if (rawChar != '\n' & rawChar != '\r') break;
                ++i;
            }
            if (inText) {
                if (lastChar != '\\' && (rawChar == '(' || rawChar == ')')) {
                    if (rawChar == '(') {
                        ++numOfPrefixes;
                    } else if (rawChar == ')') {
                        if (numOfPrefixes <= 0) {
                            inText = false;
                        } else {
                            --numOfPrefixes;
                        }
                    }
                } else if (openChar == '<' && rawChar == '>') {
                    inText = false;
                }
            }
            if (inText) {
                boolean hasTextSpace;
                float h;
                block216: {
                    int mappedIdx;
                    lastTextChar = rawChar;
                    if (openChar == '<') {
                        StringBuffer hexString = new StringBuffer(4);
                        hexString.append(rawChar);
                        int i2 = 1;
                        while (i2 < charSize) {
                            int nextInt = stream[i + i2];
                            if (nextInt == 62) {
                                i2 = 4;
                                charSize = 2;
                            } else if (nextInt == 10 | nextInt == 13) {
                                ++i;
                                --i2;
                            } else {
                                if (nextInt < 0) {
                                    nextInt += 256;
                                }
                                rawChar = (char)nextInt;
                                hexString.append(rawChar);
                            }
                            ++i2;
                        }
                        i = i + charSize - 1;
                        rawInt = Integer.parseInt(hexString.toString(), 16);
                        rawChar = (char)rawInt;
                        displayValue = this.currentFontData.getGlyphValue(rawInt);
                        if (this.textExtracted) {
                            unicodeValue = this.currentFontData.getUnicodeValue(displayValue, rawInt);
                        }
                    } else if (isCID && this.currentFontData.isDoubleByte()) {
                        int nextInt;
                        if (rawChar == '\\') {
                            while (true) {
                                if ((rawInt = stream[i]) < 0) {
                                    rawInt += 256;
                                }
                                rawChar = (char)rawInt;
                                if (rawInt < 0) {
                                    rawInt += 256;
                                }
                                rawChar = (char)rawInt;
                                if (rawInt == 92) {
                                    if ((rawChar = (char)(rawInt = stream[++i])) == 'n') {
                                        rawInt = 10;
                                    } else if (rawChar == 'b') {
                                        rawInt = 8;
                                    } else if (rawChar == 't') {
                                        rawInt = 9;
                                    } else if (rawChar == 'r') {
                                        rawInt = 13;
                                    } else if (rawChar == 'f') {
                                        rawInt = 12;
                                    } else if (stream.length > i + 2 && Character.isDigit((char)stream[i])) {
                                        int numberCount = 1;
                                        if (Character.isDigit((char)stream[i + 1])) {
                                            ++numberCount;
                                            if (Character.isDigit((char)stream[i + 2])) {
                                                ++numberCount;
                                            }
                                        }
                                        rawInt = this.readEscapeValue(i, numberCount, 8, stream);
                                        i = i + numberCount - 1;
                                    }
                                }
                                if (rawChar != '\n' && rawChar != '\r') break;
                                ++i;
                            }
                        }
                        if ((nextInt = stream[++i]) < 0) {
                            nextInt += 256;
                        }
                        if (nextInt == 92) {
                            if ((rawChar = (char)((char)(nextInt = stream[++i]))) == 'n') {
                                nextInt = 10;
                            } else if (rawChar == 'b') {
                                nextInt = 8;
                            } else if (rawChar == 't') {
                                nextInt = 9;
                            } else if (rawChar == 'r') {
                                nextInt = 13;
                            } else if (rawChar == 'f') {
                                nextInt = 12;
                            } else if (stream.length > i + 2 && Character.isDigit((char)stream[i])) {
                                int numberCount = 1;
                                if (Character.isDigit((char)stream[i + 1])) {
                                    ++numberCount;
                                    if (Character.isDigit((char)stream[i + 2])) {
                                        ++numberCount;
                                    }
                                }
                                nextInt = this.readEscapeValue(i, numberCount, 8, stream);
                                i = i + numberCount - 1;
                            }
                        }
                        rawInt = rawInt * 256 + nextInt;
                        rawChar = (char)rawInt;
                        displayValue = String.valueOf(rawChar);
                        unicodeValue = this.currentFontData.getUnicodeValue(displayValue, rawInt);
                        if (rawChar == '\\') {
                            rawChar = 'x';
                        }
                    } else if (rawChar == '\\') {
                        lastChar = rawChar;
                        rawInt = stream[++i];
                        rawChar = (char)rawInt;
                        if (stream.length > i + 2 && Character.isDigit((char)stream[i])) {
                            int numberCount = 1;
                            if (Character.isDigit((char)stream[i + 1])) {
                                ++numberCount;
                                if (Character.isDigit((char)stream[i + 2])) {
                                    ++numberCount;
                                }
                            }
                            rawInt = this.readEscapeValue(i, numberCount, 8, stream);
                            i = i + numberCount - 1;
                            if (rawInt > 255) {
                                rawInt -= 256;
                            }
                            displayValue = this.currentFontData.getGlyphValue(rawInt);
                            if (this.textExtracted) {
                                unicodeValue = this.currentFontData.getUnicodeValue(displayValue, rawInt);
                            }
                            if ((rawChar = (char)((char)rawInt)) == '\\') {
                                rawChar = 'x';
                            }
                        } else {
                            rawInt = stream[i];
                            rawChar = (char)rawInt;
                            if (rawChar == 'u') {
                                rawInt = this.readEscapeValue(i + 1, 4, 16, stream);
                                i += 4;
                                displayValue = this.currentFontData.getGlyphValue(rawInt);
                                if (this.textExtracted) {
                                    unicodeValue = this.currentFontData.getUnicodeValue(displayValue, rawInt);
                                }
                            } else {
                                if (rawChar == 'n') {
                                    rawInt = 10;
                                    rawChar = '\n';
                                } else if (rawChar == 'b') {
                                    rawInt = 8;
                                    rawChar = '\b';
                                } else if (rawChar == 't') {
                                    rawInt = 9;
                                    rawChar = '\t';
                                } else if (rawChar == 'r') {
                                    rawInt = 13;
                                    rawChar = '\r';
                                } else if (rawChar == 'f') {
                                    rawInt = 12;
                                    rawChar = '\f';
                                }
                                displayValue = this.currentFontData.getGlyphValue(rawInt);
                                if (this.textExtracted) {
                                    unicodeValue = this.currentFontData.getUnicodeValue(displayValue, rawInt);
                                }
                                if (displayValue.length() > 0) {
                                    rawChar = displayValue.charAt(0);
                                }
                            }
                        }
                    } else if (isCID) {
                        unicodeValue = displayValue = String.valueOf(rawChar);
                    } else {
                        displayValue = this.currentFontData.getGlyphValue(rawInt);
                        if (this.textExtracted) {
                            unicodeValue = this.currentFontData.getUnicodeValue(displayValue, rawInt);
                        }
                    }
                    temp[0][0] = 1.0f;
                    temp[0][1] = 0.0f;
                    temp[0][2] = 0.0f;
                    temp[1][0] = 0.0f;
                    temp[1][1] = 1.0f;
                    temp[1][2] = 0.0f;
                    temp[2][0] = currentWidth + leading;
                    temp[2][1] = 0.0f;
                    temp[2][2] = 1.0f;
                    Trm = Matrix.multiply(temp, Trm);
                    if (this.currentRotation != 0) {
                        TrmWithRotationRemoved = Matrix.multiply(temp, TrmWithRotationRemoved);
                    }
                    if (rawChar == ' ' && lastChar != ' ') {
                        TrmBeforeSpace = Trm;
                        if (this.currentRotation != 0) {
                            TrmBeforeSpaceWithRotationRemoved = TrmWithRotationRemoved;
                        }
                    }
                    leading = 0.0f;
                    PdfJavaGlyphs glyphs = this.currentFontData.getGlyphData();
                    int idx = rawInt;
                    if (this.currentFontData.isCIDFont() && !glyphs.isIdentity() && (mappedIdx = glyphs.getConvertedGlyph(rawInt)) != -1) {
                        idx = mappedIdx;
                    }
                    currentWidth = this.currentFontData.getWidth(idx);
                    if (this.renderText && Tmode != 4) {
                        float[][] displayTrm = Trm;
                        if (this.showTextAsRotated && this.currentRotation != 0) {
                            displayTrm = TrmWithRotationRemoved;
                        }
                        if (this.isPrinting && javaFont != null && (this.textPrint == 2 || useTextPrintingForNonEmbeddedFonts && (!this.currentFontData.isFontEmbedded || this.currentFontData.isFontSubstituted()))) {
                            Area transformedGlyph2;
                            if (Tmode == 7 && (transformedGlyph2 = PdfDecoder.isRunningOnMac | StandardFonts.isStandardFont(this.currentFontData.getBaseFontName()) ? glyphs.getStandardGlyph(displayTrm, rawInt, displayValue, currentWidth) : glyphs.getApproximateGlyph(displayTrm, rawInt, displayValue, currentWidth)) != null) {
                                this.currentGraphicsState.addClip(transformedGlyph2);
                            }
                            if (displayValue != null && !displayValue.startsWith("&#")) {
                                this.current.drawText(Trm, displayValue, this.currentGraphicsState, displayTrm[2][0], -displayTrm[2][1], javaFont);
                            }
                        } else if ((this.textPrint != 1 || javaFont == null) && this.currentFontData.isFontEmbedded) {
                            String charGlyph = "notdef";
                            try {
                                Area glyphShape;
                                float lineWidth;
                                if (!this.currentFontData.isCIDFont()) {
                                    charGlyph = this.currentFontData.getMappedChar(rawInt, false);
                                }
                                PdfGlyph glyph = null;
                                glyph = glyphs.getEmbeddedGlyph(this.factory, charGlyph, displayTrm, rawInt, displayValue, currentWidth, this.currentFontData.getEmbeddedChar(rawInt));
                                if (type == 3) {
                                    if (glyph != null && glyph.getmaxWidth() == 0.0f) {
                                        glyph = null;
                                    } else if (glyph != null && glyph.ignoreColors()) {
                                        glyph.lockColors(this.currentGraphicsState.getNonstrokeColor(), this.currentGraphicsState.getNonstrokeColor());
                                    }
                                }
                                if (glyph == null) break block216;
                                Object finalTrm = new float[][]{{displayTrm[0][0], displayTrm[0][1], 0.0f}, {displayTrm[1][0], displayTrm[1][1], 0.0f}, {displayTrm[2][0], displayTrm[2][1], 1.0f}};
                                float[][] finalScale = new float[][]{{(float)this.currentFontData.FontMatrix[0], (float)this.currentFontData.FontMatrix[1], 0.0f}, {(float)this.currentFontData.FontMatrix[2], (float)this.currentFontData.FontMatrix[3], 0.0f}, {0.0f, 0.0f, 1.0f}};
                                finalTrm = Matrix.multiply(finalTrm, finalScale);
                                finalTrm[2][0] = displayTrm[2][0];
                                finalTrm[2][1] = displayTrm[2][1];
                                if (finalTrm[1][0] < 0.0f && finalTrm[0][1] < 0.0f) {
                                    finalTrm[1][0] = -finalTrm[1][0];
                                    finalTrm[0][1] = -finalTrm[0][1];
                                }
                                if (type == 3) {
                                    float h2 = 0.0f;
                                    if (finalTrm[1][1] != 0.0f) {
                                        h2 = (float)fontSize * finalTrm[1][1];
                                    } else if (finalTrm[0][0] != 0.0f) {
                                        h2 = (float)fontSize * finalTrm[0][0];
                                    } else if (finalTrm[1][0] != 0.0f) {
                                        h2 = (float)fontSize * finalTrm[1][0];
                                    }
                                    if (h2 < 0.0f) {
                                        h2 = -h2;
                                    }
                                    if (h2 > max_height) {
                                        max_height = h2;
                                    }
                                }
                                if (!((lineWidth = 0.0f) > 0.0f)) {
                                    lineWidth = 0.0f;
                                }
                                AffineTransform at = new AffineTransform(finalTrm[0][0], finalTrm[0][1], finalTrm[1][0], finalTrm[1][1], finalTrm[2][0], finalTrm[2][1]);
                                int fontType = type;
                                if (type == 6) {
                                    fontType = 5;
                                    float z = 1000.0f / glyph.getmaxWidth();
                                    at.scale(currentWidth * z, 1.0);
                                } else {
                                    fontType = type == 2 || type == 5 || this.currentFontData.isFontSubstituted() ? 4 : (type == 3 ? 6 : 5);
                                }
                                if (this.generateGlyphOnRender) {
                                    fontType = -fontType;
                                }
                                if (Tmode == 7 && (glyphShape = glyph.getShape()) != null) {
                                    glyphShape.transform(at);
                                    this.currentGraphicsState.addClip(glyphShape);
                                }
                                if (this.renderDirectly) {
                                    PdfPaint strokeCol = null;
                                    PdfPaint fillCol = null;
                                    int text_fill_type = this.currentGraphicsState.getTextRenderType();
                                    if ((text_fill_type & 2) == 2) {
                                        fillCol = this.currentGraphicsState.getNonstrokeColor();
                                    }
                                    if ((text_fill_type & 1) == 1) {
                                        strokeCol = this.currentGraphicsState.getStrokeColor();
                                    }
                                    Stroke newStroke = this.currentGraphicsState.getStroke();
                                    this.g2.setStroke(newStroke);
                                    this.current.renderEmbeddedText(this.currentGraphicsState, text_fill_type, glyph, fontType, this.g2, at, false, strokeCol, fillCol, this.currentGraphicsState.getStrokeAlpha(), this.currentGraphicsState.getNonStrokeAlpha(), null, (int)lineWidth);
                                    break block216;
                                }
                                this.current.drawEmbeddedText(displayTrm, fontSize, glyph, fontType, this.currentGraphicsState, at, lineWidth);
                            }
                            catch (Exception e) {
                                this.addPageFailureMessage("Exception " + e + " on embedded font renderer");
                            }
                        } else if (displayValue.length() > 0 && !displayValue.startsWith("&#")) {
                            if (displayValue.equals("...")) {
                                displayValue = ellipsis;
                            }
                            Area transformedGlyph2 = null;
                            Area glyph = PdfDecoder.isRunningOnMac || StandardFonts.isStandardFont(this.currentFontData.getBaseFontName()) ? glyphs.getStandardGlyph(displayTrm, rawInt, displayValue, currentWidth) : glyphs.getApproximateGlyph(displayTrm, rawInt, displayValue, currentWidth);
                            if (glyph != null) {
                                AffineTransform at2 = AffineTransform.getTranslateInstance(displayTrm[2][0], displayTrm[2][1]);
                                glyph.transform(at2);
                                if (Tmode == 7) {
                                    this.currentGraphicsState.addClip(glyph);
                                }
                            }
                            if ((transformedGlyph2 = glyph) != null) {
                                if (this.renderDirectly) {
                                    PdfPaint currentCol = null;
                                    PdfPaint fillCol = null;
                                    int text_fill_type = this.currentGraphicsState.getTextRenderType();
                                    if ((text_fill_type & 2) == 2) {
                                        fillCol = this.currentGraphicsState.getNonstrokeColor();
                                    }
                                    if ((text_fill_type & 1) == 1) {
                                        currentCol = this.currentGraphicsState.getStrokeColor();
                                    }
                                    Stroke newStroke = this.currentGraphicsState.getStroke();
                                    this.g2.setStroke(newStroke);
                                    this.current.renderText(text_fill_type, transformedGlyph2, this.g2, false, currentCol, fillCol, this.currentGraphicsState.getStrokeAlpha(), this.currentGraphicsState.getNonStrokeAlpha(), null);
                                } else {
                                    this.current.drawText(displayTrm, transformedGlyph2, this.currentGraphicsState);
                                }
                            }
                        }
                    }
                }
                if (this.legacyTextMode && this.textExtracted && !isCID && max_height < (h = PdfDecoder.currentHeightLookupData.getCharHeight(rawChar, fontSize))) {
                    max_height = h;
                }
                currentWidth += this.charSpacing;
                boolean bl = hasTextSpace = runningStoryPad && this.charSpacing / spaceWidth > 1.0f;
                if (rawChar == ' ') {
                    currentWidth += wordSpacing;
                }
                currentGap = width + this.charSpacing - lastWidth;
                String spaces = "";
                if (currentGap > 0.0f & lastWidth > 0.0f) {
                    float realGap = currentGap * fontScale;
                    if (runningStoryPad && realGap > 160.0f && fontSize > 11) {
                        if (this.currentRotation == 0) {
                            this.calcCoordinates(x, Trm, isHorizontal, max_height, fontSize, y);
                        } else {
                            this.calcCoordinates(x, TrmWithRotationRemoved, isHorizontal, max_height, fontSize, y);
                        }
                        if (isHorizontal) {
                            this.pdfData.addRawTextElement(this.charSpacing * 1000.0f, this.currentTextState.writingMode, this.font_as_string, this.currentFontData.getCurrentFontSpaceWidth(), this.currentTextState, this.x1, this.y1, this.x2 - realGap, this.y2, this.moveCommand, this.textData, this.tokenNumber, this.textLength, this.currentColor, this.currentRotation);
                        }
                        this.textData = new StringBuffer();
                        this.textLength = -1;
                        width = 0.0f;
                        x = this.x2;
                    } else {
                        spaces = this.getSpaces(currentGap, spaceWidth, currentThreshold);
                    }
                }
                ++this.textLength;
                lastWidth = width += currentWidth;
                if (this.textExtracted && unicodeValue.length() > 0) {
                    if (PdfDecoder.embedWidthData) {
                        float xx = Trm[2][0];
                        float yy = Trm[2][1];
                        if (this.currentRotation != 0) {
                            xx = TrmWithRotationRemoved[2][0];
                            yy = TrmWithRotationRemoved[2][1];
                        }
                        if (hasTextSpace && spaces.length() > 0) {
                            this.textData.append(StoryData.marker);
                            if (isHorizontal | PdfGroupingAlgorithms.oldTextExtraction) {
                                this.textData.append(xx - this.charSpacing * fontScale);
                            } else {
                                this.textData.append(yy - this.charSpacing * fontScale);
                            }
                            this.textData.append(StoryData.marker);
                            this.textData.append(this.charSpacing * fontScale);
                            this.textData.append(StoryData.marker);
                        }
                        this.textData.append(spaces);
                        if (isHorizontal | PdfGroupingAlgorithms.oldTextExtraction) {
                            this.textData.append(StoryData.marker);
                            this.textData.append(xx);
                            this.textData.append(StoryData.marker);
                        } else {
                            this.textData.append(StoryData.marker);
                            this.textData.append(yy);
                            this.textData.append(StoryData.marker);
                        }
                        if (hasTextSpace) {
                            this.textData.append((currentWidth - this.charSpacing) * fontScale);
                        } else {
                            this.textData.append(currentWidth * fontScale);
                        }
                        this.textData.append(StoryData.marker);
                    } else {
                        this.textData.append(spaces);
                    }
                    String current_value = unicodeValue;
                    int length = current_value.length();
                    int ii = 0;
                    while (ii < length) {
                        char next = current_value.charAt(ii);
                        if (!runningStoryPad || next != ' ' && next != '\n' && next != '\r') {
                            hasContent = true;
                        }
                        if (PdfDecoder.isXMLExtraction() && next == '<') {
                            this.textData.append("&lt;");
                        } else if (PdfDecoder.isXMLExtraction() && next == '>') {
                            this.textData.append("&gt;");
                        } else if (next > '\u001f') {
                            this.textData.append(next);
                        } else {
                            this.textData.append(hex[next]);
                        }
                        ++ii;
                    }
                } else {
                    this.textData.append(spaces);
                }
            } else if (rawChar == '(' | rawChar == '<') {
                inText = true;
                openChar = rawChar;
            } else if (rawChar == ')' || rawChar == '>' && openChar == '<' || !inText && (rawChar == '-' || rawChar >= '0' && rawChar <= '9')) {
                float value = 0.0f;
                ++i;
                while (stream[i] == 32) {
                    ++i;
                }
                char nextChar = (char)stream[i];
                if (nextChar == '(' | nextChar == '<') {
                    --i;
                } else if (nextChar != '\'' && nextChar != '\"' && nextChar != '(' && nextChar != ']' && nextChar != '<') {
                    StringBuffer currentLeading = new StringBuffer(6);
                    int leadingStart = i;
                    boolean failed = false;
                    boolean isMultipleValues = false;
                    while (!failed) {
                        rawChar = nextChar;
                        if (rawChar != '\n' && rawChar != '\r') {
                            currentLeading.append(rawChar);
                        }
                        if ((nextChar = (char)stream[i + 1]) == ' ') {
                            isMultipleValues = true;
                        }
                        if (nextChar == '(' | nextChar == '<') break;
                        if (!(nextChar == '-' | nextChar == '.' | nextChar == ' ' | Character.isDigit(nextChar))) {
                            failed = true;
                        }
                        ++i;
                    }
                    if (failed) {
                        i = leadingStart;
                    } else if (isMultipleValues) {
                        StringTokenizer values = new StringTokenizer(currentLeading.toString());
                        value = 0.0f;
                        while (values.hasMoreTokens()) {
                            value += Float.parseFloat(values.nextToken());
                        }
                        value = -value / 1000.0f;
                    } else if (currentLeading.length() > 0) {
                        value = -Float.parseFloat(currentLeading.toString()) / 1000.0f;
                    }
                }
                width += value;
                leading += value;
            }
            ++i;
        }
        temp[0][0] = 1.0f;
        temp[0][1] = 0.0f;
        temp[0][2] = 0.0f;
        temp[1][0] = 0.0f;
        temp[1][1] = 1.0f;
        temp[1][2] = 0.0f;
        temp[2][0] = currentWidth + leading;
        temp[2][1] = 0.0f;
        temp[2][2] = 1.0f;
        Trm = Matrix.multiply(temp, Trm);
        this.currentTextState.Tm[2][0] = Trm[2][0];
        this.currentTextState.Tm[2][1] = Trm[2][1];
        if (this.currentRotation != 0) {
            TrmWithRotationRemoved = Matrix.multiply(temp, TrmWithRotationRemoved);
            this.currentTextState.TmNoRotation[2][0] = TrmWithRotationRemoved[2][0];
            this.currentTextState.TmNoRotation[2][1] = TrmWithRotationRemoved[2][1];
        }
        if (this.textExtracted) {
            width -= this.charSpacing;
            if (lastTextChar == ' ') {
                Trm = TrmBeforeSpace;
                if (this.currentRotation != 0) {
                    TrmWithRotationRemoved = TrmBeforeSpaceWithRotationRemoved;
                }
            }
            if (this.currentRotation == 0) {
                this.calcCoordinates(x, Trm, isHorizontal, max_height, fontSize, y);
            } else {
                this.calcCoordinates(x, TrmWithRotationRemoved, isHorizontal, max_height, fontSize, y);
            }
            if (this.textData.length() == 0 || !hasContent) {
                this.textData = null;
            }
            this.currentTextState.writingMode = orientation;
            if (fontSize != this.lastFontSize || this.font_as_string == null) {
                this.currentTextState.setCurrentFontSize(Math.abs(fontSize));
                this.font_as_string = Fonts.createFontToken(this.currentFont, this.currentTextState.getCurrentFontSize());
                this.lastFontSize = fontSize;
            }
            if (runningStoryPad && !isHorizontal) {
                this.textData = null;
            }
            return this.textData;
        }
        return null;
    }

    private void calcCoordinates(float x, float[][] rawTrm, boolean horizontal, float max_height, int fontSize, float y) {
        float[][] trm = new float[3][3];
        int xx = 0;
        while (xx < 3) {
            System.arraycopy(rawTrm[xx], 0, trm[xx], 0, 3);
            ++xx;
        }
        this.x1 = x;
        this.x2 = trm[2][0] - this.charSpacing * trm[0][0];
        if (horizontal) {
            if (trm[1][0] < 0.0f) {
                this.x1 = x + trm[1][0] - this.charSpacing * trm[0][0];
                this.x2 = trm[2][0];
            } else if (trm[1][0] > 0.0f) {
                this.x1 = x;
                this.x2 = trm[2][0];
            }
        } else if (trm[1][0] > 0.0f) {
            this.x1 = trm[2][0];
            this.x2 = x + trm[1][0] - this.charSpacing * trm[0][0];
        } else if (trm[1][0] < 0.0f) {
            this.x2 = trm[2][0];
            this.x1 = x + trm[1][0] - this.charSpacing * trm[0][0];
        }
        if (horizontal) {
            float s_height = 1.0f;
            if (this.legacyTextMode || this.currentFontData.getFontType() == 3) {
                s_height = max_height / (float)fontSize;
            }
            if (trm[0][1] != 0.0f) {
                this.y1 = trm[2][1] - trm[0][1] + (trm[0][1] + trm[1][1]) * s_height;
                this.y2 = y;
            } else {
                this.y1 = y + trm[1][1] * s_height;
                this.y2 = trm[2][1];
            }
        } else if (trm[0][1] <= 0.0f) {
            this.y2 = trm[2][1];
            this.y1 = y;
        } else if (trm[0][1] > 0.0f) {
            this.y1 = trm[2][1];
            this.y2 = y;
        }
    }

    private final String getSpaces(float currentGap, float spaceWidth, float currentThreshold) {
        String space = "";
        if (spaceWidth > 0.0f) {
            if (currentGap > spaceWidth) {
                while (currentGap >= spaceWidth) {
                    space = String.valueOf(' ') + space;
                    currentGap -= spaceWidth;
                }
            } else if (currentGap > spaceWidth * currentThreshold) {
                space = String.valueOf(space) + ' ';
            }
        }
        return space;
    }

    private final int readEscapeValue(int start, int count, int base, byte[] characterStream) {
        StringBuffer chars = new StringBuffer();
        int pointer = 0;
        while (pointer < count) {
            chars.append((char)characterStream[start + pointer]);
            ++pointer;
        }
        return Integer.parseInt(chars.toString(), base);
    }

    public static String getFontsInFile() {
        return fontsInFile;
    }

    public void setDirectRendering(Graphics2D g2) {
        this.renderDirectly = true;
        this.g2 = g2;
        this.defaultClip = g2.getClip();
    }

    public boolean hasEmbeddedFonts() {
        return this.hasEmbeddedFonts;
    }

    public void includeImages() {
        this.includeImagesInData = true;
    }

    public PageLines getPageLines() {
        this.pageLines.lookForCompositeLines();
        return this.pageLines;
    }

    public boolean isPageSuccessful() {
        return this.pageSuccessful;
    }

    public String getPageFailureMessage() {
        return this.pageErrorMessages;
    }

    public void addPageFailureMessage(String value) {
        this.pageSuccessful = false;
        this.pageErrorMessages = String.valueOf(this.pageErrorMessages) + value + '\n';
    }

    public Map getFontMap() {
        return this.fonts;
    }

    public StringBuffer getlastTextStreamDecoded() {
        return this.textData;
    }

    public DynamicVectorRenderer getRenderer() {
        return this.current;
    }

    public void setTextPrint(int textPrint) {
        this.textPrint = textPrint;
    }

    public boolean exitedDecoding() {
        return this.exited;
    }

    public void terminateDecoding() {
        this.exited = false;
    }

    public static boolean isFormSupportAvailable() {
        return true;
    }

    public boolean hasAllImages() {
        return this.imagesProcessedFully;
    }

    public void setExternalImageRender(ImageHandler customImageHandler) {
        this.customImageHandler = customImageHandler;
        if (this.customImageHandler != null) {
            this.keepRaw = true;
        }
        if (customImageHandler != null && this.current != null) {
            this.current.setCustomImageHandler(customImageHandler);
        }
    }

    public void setMapForMarkedContent(Object pageStream) {
        this.markedContentExtracted = true;
        this.contentHandler = new StructuredContentHandler(pageStream);
    }
}

