/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.parser;

import org.jpedal.fonts.CIDFontType0;
import org.jpedal.fonts.CIDFontType2;
import org.jpedal.fonts.PdfFont;
import org.jpedal.fonts.TrueType;
import org.jpedal.fonts.Type1C;
import org.jpedal.fonts.Type3;
import org.jpedal.fonts.glyph.PdfGlyph;
import org.jpedal.fonts.glyph.T1Glyph;
import org.jpedal.fonts.glyph.T3Glyph;
import org.jpedal.fonts.tt.TTGlyph;
import org.jpedal.io.PdfObjectReader;
import org.jpedal.objects.GraphicsState;
import org.jpedal.utils.LogWriter;

public class FontFactory {
    public static PdfFont createFont(GraphicsState currentGraphicsState, String subtype, int fontType, PdfObjectReader currentPdfFile, String subFont) {
        if (fontType == 1) {
            return new Type1C(currentPdfFile, subFont);
        }
        if (fontType == 2) {
            return new TrueType(currentPdfFile, subFont);
        }
        if (fontType == 3) {
            return new Type3(currentPdfFile, currentGraphicsState);
        }
        if (fontType == 4) {
            return new CIDFontType0(currentPdfFile);
        }
        if (fontType == 5) {
            return new CIDFontType2(currentPdfFile);
        }
        LogWriter.writeLog("Font type " + subtype + " not supported");
        return new PdfFont(currentPdfFile);
    }

    public static PdfGlyph chooseGlpyh(int glyphType, Object rawglyph) {
        if (glyphType == 6) {
            return (T3Glyph)rawglyph;
        }
        if (glyphType == 5) {
            return (T1Glyph)rawglyph;
        }
        if (glyphType == 4) {
            return (TTGlyph)rawglyph;
        }
        return null;
    }
}

