/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.objects.structuredtext;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.jpedal.PdfDecoder;
import org.jpedal.io.PdfObjectReader;
import org.jpedal.objects.PageLookup;
import org.jpedal.objects.PdfAnnots;
import org.jpedal.utils.Strip;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class MarkedContentGenerator {
    Map markInfo;
    Map structTreeRoot;
    Map ClassMap;
    static final boolean XMLdebugFlag = false;
    private PdfObjectReader currentPdfFile;
    DocumentBuilder db = null;
    Document doc;
    Element root;
    PdfDecoder decode_pdf;
    static Map fields = new HashMap();
    Map pageStreams = new HashMap();

    static {
        fields.put("ID", "x");
        fields.put("T", "x");
        fields.put("Lang", "x");
        fields.put("Alt", "x");
        fields.put("E", "x");
        fields.put("ActualText", "x");
    }

    public Document getMarkedContentTree(PdfObjectReader currentPdfFile, PdfDecoder decode_pdf, PageLookup pageLookup) {
        this.currentPdfFile = currentPdfFile;
        this.decode_pdf = decode_pdf;
        this.setupTree();
        if (this.structTreeRoot != null && this.structTreeRoot.get("ParentTree") != null) {
            this.buildTree();
            this.pageStreams.clear();
        } else {
            System.out.println("assume single page to start with!!!!");
            HashMap pageStream = new HashMap();
            try {
                decode_pdf.decodePageForMarkedContent("1", this.doc);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return this.doc;
    }

    private void setupTree() {
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            this.db = dbf.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        this.doc = this.db.newDocument();
        this.doc.appendChild(this.doc.createComment(" Created from JPedal "));
        this.doc.appendChild(this.doc.createComment(" http://www.jpedal.org "));
    }

    private void buildTree() {
        this.root = this.doc.createElement("TaggedPDF-doc");
        this.doc.appendChild(this.root);
        Map RoleMap = this.getObjectAsMap("RoleMap", this.structTreeRoot);
        String IDTree = this.currentPdfFile.getValue((String)this.structTreeRoot.get("IDTree"));
        String ParentTree = (String)this.structTreeRoot.get("ParentTree");
        if (ParentTree.endsWith("R")) {
            Map value = this.currentPdfFile.readObject(ParentTree, false, null);
            ParentTree = (String)value.get("Nums");
        }
        Object K = this.structTreeRoot.get("K");
        this.ClassMap = this.getObjectAsMap("ClassMap", this.structTreeRoot);
        if (K != null) {
            if (K instanceof String) {
                String value = (String)K;
                if (value.endsWith(" R") && !value.startsWith("/")) {
                    Map dict = this.currentPdfFile.readObject(value, false, fields);
                    this.readChildNode(dict, this.root);
                } else if (value.startsWith("[")) {
                    String possRef = Strip.removeArrayDeleminators(value);
                    StringTokenizer count = new StringTokenizer(possRef);
                    while (count.hasMoreTokens()) {
                        StringBuffer ref = new StringBuffer();
                        int i = 0;
                        while (i < 3) {
                            ref.append(count.nextToken());
                            if (i != 2) {
                                ref.append(' ');
                            }
                            ++i;
                        }
                        String obj = ref.toString();
                        Map dict = this.currentPdfFile.readObject(obj, false, fields);
                        this.readChildNode(dict, this.root);
                    }
                }
            } else {
                this.readChildNode(K, this.root);
            }
        }
    }

    private void readChildNode(Object K, Element root) {
        boolean processed = false;
        if (K instanceof Map) {
            Map dict = (Map)K;
            for (Object nextKey : dict.keySet()) {
                if (nextKey.equals("S")) continue;
                K = this.checkClassMap(nextKey, dict);
            }
            if (dict.get("S") == null && dict.get("rawValue") != null) {
                K = dict.get("rawValue");
            } else {
                processed = true;
                try {
                    root = this.createChildNode(dict, root);
                }
                catch (Exception nextKey) {
                    // empty catch block
                }
            }
        }
        if (!processed && K instanceof String) {
            String possRef;
            StringTokenizer count;
            String value = (String)K;
            if (value.endsWith(" R") && !value.startsWith("/")) {
                Map dict = this.currentPdfFile.readObject(value, false, fields);
                this.readChildNode(dict, root);
            } else if (value.startsWith("[") && (count = new StringTokenizer(possRef = Strip.removeArrayDeleminators(value))).countTokens() == 3) {
                Map dict = this.currentPdfFile.readObject(possRef, false, fields);
                this.readChildNode(dict, root);
            }
        }
    }

    private Element createChildNode(Map mapK, Element root) throws Exception {
        String S = this.currentPdfFile.getValue((String)mapK.get("S"));
        mapK.remove("S");
        if (S != null && S.startsWith("/")) {
            S = S.substring(1);
        }
        if (S == null) {
            return null;
        }
        StringBuffer cleanedS = new StringBuffer();
        int length = S.length();
        int i = 0;
        while (i < length) {
            int c = S.charAt(i);
            if (c == 35) {
                StringBuffer num = new StringBuffer(2);
                int j = 0;
                while (j < 2) {
                    num.append(S.charAt(++i));
                    ++j;
                }
                c = (char)Integer.parseInt(num.toString(), 16);
                if (!Character.isLetterOrDigit((char)c)) {
                    c = 45;
                }
            }
            if (c == 32) {
                cleanedS.append('-');
            } else if (c == 45) {
                cleanedS.append((char)c);
            } else if (Character.isLetterOrDigit((char)c)) {
                cleanedS.append((char)c);
            }
            ++i;
        }
        S = cleanedS.toString();
        String Pg = (String)mapK.get("Pg");
        Map pageStream = null;
        if (Pg != null && (pageStream = (HashMap)this.pageStreams.get(Pg)) == null) {
            pageStream = new HashMap();
            try {
                this.decode_pdf.decodePageForMarkedContent(Pg, pageStream);
                this.pageStreams.put(Pg, pageStream);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        Element newRoot = null;
        newRoot = root;
        if (!S.equals("Span")) {
            String newValue;
            if (this.ClassMap == null || (newValue = (String)this.ClassMap.get(S)) != null) {
                // empty if block
            }
            if (mapK.get("K") != null) {
                newRoot = this.doc.createElement(S);
                root.appendChild(newRoot);
            }
        }
        Iterator keys = mapK.keySet().iterator();
        while (keys.hasNext()) {
            String nextKey = keys.next().toString();
            if (nextKey.equals("S") || nextKey.equals("P") || nextKey.equals("A") || nextKey.equals("T") || nextKey.equals("C") || nextKey.equals("Pg")) continue;
            if (nextKey.equals("K")) {
                String Kvalue = (String)mapK.get("K");
                if (Kvalue.indexOf(32) == -1) {
                    int mcid = Integer.parseInt(Kvalue);
                    String text = (String)pageStream.get(Kvalue);
                    if (text == null || text.length() <= 0) continue;
                    Text textNode = this.doc.createTextNode(text);
                    newRoot.appendChild(textNode);
                    continue;
                }
                if (Kvalue.indexOf(91) != -1) {
                    String deliminators = "<[ ]>";
                    StringTokenizer values = new StringTokenizer(Kvalue, "<[ ]>", true);
                    int Kcount = values.countTokens();
                    String[] Kvalues = new String[Kcount];
                    int currentItem = 0;
                    while (values.hasMoreTokens()) {
                        Kvalues[currentItem] = values.nextToken();
                        ++currentItem;
                    }
                    currentItem = 0;
                    while (currentItem < Kcount) {
                        String text;
                        if (Kvalues[currentItem].equals("<")) {
                            ++currentItem;
                            ++currentItem;
                            int mcid = -1;
                            String ref = "";
                            while (!Kvalues[currentItem].equals(">")) {
                                StringBuffer value;
                                if (Kvalues[currentItem].equals("/MCID")) {
                                    ++currentItem;
                                    mcid = Integer.parseInt(Kvalues[++currentItem]);
                                } else if (Kvalues[currentItem].equals("/Pg")) {
                                    currentItem += 2;
                                    value = new StringBuffer();
                                    int i2 = 0;
                                    while (i2 < 5) {
                                        value.append(Kvalues[currentItem]);
                                        ++currentItem;
                                        ++i2;
                                    }
                                    ref = value.toString();
                                } else if (Kvalues[currentItem].equals("/Obj")) {
                                    currentItem += 2;
                                    value = new StringBuffer();
                                    int i3 = 0;
                                    while (i3 < 5) {
                                        value.append(Kvalues[currentItem]);
                                        ++currentItem;
                                        ++i3;
                                    }
                                    Map obj = this.currentPdfFile.readObject(value.toString(), false, null);
                                    String type = null;
                                    if (obj.get("Type") != null) {
                                        type = (String)obj.get("Type");
                                    }
                                    if (obj.get("Subtype") != null) {
                                        type = (String)obj.get("Subtype");
                                    }
                                    if (type.equals("/Annot")) {
                                        PdfAnnots pdfAnnots = this.decode_pdf.getPdfAnnotsData(null);
                                    }
                                    type.equals("/Link");
                                }
                                ++currentItem;
                            }
                            if (mcid != -1) {
                                pageStream = (Map)this.pageStreams.get(ref);
                                if (pageStream == null) {
                                    pageStream = new HashMap();
                                    try {
                                        this.decode_pdf.decodePageForMarkedContent(ref, pageStream);
                                        this.pageStreams.put(Pg, pageStream);
                                    }
                                    catch (Exception e) {
                                        e.printStackTrace();
                                    }
                                }
                                text = (String)pageStream.get(String.valueOf(mcid));
                                Text textNode = this.doc.createTextNode(text);
                                newRoot.appendChild(textNode);
                            }
                            ++currentItem;
                        } else if ("<[ ]>".indexOf(Kvalues[currentItem]) == -1) {
                            boolean isRef;
                            boolean bl = isRef = Kcount - currentItem > 4 && Kvalues[currentItem + 4].equals("R");
                            if (!isRef) {
                                int mcid = Integer.parseInt(Kvalues[currentItem]);
                                text = (String)pageStream.get(String.valueOf(mcid));
                                Text textNode = this.doc.createTextNode(text);
                                newRoot.appendChild(textNode);
                            } else if (isRef) {
                                StringBuffer value = new StringBuffer();
                                int i4 = 0;
                                while (i4 < 5) {
                                    value.append(Kvalues[currentItem]);
                                    ++currentItem;
                                    ++i4;
                                }
                                Map objData = this.currentPdfFile.readObject(value.toString(), false, fields);
                                this.readChildNode(objData, newRoot);
                            }
                        }
                        ++currentItem;
                    }
                    continue;
                }
                if (Kvalue.indexOf(82) == -1) continue;
                this.readChildNode(Kvalue, newRoot);
                continue;
            }
            Object nextValue = mapK.get(nextKey);
            if (nextValue instanceof String) {
                newRoot.setAttribute(nextKey, (String)nextValue);
                continue;
            }
            if (!(nextValue instanceof byte[])) continue;
            String string = this.currentPdfFile.getTextString((byte[])nextValue);
            newRoot.setAttribute("xml:" + nextKey.toLowerCase(), string);
        }
        return newRoot;
    }

    private Object checkClassMap(Object key, Map values) {
        String name;
        Object realValue;
        Object value = values.get(key);
        if (value == null) {
            return values;
        }
        if (value instanceof String && this.ClassMap != null && (realValue = this.ClassMap.get(name = ((String)value).substring(1))) != null) {
            values.put(key, realValue);
        }
        return values;
    }

    private Map getObjectAsMap(String ID, Map map) {
        Map ClassMap = null;
        Object raw = this.structTreeRoot.get(ID);
        ClassMap = raw instanceof String ? this.currentPdfFile.readObject((String)raw, false, fields) : (Map)raw;
        return ClassMap;
    }

    public void setRootValues(Map structTreeRoot, Map markInfo) {
        this.structTreeRoot = structTreeRoot;
        this.markInfo = markInfo;
    }
}

