/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.objects.outlines;

import java.awt.Point;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.jpedal.io.PdfObjectReader;
import org.jpedal.objects.PageLookup;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.Strip;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class OutlineData {
    private Document OutlineDataXML;
    private float[] pagesTop;
    private Map pointLookupTable;
    private float[] pagesBottom;
    private String[] refTop;
    private String[] refBottom;
    private String[] lookup;
    private Map fields = new Hashtable();
    private Map keysUsedTable = new Hashtable();

    private OutlineData() {
    }

    public OutlineData(int pageCount) {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            this.OutlineDataXML = factory.newDocumentBuilder().newDocument();
        }
        catch (ParserConfigurationException e) {
            System.err.println("Exception " + e + " generating XML document");
        }
        this.fields.put("Title", "x");
        this.fields.put("Dest", "x");
        String[] keysUsed = new String[]{"Title", "Next", "Last"};
        int i = 0;
        while (i < keysUsed.length) {
            this.keysUsedTable.put(keysUsed[i], "x");
            ++i;
        }
        this.pagesTop = new float[++pageCount];
        this.pagesBottom = new float[pageCount];
        this.refTop = new String[pageCount];
        this.refBottom = new String[pageCount];
        this.lookup = new String[pageCount];
        this.pointLookupTable = new HashMap();
    }

    public Document getList() {
        return this.OutlineDataXML;
    }

    public int readOutlineFileMetadata(Object outlineObject, PdfObjectReader currentPdfFile, PageLookup pageLookup) {
        String startObj;
        LogWriter.writeMethod("{readOutlineFileMetadata " + outlineObject + '}', 0);
        int count = 0;
        Map values = outlineObject instanceof String ? currentPdfFile.readObject((String)outlineObject, false, null) : (Map)outlineObject;
        Object rawNumber = values.get("Count");
        if (rawNumber != null) {
            count = Integer.parseInt(currentPdfFile.getValue((String)rawNumber));
        }
        if ((startObj = (String)values.get("First")) != null) {
            Element root = this.OutlineDataXML.createElement("root");
            this.OutlineDataXML.appendChild(root);
            int level = 0;
            this.readOutlineLevel(root, currentPdfFile, pageLookup, startObj, level);
        }
        return count;
    }

    public String[] getDefaultBookmarksForPage() {
        return this.lookup;
    }

    private void readOutlineLevel(Element root, PdfObjectReader currentPdfFile, PageLookup pageLookup, String startObj, int level) {
        String convertedTitle = "";
        float coord = 0.0f;
        Element child = this.OutlineDataXML.createElement("title");
        while (true) {
            byte[] title;
            Map anchorObj;
            Object anchor;
            Map values = currentPdfFile.readObject(startObj, false, this.fields);
            String ID = startObj;
            coord = -1.0f;
            String nextObj = (String)values.get("Next");
            String endObj = (String)values.get("Last");
            startObj = (String)values.get("First");
            Object destStream = values.get("Dest");
            String rawDest = destStream != null ? (destStream instanceof byte[] ? currentPdfFile.getTextString((byte[])destStream) : (String)destStream) : null;
            if (rawDest != null && rawDest.startsWith("(")) {
                rawDest = rawDest.substring(1, rawDest.length() - 1);
                if ((rawDest = currentPdfFile.convertNameToRef(rawDest)).indexOf(91) == -1) {
                    Map parentObject = currentPdfFile.readObject(rawDest, false, this.fields);
                    rawDest = (String)parentObject.get("D");
                }
            }
            if ((anchor = values.get("A")) != null && (rawDest = (String)(anchorObj = anchor instanceof String ? currentPdfFile.readObject((String)anchor, false, this.fields) : (Map)anchor).get("D")) != null && rawDest.startsWith("(")) {
                HashMap<String, String> DField = new HashMap<String, String>();
                DField.put("D", "x");
                currentPdfFile.flushObjectCache();
                anchorObj = currentPdfFile.readObject((String)anchor, false, DField);
                byte[] newD = currentPdfFile.getByteTextStringValue(anchorObj.get("D"), DField);
                rawDest = currentPdfFile.getTextString(newD);
            }
            if ((title = currentPdfFile.getByteTextStringValue(values.get("Title"), this.fields)) != null) {
                convertedTitle = currentPdfFile.getTextString(title);
                child = this.OutlineDataXML.createElement("title");
                root.appendChild(child);
                child.setAttribute("title", convertedTitle);
                Iterator keyList = values.keySet().iterator();
                while (keyList.hasNext()) {
                    Object keyValue;
                    String currentKey = keyList.next().toString();
                    if (this.keysUsedTable.containsKey(currentKey) || (keyValue = values.get(currentKey)) == null || !(keyValue instanceof String)) continue;
                    child.setAttribute(currentKey, (String)keyValue);
                }
            }
            if (rawDest != null && rawDest.startsWith("(")) {
                Map destObj;
                if ((rawDest = currentPdfFile.convertNameToRef(rawDest)) != null && (destObj = currentPdfFile.readObject(rawDest, false, null)) != null) {
                    rawDest = (String)destObj.get("D");
                }
            } else if (rawDest != null) {
                Object indirectD;
                Map dData;
                String name = currentPdfFile.convertNameToRef(rawDest);
                if (name != null) {
                    Map destObj;
                    rawDest = name;
                    if (rawDest != null && rawDest.endsWith("R") && (destObj = currentPdfFile.readObject(rawDest, false, null)) != null) {
                        rawDest = (String)destObj.get("D");
                    }
                } else if (rawDest.endsWith(" R") && (dData = currentPdfFile.readObject(rawDest, false, null)) != null && dData instanceof Map && (indirectD = dData.get("D")) != null && indirectD instanceof String) {
                    rawDest = (String)indirectD;
                }
            }
            if (rawDest != null) {
                int p;
                Map newValue;
                String rawValue;
                String ref = "";
                int page = -1;
                if (rawDest.startsWith("[")) {
                    StringTokenizer destValues = new StringTokenizer(rawDest, "[]/ ");
                    if (destValues.countTokens() > 3) {
                        ref = String.valueOf(destValues.nextToken()) + ' ' + destValues.nextToken() + ' ' + destValues.nextToken();
                    }
                } else {
                    ref = rawDest;
                }
                if ((page = pageLookup.convertObjectToPageNumber(ref)) == -1 && (rawValue = (String)(newValue = currentPdfFile.readObject(ref, false, null)).get("rawValue")) != null && (p = (rawValue = Strip.removeArrayDeleminators(rawValue)).indexOf(" R")) != -1) {
                    ref = rawValue.substring(0, p + 2);
                    page = pageLookup.convertObjectToPageNumber(ref);
                    p = rawValue.indexOf("/FitH");
                    if (p != -1) {
                        String value = rawValue.substring(p + 5).trim();
                        coord = Float.parseFloat(value);
                    }
                }
                if (page != -1) {
                    child.setAttribute("page", String.valueOf(page));
                    child.setAttribute("level", String.valueOf(level));
                    child.setAttribute("objectRef", ID);
                    Integer pageInt = new Integer(page);
                    if (rawDest != null && rawDest.indexOf("/XYZ") != -1) {
                        String y;
                        StringTokenizer destValues = new StringTokenizer(rawDest = rawDest.substring(rawDest.indexOf("/XYZ") + 4), "[] ");
                        String x = destValues.nextToken();
                        if (x.equals("null")) {
                            x = "0";
                        }
                        if ((y = destValues.nextToken()).equals("null")) {
                            y = "0";
                        }
                        this.pointLookupTable.put(title, new Point((int)Float.parseFloat(x), (int)Float.parseFloat(y)));
                    }
                    if (this.refTop[page] == null) {
                        this.pagesTop[page] = coord;
                        this.refTop[page] = ID;
                        this.pagesBottom[page] = coord;
                        this.refBottom[page] = ID;
                    } else {
                        String lastRef = this.refTop[page];
                        float last = this.pagesTop[page];
                        if (last > coord && last != -1.0f) {
                            this.pagesTop[page] = coord;
                            this.refTop[page] = ID;
                        }
                        lastRef = this.refBottom[page];
                        last = this.pagesBottom[page];
                        if (last < coord && last != -1.0f) {
                            this.pagesBottom[page] = coord;
                            this.refBottom[page] = ID;
                        }
                    }
                }
            }
            if (startObj != null) {
                this.readOutlineLevel(child, currentPdfFile, pageLookup, startObj, level + 1);
            }
            if (nextObj == null) break;
            startObj = nextObj;
        }
    }
}

