/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.objects.acroforms.specificImplementations;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.SwingConstants;

public class FixImageIcon
extends ImageIcon
implements Icon,
SwingConstants {
    private static final long serialVersionUID = 8946195842453749725L;
    private int width = -1;
    private int height = -1;
    private Image image = null;

    public FixImageIcon(Image inImage) {
        this.image = inImage;
    }

    public void setWH(int newWidth, int newHeight) {
        this.width = newWidth;
        this.height = newHeight;
    }

    public int getIconHeight() {
        if (this.image == null) {
            return this.height;
        }
        if (this.height == -1) {
            return this.image.getHeight(null);
        }
        return this.height;
    }

    public int getIconWidth() {
        if (this.image == null) {
            return this.width;
        }
        if (this.width == -1) {
            return this.image.getWidth(null);
        }
        return this.width;
    }

    public Image getImage() {
        return this.image;
    }

    public void paintIcon(Component c, Graphics g, int x, int y) {
        if (this.image == null) {
            return;
        }
        if (c.isEnabled()) {
            g.setColor(c.getBackground());
        } else {
            g.setColor(Color.gray);
        }
        Graphics2D g2 = (Graphics2D)g;
        if (this.width > 0 && this.height > 0) {
            if (g2.getTransform().getShearX() < 0.0) {
                g2.rotate(-1.5707963267948966);
                g2.translate(-this.height, 0);
                g2.drawImage(this.image, 0, 0, this.height, this.width, null);
            } else {
                g2.drawImage(this.image, 0, 0, this.width, this.height, null);
            }
        } else {
            g2.drawImage(this.image, 0, 0, null);
        }
        g2.translate(-x, -y);
    }
}

