/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.objects.acroforms.specificImplementations;

import java.awt.Component;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import org.jpedal.objects.Javascript;
import org.jpedal.objects.acroforms.rendering.AcroRenderer;

public class CustomMouseListener
implements MouseListener {
    private static final boolean debugMouseActions = false;
    private static final boolean debugUnimplemented = false;
    private static final boolean debugXFAActions = false;
    private String command = "";
    private String ref = "";
    private Map enteredAction = null;
    private Map exitedAction = null;
    private Map hideAction = null;
    private Map clickedAction = null;
    private Map captionChanger = null;
    private int javascriptWhen;
    private String submitURL = null;
    private AcroRenderer acrorend;
    private Javascript javascript;

    public CustomMouseListener(String ref, String inCommand, AcroRenderer acrorenderer) {
        this.ref = ref;
        this.command = inCommand;
        this.acrorend = acrorenderer;
    }

    public CustomMouseListener(Map actionMap, String type, AcroRenderer acrorenderer) {
        if (type.equals("entered")) {
            this.enteredAction = actionMap;
        } else if (type.equals("exited")) {
            this.exitedAction = actionMap;
        } else if (type.equals("Hide")) {
            this.hideAction = actionMap;
        } else if (type.equals("Clicked")) {
            this.clickedAction = actionMap;
        }
        this.acrorend = acrorenderer;
    }

    public CustomMouseListener(Map dataMap, AcroRenderer acrorenderer) {
    }

    public CustomMouseListener(String normalCaption, String rolloverCaption, String downCaption) {
        this.captionChanger = new HashMap();
        if (rolloverCaption != null) {
            this.captionChanger.put("rollover", rolloverCaption);
        }
        if (downCaption != null) {
            this.captionChanger.put("down", downCaption);
        }
        this.captionChanger.put("normal", normalCaption);
    }

    public CustomMouseListener(int activity, String scriptType, String script, AcroRenderer acro) {
        if (script.indexOf("resetData") != -1) {
            this.command = "ResetForm";
            this.acrorend = acro;
        } else if (scriptType != null) {
            if (scriptType.indexOf("javascript") != -1) {
                int index = script.indexOf(40);
                this.javascriptWhen = activity;
            } else {
                scriptType.indexOf("submit");
            }
        }
    }

    public void mouseEntered(MouseEvent e) {
        String command;
        if (e.getSource() instanceof AbstractButton && this.captionChanger != null && this.captionChanger.containsKey("rollover")) {
            ((AbstractButton)e.getSource()).setText((String)this.captionChanger.get("rollover"));
        }
        if (this.command.equals("togglenoview")) {
            ((JComponent)e.getSource()).setVisible(true);
            ((JComponent)e.getSource()).repaint();
        } else if (this.command.equals("comboEntry")) {
            ((JComboBox)e.getSource()).showPopup();
        }
        if (this.enteredAction != null && (command = (String)this.enteredAction.get("command")).equals("/Hide")) {
            Object[] checkObj;
            String name = (String)this.enteredAction.get("fields");
            int start = 0;
            if (name.startsWith("(")) {
                ++start;
            }
            if ((checkObj = this.acrorend.getComponentsByName(name = name.substring(start, name.length() - start))) != null && checkObj[0] instanceof Component) {
                boolean hide = (Boolean)this.enteredAction.get("hide");
                Component swingComponent = (Component)checkObj[0];
                swingComponent.setVisible(!hide);
                swingComponent.repaint();
            }
        }
    }

    public void mouseExited(MouseEvent e) {
        String command;
        if (e.getSource() instanceof AbstractButton && this.captionChanger != null && this.captionChanger.containsKey("normal")) {
            ((AbstractButton)e.getSource()).setText((String)this.captionChanger.get("normal"));
        }
        if (this.command.equals("togglenoview")) {
            ((JComponent)e.getSource()).setVisible(false);
            ((JComponent)e.getSource()).repaint();
        } else if (this.command.equals("comboEntry")) {
            ((JComboBox)e.getSource()).hidePopup();
        }
        if (this.exitedAction != null && (command = (String)this.exitedAction.get("command")).equals("/Hide")) {
            Object[] checkObj;
            String name = (String)this.exitedAction.get("fields");
            int start = 0;
            if (name.startsWith("(")) {
                ++start;
            }
            if ((checkObj = this.acrorend.getComponentsByName(name = name.substring(start, name.length() - start))) != null && checkObj[0] instanceof Component) {
                boolean hide = (Boolean)this.exitedAction.get("hide");
                Component swingComponent = (Component)checkObj[0];
                swingComponent.setVisible(!hide);
                swingComponent.repaint();
            }
        }
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
        if (e.getSource() instanceof AbstractButton && this.captionChanger != null && this.captionChanger.containsKey("down")) {
            ((AbstractButton)e.getSource()).setText((String)this.captionChanger.get("down"));
        }
        if (!this.command.equals("comboEntry")) {
            this.command.length();
        }
    }

    public void mouseReleased(MouseEvent e) {
        if (e.getSource() instanceof AbstractButton && this.captionChanger != null) {
            if (this.captionChanger.containsKey("rollover")) {
                ((AbstractButton)e.getSource()).setText((String)this.captionChanger.get("rollover"));
            } else {
                ((AbstractButton)e.getSource()).setText((String)this.captionChanger.get("normal"));
            }
        }
        if (!this.command.equals("comboEntry") && !this.command.equals("ResetForm")) {
            this.command.length();
        }
    }
}

