/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.objects.acroforms.rendering;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jpedal.PdfDecoder;
import org.jpedal.exception.PdfException;
import org.jpedal.external.LinkHandler;
import org.jpedal.io.PdfObjectReader;
import org.jpedal.objects.Javascript;
import org.jpedal.objects.PdfAnnots;
import org.jpedal.objects.PdfFormData;
import org.jpedal.objects.PdfPageData;
import org.jpedal.objects.acroforms.actions.ActionHandler;
import org.jpedal.objects.acroforms.actions.DefaultActionHandler;
import org.jpedal.objects.acroforms.creation.DefaultFormFactory;
import org.jpedal.objects.acroforms.creation.FormFactory;
import org.jpedal.objects.acroforms.decoding.AnnotStream;
import org.jpedal.objects.acroforms.decoding.FormDecoder;
import org.jpedal.objects.acroforms.decoding.FormStream;
import org.jpedal.objects.acroforms.formData.FormObject;
import org.jpedal.objects.acroforms.formData.GUIData;
import org.jpedal.objects.acroforms.formData.SwingData;
import org.jpedal.objects.acroforms.rendering.AcroRenderer;

public class DefaultAcroRenderer
implements AcroRenderer {
    private static final boolean showFormsDecoded = false;
    private Map rawFormData = new HashMap();
    private List acroFormDataList;
    private static final boolean showMethods = false;
    private static final boolean identifyType = false;
    private static final boolean debug = false;
    private FormFactory formFactory;
    private GUIData compData = new SwingData();
    private Set sigObject = null;
    public static final int ANNOTATION = 1;
    public static final int FORM = 2;
    public static final int XFAFORM = 3;
    protected int formType = 0;
    private PdfPageData pageData;
    private int formCount = 0;
    private int fieldCount = 0;
    protected int pageCount = 0;
    private PdfObjectReader currentPdfFile;
    private FormDecoder formDecoder;
    private ActionHandler formsActionHandler;
    private LinkHandler linkHandler;
    private Javascript javascript;
    private int insetH;
    private Map formKids;

    public void resetHandler(Object userActionHandler, PdfDecoder decode_pdf, int type) {
        if (type == 5) {
            this.formsActionHandler = userActionHandler != null ? (ActionHandler)userActionHandler : new DefaultActionHandler();
            this.formsActionHandler.init(decode_pdf, this.currentPdfFile, this.javascript, this);
            if (this.formFactory != null) {
                this.formFactory.reset(this, this.formsActionHandler);
                this.compData.resetDuplicates();
            }
        } else if (type == 7) {
            this.linkHandler = userActionHandler != null ? (LinkHandler)userActionHandler : null;
        }
    }

    public void removeDisplayComponentsFromScreen() {
        if (this.compData != null) {
            this.compData.removeAllComponentsFromScreen();
        }
    }

    public void init(Object obj, int insetW, int insetH, PdfPageData pageData, PdfObjectReader currentPdfFile, Map formKids) {
        this.insetH = insetH;
        this.currentPdfFile = currentPdfFile;
        this.pageData = pageData;
        this.formKids = formKids;
        this.sigObject = null;
        boolean resetToEmpty = true;
        this.compData.setPageData(pageData, insetW, insetH);
        if (obj == null) {
            this.acroFormDataList = null;
            this.formCount = 0;
            this.fieldCount = 0;
        } else if (this.formType == 2) {
            PdfFormData acroFormData = (PdfFormData)obj;
            if (!acroFormData.hasXFAFormData()) {
                this.formDecoder = new FormStream(currentPdfFile);
            }
            this.acroFormDataList = acroFormData.getFormData();
            this.formCount = acroFormData.getTotalCount();
            this.fieldCount = this.acroFormDataList.size();
        } else if (this.formType == 1) {
            PdfAnnots annotData = (PdfAnnots)obj;
            this.formDecoder = new AnnotStream(currentPdfFile);
            this.acroFormDataList = annotData.getAnnotRawDataList();
            int size = this.acroFormDataList.size();
            this.formCount += size;
            this.fieldCount = size;
            resetToEmpty = false;
        }
        this.resetContainers(resetToEmpty);
    }

    protected void resetContainers(boolean resetToEmpty) {
        if (resetToEmpty) {
            if (this.formDecoder != null) {
                this.formDecoder.resetItems();
            }
            this.compData.resetComponents(this.formCount, this.pageCount, false);
        } else {
            this.compData.resetComponents(this.formCount, this.pageCount, true);
        }
        if (this.formFactory == null) {
            this.formFactory = new DefaultFormFactory(this, this.formsActionHandler);
        } else {
            this.formFactory.reset(this, this.formsActionHandler);
            this.compData.resetDuplicates();
        }
    }

    public void createDisplayComponentsForPage(int page) {
        if (this.compData.getStartComponentCountForPage(page) == -1) {
            this.compData.initParametersForPage(this.pageData, page);
            if (this.formsActionHandler != null) {
                this.formsActionHandler.setPageAccess(this.pageData.getMediaBoxHeight(page), this.insetH);
            }
            if (this.formType == 2) {
                this.formDecoder.resetItems();
            }
            boolean useXFA = this.formType == 3;
            FormObject[] xfaFormList = null;
            FormObject[] forms = new FormObject[this.fieldCount];
            FormObject formObject = null;
            Map currentField = null;
            int i = 0;
            int count = this.fieldCount;
            int fieldNum = this.fieldCount - 1;
            while (fieldNum > -1) {
                currentField = (Map)this.acroFormDataList.get(fieldNum);
                if (page == this.getPageForComponent(page, currentField) && (formObject = this.formDecoder.createAppearanceString(currentField, this.currentPdfFile, page)) != null) {
                    formObject.setPageNumber(page);
                    forms[i++] = formObject;
                    this.rawFormData.put(formObject.getFieldName(), formObject);
                }
                --fieldNum;
            }
            if (xfaFormList != null || !useXFA) {
                int k = 0;
                while (k < count) {
                    formObject = useXFA ? xfaFormList[k] : forms[k];
                    if (formObject != null && page == formObject.getPageNumber()) {
                        this.createField(formObject, this.compData.getNextFreeField(), false);
                    }
                    ++k;
                }
            }
            this.compData.completeFields(page);
        }
    }

    public Object getFormDataAsObject(String objectName) {
        return this.rawFormData.get(objectName);
    }

    private int getPageForComponent(int page, Map currentField) {
        Object kidData;
        int formPage = -1;
        Object rawPageNumber = this.currentPdfFile.resolveToMapOrString("PageNumber", currentField.get("PageNumber"));
        if (rawPageNumber != null) {
            formPage = Integer.parseInt((String)rawPageNumber);
        }
        if (formPage == -1 && this.formType == 1) {
            return page;
        }
        if (formPage == -1 && currentField.containsKey("Kids") && (kidData = this.currentPdfFile.resolveToMapOrString("Kids", currentField.get("Kids"))) instanceof Map) {
            Map kidMap = (Map)kidData;
            Iterator iter = kidMap.keySet().iterator();
            int val = 0;
            int kidPage = -1;
            while (iter.hasNext()) {
                Object kidPageNum;
                String key = (String)iter.next();
                Object data = this.currentPdfFile.resolveToMapOrString(key, kidMap.get(key));
                if (data instanceof Map && (kidPageNum = this.currentPdfFile.resolveToMapOrString("PageNumber", ((Map)data).get("PageNumber"))) != null) {
                    kidPage = Integer.parseInt((String)kidPageNum);
                }
                if (kidPage == page) {
                    formPage = kidPage;
                }
                ++val;
            }
        }
        return formPage;
    }

    public void displayComponentsOnscreen(int startPage, int endPage) {
        this.compData.displayComponents(startPage, ++endPage);
    }

    private void createField(FormObject formObject, int formNum, boolean isChildObject) {
        if (!isChildObject) {
            this.compData.resetButtonGroup();
        }
        Integer widgetType = FormFactory.UNKNOWN;
        Object retComponent = null;
        boolean button = false;
        boolean text = false;
        boolean choice = false;
        boolean signature = false;
        int typeFlag = formObject.getType();
        if (typeFlag != -1) {
            button = typeFlag == 0;
            text = typeFlag == 2;
            choice = typeFlag == 1;
            boolean bl = signature = typeFlag == 3;
        }
        if (signature) {
            if (this.sigObject == null) {
                this.sigObject = new HashSet();
            }
            this.sigObject.add(formObject);
        }
        boolean readOnly = false;
        boolean required = false;
        boolean noexport = false;
        boolean[] flags = formObject.getFieldFlags();
        if (flags != null) {
            readOnly = flags[1];
            required = flags[2];
            noexport = flags[3];
        }
        if (button) {
            boolean isPushButton = false;
            boolean isRadio = false;
            boolean hasNoToggleToOff = false;
            boolean radioinUnison = false;
            if (flags != null) {
                isPushButton = flags[16];
                isRadio = flags[15];
                hasNoToggleToOff = flags[14];
                radioinUnison = flags[25];
            }
            if (isPushButton) {
                widgetType = FormFactory.PUSHBUTTON;
                retComponent = this.formFactory.pushBut(formObject);
            } else {
                String parent;
                String ref;
                widgetType = isRadio ? FormFactory.RADIOBUTTON : FormFactory.CHECKBOXBUTTON;
                if (formObject.getKidData() != null) {
                    Map kidData = formObject.getKidData();
                    Iterator iter = kidData.keySet().iterator();
                    while (iter.hasNext()) {
                        this.createField((FormObject)kidData.get(iter.next()), ++formNum, true);
                    }
                }
                if ((ref = formObject.getPDFRef()) != null && (parent = (String)this.formKids.get(formObject.getPDFRef())) != null) {
                    formObject.setAnnotParent(parent);
                }
                retComponent = isRadio ? this.formFactory.radioBut(formObject) : this.formFactory.checkBoxBut(formObject);
            }
        } else if (text) {
            boolean isMultiline = false;
            boolean hasPassword = false;
            boolean doNotScroll = false;
            boolean richtext = false;
            boolean fileSelect = false;
            boolean doNotSpellCheck = false;
            if (flags != null) {
                isMultiline = flags[12];
                hasPassword = flags[13];
                doNotScroll = flags[23];
                richtext = flags[25];
                fileSelect = flags[20];
                doNotSpellCheck = flags[22];
            }
            if (isMultiline) {
                if (hasPassword) {
                    widgetType = FormFactory.MULTILINEPASSWORD;
                    retComponent = this.formFactory.multiLinePassword(formObject);
                } else {
                    widgetType = FormFactory.MULTILINETEXT;
                    retComponent = this.formFactory.multiLineText(formObject);
                }
            } else if (hasPassword) {
                widgetType = FormFactory.SINGLELINEPASSWORD;
                retComponent = this.formFactory.singleLinePassword(formObject);
            } else {
                widgetType = FormFactory.SINGLELINETEXT;
                retComponent = this.formFactory.singleLineText(formObject);
            }
        } else if (choice) {
            boolean isCombo = false;
            boolean multiSelect = false;
            boolean sort = false;
            boolean isEditable = false;
            boolean doNotSpellCheck = false;
            boolean comminOnSelChange = false;
            if (flags != null) {
                isCombo = flags[17];
                multiSelect = flags[21];
                sort = flags[19];
                isEditable = flags[18];
                doNotSpellCheck = flags[22];
                comminOnSelChange = flags[26];
            }
            if (isCombo) {
                widgetType = FormFactory.COMBOBOX;
                retComponent = this.formFactory.comboBox(formObject);
            } else {
                widgetType = FormFactory.LIST;
                retComponent = this.formFactory.listField(formObject);
            }
        } else if (signature) {
            widgetType = FormFactory.SIGNATURE;
            retComponent = this.formFactory.signature(formObject);
        } else if (this.formType == 1) {
            widgetType = FormFactory.ANNOTATION;
            retComponent = this.formFactory.annotationButton(formObject);
        }
        this.compData.completeField(formObject, formNum, isChildObject, widgetType, retComponent);
    }

    public void setJavaScriptObject(Javascript javascript, Object userExpressionEngine) {
        this.javascript = javascript;
        if (this.compData != null) {
            this.compData.setJavascript(javascript);
        }
    }

    public Object[] getComponentsByName(String objectName) {
        int p = 1;
        while (p < this.pageCount + 1) {
            this.createDisplayComponentsForPage(p);
            ++p;
        }
        return this.compData.getComponentsByName(objectName);
    }

    public List getComponentNameList() throws PdfException {
        if (this.fieldCount == 0) {
            return null;
        }
        int p = 1;
        while (p < this.pageCount + 1) {
            this.createDisplayComponentsForPage(p);
            ++p;
        }
        return this.getComponentNameList(-1);
    }

    public List getComponentNameList(int pageNumber) throws PdfException {
        if (this.fieldCount == 0) {
            return null;
        }
        return this.compData.getComponentNameList(pageNumber);
    }

    public void setFormFactory(FormFactory newFormFactory) {
        System.out.println("setFormFactory " + newFormFactory);
        this.formFactory = newFormFactory;
        this.compData = this.formFactory.getCustomCompData();
        this.compData.setJavascript(this.javascript);
    }

    public void openFile(int pageCount) {
        this.pageCount = pageCount;
        this.formType = 2;
        this.compData.reset();
        this.rawFormData.clear();
    }

    public Map getSignatureObject(String ref) {
        Map certObj = this.currentPdfFile.readObject(ref, false, null);
        Object sigRef = certObj.get("V");
        if (sigRef == null) {
            return null;
        }
        HashMap<String, String> fields = new HashMap<String, String>();
        fields.put("Name", "x");
        fields.put("Reason", "x");
        fields.put("Location", "x");
        fields.put("M", "x");
        fields.put("Cert", "x");
        certObj = sigRef instanceof String ? this.currentPdfFile.readObject((String)sigRef, false, fields) : (Map)sigRef;
        for (Object fieldName : fields.keySet()) {
            byte[] value = (byte[])certObj.get(fieldName);
            if (value == null || fieldName.equals("Cert")) continue;
            certObj.put(fieldName, this.currentPdfFile.getTextString(value));
        }
        return certObj;
    }

    public GUIData getCompData() {
        return this.compData;
    }

    public Iterator getSignatureObjects() {
        if (this.sigObject == null) {
            return null;
        }
        return this.sigObject.iterator();
    }

    public ActionHandler getActionHandler() {
        return this.formsActionHandler;
    }
}

