/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.objects.acroforms.formData;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.text.JTextComponent;
import org.jpedal.PdfPanel;
import org.jpedal.objects.acroforms.creation.FormFactory;
import org.jpedal.objects.acroforms.formData.ComponentData;
import org.jpedal.objects.acroforms.formData.FormObject;
import org.jpedal.objects.acroforms.formData.GUIData;
import org.jpedal.objects.acroforms.specificImplementations.FixImageIcon;
import org.jpedal.objects.acroforms.utils.FormUtils;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.Strip;

public class SwingData
extends ComponentData
implements GUIData {
    private Component[] allFields;
    private JScrollPane[] scroll;
    private ButtonGroup bg = new ButtonGroup();
    private JPanel panel;
    private Map annotBgs = new HashMap();

    public void loseFocus() {
        if (this.panel != null) {
            if (SwingUtilities.isEventDispatchThread()) {
                this.panel.grabFocus();
            } else {
                Runnable doPaintComponent = new Runnable(){

                    public void run() {
                        SwingData.this.panel.grabFocus();
                    }
                };
                SwingUtilities.invokeLater(doPaintComponent);
            }
        }
    }

    public void setFormType(String fieldName, Integer type) {
        this.typeValues.put(fieldName, type);
    }

    private Object[] getComponentsByName(String objectName, Object checkObj) {
        String duplicateComponents = (String)this.duplicates.get(objectName);
        int index = (Integer)checkObj;
        boolean moreToProcess = true;
        int firstIndex = index;
        while (moreToProcess) {
            if (index + 1 < this.allFields.length && this.allFields[index + 1] != null && FormUtils.removeStateToCheck(this.allFields[index + 1].getName(), false).equals(objectName)) {
                ++index;
                continue;
            }
            moreToProcess = false;
        }
        int size = index + 1 - firstIndex;
        Object[] compsToRet = new Component[size];
        int i = 0;
        while (i < size) {
            compsToRet[i] = this.allFields[firstIndex];
            if (firstIndex == index) break;
            ++i;
            ++firstIndex;
        }
        if (duplicateComponents != null && duplicateComponents.indexOf(44) != -1) {
            StringTokenizer additionalComponents = new StringTokenizer(duplicateComponents, ",");
            int count = additionalComponents.countTokens();
            Object[] origComponentList = compsToRet;
            compsToRet = new Component[size + count];
            System.arraycopy(origComponentList, 0, compsToRet, 0, size);
            int i2 = 0;
            while (i2 < count) {
                int ii = Integer.parseInt(additionalComponents.nextToken());
                compsToRet[i2 + size] = this.allFields[ii];
                ++i2;
            }
        }
        return compsToRet;
    }

    public Object getValue(Object objectName) {
        if (objectName == null) {
            return "";
        }
        Object retValue = "";
        Object checkObj = this.nameToCompIndex.get(objectName);
        retValue = this.getFormValue(checkObj);
        return retValue;
    }

    public void setValue(String name, Object value, boolean isValid, boolean isFormatted) {
        if (isValid) {
            this.lastValidValue.put(name, value);
        }
        if (isFormatted) {
            this.lastUnformattedValue.put(name, this.getValue(name));
        }
        Object checkObj = this.nameToCompIndex.get(name);
        this.setFormValue(value, checkObj);
    }

    public String getComponentName(int currentComp, ArrayList nameList, String lastName) {
        String currentName;
        Component currentField = this.allFields[currentComp];
        if (currentField != null && (currentName = FormUtils.removeStateToCheck(currentField.getName(), false)) != null && !lastName.equals(currentName)) {
            String previous = (String)this.duplicates.get(currentName);
            if (previous != null) {
                this.duplicates.put(currentName, String.valueOf(previous) + ',' + currentComp);
            } else {
                this.duplicates.put(currentName, String.valueOf(currentComp));
            }
            nameList.add(currentName);
            lastName = currentName;
        }
        return lastName;
    }

    public Object[] getComponentsByName(String objectName) {
        if (objectName == null) {
            return this.allFields;
        }
        Object checkObj = this.nameToCompIndex.get(objectName);
        if (checkObj == null) {
            return null;
        }
        if (checkObj instanceof Integer) {
            return this.getComponentsByName(objectName, checkObj);
        }
        LogWriter.writeLog("{stream} ERROR DefaultAcroRenderer.getComponentByName() Object NOT Integer and NOT null");
        return null;
    }

    public Object getFormValue(Object checkObj) {
        Object retValue = "";
        if (checkObj != null) {
            int index = (Integer)checkObj;
            retValue = this.allFields[index] instanceof JCheckBox ? Boolean.valueOf(((JCheckBox)this.allFields[index]).isSelected()) : (this.allFields[index] instanceof JComboBox ? ((JComboBox)this.allFields[index]).getSelectedItem() : (this.allFields[index] instanceof JList ? ((JList)this.allFields[index]).getSelectedValues() : (this.allFields[index] instanceof JRadioButton ? Boolean.valueOf(((JRadioButton)this.allFields[index]).isSelected()) : (this.allFields[index] instanceof JTextComponent ? ((JTextComponent)this.allFields[index]).getText() : ""))));
        }
        return retValue;
    }

    public void setFormValue(Object value, Object checkObj) {
        if (checkObj != null) {
            int index = (Integer)checkObj;
            if (this.allFields[index] instanceof JCheckBox) {
                ((JCheckBox)this.allFields[index]).setSelected(Boolean.valueOf((String)value));
            } else if (this.allFields[index] instanceof JComboBox) {
                ((JComboBox)this.allFields[index]).setSelectedItem(value);
            } else if (this.allFields[index] instanceof JList) {
                ((JList)this.allFields[index]).setSelectedValue(value, false);
            } else if (this.allFields[index] instanceof JRadioButton) {
                ((JRadioButton)this.allFields[index]).setText((String)value);
            } else if (this.allFields[index] instanceof JTextComponent) {
                ((JTextComponent)this.allFields[index]).setText((String)value);
            }
        }
    }

    public void showForms() {
        if (this.allFields != null) {
            int i = 0;
            while (i < this.allFields.length) {
                if (this.allFields[i] != null) {
                    this.allFields[i].setBackground(Color.green);
                    this.allFields[i].setForeground(Color.lightGray);
                    this.allFields[i].setVisible(true);
                    this.allFields[i].setEnabled(true);
                    ((JComponent)this.allFields[i]).setOpaque(true);
                    if (this.allFields[i] instanceof AbstractButton) {
                        if (!(this.allFields[i] instanceof JRadioButton)) {
                            ((AbstractButton)this.allFields[i]).setIcon(null);
                        }
                    } else if (this.allFields[i] instanceof JComboBox) {
                        ((JComboBox)this.allFields[i]).setEditable(false);
                    }
                }
                ++i;
            }
        }
    }

    public Object getWidget(Object objectName) {
        if (objectName == null) {
            return null;
        }
        Object checkObj = this.nameToCompIndex.get(objectName);
        if (checkObj == null) {
            return null;
        }
        int index = (Integer)checkObj;
        return this.allFields[index];
    }

    private void renderComponent(Graphics2D g2, int currentComp, Component comp, int rotation) {
        if (comp != null) {
            boolean editable = false;
            if (comp instanceof JComboBox) {
                if (((JComboBox)comp).isEditable()) {
                    editable = true;
                    ((JComboBox)comp).setEditable(false);
                }
                if (!UIManager.getLookAndFeel().isNativeLookAndFeel() && ((JComboBox)comp).getComponentCount() > 0) {
                    this.renderComponent(g2, currentComp, ((JComboBox)comp).getComponent(0), rotation);
                }
            }
            this.scaleComponent(this.currentPage, 1.0f, rotation, currentComp, comp, false);
            AffineTransform ax = g2.getTransform();
            g2.translate(comp.getBounds().x - this.insetW, comp.getBounds().y + this.cropOtherY);
            comp.paint(g2);
            g2.setTransform(ax);
            if (editable) {
                ((JComboBox)comp).setEditable(true);
            }
        }
    }

    public void renderFormsOntoG2(Object raw, int pageIndex, float scaling, int rotation) {
        AffineTransform defaultAf;
        Graphics2D g2;
        block13: {
            g2 = (Graphics2D)raw;
            defaultAf = g2.getTransform();
            AffineTransform aff = g2.getTransform();
            aff.scale(1.0, -1.0);
            aff.translate(0.0, -this.pageHeight - this.insetH);
            g2.setTransform(aff);
            try {
                int currentComp = this.trackPagesRendered[pageIndex];
                Component[] formComps = this.allFields;
                if (formComps == null || currentComp == -1) break block13;
                JPanel dummyPanel = new JPanel();
                int tempIndent = this.indent;
                this.indent = 0;
                while (this.pageMap.length > currentComp && this.pageMap[currentComp] == pageIndex) {
                    Component comp = formComps[currentComp];
                    if (comp != null && comp.isVisible()) {
                        float boundHeight = this.boundingBoxs[currentComp][3] - this.boundingBoxs[currentComp][1];
                        int swingHeight = comp.getPreferredSize().height;
                        if (comp instanceof JList && ((JList)comp).getSelectedIndex() != -1 && boundHeight < (float)swingHeight) {
                            JList comp2 = (JList)comp;
                            dummyPanel.add(comp);
                            ListModel model = comp2.getModel();
                            Object[] array = new Object[model.getSize()];
                            int selectedIndex = comp2.getSelectedIndex();
                            int c = 0;
                            array[c++] = model.getElementAt(selectedIndex);
                            int i = 0;
                            while (i < array.length) {
                                if (i != selectedIndex) {
                                    array[c++] = model.getElementAt(i);
                                }
                                ++i;
                            }
                            comp2.setListData(array);
                            comp2.setSelectedIndex(0);
                            try {
                                this.renderComponent(g2, currentComp, comp2, rotation);
                                dummyPanel.remove(comp2);
                            }
                            catch (Exception exception) {}
                        } else {
                            dummyPanel.add(comp);
                            try {
                                this.renderComponent(g2, currentComp, comp, rotation);
                                dummyPanel.remove(comp);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    }
                    if (++currentComp == this.pageMap.length) break;
                }
                this.indent = tempIndent;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        g2.setTransform(defaultAf);
        if (this.currentPage == pageIndex && this.panel != null) {
            this.resetScaledLocation(this.displayScaling, rotation, this.indent);
        }
    }

    private void setField(Component nextComp, int formPage, float scaling, int rotation) {
        String curCompName = FormUtils.removeStateToCheck(nextComp.getName(), false);
        if (curCompName != null && !this.lastNameAdded.equals(curCompName)) {
            this.nameToCompIndex.put(curCompName, new Integer(this.nextFreeField));
            this.lastNameAdded = curCompName;
        }
        if (nextComp != null) {
            Rectangle rect = nextComp.getBounds();
            if (rect != null) {
                this.boundingBoxs[this.nextFreeField][0] = rect.x;
                this.boundingBoxs[this.nextFreeField][1] = rect.y;
                this.boundingBoxs[this.nextFreeField][2] = rect.width + rect.x;
                this.boundingBoxs[this.nextFreeField][3] = rect.height + rect.y;
            }
            this.allFields[this.nextFreeField] = nextComp;
            this.scroll[this.nextFreeField] = null;
            this.fontSize[this.nextFreeField] = this.fontSizes[this.nextFreeField];
            this.firstTimeDisplayed[this.nextFreeField] = true;
            this.scaleComponent(formPage, scaling, rotation, this.nextFreeField, nextComp, true);
        }
        this.pageMap[this.nextFreeField] = formPage;
        ++this.nextFreeField;
    }

    private void scaleComponent(int currentPage, float scaling, int rotation, int i, Component comp, boolean repaint) {
        if (comp == null) {
            return;
        }
        int x = 0;
        int y = 0;
        int w = 0;
        int h = 0;
        int cropOtherX = this.pageData.getMediaBoxWidth(currentPage) - this.pageData.getCropBoxWidth(currentPage) - this.pageData.getCropBoxX(currentPage);
        if (rotation == 0) {
            int crx = this.pageData.getCropBoxX(currentPage);
            float x100 = this.boundingBoxs[i][0] - (float)crx + (float)this.insetW;
            if (!repaint) {
                x100 += (float)crx;
            }
            float y100 = (float)this.pageData.getMediaBoxHeight(currentPage) - this.boundingBoxs[i][3] - (float)this.cropOtherY + (float)this.insetH;
            float w100 = this.boundingBoxs[i][2] - this.boundingBoxs[i][0];
            float h100 = this.boundingBoxs[i][3] - this.boundingBoxs[i][1];
            x = (int)((x100 - (float)this.insetW) * scaling + (float)this.insetW);
            y = (int)((y100 - (float)this.insetH) * scaling + (float)this.insetH);
            w = (int)(w100 * scaling);
            h = (int)(h100 * scaling);
        } else if (rotation == 90) {
            float x100 = this.boundingBoxs[i][1] - (float)this.pageData.getCropBoxY(currentPage) + (float)this.insetW;
            float y100 = this.boundingBoxs[i][0] - (float)this.pageData.getCropBoxX(currentPage) + (float)this.insetH;
            float w100 = this.boundingBoxs[i][3] - this.boundingBoxs[i][1];
            float h100 = this.boundingBoxs[i][2] - this.boundingBoxs[i][0];
            x = (int)((x100 - (float)this.insetH) * scaling + (float)this.insetH);
            y = (int)((y100 - (float)this.insetW) * scaling + (float)this.insetW);
            w = (int)(w100 * scaling);
            h = (int)(h100 * scaling);
        } else if (rotation == 180) {
            int x100 = (int)((float)this.pageData.getMediaBoxWidth(currentPage) - this.boundingBoxs[i][2] - (float)cropOtherX) + this.insetW;
            int y100 = (int)(this.boundingBoxs[i][1] - (float)this.pageData.getCropBoxY(currentPage)) + this.insetH;
            int w100 = (int)(this.boundingBoxs[i][2] - this.boundingBoxs[i][0]);
            int h100 = (int)(this.boundingBoxs[i][3] - this.boundingBoxs[i][1]);
            x = (int)((float)(x100 - this.insetW) * scaling + (float)this.insetW);
            y = (int)((float)(y100 - this.insetH) * scaling + (float)this.insetH);
            w = (int)((float)w100 * scaling);
            h = (int)((float)h100 * scaling);
        } else if (rotation == 270) {
            float x100 = (float)this.pageData.getMediaBoxHeight(currentPage) - this.boundingBoxs[i][3] - (float)this.cropOtherY + (float)this.insetW;
            float y100 = (float)this.pageData.getMediaBoxWidth(currentPage) - this.boundingBoxs[i][2] - (float)cropOtherX + (float)this.insetH;
            float w100 = this.boundingBoxs[i][3] - this.boundingBoxs[i][1];
            float h100 = this.boundingBoxs[i][2] - this.boundingBoxs[i][0];
            x = (int)((x100 - (float)this.insetH) * scaling + (float)this.insetH);
            y = (int)((y100 - (float)this.insetW) * scaling + (float)this.insetW);
            w = (int)(w100 * scaling);
            h = (int)(h100 * scaling);
        }
        Font resetFont = comp.getFont();
        if (resetFont != null) {
            int size;
            int rawSize = this.fontSize[i];
            if (rawSize == -1) {
                rawSize = 8;
            }
            if (rawSize == 0) {
                int len;
                String text;
                int height = (int)(this.boundingBoxs[i][3] - this.boundingBoxs[i][1]);
                int width = (int)(this.boundingBoxs[i][2] - this.boundingBoxs[i][0]);
                if (rotation == 90 || rotation == 270) {
                    int tmp = height;
                    height = width;
                    width = tmp;
                }
                rawSize = height = (int)((double)height * 0.85);
                if (comp instanceof JTextComponent) {
                    int len2 = ((JTextComponent)comp).getText().length();
                    if (len2 * height / 2 > width) {
                        if (len2 > 0) {
                            width /= len2;
                        }
                        rawSize = width;
                    }
                } else if (comp instanceof JButton && (text = ((JButton)comp).getText()) != null && (len = text.length()) * height / 2 > width) {
                    if (len > 0) {
                        width /= len;
                    }
                    rawSize = width;
                }
            }
            if ((size = (int)((float)rawSize * scaling)) < 1) {
                size = 1;
            }
            Font newFont = new Font(resetFont.getFontName(), resetFont.getStyle(), size);
            comp.setFont(newFont);
            if (this.xReached != null) {
                x += this.xReached[currentPage];
                y += this.yReached[currentPage];
            }
            comp.setBounds(this.indent + x, y, w, h);
        }
        if (comp != null && comp instanceof AbstractButton) {
            AbstractButton but = (AbstractButton)comp;
            Icon curIcon = but.getIcon();
            if (curIcon instanceof FixImageIcon) {
                ((FixImageIcon)curIcon).setWH(comp.getWidth(), comp.getHeight());
            }
            if ((curIcon = but.getPressedIcon()) instanceof FixImageIcon) {
                ((FixImageIcon)curIcon).setWH(comp.getWidth(), comp.getHeight());
            }
            if ((curIcon = but.getSelectedIcon()) instanceof FixImageIcon) {
                ((FixImageIcon)curIcon).setWH(comp.getWidth(), comp.getHeight());
            }
            if ((curIcon = but.getRolloverIcon()) instanceof FixImageIcon) {
                ((FixImageIcon)curIcon).setWH(comp.getWidth(), comp.getHeight());
            }
            if ((curIcon = but.getRolloverSelectedIcon()) instanceof FixImageIcon) {
                ((FixImageIcon)curIcon).setWH(comp.getWidth(), comp.getHeight());
            }
        }
    }

    public void resetComponents(int formCount, int pageCount, boolean keepValues) {
        super.resetComponents(formCount, pageCount, keepValues);
        if (!keepValues) {
            this.scroll = new JScrollPane[formCount + 1];
            this.allFields = new Component[formCount + 1];
        } else {
            JScrollPane[] tmpScroll = this.scroll;
            Component[] tmpFields = this.allFields;
            this.allFields = new Component[formCount + 1];
            this.scroll = new JScrollPane[formCount + 1];
            int origSize = tmpFields.length;
            int i = 0;
            while (i < formCount + 1) {
                if (i == origSize) break;
                this.allFields[i] = tmpFields[i];
                this.scroll[i] = tmpScroll[i];
                ++i;
            }
        }
        this.annotBgs.clear();
    }

    public void removeAllComponentsFromScreen() {
        if (this.panel != null) {
            if (SwingUtilities.isEventDispatchThread()) {
                this.panel.removeAll();
            } else {
                Runnable doPaintComponent = new Runnable(){

                    public void run() {
                        SwingData.this.panel.removeAll();
                    }
                };
                SwingUtilities.invokeLater(doPaintComponent);
            }
        }
    }

    public void setRootDisplayComponent(final Object rootComp) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.panel = (JPanel)rootComp;
        } else {
            Runnable doPaintComponent = new Runnable(){

                public void run() {
                    SwingData.this.panel = (JPanel)rootComp;
                }
            };
            SwingUtilities.invokeLater(doPaintComponent);
        }
    }

    public void completeFields(int page) {
        if (this.additionFieldsMap.get(String.valueOf(page)) != null) {
            ArrayList list = (ArrayList)this.additionFieldsMap.get(String.valueOf(page));
            Iterator iter = list.iterator();
            while (iter.hasNext()) {
                this.setField((Component)iter.next(), page, this.scaling, this.rotation);
            }
        }
    }

    public void completeField(FormObject formObject, int formNum, boolean isChildObject, Integer formType, Object rawField) {
        Rectangle rect;
        if (rawField == null) {
            return;
        }
        Component retComponent = (Component)rawField;
        String fieldName = formObject.getFieldName();
        int formPage = formObject.getPageNumber();
        String name = fieldName;
        if (name != null) {
            String stateToCheck = formObject.getStateTocheck();
            if (stateToCheck != null && stateToCheck.length() > 0) {
                name = String.valueOf(name) + "-(" + stateToCheck + ')';
            }
            retComponent.setName(name);
        }
        if ((rect = formObject.getBoundingRectangle()) != null) {
            retComponent.setBounds(rect);
        }
        String defaultValue = formObject.getDefaultValue();
        defaultValue = formObject.getValuesMap() != null ? (String)formObject.getValuesMap().get(Strip.checkRemoveLeadingSlach(defaultValue)) : Strip.checkRemoveLeadingSlach(defaultValue);
        this.fontSizes[formNum] = formObject.getTextSize();
        this.defaultValues[formNum] = defaultValue;
        if (formType.equals(FormFactory.UNKNOWN)) {
            this.typeValues.put(fieldName, FormFactory.ANNOTATION);
        } else {
            this.typeValues.put(fieldName, formType);
        }
        if (isChildObject) {
            try {
                AbstractButton but = (AbstractButton)retComponent;
                but.setBounds(formObject.getBoundingRectangle());
                but.setText(String.valueOf(formObject.getPageNumber()));
                this.bg.add(but);
            }
            catch (ClassCastException but) {}
        } else if (this.bg.getButtonCount() > 1) {
            AbstractButton[] sortedButtons = FormUtils.sortGroupSmallestFirst(this.bg);
            int j = 0;
            while (j < this.bg.getButtonCount()) {
                ArrayList list;
                if (sortedButtons[j].getLabel().equals(String.valueOf(formPage))) {
                    String currentState = formObject.getCurrentState();
                    String onState = formObject.getOnState();
                    if (currentState != null && currentState.equals(FormUtils.removeStateToCheck(sortedButtons[j].getName(), true)) || onState != null && onState.equals(FormUtils.removeStateToCheck(sortedButtons[j].getName(), true))) {
                        sortedButtons[j].setSelected(true);
                    }
                    this.setField(sortedButtons[j], formPage, this.scaling, this.rotation);
                } else if (this.additionFieldsMap.get(sortedButtons[j].getLabel()) != null) {
                    list = (ArrayList)this.additionFieldsMap.get(sortedButtons[j].getLabel());
                    list.add(sortedButtons[j]);
                    this.additionFieldsMap.put(sortedButtons[j].getLabel(), list);
                } else {
                    list = new ArrayList();
                    list.add(sortedButtons[j]);
                    this.additionFieldsMap.put(sortedButtons[j].getLabel(), list);
                }
                ++j;
            }
        } else if (retComponent != null) {
            String annotLink;
            if (formObject.getFieldFlags()[14] && retComponent instanceof AbstractButton) {
                AbstractButton but = (AbstractButton)retComponent;
                but.setBounds(formObject.getBoundingRectangle());
                but.setText(String.valueOf(formObject.getPageNumber()));
                new ButtonGroup().add(but);
            }
            if ((annotLink = formObject.getAnnotParent()) != null) {
                ButtonGroup annotBg;
                Object currentBg = this.annotBgs.get(annotLink);
                if (currentBg == null) {
                    annotBg = new ButtonGroup();
                    this.annotBgs.put(annotLink, annotBg);
                } else {
                    annotBg = (ButtonGroup)currentBg;
                }
                try {
                    if (retComponent instanceof AbstractButton) {
                        AbstractButton but = (AbstractButton)retComponent;
                        but.setBounds(formObject.getBoundingRectangle());
                        but.setText(String.valueOf(formObject.getPageNumber()));
                        annotBg.add(but);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.setField(retComponent, formPage, this.scaling, this.rotation);
        }
    }

    private void removePageRangeFromDisplay(int start, int end, PdfPanel panel) {
        try {
            int page = start;
            while (page < end) {
                int currentComp = this.trackPagesRendered[page];
                if (currentComp != -1) {
                    while (this.pageMap[currentComp] >= start && this.pageMap[currentComp] <= end) {
                        if (this.allFields[currentComp] != null) {
                            panel.remove(this.allFields[currentComp]);
                        }
                        if (++currentComp == this.pageMap.length) break;
                    }
                }
                ++page;
            }
        }
        catch (Exception ee) {
            ee.printStackTrace();
            System.exit(1);
        }
    }

    public void resetScaledLocation(float scaling, int rotation, int indent) {
        this.indent = indent;
        this.displayScaling = scaling;
        this.rotation = rotation;
        if (this.trackPagesRendered == null) {
            return;
        }
        if (scaling != this.lastScaling || (float)rotation != this.oldRotation || (float)indent != this.oldIndent) {
            this.oldRotation = rotation;
            this.lastScaling = scaling;
            this.oldIndent = indent;
            int currentComp = this.startPage < this.trackPagesRendered.length ? this.trackPagesRendered[this.startPage] : 0;
            if (this.allFields != null && this.currentPage > 0 && currentComp != -1 && this.pageMap.length > currentComp) {
                while (currentComp < this.pageMap.length && currentComp > -1 && this.pageMap[currentComp] >= this.startPage && this.pageMap[currentComp] < this.endPage && this.allFields[currentComp] != null) {
                    Runnable doPaintComponent;
                    if (this.panel != null) {
                        if (SwingUtilities.isEventDispatchThread()) {
                            if (this.scroll[currentComp] == null) {
                                this.panel.remove(this.allFields[currentComp]);
                            } else {
                                this.panel.remove(this.scroll[currentComp]);
                            }
                            this.scaleComponent(this.pageMap[currentComp], scaling, rotation, currentComp, this.allFields[currentComp], true);
                        } else {
                            final int id = currentComp;
                            final float s = scaling;
                            final int r = rotation;
                            doPaintComponent = new Runnable(){

                                public void run() {
                                    if (SwingData.this.scroll[id] == null) {
                                        SwingData.this.panel.remove(SwingData.this.allFields[id]);
                                    } else {
                                        SwingData.this.panel.remove(SwingData.this.scroll[id]);
                                    }
                                    SwingData.this.scaleComponent(SwingData.this.pageMap[id], s, r, id, SwingData.this.allFields[id], true);
                                }
                            };
                            SwingUtilities.invokeLater(doPaintComponent);
                        }
                    }
                    if (this.panel != null) {
                        float boundHeight = this.boundingBoxs[currentComp][3] - this.boundingBoxs[currentComp][1];
                        int swingHeight = this.allFields[currentComp].getPreferredSize().height;
                        if (this.allFields[currentComp] instanceof JList && boundHeight < (float)swingHeight) {
                            JList comp = (JList)this.allFields[currentComp];
                            if (this.scroll[currentComp] != null) {
                                this.scroll[currentComp].remove(comp);
                            }
                            this.scroll[currentComp] = new JScrollPane(comp);
                            this.scroll[currentComp].setVerticalScrollBarPolicy(20);
                            this.scroll[currentComp].setHorizontalScrollBarPolicy(30);
                            this.scroll[currentComp].setLocation(comp.getLocation());
                            this.scroll[currentComp].setPreferredSize(comp.getPreferredSize());
                            this.scroll[currentComp].setSize(comp.getSize());
                            int index = comp.getSelectedIndex();
                            if (index > -1) {
                                comp.ensureIndexIsVisible(index);
                            }
                            if (SwingUtilities.isEventDispatchThread()) {
                                this.panel.add(this.scroll[currentComp]);
                            } else {
                                final int id = currentComp;
                                Runnable doPaintComponent2 = new Runnable(){

                                    public void run() {
                                        SwingData.this.panel.add(SwingData.this.scroll[id]);
                                    }
                                };
                                SwingUtilities.invokeLater(doPaintComponent2);
                            }
                        } else if (SwingUtilities.isEventDispatchThread()) {
                            this.panel.add(this.allFields[currentComp]);
                        } else {
                            final int id = currentComp;
                            doPaintComponent = new Runnable(){

                                public void run() {
                                    SwingData.this.panel.add(SwingData.this.allFields[id]);
                                }
                            };
                            SwingUtilities.invokeLater(doPaintComponent);
                        }
                    }
                    ++currentComp;
                }
            }
        }
    }

    public void displayComponents(int startPage, int endPage) {
        if (this.panel == null) {
            return;
        }
        this.startPage = startPage;
        this.endPage = endPage;
        int page = startPage;
        while (page < endPage) {
            int currentComp = this.getStartComponentCountForPage(page);
            if (this.pageMap.length <= currentComp) {
                return;
            }
            if (currentComp != -1 && currentComp != -999 && startPage > 0 && endPage > 0) {
                while (this.pageMap[currentComp] >= startPage && this.pageMap[currentComp] < endPage) {
                    if (this.allFields[currentComp] != null) {
                        if (SwingUtilities.isEventDispatchThread()) {
                            this.scaleComponent(this.pageMap[currentComp], this.scaling, this.rotation, currentComp, this.allFields[currentComp], true);
                            this.panel.add(this.allFields[currentComp]);
                        } else {
                            final int id = currentComp;
                            Runnable doPaintComponent = new Runnable(){

                                public void run() {
                                    SwingData.this.scaleComponent(SwingData.this.pageMap[id], SwingData.this.scaling, SwingData.this.rotation, id, SwingData.this.allFields[id], true);
                                    SwingData.this.panel.add(SwingData.this.allFields[id]);
                                }
                            };
                            SwingUtilities.invokeLater(doPaintComponent);
                        }
                        String currentName = FormUtils.removeStateToCheck(this.allFields[currentComp].getName(), false);
                        this.firstTimeDisplayed[currentComp] = false;
                    }
                    if (++currentComp == this.pageMap.length) break;
                }
            }
            ++page;
        }
    }

    public void reportError(int code, Object[] args) {
        if (code == 1) {
            JOptionPane.showMessageDialog(this.panel, "The values entered does not match the format of the field [" + args[0] + " ]", "Warning: Javascript Window", 1);
        } else if (code == 2) {
            JOptionPane.showMessageDialog(this.panel, "Invalid date/time: please ensure that the date/time exists. Field [" + args[0] + " ] should match format " + args[1], "Warning: Javascript Window", 1);
        } else if (code == 3) {
            StringBuffer message = new StringBuffer("Invalid value: must be greater than ");
            if (args[1].equals("true")) {
                message.append("or equal to ");
            }
            message.append(args[2]);
            message.append("\nand less than ");
            if (args[3].equals("true")) {
                message.append("or equal to ");
            }
            message.append(args[4]);
            message.append('.');
            JOptionPane.showMessageDialog(this.panel, message.toString(), "Warning: Javascript Window", 1);
        } else {
            JOptionPane.showMessageDialog(this.panel, "The values entered does not match the format of the field", "Warning: Javascript Window", 1);
        }
    }

    public void resetButtonGroup() {
        this.bg = new ButtonGroup();
    }

    public List getComponentNameList(int pageNumber) {
        if (this.trackPagesRendered == null) {
            return null;
        }
        if (pageNumber != -1 && this.trackPagesRendered[pageNumber] == -1) {
            return null;
        }
        int currentComp = pageNumber == -1 ? 0 : this.trackPagesRendered[pageNumber];
        ArrayList nameList = new ArrayList();
        String lastName = "";
        String currentName = "";
        while (pageNumber == -1 || this.pageMap[currentComp] == pageNumber) {
            lastName = this.getComponentName(currentComp, nameList, lastName);
            if (++currentComp == this.pageMap.length) break;
        }
        return nameList;
    }

    public void execute(Map codeMap) {
        if (((String)codeMap.get("S")).indexOf("Hide") != -1) {
            String fieldName = (String)codeMap.get("T");
            String hideVal = (String)codeMap.get("H");
            boolean show = hideVal == null ? false : Boolean.valueOf(hideVal) == false;
            Component[] fields = (Component[])this.getComponentsByName(fieldName);
            int i = 0;
            while (i < fields.length) {
                fields[i].setVisible(show);
                ++i;
            }
        }
    }
}

