/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.objects.acroforms.formData;

import java.util.HashMap;
import java.util.Map;
import org.jpedal.objects.Javascript;
import org.jpedal.objects.PdfPageData;
import org.jpedal.objects.acroforms.creation.FormFactory;

public class ComponentData {
    protected int insetW;
    protected int insetH;
    protected PdfPageData pageData;
    protected Javascript javascript;
    protected int pageHeight;
    protected int cropOtherY;
    protected int indent;
    protected float displayScaling;
    protected float scaling = 0.0f;
    protected int rotation;
    protected float lastScaling = -1.0f;
    protected float oldRotation = 0.0f;
    protected float oldIndent = 0.0f;
    protected int startPage;
    protected int endPage;
    protected int currentPage;
    protected String lastNameAdded = "";
    protected Map duplicates = new HashMap();
    protected Map lastValidValue = new HashMap();
    protected Map lastUnformattedValue = new HashMap();
    protected Map additionFieldsMap = new HashMap();
    protected Map nameToCompIndex;
    protected Map typeValues;
    protected int nextFreeField = 0;
    protected float[][] boundingBoxs;
    protected int[] fontSize;
    protected int[] xReached;
    protected int[] yReached;
    protected int[] trackPagesRendered;
    protected boolean[] firstTimeDisplayed;
    protected int[] fontSizes;
    protected String[] defaultValues;
    public int[] pageMap;

    public Object getLastValidValue(String ref) {
        return this.lastValidValue.get(ref);
    }

    public Object getLastUnformattedValue(String ref) {
        return this.lastUnformattedValue.get(ref);
    }

    public void reset() {
        this.lastValidValue.clear();
        this.lastUnformattedValue.clear();
    }

    public Integer getTypeValueByName(String fieldName) {
        Object key = this.typeValues.get(fieldName);
        if (key == null) {
            return FormFactory.UNKNOWN;
        }
        return (Integer)this.typeValues.get(fieldName);
    }

    private int setStartForPage(int page) {
        this.trackPagesRendered[page] = this.nextFreeField;
        return this.nextFreeField;
    }

    public int getNextFreeField() {
        return this.nextFreeField;
    }

    public int getStartComponentCountForPage(int page) {
        if (this.trackPagesRendered == null) {
            return -999;
        }
        if (this.trackPagesRendered.length > page) {
            return this.trackPagesRendered[page];
        }
        return -1;
    }

    public void initParametersForPage(PdfPageData pageData, int page) {
        int mediaHeight = pageData.getMediaBoxHeight(page);
        int cropTop = pageData.getCropBoxHeight(page) + pageData.getCropBoxY(page);
        this.cropOtherY = 0;
        if (mediaHeight != cropTop) {
            this.cropOtherY = mediaHeight - cropTop;
        }
        this.pageHeight = mediaHeight;
        this.currentPage = page;
        this.setStartForPage(page);
    }

    public void resetComponents(int formCount, int pageCount, boolean keepValues) {
        this.nextFreeField = 0;
        this.additionFieldsMap.clear();
        if (!keepValues) {
            this.nameToCompIndex = new HashMap(formCount + 1);
            this.typeValues = new HashMap(formCount + 1);
            this.pageMap = new int[formCount + 1];
            this.fontSize = new int[formCount + 1];
            this.boundingBoxs = new float[formCount + 1][4];
            this.fontSizes = new int[formCount + 1];
            this.defaultValues = new String[formCount + 1];
            this.firstTimeDisplayed = new boolean[formCount + 1];
            this.trackPagesRendered = new int[pageCount + 1];
            int i = 0;
            while (i < pageCount + 1) {
                this.trackPagesRendered[i] = -1;
                ++i;
            }
        } else {
            boolean[] tmpFirstTimeDisplayed = this.firstTimeDisplayed;
            int[] tmpMap = this.pageMap;
            int[] tmpSize = this.fontSize;
            String[] tmpValues = this.defaultValues;
            float[][] tmpBoxs = this.boundingBoxs;
            int[] tmpSizes = this.fontSizes;
            this.firstTimeDisplayed = new boolean[formCount + 1];
            this.pageMap = new int[formCount + 1];
            this.fontSize = new int[formCount + 1];
            this.defaultValues = new String[formCount + 1];
            this.boundingBoxs = new float[formCount + 1][4];
            this.fontSizes = new int[formCount + 1];
            int origSize = tmpMap.length;
            int i = 0;
            while (i < formCount + 1) {
                if (i != origSize) {
                    this.firstTimeDisplayed[i] = tmpFirstTimeDisplayed[i];
                    this.pageMap[i] = tmpMap[i];
                    this.fontSize[i] = tmpSize[i];
                    this.defaultValues[i] = tmpValues[i];
                    System.arraycopy(tmpBoxs[i], 0, this.boundingBoxs[i], 0, 4);
                    this.fontSizes[i] = tmpSizes[i];
                    ++this.nextFreeField;
                    ++i;
                    continue;
                }
                break;
            }
        }
    }

    public void setPageValues(float scaling, int rotation) {
        this.scaling = scaling;
        this.rotation = rotation;
        this.displayScaling = scaling;
    }

    public void setPageData(PdfPageData pageData, int insetW, int insetH) {
        this.insetW = insetW;
        this.insetH = insetH;
        this.pageData = pageData;
    }

    public String[] getDefaultValues() {
        return this.defaultValues;
    }

    public void setPageDisplacements(int[] xReached, int[] yReached) {
        this.xReached = xReached;
        this.yReached = yReached;
    }

    public void setJavascript(Javascript javascript) {
        this.javascript = javascript;
    }

    public void resetDuplicates() {
        this.duplicates.clear();
    }
}

