/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.objects.acroforms.creation;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.image.BufferedImage;
import java.awt.image.ByteLookupTable;
import java.awt.image.LookupOp;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.text.JTextComponent;
import org.jpedal.gui.ShowGUIMessage;
import org.jpedal.objects.acroforms.actions.ActionHandler;
import org.jpedal.objects.acroforms.actions.JPedalListener;
import org.jpedal.objects.acroforms.creation.FormFactory;
import org.jpedal.objects.acroforms.formData.FormObject;
import org.jpedal.objects.acroforms.formData.GUIData;
import org.jpedal.objects.acroforms.formData.SwingData;
import org.jpedal.objects.acroforms.rendering.AcroRenderer;
import org.jpedal.objects.acroforms.specificImplementations.FixImageIcon;
import org.jpedal.objects.acroforms.utils.ConvertToString;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.Strip;

public class DefaultFormFactory
implements FormFactory {
    private static final boolean debugUnimplemented = false;
    private AcroRenderer acrorend;
    private boolean printAllouts;
    private boolean printouts;
    private ActionHandler formsActionHandler;

    private DefaultFormFactory() {
        this.printouts = this.printAllouts = false;
    }

    public DefaultFormFactory(AcroRenderer acroRenderer, ActionHandler actionHandler) {
        this.printouts = this.printAllouts = false;
        this.acrorend = acroRenderer;
        this.formsActionHandler = actionHandler;
    }

    public void reset(AcroRenderer acroRenderer, ActionHandler actionHandler) {
        this.acrorend = acroRenderer;
        this.formsActionHandler = actionHandler;
    }

    public Object annotationButton(FormObject form) {
        JButton but = new JButton();
        this.setupButton(but, form);
        this.setupUniversalFeatures(but, form);
        return but;
    }

    public Object comboBox(FormObject form) {
        boolean[] flags;
        String[] items = form.getItemsList();
        JComboBox<Object> comboBox = items == null ? new JComboBox() : new JComboBox<String>(items);
        String textValue = form.getSelectedItem();
        if (form.getValuesMap() != null) {
            comboBox.setSelectedItem(form.getValuesMap().get(textValue));
        } else {
            comboBox.setSelectedItem(textValue);
        }
        if (this.printouts) {
            System.out.println("currently selected value=" + textValue);
        }
        if ((flags = form.getFieldFlags())[18]) {
            if (this.printouts) {
                System.out.println("drop list and an editable text box");
            }
            comboBox.setEditable(true);
        } else {
            if (this.printouts) {
                System.out.println("only a drop list");
            }
            comboBox.setEditable(false);
        }
        this.setupUniversalFeatures(comboBox, form);
        if (flags[1]) {
            comboBox.setEditable(false);
            comboBox.setEnabled(false);
            if (this.printouts) {
                System.out.println("READONLY=" + comboBox);
            }
        }
        return comboBox;
    }

    public Object checkBoxBut(FormObject form) {
        JCheckBox checkBut = new JCheckBox();
        this.setupButton(checkBut, form);
        this.setupUniversalFeatures(checkBut, form);
        boolean[] flags = form.getFieldFlags();
        if (flags != null && flags[1]) {
            checkBut.setEnabled(false);
            checkBut.setDisabledIcon(checkBut.getIcon());
            checkBut.setDisabledSelectedIcon(checkBut.getSelectedIcon());
        }
        return checkBut;
    }

    public Object listField(FormObject form) {
        String[] items = form.getItemsList();
        JList<Object> list = items != null ? new JList<String>(items) : new JList();
        if (!form.getFieldFlags()[21]) {
            list.setSelectionMode(0);
        }
        if (form.getTopIndex() != null) {
            list.setSelectedIndices(form.getTopIndex());
            if (this.printouts) {
                System.out.println("topIndex should be=" + ConvertToString.convertArrayToString(form.getTopIndex()));
            }
        } else {
            String textValue = form.getSelectedItem();
            if (form.getValuesMap() != null) {
                list.setSelectedValue(form.getValuesMap().get(textValue), true);
            } else {
                list.setSelectedValue(textValue, true);
            }
            if (this.printouts) {
                System.out.println("currently selected value=" + textValue);
            }
        }
        this.setupUniversalFeatures(list, form);
        return list;
    }

    public Object multiLinePassword(FormObject form) {
        String textValue = form.getTextString();
        int maxLength = form.getMaxTextLength();
        JPasswordField multipass = maxLength != -1 ? new JPasswordField(textValue, maxLength) : new JPasswordField(textValue);
        multipass.setEchoChar('*');
        if (this.printouts) {
            System.out.println("there is a password to be entered that can be MULTILINED");
        }
        this.setupUniversalFeatures(multipass, form);
        DefaultFormFactory.setupTextFeatures(multipass, form);
        boolean[] flags = form.getFieldFlags();
        if (flags != null && flags[1]) {
            multipass.setEnabled(false);
            multipass.setEditable(false);
            if (this.printouts) {
                System.out.println("READONLY=" + multipass);
            }
        }
        this.setToolTip(form, multipass);
        return multipass;
    }

    public Object multiLineText(FormObject form) {
        JTextArea newTextarea = new JTextArea(form.getTextString());
        newTextarea.setLineWrap(true);
        this.setupUniversalFeatures(newTextarea, form);
        boolean[] flags = form.getFieldFlags();
        if (flags != null && flags[1]) {
            newTextarea.setEnabled(false);
            newTextarea.setEditable(false);
            if (this.printouts) {
                System.out.println("READONLY=" + newTextarea);
            }
        }
        this.setToolTip(form, newTextarea);
        return newTextarea;
    }

    public Object signature(FormObject form) {
        JButton sigBut = new JButton();
        this.setupButton(sigBut, form);
        this.setupUniversalFeatures(sigBut, form);
        boolean[] flags = form.getFieldFlags();
        if (flags != null && flags[1]) {
            sigBut.setEnabled(false);
            sigBut.setDisabledIcon(sigBut.getIcon());
            sigBut.setDisabledSelectedIcon(sigBut.getSelectedIcon());
        }
        return sigBut;
    }

    public Object pushBut(FormObject form) {
        JButton pushBut = new JButton();
        this.setupButton(pushBut, form);
        this.setupUniversalFeatures(pushBut, form);
        boolean[] flags = form.getFieldFlags();
        if (flags != null && flags[1]) {
            pushBut.setEnabled(false);
            pushBut.setDisabledIcon(pushBut.getIcon());
            pushBut.setDisabledSelectedIcon(pushBut.getSelectedIcon());
        }
        return pushBut;
    }

    public Object radioBut(FormObject form) {
        JRadioButton radioBut = new JRadioButton();
        this.setupButton(radioBut, form);
        this.setupUniversalFeatures(radioBut, form);
        boolean[] flags = form.getFieldFlags();
        if (flags != null && flags[1]) {
            radioBut.setEnabled(false);
            radioBut.setDisabledIcon(radioBut.getIcon());
            radioBut.setDisabledSelectedIcon(radioBut.getSelectedIcon());
        }
        return radioBut;
    }

    public Object singleLinePassword(FormObject form) {
        JPasswordField newPassword = new JPasswordField(form.getTextString());
        newPassword.setEchoChar('*');
        int maxLength = form.getMaxTextLength();
        if (maxLength != -1) {
            newPassword.setColumns(maxLength);
            if (this.printouts) {
                System.out.println("textlength added=" + maxLength);
            }
        }
        this.setupUniversalFeatures(newPassword, form);
        DefaultFormFactory.setupTextFeatures(newPassword, form);
        boolean[] flags = form.getFieldFlags();
        if (flags != null && flags[1]) {
            newPassword.setEnabled(false);
            newPassword.setEditable(false);
            if (this.printouts) {
                System.out.println("READONLY=" + newPassword);
            }
        }
        this.setToolTip(form, newPassword);
        return newPassword;
    }

    public Object singleLineText(FormObject form) {
        JTextField newTextfield = new JTextField(form.getTextString());
        this.setupUniversalFeatures(newTextfield, form);
        DefaultFormFactory.setupTextFeatures(newTextfield, form);
        boolean[] flags = form.getFieldFlags();
        if (flags != null && flags[1]) {
            newTextfield.setEnabled(false);
            newTextfield.setEditable(false);
            if (this.printouts) {
                System.out.println("READONLY=" + newTextfield);
            }
        }
        this.setToolTip(form, newTextfield);
        return newTextfield;
    }

    private static void setupTextFeatures(JTextField textcomp, FormObject form) {
        if (form.getAlignment() != -1) {
            textcomp.setHorizontalAlignment(form.getAlignment());
        }
    }

    private void setupButton(AbstractButton comp, FormObject form) {
        int textPosition;
        String normalCaption = form.getNormalCaption();
        comp.setText(normalCaption);
        comp.setContentAreaFilled(false);
        String downCaption = form.getDownCaption();
        String rolloverCaption = form.getRolloverCaption();
        if (downCaption != null || rolloverCaption != null) {
            comp.addMouseListener(this.formsActionHandler.setupChangingCaption(normalCaption, rolloverCaption, downCaption));
        }
        if (form.isAppearancesUsed()) {
            this.appearanceImages(form, comp, false);
        }
        if ((textPosition = form.getTextPosition()) != -1) {
            switch (textPosition) {
                case 0: {
                    comp.setIcon(null);
                    comp.setText(normalCaption);
                    break;
                }
                case 1: {
                    comp.setText(null);
                    break;
                }
                case 2: {
                    comp.setVerticalTextPosition(3);
                    break;
                }
                case 3: {
                    comp.setVerticalTextPosition(1);
                    break;
                }
                case 4: {
                    comp.setHorizontalTextPosition(4);
                    break;
                }
                case 5: {
                    comp.setHorizontalTextPosition(2);
                    break;
                }
                case 6: {
                    comp.setText(null);
                }
            }
        }
        Insets insetZero = new Insets(0, 0, 0, 0);
        comp.setMargin(insetZero);
        comp.addMouseListener(this.formsActionHandler.setHoverCursor());
    }

    private void appearanceImages(FormObject form, AbstractButton comp, boolean showImages) {
        String defaultState = form.getDefaultState();
        if (this.printouts) {
            System.out.println("default state=" + defaultState);
        }
        if (defaultState != null && defaultState.equals(form.getNormalOnState())) {
            comp.setSelected(true);
        }
        if (form.hasNormalOff()) {
            comp.setText(null);
            comp.setIcon(new FixImageIcon(form.getNormalOffImage()));
            if (showImages) {
                ShowGUIMessage.showGUIMessage("normalAppOffImage", form.getNormalOffImage(), "normalAppOff");
            }
        }
        if (form.hasNormalOn()) {
            comp.setText(null);
            comp.setSelectedIcon(new FixImageIcon(form.getNormalOnImage()));
            if (showImages) {
                ShowGUIMessage.showGUIMessage("normalAppOnImage", form.getNormalOnImage(), "normalAppOn");
            }
        }
        if (form.hasNoDownIcon()) {
            comp.setPressedIcon(comp.getIcon());
        } else {
            BufferedImage normalOffImage = form.getNormalOffImage();
            BufferedImage normalOnImage = form.getNormalOnImage();
            BufferedImage downOff = null;
            BufferedImage downOn = null;
            if (form.hasOffsetDownIcon() && !form.hasDownImage()) {
                if (form.hasNormalOff()) {
                    if (form.hasNormalOn()) {
                        downOn = this.createPressedLook(normalOnImage);
                        downOff = this.createPressedLook(normalOffImage);
                    } else {
                        downOff = this.createPressedLook(normalOffImage);
                    }
                } else if (form.hasNormalOn()) {
                    downOff = this.createPressedLook(normalOnImage);
                }
            } else if (form.hasInvertDownIcon()) {
                if (form.hasNormalOff()) {
                    if (form.hasNormalOn()) {
                        downOff = this.invertImage(normalOffImage);
                        downOn = this.invertImage(normalOnImage);
                    } else {
                        downOff = this.invertImage(normalOffImage);
                    }
                } else if (form.hasNormalOn()) {
                    downOff = this.invertImage(normalOnImage);
                }
            } else {
                downOff = form.getDownOffImage();
                downOn = form.getDownOnImage();
            }
            if (downOff == null && downOn == null) {
                if (form.hasNormalOff()) {
                    if (form.hasNormalOn()) {
                        downOff = this.invertImage(normalOffImage);
                        downOn = this.invertImage(normalOnImage);
                    } else {
                        downOff = this.invertImage(normalOffImage);
                    }
                } else if (form.hasNormalOn()) {
                    downOff = this.invertImage(normalOnImage);
                }
            }
            if (showImages) {
                ShowGUIMessage.showGUIMessage("downAppOffImage", form.getDownOffImage(), "downAppOff");
                ShowGUIMessage.showGUIMessage("downAppOnImage", form.getDownOnImage(), "downAppOn");
            }
            if (downOff == null || downOn == null) {
                if (downOff != null) {
                    comp.setText(null);
                    comp.setPressedIcon(new FixImageIcon(downOff));
                } else if (downOn != null) {
                    comp.setText(null);
                    comp.setPressedIcon(new FixImageIcon(downOn));
                }
                if (this.printouts) {
                    System.out.println("CHECK there is an off or on down image not both does this work, DefaultAcro.createAppearanceImages");
                }
            } else {
                if (comp.isSelected()) {
                    comp.setPressedIcon(new FixImageIcon(downOn));
                } else {
                    comp.setPressedIcon(new FixImageIcon(downOff));
                }
                comp.addActionListener(this.formsActionHandler.setupChangingDownIcon(downOff, downOn));
            }
        }
        if (form.hasRolloverOff()) {
            comp.setRolloverEnabled(true);
            comp.setText(null);
            comp.setRolloverIcon(new FixImageIcon(form.getRolloverOffImage()));
            if (showImages) {
                ShowGUIMessage.showGUIMessage("rolloverAppOffImage", form.getRolloverOffImage(), "rolloverAppOff");
            }
        }
        if (form.hasRolloverOn()) {
            comp.setRolloverEnabled(true);
            comp.setText(null);
            comp.setRolloverSelectedIcon(new FixImageIcon(form.getRolloverOnImage()));
            if (showImages) {
                ShowGUIMessage.showGUIMessage("rolloverAppOnImage", form.getRolloverOnImage(), "rolloverAppOn");
            }
        }
    }

    private BufferedImage invertImage(BufferedImage image) {
        if (image == null) {
            return null;
        }
        BufferedImage ret = new BufferedImage(image.getWidth(), image.getHeight(), image.getType());
        byte[] reverse = new byte[256];
        int j = 0;
        while (j < 200) {
            reverse[j] = (byte)(256 - j);
            ++j;
        }
        ByteLookupTable blut = new ByteLookupTable(0, reverse);
        LookupOp lop = new LookupOp(blut, null);
        lop.filter(image, ret);
        return ret;
    }

    private BufferedImage createPressedLook(Image image) {
        BufferedImage pressedImage = new BufferedImage(image.getWidth(null) + 2, image.getHeight(null) + 2, 2);
        Graphics2D g = (Graphics2D)pressedImage.getGraphics();
        g.drawImage(image, 1, 1, null);
        g.dispose();
        return pressedImage;
    }

    private void setupUniversalFeatures(JComponent comp, FormObject form) {
        Color backgroundColor;
        comp.setOpaque(false);
        Font textFont = form.getTextFont();
        if (textFont != null) {
            comp.setFont(textFont);
        }
        comp.setForeground(form.getTextColor());
        Border newBorder = this.createBorderStyle(form.getBorder(), form.getBorderColor(), Color.white);
        comp.setBorder(newBorder);
        if (this.printouts) {
            System.out.println("borderStyle=" + newBorder);
        }
        if ((backgroundColor = form.getBackgroundColor()) != null) {
            comp.setBackground(backgroundColor);
            comp.setOpaque(true);
        }
        this.setupMouseListener(comp, form);
        if (this.printouts) {
            System.out.println("flagNum=" + form.getCharacteristics());
        }
    }

    private void setupMouseListener(Component currentComp, FormObject form) {
        Map aDataMap;
        boolean[] characteristic = form.getCharacteristics();
        if (characteristic[0] || characteristic[1] || characteristic[5]) {
            currentComp.setVisible(false);
        }
        JPedalListener jpedalListener = new JPedalListener(form, this.acrorend, this.formsActionHandler);
        if (currentComp instanceof JComboBox) {
            ((JComboBox)currentComp).getComponent(0).addMouseListener(jpedalListener);
            ((JComboBox)currentComp).getComponent(0).addKeyListener(jpedalListener);
            ((JComboBox)currentComp).getComponent(0).addFocusListener(jpedalListener);
            ((JComboBox)currentComp).getComponent(0).addComponentListener(jpedalListener);
            ((JComboBox)currentComp).getComponent(0).addInputMethodListener(jpedalListener);
            ((JComboBox)currentComp).getComponent(0).addHierarchyListener(jpedalListener);
        }
        currentComp.addMouseListener(jpedalListener);
        currentComp.addKeyListener(jpedalListener);
        currentComp.addFocusListener(jpedalListener);
        currentComp.addComponentListener(jpedalListener);
        currentComp.addInputMethodListener(jpedalListener);
        currentComp.addHierarchyListener(jpedalListener);
        Object adata = form.getAobj();
        if (adata != null && adata instanceof Map && (aDataMap = (Map)adata).containsKey("S") && ((String)aDataMap.get("S")).indexOf("URI") != -1) {
            String text = (String)aDataMap.get("URI");
            ((JComponent)currentComp).setToolTipText(text);
        }
    }

    private Border createBorderStyle(Object borderObj, Color borderColor, Color borderBackgroundColor) {
        Object dashPattern;
        String style;
        if (this.printouts) {
            System.out.println("createBorderStyle() color=" + borderColor + " background color=" + borderBackgroundColor + "\n\tfield=" + borderObj);
        }
        Map borderStream = new HashMap<String, String>();
        if (borderObj == null) {
            borderStream.put("S", "/S");
            borderStream.put("W", "1");
        } else if (borderObj instanceof Map) {
            borderStream = (Map)borderObj;
        } else {
            LogWriter.writeFormLog("{DefaultFormFactory.createBorderStyle} border stream is String DefaultFormFactory.createBorderStyle", false);
        }
        if (borderBackgroundColor == null && this.printouts) {
            System.out.println("background border color null");
        }
        if (borderColor == null) {
            if (this.printouts) {
                System.out.println("border color null");
            }
            return null;
        }
        Border newBorder = null;
        String width = (String)borderStream.get("W");
        int w = 1;
        if (width != null) {
            w = Integer.parseInt(width);
        }
        if (this.printouts) {
            System.out.println("width=" + width);
        }
        style = (style = (String)borderStream.get("S")) == null ? "S" : Strip.checkRemoveLeadingSlach(style);
        if (this.printouts) {
            System.out.println("style=" + style);
        }
        if (style.equals("U")) {
            if (this.printouts) {
                System.out.println("FormStream.createBorderStyle() U CHECK=" + ConvertToString.convertMapToString(borderStream, null));
            }
            newBorder = BorderFactory.createMatteBorder(0, 0, w, 0, borderColor);
        } else if (style.equals("I")) {
            if (this.printouts) {
                System.out.println("FormStream.createBorderStyle() I CHECK=" + ConvertToString.convertMapToString(borderStream, null));
            }
            newBorder = BorderFactory.createEtchedBorder(borderColor, borderBackgroundColor);
        } else if (style.equals("B")) {
            if (this.printouts) {
                System.out.println("FormStream.createBorderStyle() B CHECK=" + ConvertToString.convertMapToString(borderStream, null));
            }
            newBorder = BorderFactory.createBevelBorder(1, borderColor, borderBackgroundColor);
        } else if (style.equals("S")) {
            if (this.printouts) {
                System.out.println("FormStream.createBorderStyle() S CHECK=" + ConvertToString.convertMapToString(borderStream, null));
            }
            newBorder = BorderFactory.createLineBorder(borderColor, w);
        } else if (!style.equals("D") || (dashPattern = borderStream.get("D")) instanceof String || dashPattern instanceof Map) {
            // empty if block
        }
        return newBorder;
    }

    private void setToolTip(FormObject formObject, Object retComponent) {
        String userName = formObject.getUserName();
        if (userName != null) {
            ((JTextComponent)retComponent).setToolTipText(userName);
        }
    }

    public GUIData getCustomCompData() {
        return new SwingData();
    }
}

