/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.objects.acroforms.actions;

import java.awt.Component;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.InputMethodEvent;
import java.awt.event.InputMethodListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.text.JTextComponent;
import org.jpedal.objects.acroforms.actions.ActionHandler;
import org.jpedal.objects.acroforms.formData.FormObject;
import org.jpedal.objects.acroforms.rendering.AcroRenderer;

public class JPedalListener
implements MouseListener,
KeyListener,
FocusListener,
ComponentListener,
InputMethodListener,
HierarchyListener {
    private FormObject formObject;
    private AcroRenderer acrorend;
    private ActionHandler handler;

    public JPedalListener(FormObject form, AcroRenderer acroRend, ActionHandler formsHandler) {
        this.formObject = form;
        this.acrorend = acroRend;
        this.handler = formsHandler;
    }

    public void mouseClicked(MouseEvent e) {
        this.handler.A(e, this.formObject, 3);
    }

    public void mousePressed(MouseEvent e) {
        this.handler.A(e, this.formObject, 1);
        this.handler.D(e, this.formObject);
    }

    public void mouseReleased(MouseEvent e) {
        this.handler.A(e, this.formObject, 2);
        this.handler.U(e, this.formObject);
    }

    public void mouseEntered(MouseEvent e) {
        Object objE;
        this.handler.A(e, this.formObject, 4);
        this.handler.E(e, this.formObject);
        if (this.formObject.getCharacteristics()[8]) {
            ((JComponent)e.getSource()).setVisible(true);
            ((JComponent)e.getSource()).repaint();
        }
        if ((objE = this.formObject.getEobj()) instanceof Map) {
            Map enteredData = (Map)objE;
            String command = (String)enteredData.get("S");
            if (command.equals("/Hide")) {
                Component[] checkObj;
                String name = (String)enteredData.get("T");
                if (name.startsWith("(")) {
                    name = name.substring(1, name.length() - 1);
                }
                Boolean hide = Boolean.TRUE;
                if (enteredData.containsKey("H")) {
                    hide = Boolean.valueOf((String)enteredData.get("H"));
                }
                if ((checkObj = (Component[])this.acrorend.getComponentsByName(name)) != null) {
                    boolean hideB = hide;
                    checkObj[0].setVisible(!hideB);
                    checkObj[0].repaint();
                }
            } else {
                command.equals("/GoToR");
            }
        }
    }

    public void mouseExited(MouseEvent e) {
        Map exitedData;
        String command;
        Object objX;
        this.handler.A(e, this.formObject, 5);
        this.handler.X(e, this.formObject);
        if (this.formObject.getCharacteristics()[8]) {
            ((JComponent)e.getSource()).setVisible(false);
            ((JComponent)e.getSource()).repaint();
        }
        if ((objX = this.formObject.getXobj()) instanceof Map && (command = (String)(exitedData = (Map)objX).get("S")).equals("/Hide")) {
            String name = (String)exitedData.get("T");
            if (name.startsWith("(")) {
                name = name.substring(1, name.length() - 1);
            }
            Boolean hide = Boolean.TRUE;
            if (exitedData.containsKey("H")) {
                hide = Boolean.valueOf((String)exitedData.get("H"));
            }
            exitedData.put("hide", hide);
            Object[] checkObj = this.acrorend.getComponentsByName(name);
            if (checkObj != null && checkObj[0] instanceof Component) {
                Component swingComponent = (Component)checkObj[0];
                boolean hideB = hide;
                swingComponent.setVisible(!hideB);
                swingComponent.repaint();
            }
        }
    }

    public void keyTyped(KeyEvent e) {
        char c;
        boolean keyIgnored = false;
        int maxLength = this.formObject.getMaxTextLength();
        if (maxLength != -1 && (c = e.getKeyChar()) != '\b' && c != '\u007f') {
            JTextComponent comp = (JTextComponent)e.getSource();
            String text = comp.getText();
            int length = text.length();
            if (length >= maxLength) {
                e.consume();
                keyIgnored = true;
            }
            if (length > maxLength) {
                comp.setText(text.substring(0, maxLength));
            }
        }
        if (!keyIgnored) {
            int rejectKey;
            if (e.getKeyChar() == '\n') {
                this.acrorend.getCompData().loseFocus();
            }
            if ((rejectKey = this.handler.K(e, this.formObject, 1)) == 1) {
                e.consume();
            }
            this.handler.V(e, this.formObject, 1);
        }
    }

    public void keyPressed(KeyEvent e) {
    }

    public void keyReleased(KeyEvent e) {
        this.handler.K(e, this.formObject, 2);
        this.handler.V(e, this.formObject, 2);
    }

    public void focusGained(FocusEvent e) {
        this.handler.Fo(e, this.formObject);
        String fieldName = this.formObject.getFieldName();
        Object lastUnformattedValue = this.acrorend.getCompData().getLastUnformattedValue(fieldName);
        if (lastUnformattedValue != null && !lastUnformattedValue.equals(this.acrorend.getCompData().getValue(fieldName))) {
            this.acrorend.getCompData().setValue(fieldName, lastUnformattedValue, false, false);
        }
    }

    public void focusLost(FocusEvent e) {
        this.handler.Bl(e, this.formObject);
        this.handler.K(e, this.formObject, 6);
        this.handler.V(e, this.formObject, 6);
        this.acrorend.getCompData().loseFocus();
    }

    public void componentResized(ComponentEvent e) {
    }

    public void componentMoved(ComponentEvent e) {
    }

    public void componentShown(ComponentEvent e) {
    }

    public void componentHidden(ComponentEvent e) {
    }

    public void inputMethodTextChanged(InputMethodEvent e) {
    }

    public void caretPositionChanged(InputMethodEvent e) {
    }

    public void hierarchyChanged(HierarchyEvent e) {
    }
}

