/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.objects;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.jpedal.utils.Strip;

public class StoryData
implements Cloneable,
Serializable {
    public static final int STANDARD_LINK = 1;
    public static final int CHILD_LINK = 2;
    public static final int X1 = 0;
    public static final int X2 = 1;
    public static final int Y1 = 2;
    public static final int Y2 = 3;
    Map newShapes = new HashMap();
    public float[] lx1;
    public float[] lx2;
    public float[] ly1;
    public float[] ly2;
    public static String marker = String.valueOf('\uffff');
    public static String hiddenMarker = String.valueOf('\ufffe');
    protected int max = 2000;
    public Object[] links = new Object[this.max];
    public Object[] children = new Object[this.max];
    public String[] contents = new String[this.max];
    public String[] rawData = new String[this.max];
    public String[] prefix = new String[this.max];
    public int[] regExpStatus = new int[this.max];
    public String[] unformattedContent = new String[this.max];
    public int[] f_writingMode = new int[this.max];
    public String[] f_font_used = new String[this.max];
    public String[] font_data = new String[this.max];
    public int[] text_length = new int[this.max];
    public int[] move_command = new int[this.max];
    public float[] f_character_spacing = new float[this.max];
    public int[] token_counter = new int[this.max];
    public int[] f_end_font_size = new int[this.max];
    public float[] space_width = new float[this.max];
    public float[] f_x1 = new float[this.max];
    public String[] colorTag = new String[this.max];
    public float[] f_x2 = new float[this.max];
    public float[] f_y1 = new float[this.max];
    public float[] f_y2 = new float[this.max];
    public String[] category = new String[this.max];
    public int[] objectType = new int[this.max];
    public int[] lineCount = new int[this.max];
    boolean isColorExtracted;

    public float getCoordinate(int type, int storyNumber) {
        float value = -1.0f;
        switch (type) {
            case 0: {
                value = this.f_x1[storyNumber];
                break;
            }
            case 1: {
                value = this.f_x2[storyNumber];
                break;
            }
            case 2: {
                value = this.f_y1[storyNumber];
                break;
            }
            case 3: {
                value = this.f_y2[storyNumber];
                break;
            }
            default: {
                value = -1.0f;
            }
        }
        return value;
    }

    public float[] getCoordinates(int type, boolean isCombinedArea) {
        float[] value = null;
        switch (type) {
            case 0: {
                if (isCombinedArea && this.lx1 != null) {
                    value = this.lx1;
                    break;
                }
                value = this.f_x1;
                break;
            }
            case 1: {
                if (isCombinedArea && this.lx2 != null) {
                    value = this.lx2;
                    break;
                }
                value = this.f_x2;
                break;
            }
            case 2: {
                if (isCombinedArea && this.ly1 != null) {
                    value = this.ly1;
                    break;
                }
                value = this.f_y1;
                break;
            }
            case 3: {
                if (isCombinedArea && this.ly2 != null) {
                    value = this.ly2;
                    break;
                }
                value = this.f_y2;
                break;
            }
            default: {
                value = null;
            }
        }
        return value;
    }

    public void enableTextColorDataExtraction() {
        this.isColorExtracted = true;
    }

    public boolean isColorExtracted() {
        return this.isColorExtracted;
    }

    public int getObjectType(int i) {
        return this.objectType[i];
    }

    public String getCategory(int i) {
        return this.category[i];
    }

    public String getXMLContent(int current_story) {
        String value = this.unformattedContent[current_story];
        if (this.prefix[current_story] != null) {
            value = String.valueOf(this.prefix[current_story]) + value;
        }
        return value;
    }

    public void setXMLContent(int current_story, String content) {
        this.unformattedContent[current_story] = content;
    }

    public String getTextContent(int current_story, boolean addPrefix, boolean stripXML) {
        String value = this.contents[current_story];
        if (this.prefix[current_story] != null && addPrefix) {
            value = stripXML ? String.valueOf(Strip.convertToText(this.prefix[current_story])) + value : String.valueOf(this.prefix[current_story]) + value;
        }
        return value;
    }

    public void setTextContent(int current_story, String content) {
        this.contents[current_story] = content;
    }

    public void setCategory(String newCategory, int current_story) {
        this.category[current_story] = newCategory;
    }

    public void setObjectType(int newType, int current_story) {
        this.objectType[current_story] = newType;
    }

    public int getStoryCount() {
        return this.f_x1.length;
    }

    public Object clone() throws CloneNotSupportedException {
        try {
            return super.clone();
        }
        catch (Exception e) {
            throw new Error("This should not occur since we implement Cloneable");
        }
    }

    public int[] getLinkedItems(int i) {
        return (int[])this.links[i];
    }

    public int[] getChildren(int i) {
        return (int[])this.children[i];
    }

    public void setLinkedItems(int i, int[] list) {
        this.links[i] = list;
    }

    public void setChildrenItems(int i, int[] children) {
        this.children[i] = children;
    }

    public void appendLinkedItem(int i, int[] linkedItems) {
        if (linkedItems != null) {
            int j = 0;
            while (j < linkedItems.length) {
                if (linkedItems[j] != -1) {
                    System.out.println(String.valueOf(i) + " Added " + linkedItems[j]);
                }
                ++j;
            }
        }
        this.links[i] = linkedItems;
    }

    public void appendChildrenItem(int i, int[] children) {
        if (children != null) {
            int j = 0;
            while (j < children.length) {
                if (children[j] != -1) {
                    System.out.println(String.valueOf(i) + " Added " + children[j]);
                }
                ++j;
            }
        }
        this.children[i] = children;
    }

    public String getNewShapeData(int current_story) {
        return (String)this.newShapes.get(new Integer(current_story));
    }

    public void addNewShape(int current_story, String data) {
        this.newShapes.put(new Integer(current_story), data);
    }
}

