/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.objects;

import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.Path2D;
import java.awt.geom.PathIterator;
import java.io.Serializable;
import org.jpedal.color.PdfColor;
import org.jpedal.color.PdfPaint;
import org.jpedal.objects.PageLines;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.repositories.Vector_Float;
import org.jpedal.utils.repositories.Vector_Int;

public class PdfShape
implements Serializable {
    private Vector_Float shape_primitive_x2 = new Vector_Float(1000);
    private Vector_Float shape_primitive_y = new Vector_Float(1000);
    private Vector_Int shape_primitives = new Vector_Int(1000);
    private int winding_rule = 1;
    private Vector_Float shape_primitive_x3 = new Vector_Float(1000);
    private Vector_Float shape_primitive_y3 = new Vector_Float(1000);
    private Vector_Float shape_primitive_y2 = new Vector_Float(1000);
    private Vector_Float shape_primitive_x = new Vector_Float(1000);
    private static final int H = 3;
    private static final int L = 2;
    private static final int V = 6;
    private static final int M = 1;
    private static final int Y = 4;
    private static final int C = 5;

    public final void closeShape() {
        this.shape_primitives.addElement(3);
        this.shape_primitive_x.addElement(0.0f);
        this.shape_primitive_y.addElement(0.0f);
        this.shape_primitive_x2.addElement(0.0f);
        this.shape_primitive_y2.addElement(0.0f);
        this.shape_primitive_x3.addElement(0.0f);
        this.shape_primitive_y3.addElement(0.0f);
    }

    public final void addBezierCurveC(float x, float y, float x2, float y2, float x3, float y3) {
        this.shape_primitives.addElement(5);
        this.shape_primitive_x.addElement(x);
        this.shape_primitive_y.addElement(y);
        this.shape_primitive_x2.addElement(x2);
        this.shape_primitive_y2.addElement(y2);
        this.shape_primitive_x3.addElement(x3);
        this.shape_primitive_y3.addElement(y3);
    }

    public final void setNONZEROWindingRule() {
        this.winding_rule = 1;
    }

    public final void lineTo(float x, float y) {
        this.shape_primitives.addElement(2);
        this.shape_primitive_x.addElement(x);
        this.shape_primitive_y.addElement(y);
        this.shape_primitive_x2.addElement(0.0f);
        this.shape_primitive_y2.addElement(0.0f);
        this.shape_primitive_x3.addElement(0.0f);
        this.shape_primitive_y3.addElement(0.0f);
    }

    public final void addBezierCurveV(float x2, float y2, float x3, float y3) {
        this.shape_primitives.addElement(6);
        this.shape_primitive_x.addElement(200.0f);
        this.shape_primitive_y.addElement(200.0f);
        this.shape_primitive_x2.addElement(x2);
        this.shape_primitive_y2.addElement(y2);
        this.shape_primitive_x3.addElement(x3);
        this.shape_primitive_y3.addElement(y3);
    }

    public final Shape generateShapeFromPath(Area clip, float[][] CTM, boolean is_clip, PageLines pageLines, boolean isFill, PdfPaint paint, float thickness, float pageWidth) {
        Path2D current_path = null;
        Area current_area = null;
        Shape current_shape = null;
        float[] x = this.shape_primitive_x.get();
        float[] y = this.shape_primitive_y.get();
        float[] x2 = this.shape_primitive_x2.get();
        float[] y2 = this.shape_primitive_y2.get();
        float[] x3 = this.shape_primitive_x3.get();
        float[] y3 = this.shape_primitive_y3.get();
        int[] command = this.shape_primitives.get();
        int i = 0;
        float lx = x[0];
        float ly = y[0];
        int end = this.shape_primitives.size() - 1;
        boolean show = false;
        while (i < end) {
            if (current_path == null) {
                current_path = new GeneralPath(this.winding_rule);
                ((Path2D.Float)current_path).moveTo(x[i], y[i]);
                lx = x[i];
                ly = y[i];
                if (show) {
                    LogWriter.writeLog("==START=" + x + ' ' + y);
                }
            }
            if (command[i] == 3) {
                current_path.closePath();
                if (is_clip) {
                    if (show) {
                        LogWriter.writeLog("==H\n\n" + current_area + ' ' + ((Path2D.Float)current_path).getBounds2D() + ' ' + new Area(current_path).getBounds2D());
                    }
                    if (current_area == null) {
                        current_area = new Area(current_path);
                        if (current_area.getBounds2D().getWidth() <= 0.0 || current_area.getBounds2D().getHeight() <= 0.0) {
                            current_area = new Area(((Path2D.Float)current_path).getBounds2D());
                        }
                    } else {
                        current_area.add(new Area(current_path));
                    }
                    current_path = null;
                } else if (show) {
                    LogWriter.writeLog("close shape");
                }
            }
            if (command[i] == 2) {
                ((Path2D.Float)current_path).lineTo(x[i], y[i]);
                if (pageLines != null) {
                    float w = Math.abs(lx - x[i]);
                    w = CTM[0][0] != 0.0f ? (w *= CTM[0][0]) : (w *= CTM[1][0]);
                    float h = Math.abs(ly - y[i]);
                    h = CTM[1][1] != 0.0f ? (h *= CTM[1][1]) : (h *= CTM[0][1]);
                    if (!isFill) {
                        double pageRatio = 0.0;
                        if (pageWidth > 0.0f) {
                            pageRatio = w / pageWidth;
                        }
                        if (w >= 1.0f && w < 2.0f && h > 8.0f) {
                            pageLines.addVerticalLine(lx, ly, x[i], y[i]);
                        } else if (h >= 1.0f && h < 2.0f && w > 50.0f) {
                            pageLines.addHorizontalLine(lx, ly, x[i], y[i]);
                        } else if (h < 1.0f && pageRatio <= 1.0 && pageRatio > 0.8 && (double)thickness > 0.25) {
                            pageLines.addHorizontalLine(lx, ly, x[i], y[i]);
                        }
                        pageLines.addPossibleLineEnclosingAdvert((int)lx, (int)x[i], (int)ly, (int)y[i], (int)w, (int)h);
                    } else if (h > 50.0f && w < 1.0f) {
                        pageLines.addVerticalLine(lx, ly, x[i], y[i]);
                    }
                }
                lx = x[i];
                ly = y[i];
                if (show) {
                    LogWriter.writeLog("==L" + x[i] + ',' + y[i] + "  ");
                }
            } else if (command[i] == 1) {
                ((Path2D.Float)current_path).moveTo(x[i], y[i]);
                lx = x[i];
                ly = y[i];
                if (show) {
                    LogWriter.writeLog("==M" + x[i] + ',' + y[i] + "  ");
                }
            } else if (command[i] == 4) {
                if (show) {
                    LogWriter.writeLog("==Y " + x[i] + ' ' + y[i] + ' ' + x3[i] + ' ' + y3[i] + ' ' + x3[i] + ' ' + y3[i]);
                }
                ((Path2D.Float)current_path).curveTo(x[i], y[i], x3[i], y3[i], x3[i], y3[i]);
                lx = x3[i];
                ly = y3[i];
            } else if (command[i] == 5) {
                if (show) {
                    LogWriter.writeLog("==C " + x + ' ' + y + ' ' + x2 + ' ' + y2 + ' ' + x3 + ' ' + y3);
                }
                ((Path2D.Float)current_path).curveTo(x[i], y[i], x2[i], y2[i], x3[i], y3[i]);
                lx = x3[i];
                ly = y3[i];
            } else if (command[i] == 6) {
                float c_x = (float)current_path.getCurrentPoint().getX();
                float c_y = (float)current_path.getCurrentPoint().getY();
                if (show) {
                    LogWriter.writeLog("==v " + c_x + ',' + c_y + ',' + x2[i] + ',' + y2[i] + ',' + x3[i] + ',' + y3[i]);
                }
                ((Path2D.Float)current_path).curveTo(c_x, c_y, x2[i], y2[i], x3[i], y3[i]);
                lx = x3[i];
                ly = y3[i];
            }
            ++i;
        }
        if (current_path != null && current_path.getBounds().getHeight() == 0.0) {
            if (thickness > 1.0f && ((Path2D.Float)current_path).getBounds2D().getWidth() < 1.0) {
                ((Path2D.Float)current_path).moveTo(0.0f, -thickness / 2.0f);
                ((Path2D.Float)current_path).lineTo(0.0f, thickness / 2.0f);
            } else {
                ((Path2D.Float)current_path).moveTo(0.0f, 1.0f);
            }
        }
        if (current_path != null && current_path.getBounds().getWidth() == 0.0) {
            ((Path2D.Float)current_path).moveTo(1.0f, 0.0f);
        }
        if (CTM[0][0] != 1.0f || CTM[1][0] != 0.0f || CTM[2][0] != 0.0f || CTM[0][1] != 0.0f || CTM[1][1] != 1.0f || CTM[2][1] != 0.0f || CTM[0][2] != 0.0f || CTM[1][2] != 0.0f || CTM[2][2] != 1.0f) {
            AffineTransform CTM_transform = new AffineTransform(CTM[0][0], CTM[0][1], CTM[1][0], CTM[1][1], CTM[2][0], CTM[2][1]);
            if (current_path != null) {
                ((Path2D.Float)current_path).transform(CTM_transform);
            } else if (current_area != null) {
                current_area.transform(CTM_transform);
            }
        }
        current_shape = !is_clip ? (current_area == null ? current_path : current_area) : current_area;
        if (pageLines != null && current_shape != null) {
            Rectangle outline = current_shape.getBounds();
            int x1 = outline.x;
            int y1 = outline.y;
            int mx = (int)outline.getMaxX();
            int my = (int)outline.getMaxY();
            if (clip != null) {
                int clipX = clip.getBounds().x;
                int clipY = clip.getBounds().y;
                int clipW = (int)clip.getBounds().getMaxX();
                int clipH = (int)clip.getBounds().getMaxY();
                if (x1 < clipX) {
                    x1 = clipX;
                }
                if (y1 < clipY) {
                    y1 = clipY;
                }
                if (mx > clipW) {
                    mx = clipW;
                }
                if (my > clipH) {
                    my = clipH;
                }
            }
            int w = mx - x1;
            int h = my - y1;
            if (w < 5 && h < 5) {
                pageLines.addPossiblePartLine(x1, y1, x1 + w, y1 + h);
            } else if (isFill) {
                if (w > 8 && h > 8) {
                    PdfColor col = null;
                    if (paint instanceof PdfColor) {
                        col = (PdfColor)paint;
                    }
                    if (col != null) {
                        boolean isWhite;
                        boolean bl = isWhite = col.getRed() > 253 && col.getBlue() > 253 && col.getBlue() > 253;
                        if (!isWhite) {
                            pageLines.addBox(x1, y1, x1 + w, y1 + h, col);
                        }
                    }
                } else if (w < 4 && h > 8) {
                    pageLines.addVerticalLine(x1, y1, x1 + w, y1 + h);
                } else if (h < 6 && w > 50) {
                    pageLines.addHorizontalLine(x1, y1, x1 + w, y1 + h);
                }
            }
        }
        if (pageLines != null && current_shape != null && isFill) {
            int x1 = current_shape.getBounds().x;
            int y1 = current_shape.getBounds().y;
            int w = current_shape.getBounds().width;
            int h = current_shape.getBounds().height;
            pageLines.addPossibleLineEnclosingAdvert(x1, x1 + w, y1 + h, y1, w, h);
        }
        return current_shape;
    }

    public final void appendRectangle(float x, float y, float w, float h) {
        this.moveTo(x, y);
        this.lineTo(x + w, y);
        this.lineTo(x + w, y + h);
        this.lineTo(x, y + h);
        this.lineTo(x, y);
        this.closeShape();
    }

    public final void moveTo(float x, float y) {
        this.shape_primitives.addElement(1);
        this.shape_primitive_x.addElement(x);
        this.shape_primitive_y.addElement(y);
        this.shape_primitive_x2.addElement(0.0f);
        this.shape_primitive_y2.addElement(0.0f);
        this.shape_primitive_x3.addElement(0.0f);
        this.shape_primitive_y3.addElement(0.0f);
    }

    public final void addBezierCurveY(float x, float y, float x3, float y3) {
        this.shape_primitives.addElement(4);
        this.shape_primitive_x.addElement(x);
        this.shape_primitive_y.addElement(y);
        this.shape_primitive_x2.addElement(0.0f);
        this.shape_primitive_y2.addElement(0.0f);
        this.shape_primitive_x3.addElement(x3);
        this.shape_primitive_y3.addElement(y3);
    }

    public final void resetPath() {
        this.shape_primitives.clear();
        this.shape_primitive_x.clear();
        this.shape_primitive_y.clear();
        this.shape_primitive_x2.clear();
        this.shape_primitive_y2.clear();
        this.shape_primitive_x3.clear();
        this.shape_primitive_y3.clear();
        this.winding_rule = 1;
    }

    public final void setEVENODDWindingRule() {
        this.winding_rule = 0;
    }

    private final void showShape(Shape current_shape) {
        PathIterator xx = current_shape.getPathIterator(null);
        double[] coords = new double[6];
        block5: while (!xx.isDone()) {
            int type = xx.currentSegment(coords);
            xx.next();
            switch (type) {
                case 0: {
                    LogWriter.writeLog("MoveTo" + coords[0] + ' ' + coords[1]);
                    if (!(coords[0] == 0.0 & coords[1] == 0.0)) continue block5;
                    LogWriter.writeLog("xxx");
                    break;
                }
                case 1: {
                    LogWriter.writeLog("LineTo" + coords[0] + ' ' + coords[1]);
                    if (!(coords[0] == 0.0 & coords[1] == 0.0)) continue block5;
                    LogWriter.writeLog("xxx");
                    break;
                }
                case 4: {
                    LogWriter.writeLog("CLOSE");
                    break;
                }
                default: {
                    LogWriter.writeLog("Other" + coords[0] + ' ' + coords[1]);
                }
            }
        }
    }
}

