/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.objects;

import java.io.ByteArrayInputStream;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilderFactory;
import org.jpedal.exception.PdfException;
import org.jpedal.utils.Strip;
import org.w3c.dom.Document;

public class PdfFormData {
    private List formObjects = new Vector();
    public static final int XFA_TEMPLATE = 0;
    public static final int XFA_DATASET = 1;
    public static final int XFA_CONFIG = 2;
    private Document xfaTemplate = null;
    private Document xfaDataset = null;
    private Document xfaConfig = null;
    private boolean hasXFA = false;
    private int formCount = 0;
    private int totalCount = 0;
    private boolean isDemo = false;
    private static boolean failed;
    private static final boolean showXML = false;

    public PdfFormData(boolean isDemo) {
        this.isDemo = isDemo;
    }

    public boolean hasXFAFormData() {
        return this.hasXFA;
    }

    public Document getXFAFormData(int type) throws PdfException {
        if (type == 0) {
            return this.xfaTemplate;
        }
        if (type == 1) {
            return this.xfaDataset;
        }
        if (type == 2) {
            return this.xfaConfig;
        }
        throw new PdfException("Unknown type for XFA");
    }

    public void setXFAFormData(int type, byte[] xmlString) throws PdfException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        Document content = null;
        try {
            content = factory.newDocumentBuilder().parse(new ByteArrayInputStream(xmlString));
        }
        catch (Exception e) {
            content = null;
        }
        if (type == 0) {
            this.xfaTemplate = content;
            this.hasXFA = true;
        } else if (type == 1) {
            this.xfaDataset = content;
            this.hasXFA = true;
        } else if (type == 2) {
            this.xfaConfig = content;
            this.hasXFA = true;
        } else {
            throw new PdfException("Unknown type for XFA");
        }
    }

    public void addFormElement(Map currentForm) {
        String value;
        for (Object localKey : currentForm.keySet()) {
            Object localValue = currentForm.get(localKey);
            if (!(localValue instanceof String) || (value = (String)localValue) == null) continue;
            if (value.startsWith("/")) {
                value = value.substring(1);
            }
            currentForm.put(localKey, value);
        }
        value = (String)currentForm.get("Rect");
        if (value != null) {
            currentForm.put("Rect", Strip.removeArrayDeleminators(value));
        }
        this.formObjects.add(this.formCount, currentForm);
        ++this.formCount;
    }

    private String makeDemo(String value) {
        if (this.isDemo & value != null) {
            StringBuffer textData = new StringBuffer(value);
            int len = textData.length();
            int ii = 0;
            while (ii < len) {
                textData.replace(ii, ii + 1, "1");
                ii += 4;
            }
            value = textData.toString();
        }
        return value;
    }

    public final List getFormData() {
        return this.formObjects;
    }

    public void incrementCount(int kidCount) {
        this.totalCount += kidCount;
    }

    public int getTotalCount() {
        return this.totalCount;
    }
}

