/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.objects;

import java.awt.BasicStroke;
import java.awt.Stroke;
import java.awt.geom.Area;
import java.util.HashMap;
import java.util.Map;
import org.jpedal.color.PdfColor;
import org.jpedal.color.PdfPaint;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.Strip;

public class GraphicsState
implements Cloneable {
    public float x;
    public float y;
    private float strokeAlpha = 1.0f;
    private float nonstrokeAlpha = 1.0f;
    String TR = null;
    private boolean op = false;
    private boolean OP = false;
    private float OPM = 0.0f;
    PdfPaint nonstrokeColor = new PdfColor(0, 0, 0);
    PdfPaint strokeColor = new PdfColor(0, 0, 0);
    private Area current_clipping_shape = null;
    public float[][] CTM = new float[3][3];
    private int current_line_dash_phase = 0;
    private Area TRmask = null;
    private int fill_type;
    private int mitre_limit = 0;
    private float[] current_line_dash_array = new float[0];
    private int current_line_cap_style = 0;
    private float current_line_width = 1.0f;
    private int current_line_join_style = 0;
    private int text_render_type = 2;
    int minX = 0;
    int minY = 0;
    public static final int STROKE = 1;
    public static final int FILL = 2;
    public static final int FILLSTROKE = 3;
    public static final int INVISIBLE = 4;
    public static final int CLIPTEXT = 7;

    public GraphicsState() {
        this.resetCTM();
    }

    public GraphicsState(int minX, int minY) {
        this.minX = -minX;
        this.minY = -minY;
        this.resetCTM();
    }

    public float getStrokeAlpha() {
        return this.strokeAlpha;
    }

    public float getNonStrokeAlpha() {
        return this.nonstrokeAlpha;
    }

    public boolean getStrokeOP() {
        return this.OP;
    }

    public boolean getNonStrokeOP() {
        return this.op;
    }

    public float getOPM() {
        return this.OPM;
    }

    public String getTR() {
        return this.TR;
    }

    public final void setTextRenderType(int text_render_type) {
        this.text_render_type = text_render_type;
        this.TRmask = null;
    }

    public final int getTextRenderType() {
        return this.text_render_type;
    }

    public final void setMitreLimit(int mitre_limit) {
        this.mitre_limit = mitre_limit;
    }

    public final float getLineWidth() {
        return this.current_line_width;
    }

    public final void setFillType(int fill_type) {
        this.fill_type = fill_type;
    }

    public final void updateClip(Area current_area) {
        if (this.current_clipping_shape == null) {
            this.current_clipping_shape = current_area;
        } else {
            this.current_clipping_shape.intersect(current_area);
        }
    }

    public final void addClip(Area current_area) {
        if (this.TRmask == null) {
            this.TRmask = current_area;
        } else {
            this.TRmask.add(current_area);
        }
    }

    public final Stroke getStroke() {
        float w = this.current_line_width;
        if (this.CTM[0][0] != 0.0f) {
            w *= this.CTM[0][0];
        } else if (this.CTM[0][1] != 0.0f) {
            w *= this.CTM[0][1];
        }
        if (w < 0.0f) {
            w = -w;
        }
        if (this.mitre_limit < 1) {
            this.mitre_limit = 1;
        }
        BasicStroke current_stroke = this.current_line_dash_array.length > 0 ? new BasicStroke(w, this.current_line_cap_style, this.current_line_join_style, this.mitre_limit, this.current_line_dash_array, this.current_line_dash_phase) : new BasicStroke(w, this.current_line_cap_style, this.current_line_join_style, this.mitre_limit);
        return current_stroke;
    }

    public final void setLineWidth(float current_line_width) {
        this.current_line_width = current_line_width;
    }

    public final Area getClippingShape() {
        if (this.TRmask != null && this.current_clipping_shape != null) {
            this.TRmask.intersect(this.current_clipping_shape);
            return this.TRmask;
        }
        return this.current_clipping_shape;
    }

    public void setMode(Object rawValues) {
        if (rawValues == null) {
            rawValues = new HashMap();
        }
        Map values = rawValues;
        this.strokeAlpha = 1.0f;
        this.nonstrokeAlpha = 1.0f;
        this.op = false;
        this.OP = false;
        String value = (String)values.get("LW");
        if (value != null) {
            this.current_line_width = Float.parseFloat(value);
        }
        boolean AIS = false;
        String SMask = null;
        value = (String)values.get("AIS");
        if (value != null && value.equals("true")) {
            AIS = true;
        }
        if ((value = (String)values.get("SMask")) != null) {
            SMask = value;
        }
        if (SMask != null && !AIS && SMask.equals("/None")) {
            this.strokeAlpha = 1.0f;
            this.nonstrokeAlpha = 1.0f;
        } else {
            value = (String)values.get("CA");
            if (value != null) {
                this.strokeAlpha = Float.parseFloat(value);
            }
            if ((value = (String)values.get("ca")) != null) {
                this.nonstrokeAlpha = Float.parseFloat(value);
            }
        }
        value = (String)values.get("OP");
        if (value != null) {
            this.OP = Boolean.valueOf(value);
        }
        this.op = (value = (String)values.get("op")) == null ? this.OP : Boolean.valueOf(value);
        value = (String)values.get("OPM");
        this.OPM = value == null ? 0.0f : Float.valueOf(value).floatValue();
        this.TR = (String)values.get("TR");
        if (this.TR != null) {
            if (this.TR.equals("/Identity")) {
                this.TR = null;
            } else if (this.TR.endsWith("]")) {
                this.TR = Strip.removeArrayDeleminators(this.TR);
                if (this.TR.endsWith("/Identity") && this.TR.indexOf(82) == -1) {
                    this.TR = null;
                }
            }
        }
    }

    public final void setCapStyle(int cap_style) {
        this.current_line_cap_style = cap_style;
    }

    public final void setJoinStyle(int join_style) {
        this.current_line_join_style = join_style;
    }

    public final void checkWholePageClip(int max_y) {
        if (this.current_clipping_shape != null && this.current_clipping_shape.getBounds().getHeight() >= (double)max_y) {
            this.current_clipping_shape = null;
        }
    }

    public final void setDashArray(float[] current_line_dash_array) {
        this.current_line_dash_array = current_line_dash_array;
    }

    public final Object clone() {
        Object o = null;
        try {
            o = super.clone();
        }
        catch (Exception e) {
            LogWriter.writeLog("[PDF] Error cloning GS state");
        }
        return o;
    }

    public final void resetCTM() {
        this.CTM[0][0] = 1.0f;
        this.CTM[1][0] = 0.0f;
        this.CTM[2][0] = this.minX;
        this.CTM[0][1] = 0.0f;
        this.CTM[1][1] = 1.0f;
        this.CTM[2][1] = this.minY;
        this.CTM[0][2] = 0.0f;
        this.CTM[1][2] = 0.0f;
        this.CTM[2][2] = 1.0f;
    }

    public final void setDashPhase(int current_line_dash_phase) {
        this.current_line_dash_phase = current_line_dash_phase;
    }

    public final int getFillType() {
        return this.fill_type;
    }

    public final void setClippingShape(Area new_clip) {
        this.current_clipping_shape = new_clip;
    }

    public PdfPaint getNonstrokeColor() {
        return this.nonstrokeColor;
    }

    public void setNonstrokeColor(PdfPaint currentNonstrokeColor) {
        this.nonstrokeColor = currentNonstrokeColor;
    }

    public PdfPaint getStrokeColor() {
        return this.strokeColor;
    }

    public void setStrokeColor(PdfPaint strokeColor) {
        this.strokeColor = strokeColor;
    }
}

