/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.io;

import java.awt.Color;
import java.awt.Component;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import org.jpedal.utils.LogWriter;

public class StatusBar {
    private int debug_level = 0;
    private int progress_size = 0;
    private String current = "";
    private int progress_max_size = 100;
    private JProgressBar status = null;
    private boolean showMessages = false;
    public float percentageDone = 0.0f;
    private Color masterColor = null;
    private Color childColor = null;

    public StatusBar() {
        this.initialiseStatus("");
    }

    public StatusBar(Color newColor) {
        this.masterColor = newColor;
        this.initialiseStatus("");
    }

    public final void initialiseStatus(String current) {
        this.progress_size = 0;
        this.status = new JProgressBar();
        if (this.masterColor != null) {
            this.status.setForeground(this.masterColor);
        }
        this.status.setStringPainted(true);
        this.status.setMaximum(this.progress_max_size);
        this.status.setMinimum(0);
        this.updateStatus(current, 4);
    }

    public final void updateStatus(String progress_bar, int debug_level_to_use) {
        this.current = progress_bar;
        if (this.showMessages) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    StatusBar.this.status.setString(StatusBar.this.current);
                    StatusBar.this.status.setValue(StatusBar.this.progress_size);
                }
            });
        }
        if (this.debug_level > debug_level_to_use) {
            LogWriter.writeLog(progress_bar);
        }
    }

    public final Component getStatusObject() {
        return this.status;
    }

    public final void setProgress(int size) {
        if (this.status != null) {
            if (size == 0) {
                this.progress_size = 0;
            }
            if (this.progress_size < size) {
                this.progress_size = size;
            }
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    StatusBar.this.status.setValue(StatusBar.this.progress_size);
                }
            });
        }
    }

    public final void resetStatus(String current) {
        this.progress_size = 0;
        this.updateStatus(current, 4);
    }

    public final void setClientDisplay() {
        this.showMessages = true;
    }

    public void inSubroutine(boolean flag) {
        if (this.status != null) {
            if (flag) {
                if (this.childColor != null) {
                    this.status.setForeground(this.childColor);
                }
                this.resetStatus("Subroutine");
            } else {
                if (this.masterColor != null) {
                    this.status.setForeground(this.masterColor);
                }
                this.resetStatus("");
            }
        }
    }

    public void setColorForSubroutines(Color newColor) {
        this.childColor = newColor;
    }
}

