/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.io;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.jpedal.exception.PdfException;
import org.jpedal.io.RandomAccessBuffer;
import org.jpedal.io.RandomAccessDataBuffer;
import org.jpedal.io.RandomAccessFileBuffer;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.repositories.Vector_Int;
import org.jpedal.utils.repositories.Vector_boolean;

public class PdfFileReader {
    protected Map cachedObjects = new HashMap();
    boolean isFDF = false;
    protected RandomAccessBuffer pdf_datafile = null;
    protected int currentGeneration = 0;
    protected long eof = 0L;
    protected Vector_Int offset = new Vector_Int(2000);
    protected Vector_boolean isCompressed = new Vector_boolean(2000);
    private Vector_Int generation = new Vector_Int(2000);

    protected final long movePointer(String pages_id) {
        long pointer = this.getOffset(pages_id);
        return this.movePointer(pointer);
    }

    public final String getType() {
        String pdf_type = "";
        try {
            this.movePointer(0L);
            pdf_type = this.pdf_datafile.readLine();
            int pos = pdf_type.indexOf("%PDF");
            if (pos != -1) {
                pdf_type = pdf_type.substring(pos + 5);
            }
        }
        catch (Exception e) {
            LogWriter.writeLog("Exception " + e + " in reading type");
        }
        return pdf_type;
    }

    public final void openPdfFile(String filename) throws PdfException {
        this.isFDF = filename.toLowerCase().endsWith(".fdf");
        try {
            this.pdf_datafile = new RandomAccessFileBuffer(filename, "r");
            this.eof = this.pdf_datafile.length();
        }
        catch (Exception e) {
            LogWriter.writeLog("Exception " + e + " accessing file");
            throw new PdfException("Exception " + e + " accessing file");
        }
    }

    public final void openPdfFile(byte[] data) throws PdfException {
        try {
            this.pdf_datafile = new RandomAccessDataBuffer(data);
            this.eof = this.pdf_datafile.length();
        }
        catch (Exception e) {
            LogWriter.writeLog("Exception " + e + " accessing file");
            throw new PdfException("Exception " + e + " accessing file");
        }
        LogWriter.writeMethod("{openPdfFile} EOF=" + this.eof, 0);
    }

    protected final long movePointer(long pointer) {
        long old_pointer = 0L;
        try {
            if (pointer > this.pdf_datafile.length()) {
                LogWriter.writeLog("Attempting to access ref outside file");
            } else {
                old_pointer = this.getPointer();
                this.pdf_datafile.seek(pointer);
            }
        }
        catch (Exception e) {
            LogWriter.writeLog("Exception " + e + " moving pointer to  " + pointer + " in file. EOF =" + this.eof);
        }
        return old_pointer;
    }

    protected final long getPointer() {
        long old_pointer = 0L;
        try {
            old_pointer = this.pdf_datafile.getFilePointer();
        }
        catch (Exception e) {
            LogWriter.writeLog("Exception " + e + " getting pointer in file");
        }
        return old_pointer;
    }

    public final void closePdfFile() {
        try {
            if (this.pdf_datafile != null) {
                this.pdf_datafile.close();
                this.pdf_datafile = null;
            }
            if (this.cachedObjects != null) {
                for (String fileName : this.cachedObjects.keySet()) {
                    File file = new File(fileName);
                    file.delete();
                    if (!file.exists()) continue;
                    LogWriter.writeLog("Unable to delete temp file " + fileName);
                }
            }
        }
        catch (Exception e) {
            LogWriter.writeLog("Exception " + e + " closing file");
        }
    }

    protected final void storeObjectOffset(int current_number, int current_offset, int current_generation, boolean isEntryCompressed) {
        int existing_generation = 0;
        int offsetNumber = 0;
        if (current_number < this.generation.getCapacity()) {
            existing_generation = this.generation.elementAt(current_number);
            offsetNumber = this.offset.elementAt(current_number);
        }
        if (existing_generation < current_generation | offsetNumber == 0) {
            this.offset.setElementAt(current_offset, current_number);
            this.generation.setElementAt(current_generation, current_number);
            this.isCompressed.setElementAt(isEntryCompressed, current_number);
        }
    }

    protected final int getCompressedStreamObject(String value) {
        int currentID = 0;
        if (value.endsWith("R")) {
            StringTokenizer values = new StringTokenizer(value);
            currentID = Integer.parseInt(values.nextToken());
            this.currentGeneration = Integer.parseInt(values.nextToken());
        } else {
            LogWriter.writeLog("Error with reference ..value=" + value + "<");
        }
        return this.offset.elementAt(currentID);
    }

    protected final int getOffset(String value) {
        int currentID = 0;
        if (value.endsWith("R")) {
            StringTokenizer values = new StringTokenizer(value);
            currentID = Integer.parseInt(values.nextToken());
            this.currentGeneration = Integer.parseInt(values.nextToken());
        } else {
            LogWriter.writeLog("2. Error with reference .." + value + "<<");
        }
        return this.offset.elementAt(currentID);
    }

    protected final int getOffsetInCompressedStream(String value) {
        int currentID = 0;
        if (value.endsWith("R")) {
            StringTokenizer values = new StringTokenizer(value);
            currentID = Integer.parseInt(values.nextToken());
            this.currentGeneration = Integer.parseInt(values.nextToken());
        } else {
            LogWriter.writeLog("3. Error with reference .." + value + "<");
        }
        return this.generation.elementAt(currentID);
    }

    protected final int getGen(String value) {
        int currentID = 0;
        if (value.endsWith("R")) {
            StringTokenizer values = new StringTokenizer(value);
            currentID = Integer.parseInt(values.nextToken());
            this.currentGeneration = Integer.parseInt(values.nextToken());
        } else {
            LogWriter.writeLog("4. Error with reference .." + value + "<");
        }
        return this.generation.elementAt(currentID);
    }

    protected final boolean isCompressed(String value) {
        int currentID = 0;
        if (value.endsWith("R")) {
            StringTokenizer values = new StringTokenizer(value);
            currentID = Integer.parseInt(values.nextToken());
            this.currentGeneration = Integer.parseInt(values.nextToken());
        } else {
            LogWriter.writeLog("5.Error with reference .." + value + "<");
        }
        return this.isCompressed.elementAt(currentID);
    }
}

