/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.io;

import java.awt.color.ColorSpace;
import java.awt.color.ICC_ColorSpace;
import java.awt.color.ICC_Profile;
import java.awt.image.BufferedImage;
import java.awt.image.ColorConvertOp;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import org.jpedal.color.ColorSpaces;
import org.jpedal.color.DeviceCMYKColorSpace;
import org.jpedal.exception.PdfException;
import org.jpedal.utils.LogWriter;

public class ColorSpaceConvertor {
    private static ColorSpace rgbCS;
    private static ColorConvertOp CSToRGB;
    private static ColorConvertOp ccopWithHints;
    private static ColorModel rgbModel;
    public static boolean wasRemoved;
    public static boolean isUsingARGB;

    static {
        CSToRGB = null;
        ccopWithHints = new ColorConvertOp(ColorSpaces.hints);
        rgbModel = null;
        isUsingARGB = false;
    }

    private static void initCMYKColorspace() throws PdfException {
        try {
            ICC_Profile p = ICC_Profile.getInstance(ColorSpaceConvertor.class.getResourceAsStream("/org/jpedal/res/cmm/cmyk.icm"));
            ICC_Profile rgbProfile = ICC_Profile.getInstance(1000);
            rgbCS = new ICC_ColorSpace(rgbProfile);
            rgbModel = new ComponentColorModel(rgbCS, new int[]{8, 8, 8}, false, false, 1, 0);
            CSToRGB = new ColorConvertOp(new ICC_ColorSpace(p), rgbCS, ColorSpaces.hints);
        }
        catch (Exception e) {
            LogWriter.writeLog("Exception " + e + " initialising color components");
            throw new PdfException("[PDF] Unable to create CMYK colorspace. Check cmyk.icm in jar file");
        }
    }

    public static BufferedImage convertFromICCCMYK(int width, int height, byte[] data, ColorSpace cs) {
        if (cs == null) {
            cs = rgbCS;
        }
        BufferedImage image = null;
        try {
            int size = width * height * 4;
            if (data.length < size) {
                byte[] newData = new byte[size];
                System.arraycopy(data, 0, newData, 0, data.length);
                data = newData;
            }
            DataBufferByte db = new DataBufferByte(data, data.length);
            int[] nArray = new int[4];
            nArray[1] = 1;
            nArray[2] = 2;
            nArray[3] = 3;
            int[] bands = nArray;
            WritableRaster raster = Raster.createInterleavedRaster(db, width, height, width * 4, 4, bands, null);
            ComponentColorModel cmykModel = new ComponentColorModel(cs, new int[]{8, 8, 8, 8}, false, false, 1, 0);
            image = new BufferedImage(cmykModel, raster, false, null);
        }
        catch (Exception ee) {
            LogWriter.writeLog("Exception  " + ee + " converting from ICC colorspace");
        }
        return image;
    }

    public static BufferedImage convertFromICCCMYK(int width, int height, DataBuffer db, ColorSpace cs) {
        BufferedImage image = null;
        try {
            int[] nArray = new int[4];
            nArray[1] = 1;
            nArray[2] = 2;
            nArray[3] = 3;
            int[] bands = nArray;
            WritableRaster raster = Raster.createInterleavedRaster(db, width, height, width * 4, 4, bands, null);
            ComponentColorModel cmykModel = new ComponentColorModel(cs, new int[]{8, 8, 8, 8}, false, false, 1, 0);
            image = new BufferedImage(cmykModel, raster, false, null);
        }
        catch (Exception ee) {
            LogWriter.writeLog("Exception  " + ee + " converting from ICC colorspace");
        }
        return image;
    }

    public static byte[] convertIndexToRGB(byte[] data, ColorSpace cs) {
        try {
            int width = data.length / 4;
            int height = 1;
            DataBufferByte db = new DataBufferByte(data, data.length);
            int[] nArray = new int[4];
            nArray[1] = 1;
            nArray[2] = 2;
            nArray[3] = 3;
            int[] bands = nArray;
            WritableRaster raster = Raster.createInterleavedRaster(db, width, height, width * 4, 4, bands, null);
            WritableRaster rgbRaster = rgbModel.createCompatibleWritableRaster(width, height);
            if (CSToRGB == null) {
                ColorSpaceConvertor.initCMYKColorspace();
            }
            CSToRGB.filter(raster, rgbRaster);
            int size = width * height * 3;
            data = new byte[size];
            DataBuffer convertedData = rgbRaster.getDataBuffer();
            int ii = 0;
            while (ii < size) {
                data[ii] = (byte)convertedData.getElem(ii);
                ++ii;
            }
        }
        catch (Exception ee) {
            LogWriter.writeLog("Exception  " + ee + " converting colorspace");
        }
        return data;
    }

    public static final BufferedImage convertToRGB(BufferedImage image) {
        if (image.getType() != 1) {
            try {
                BufferedImage raw_image = image;
                image = new BufferedImage(image.getWidth(), image.getHeight(), 1);
                ccopWithHints.filter(raw_image, image);
            }
            catch (Exception e) {
                LogWriter.writeLog("Exception " + e.toString() + " removing alpha from JPEG image");
            }
        }
        return image;
    }

    public static final BufferedImage convertToARGB(BufferedImage image) {
        if (image.getType() != 2) {
            try {
                BufferedImage raw_image = image;
                image = new BufferedImage(raw_image.getWidth(), raw_image.getHeight(), 2);
                ColorConvertOp xformOp = new ColorConvertOp(null);
                xformOp.filter(raw_image, image);
            }
            catch (Exception e) {
                LogWriter.writeLog("Exception " + e + " creating argb image");
            }
        }
        isUsingARGB = true;
        return image;
    }

    public static BufferedImage algorithmicConvertCMYKImageToRGB(byte[] buffer, int w, int h) {
        BufferedImage image = null;
        byte[] new_data = new byte[w * h * 3];
        int pixelCount = w * h * 4;
        double lastC = -1.0;
        double lastM = -1.12;
        double lastY = -1.12;
        double lastK = -1.21;
        double x = 255.0;
        new_data = new byte[w * h * 3];
        double outRed = 0.0;
        double outGreen = 0.0;
        double outBlue = 0.0;
        int pixelReached = 0;
        int i = 0;
        while (i < pixelCount) {
            double inCyan = (double)(buffer[i] & 0xFF) / x;
            double inMagenta = (double)(buffer[i + 1] & 0xFF) / x;
            double inYellow = (double)(buffer[i + 2] & 0xFF) / x;
            double inBlack = (double)(buffer[i + 3] & 0xFF) / x;
            if (lastC != inCyan || lastM != inMagenta || lastY != inYellow || lastK != inBlack) {
                double k = 1.0;
                double c = ColorSpaceConvertor.clip01(inCyan + inBlack);
                double m = ColorSpaceConvertor.clip01(inMagenta + inBlack);
                double y = ColorSpaceConvertor.clip01(inYellow + inBlack);
                double aw = (k - c) * (k - m) * (k - y);
                double ac = c * (k - m) * (k - y);
                double am = (k - c) * m * (k - y);
                double ay = (k - c) * (k - m) * y;
                double ar = (k - c) * m * y;
                double ag = c * (k - m) * y;
                double ab = c * m * (k - y);
                outRed = x * ColorSpaceConvertor.clip01(aw + 0.9137 * am + 0.9961 * ay + 0.9882 * ar);
                outGreen = x * ColorSpaceConvertor.clip01(aw + 0.6196 * ac + ay + 0.5176 * ag);
                outBlue = x * ColorSpaceConvertor.clip01(aw + 0.7804 * ac + 0.5412 * am + 0.0667 * ar + 0.2118 * ag + 0.4863 * ab);
                lastC = inCyan;
                lastM = inMagenta;
                lastY = inYellow;
                lastK = inBlack;
            }
            new_data[pixelReached++] = (byte)outRed;
            new_data[pixelReached++] = (byte)outGreen;
            new_data[pixelReached++] = (byte)outBlue;
            i += 4;
        }
        try {
            int[] nArray = new int[3];
            nArray[1] = 1;
            nArray[2] = 2;
            int[] b = nArray;
            DataBufferByte db = new DataBufferByte(new_data, new_data.length);
            image = new BufferedImage(w, h, 1);
            WritableRaster raster = Raster.createInterleavedRaster(db, w, h, w * 3, 3, b, null);
            image.setData(raster);
        }
        catch (Exception e) {
            LogWriter.writeLog("Exception " + e + " with 24 bit RGB image");
        }
        return image;
    }

    public static BufferedImage algorithmicConvertCMYKImageToRGB(DataBuffer data, int w, int h, boolean debug) {
        wasRemoved = false;
        byte[] buffer = ((DataBufferByte)data).getData();
        BufferedImage image = null;
        byte[] new_data = new byte[w * h * 4];
        int pixelCount = w * h * 4;
        boolean nonTransparent = false;
        int r = 0;
        int g = 0;
        int b = 0;
        int lastC = -1;
        int lastM = -1;
        int lastY = -1;
        int lastK = -1;
        int pixelReached = 0;
        int i = 0;
        while (i < pixelCount) {
            int Y = buffer[i] & 0xFF;
            int Cb = (buffer[1 + i] & 0xFF) - 128;
            int Cr = (buffer[2 + i] & 0xFF) - 128;
            int CENTER = buffer[3 + i] & 0xFF;
            int a = 255;
            if (lastC != Y || lastM != Cb || lastY != Cr || lastK != CENTER) {
                if (debug) {
                    System.out.println(String.valueOf(Y) + " " + Cb + ' ' + Cr + ' ' + CENTER);
                }
                if ((r = (int)((float)(Y - CENTER) + 1.402f * (float)Cr)) < 0) {
                    r = 0;
                }
                if (r > 255) {
                    r = 255;
                }
                if ((g = (int)((float)(Y - CENTER) - 0.34414f * (float)Cb - 0.71414f * (float)Cr)) < 0) {
                    g = 0;
                }
                if (g > 255) {
                    g = 255;
                }
                if ((b = (int)((float)(Y - CENTER) + 1.772f * (float)Cb)) < 0) {
                    b = 0;
                }
                if (b > 255) {
                    b = 255;
                }
                if (Y == 255 && Cr == Cb && CENTER == 0 || CENTER == 255 && Cr == 0) {
                    r = 255;
                    g = 255;
                    b = 255;
                    if (CENTER == 255) {
                        a = 0;
                    } else {
                        nonTransparent = true;
                    }
                } else {
                    nonTransparent = true;
                }
                if (debug) {
                    System.out.println(String.valueOf(r) + " " + g + ' ' + b);
                }
                lastC = Y;
                lastM = Cb;
                lastY = Cr;
                lastK = CENTER;
            }
            new_data[pixelReached++] = (byte)r;
            new_data[pixelReached++] = (byte)g;
            new_data[pixelReached++] = (byte)b;
            new_data[pixelReached++] = (byte)a;
            i += 4;
        }
        if (!nonTransparent) {
            wasRemoved = true;
            return null;
        }
        try {
            int[] nArray = new int[4];
            nArray[1] = 1;
            nArray[2] = 2;
            nArray[3] = 3;
            int[] bands = nArray;
            DataBufferByte db = new DataBufferByte(new_data, new_data.length);
            image = new BufferedImage(w, h, 2);
            WritableRaster raster = Raster.createInterleavedRaster(db, w, h, w * 4, 4, bands, null);
            image.setData(raster);
        }
        catch (Exception e) {
            System.out.println(e);
            e.printStackTrace();
            LogWriter.writeLog("Exception " + e + " with 24 bit RGB image");
        }
        return image;
    }

    public static BufferedImage iccConvertCMYKImageToRGB(byte[] buffer, int w, int h, boolean debug) {
        ColorSpace CMYK = new DeviceCMYKColorSpace().getColorSpace();
        wasRemoved = false;
        BufferedImage image = null;
        byte[] new_data = new byte[w * h * 4];
        int pixelCount = w * h * 4;
        boolean nonTransparent = false;
        int r = 0;
        int g = 0;
        int b = 0;
        int lastC = -1;
        int lastM = -1;
        int lastY = -1;
        int lastK = -1;
        float c = 0.0f;
        float m = 0.0f;
        float y = 0.0f;
        float k = 0.0f;
        int pixelReached = 0;
        int i = 0;
        while (i < pixelCount) {
            int Y = buffer[i] & 0xFF;
            int Cb = (buffer[i + 1] & 0xFF) - 128;
            int Cr = (buffer[i + 2] & 0xFF) - 128;
            int CENTER = buffer[i + 3] & 0xFF;
            int a = 255;
            if (lastC != Y || lastM != Cb || lastY != Cr || lastK != CENTER) {
                if (debug) {
                    System.out.println(String.valueOf(Y) + " " + Cb + ' ' + Cr + ' ' + CENTER);
                }
                if ((c = ((float)(255 - Y) - 1.4021f * (float)Cr) / 255.0f) < 0.0f) {
                    c = 0.0f;
                }
                if (c > 255.0f) {
                    c = 255.0f;
                }
                if ((m = ((float)(255 - Y) + 0.3441f * (float)Cb + 0.7142f * (float)Cr) / 255.0f) < 0.0f) {
                    m = 0.0f;
                }
                if (m > 255.0f) {
                    m = 255.0f;
                }
                y = ((float)(255 - Y) - 1.7718f * (float)Cb) / 255.0f;
                k = (float)CENTER / 255.0f;
                float[] cmykValues = new float[]{c, m, y, k};
                float[] rgb = CMYK.toRGB(cmykValues);
                int jj = 0;
                while (jj < 3) {
                    if ((double)rgb[jj] > 0.99) {
                        rgb[jj] = 1.0f;
                    } else if ((double)rgb[jj] < 0.01) {
                        rgb[jj] = 0.0f;
                    }
                    ++jj;
                }
                r = (int)(255.0f * rgb[0]);
                g = (int)(255.0f * rgb[1]);
                b = (int)(255.0f * rgb[2]);
                if (Y == 255 && Cr == Cb && CENTER == 0 || CENTER == 255 && Cr == 0) {
                    r = 255;
                    g = 255;
                    b = 255;
                    if (CENTER == 255) {
                        a = 0;
                    } else {
                        nonTransparent = true;
                    }
                } else {
                    nonTransparent = true;
                }
                if (debug) {
                    System.out.println(String.valueOf(r) + " " + g + ' ' + b);
                }
                lastC = Y;
                lastM = Cb;
                lastY = Cr;
                lastK = CENTER;
            }
            new_data[pixelReached++] = (byte)r;
            new_data[pixelReached++] = (byte)g;
            new_data[pixelReached++] = (byte)b;
            new_data[pixelReached++] = (byte)a;
            i += 4;
        }
        if (!nonTransparent) {
            wasRemoved = true;
            return null;
        }
        try {
            int[] nArray = new int[4];
            nArray[1] = 1;
            nArray[2] = 2;
            nArray[3] = 3;
            int[] bands = nArray;
            DataBufferByte db = new DataBufferByte(new_data, new_data.length);
            image = new BufferedImage(w, h, 2);
            WritableRaster raster = Raster.createInterleavedRaster(db, w, h, w * 4, 4, bands, null);
            image.setData(raster);
        }
        catch (Exception e) {
            System.out.println(e);
            e.printStackTrace();
            LogWriter.writeLog("Exception " + e + " with 24 bit RGB image");
        }
        return image;
    }

    public static final BufferedImage convertColorspace(BufferedImage image, int newType) {
        try {
            BufferedImage raw_image = image;
            image = new BufferedImage(raw_image.getWidth(), raw_image.getHeight(), newType);
            ColorConvertOp xformOp = new ColorConvertOp(null);
            xformOp.filter(raw_image, image);
        }
        catch (Exception e) {
            LogWriter.writeLog("Exception " + e + " converting image");
        }
        return image;
    }

    private static double clip01(double value) {
        if (value < 0.0) {
            value = 0.0;
        }
        if (value > 1.0) {
            value = 1.0;
        }
        return value;
    }
}

