/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.images;

public class ImageOps {
    private static int[] bitCheck = new int[]{128, 64, 32, 16, 8, 4, 2, 1};

    private static byte[] invertByteImage(int w, int h, int componentCount, byte[] data) {
        int temp = data.length / (w * h);
        if (temp != componentCount) {
            componentCount = temp;
        }
        int bytesInRow = w * componentCount;
        int topByte = 0;
        int bottomByte = (h - 1) * bytesInRow;
        while (topByte < bottomByte) {
            int row = 0;
            while (row < bytesInRow) {
                int c = 0;
                while (c < componentCount) {
                    byte tempByte = data[topByte + row + c];
                    data[topByte + row + c] = data[bottomByte + row + c];
                    data[bottomByte + row + c] = tempByte;
                    ++c;
                }
                row += componentCount;
            }
            topByte += bytesInRow;
            bottomByte -= bytesInRow;
        }
        return data;
    }

    private static byte[] invertOneBitImage(int w, int h, byte[] data) {
        int bytesInRow = (w + 7) / 8;
        int topByte = 0;
        int bottomByte = (h - 1) * bytesInRow;
        while (topByte < bottomByte) {
            int row = 0;
            while (row < bytesInRow) {
                byte tempByte = data[topByte + row];
                data[topByte + row] = data[bottomByte + row];
                data[bottomByte + row] = tempByte;
                ++row;
            }
            topByte += bytesInRow;
            bottomByte -= bytesInRow;
        }
        return data;
    }

    private static byte[] rotateOneBitImage(int w, int h, byte[] data, int newH, int newW) {
        int bytesInRow = (w + 7) / 8;
        int newBytesInRow = (newW + 7) / 8;
        byte[] newData = new byte[newBytesInRow * newH];
        int y = 0;
        while (y < h) {
            int x = 0;
            while (x < w) {
                int byteUsed = y * bytesInRow + (x >> 3);
                byte pixelByte = data[byteUsed];
                if (pixelByte == 0) {
                    x += 7;
                } else {
                    int bitUsed = x & 7;
                    if ((pixelByte & bitCheck[bitUsed]) == bitCheck[bitUsed]) {
                        int newByteUsed = x * newBytesInRow + (y >> 3);
                        byte newPixelByte = newData[newByteUsed];
                        int newBitUsed = y & 7;
                        newData[newByteUsed] = newPixelByte = (byte)(newPixelByte | bitCheck[newBitUsed]);
                    }
                }
                ++x;
            }
            ++y;
        }
        return newData;
    }

    private static byte[] rotateByteImage(int w, int h, int componentCount, byte[] data) {
        int temp = data.length / (w * h);
        if (temp != componentCount) {
            componentCount = temp;
        }
        int bytesInRow = w * componentCount;
        int newBytesInRow = h * componentCount;
        byte[] rotatedData = new byte[data.length];
        int y = 0;
        while (y < h) {
            int x = 0;
            while (x < bytesInRow) {
                int c = 0;
                int convertPoint = (w - 1 - x / componentCount) * newBytesInRow + y * componentCount;
                while (c < componentCount) {
                    rotatedData[convertPoint + c] = data[y * bytesInRow + (x + c)];
                    ++c;
                }
                x += componentCount;
            }
            ++y;
        }
        return rotatedData;
    }

    public static byte[] invertImage(byte[] data, int w, int h, int d, int comp, byte[] index) {
        if (d == 8) {
            if (index != null) {
                comp = 1;
            }
            return ImageOps.invertByteImage(w, h, comp, data);
        }
        if (d != 4 && d == 1) {
            return ImageOps.invertOneBitImage(w, h, data);
        }
        return null;
    }

    public static byte[] rotateImage(byte[] data, int w, int h, int d, int comp, byte[] index) {
        if (d == 8) {
            if (index != null) {
                comp = 1;
            }
            return ImageOps.rotateByteImage(w, h, comp, data);
        }
        if (d != 4 && d == 1) {
            return ImageOps.rotateOneBitImage(w, h, data, w, h);
        }
        return null;
    }
}

