/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.gui;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.io.Serializable;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import javax.swing.ImageIcon;
import org.jpedal.objects.PdfAnnots;
import org.jpedal.utils.LogWriter;

public class Hotspots
implements Serializable {
    protected Rectangle[] pos;
    private String[] annotationTypes = new String[0];
    private Color[] annotationColors;
    private Stroke[] annotationStrokes;
    private Color[] borderColor;
    private boolean[] hasOwnIcon;
    private transient Image[] icons;
    private String[] tooltips;
    private int[] annotationType;
    private transient Image[] AnnotationIcons;
    private Map annotationLookup = new HashMap();
    public static final Integer NO_ICONS = new Integer(0);
    public static final Integer EACH_ICON_UNIQUE = new Integer(1);
    public static final Integer EACH_TYPE_UNIQUE = new Integer(2);

    public void setHotspots(PdfAnnots annotsData) {
        int count = annotsData.getAnnotCount();
        if (count > 0) {
            this.annotationColors = new Color[count];
            this.icons = new Image[count];
            this.annotationStrokes = new Stroke[count];
            this.borderColor = new Color[count];
            this.hasOwnIcon = new boolean[count];
            this.tooltips = new String[count];
            this.pos = new Rectangle[count];
            this.annotationType = new int[count];
            int i = 0;
            while (i < count) {
                String rawArea = annotsData.getAnnotObjectArea(i);
                String subtype = annotsData.getAnnotSubType(i);
                StringTokenizer values = new StringTokenizer(rawArea);
                int[] coords = new int[4];
                int ii = 0;
                while (ii < 4) {
                    coords[ii] = (int)Float.parseFloat(values.nextToken());
                    ++ii;
                }
                int h = coords[1] - coords[3];
                this.pos[i] = h > 0 ? new Rectangle(coords[0], coords[1] - h, coords[2] - coords[0], h) : new Rectangle(coords[0], coords[3] + h, coords[2] - coords[0], -h);
                this.annotationColors[i] = annotsData.getAnnotColor(i);
                this.annotationStrokes[i] = annotsData.getBorderStroke(i);
                this.borderColor[i] = annotsData.getBorderColor(i);
                this.tooltips[i] = annotsData.getField(i, "Contents");
                this.hasOwnIcon[i] = annotsData.hasOwnIcon(i);
                Object rawValue = this.annotationLookup.get(subtype);
                int imageType = 0;
                if (rawValue != null) {
                    imageType = (Integer)this.annotationLookup.get(subtype);
                }
                this.icons[i] = rawValue == null ? null : this.AnnotationIcons[imageType];
                this.annotationType[i] = imageType;
                ++i;
            }
        } else {
            this.pos = null;
            this.annotationStrokes = null;
            this.annotationColors = null;
            this.icons = null;
            this.tooltips = null;
        }
    }

    public void flushAnnotationsDisplayed() {
        this.annotationColors = null;
        this.annotationStrokes = null;
        this.borderColor = null;
        this.hasOwnIcon = null;
        this.pos = null;
    }

    public Hotspots(String[] annotationTypes, String path) {
        this.init(annotationTypes, path);
    }

    private void init(String[] annotationTypes, String path) {
        this.annotationTypes = annotationTypes;
        int count = annotationTypes.length;
        this.AnnotationIcons = new Image[annotationTypes.length];
        int i = 1;
        while (i < count) {
            URL img = null;
            try {
                img = this.getClass().getResource(String.valueOf('/') + path + annotationTypes[i] + ".gif");
            }
            catch (Exception e) {
                LogWriter.writeLog("Exception " + e + " Unable to log images for annotations");
            }
            if (img != null) {
                this.AnnotationIcons[i] = new ImageIcon(img).getImage();
            }
            this.annotationLookup.put(annotationTypes[i], new Integer(i));
            ++i;
        }
    }

    public void checkType(String type) {
        if (this.annotationLookup.get(type) == null) {
            Integer nextItem = new Integer(this.annotationLookup.keySet().size());
            this.annotationLookup.put(type, nextItem);
        }
    }

    public Hotspots() {
        String[] defaultTypes = new String[]{"Other", "Text", "FileAttachment"};
        this.init(defaultTypes, "org/jpedal/examples/simpleviewer/annots/");
    }

    public String getTooltip(Point current_p, Map individualIcons, int page) {
        String result = null;
        if (this.pos != null) {
            int count = this.pos.length;
            int i = 0;
            while (i < count) {
                if (this.pos[i] != null && this.tooltips[i] != null && this.pos[i].contains(current_p)) {
                    result = this.tooltips[i];
                    if (individualIcons != null && individualIcons.get(String.valueOf(page) + "-" + this.annotationTypes[this.annotationType[i]]) == null) {
                        result = null;
                    }
                    i = count;
                }
                ++i;
            }
        }
        return result;
    }

    public void addHotspotsToDisplay(Graphics2D g2, Map individualIcons, int page) {
        block13: {
            if (this.pos == null) break block13;
            int count = this.pos.length;
            if (individualIcons != null) {
                int j = 0;
                while (j < this.annotationTypes.length) {
                    Image[] iconsUsed = (Image[])individualIcons.get(String.valueOf(page) + "-" + this.annotationTypes[j]);
                    int current = 0;
                    if (iconsUsed != null) {
                        int i = 0;
                        while (i < count) {
                            if (this.annotationType[i] == j && !this.hasOwnIcon[i]) {
                                try {
                                    if (iconsUsed[current] != null) {
                                        AffineTransform af = new AffineTransform();
                                        af.translate(this.pos[i].x, this.pos[i].y + iconsUsed[current].getHeight(null));
                                        af.scale(1.0, -1.0);
                                        g2.drawImage(iconsUsed[current], af, null);
                                    }
                                }
                                catch (Exception e) {
                                    LogWriter.writeLog("Insufficient icons for page");
                                    i = count;
                                }
                                ++current;
                            }
                            ++i;
                        }
                    }
                    ++j;
                }
            } else {
                int i = 0;
                while (i < count) {
                    if (this.pos != null && this.pos[i] != null && this.icons != null && this.icons[i] != null && !this.hasOwnIcon[i]) {
                        if (this.annotationStrokes[i] != null) {
                            g2.setColor(this.borderColor[i]);
                            g2.setStroke(this.annotationStrokes[i]);
                            g2.draw(this.pos[i]);
                        }
                        AffineTransform af = new AffineTransform();
                        af.translate(this.pos[i].x, this.pos[i].y + this.icons[i].getHeight(null));
                        af.scale(1.0, -1.0);
                        if (this.icons[i] != null) {
                            g2.drawImage(this.icons[i], af, null);
                        }
                    }
                    ++i;
                }
            }
        }
    }

    public Rectangle[] getAnnotationhotSpots() {
        return this.pos;
    }
}

