/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.function;

public class PostscriptFactory {
    static final int[] scale = new int[]{1, 676, 17576, 456976};
    private int level = 0;
    private static final byte START_BRACE = 123;
    private static final byte END_BRACE = 125;
    private byte[] stream;
    private int ptr;
    private int streamLength;
    private static final boolean debug = false;
    protected boolean testingFunction = false;
    protected double[] stack;
    protected int[] stackType;
    protected int stkPtr = 0;
    protected int stkTypePtr = 0;
    protected int currentType = 0;
    static final double radiansToDegrees = 57.29577951308232;
    protected static final double isTrue = 1.0;
    protected static final double isFalse = 0.0;
    protected static final int PS_INTEGER = 1;
    protected static final int PS_REAL = 2;
    protected static final int PS_BOOLEAN = 3;
    protected static final int PS_UNKNOWN = 0;
    protected static final int PS_abs = 317044;
    protected static final int PS_add = 54756;
    protected static final int PS_atan = 5953532;
    protected static final int PS_ceil = 5170050;
    protected static final int PS_cos = 325834;
    protected static final int PS_cvi = 154806;
    protected static final int PS_cvr = 312990;
    protected static final int PS_div = 374507;
    protected static final int PS_exp = 279192;
    protected static final int PS_floo = 6651169;
    protected static final int PS_idiv = 9739140;
    protected static final int PS_ln = 8799;
    protected static final int PS_log = 114931;
    protected static final int PS_mod = 62204;
    protected static final int PS_mul = 206868;
    protected static final int PS_neg = 108173;
    protected static final int PS_sin = 233914;
    protected static final int PS_sqrt = 8992170;
    protected static final int PS_sub = 31114;
    protected static final int PS_roun = 6301689;
    protected static final int PS_trun = 6303719;
    protected static final int PS_and = 61516;
    protected static final int PS_bits = 8564921;
    protected static final int PS_eq = 10820;
    protected static final int PS_fals = 8418909;
    protected static final int PS_ge = 2710;
    protected static final int PS_gt = 12850;
    protected static final int PS_le = 2715;
    protected static final int PS_lt = 12855;
    protected static final int PS_ne = 2717;
    protected static final int PS_not = 343421;
    protected static final int PS_or = 11506;
    protected static final int PS_true = 2190935;
    protected static final int PS_xor = 308279;
    protected static final int PS_if = 3388;
    protected static final int PS_ifel = 5100428;
    protected static final int PS_copy = 11240530;
    protected static final int PS_exch = 3249536;
    protected static final int PS_pop = 273119;
    protected static final int PS_dup = 277163;
    protected static final int PS_inde = 1889428;
    protected static final int PS_roll = 5229553;

    public PostscriptFactory(byte[] stream) {
        this.stream = stream;
        this.streamLength = stream.length;
    }

    protected static String toString(int id) {
        String str = "";
        switch (id) {
            case 317044: {
                str = "abs";
                break;
            }
            case 54756: {
                str = "add";
                break;
            }
            case 5953532: {
                str = "atan";
                break;
            }
            case 5170050: {
                str = "ceiling";
                break;
            }
            case 325834: {
                str = "cos";
                break;
            }
            case 154806: {
                str = "cvi";
                break;
            }
            case 312990: {
                str = "cvr";
                break;
            }
            case 374507: {
                str = "div";
                break;
            }
            case 279192: {
                str = "exp";
                break;
            }
            case 6651169: {
                str = "floor";
                break;
            }
            case 9739140: {
                str = "idiv";
                break;
            }
            case 8799: {
                str = "ln";
                break;
            }
            case 114931: {
                str = "log";
                break;
            }
            case 62204: {
                str = "mod";
                break;
            }
            case 206868: {
                str = "mul";
                break;
            }
            case 108173: {
                str = "neg";
                break;
            }
            case 233914: {
                str = "sin";
                break;
            }
            case 8992170: {
                str = "sqrt";
                break;
            }
            case 31114: {
                str = "sub";
                break;
            }
            case 6301689: {
                str = "round";
                break;
            }
            case 6303719: {
                str = "truncate";
                break;
            }
            case 61516: {
                str = "and";
                break;
            }
            case 8564921: {
                str = "bitshift";
                break;
            }
            case 10820: {
                str = "eq";
                break;
            }
            case 8418909: {
                str = "false";
                break;
            }
            case 2710: {
                str = "ge";
                break;
            }
            case 12850: {
                str = "gt";
                break;
            }
            case 2715: {
                str = "le";
                break;
            }
            case 12855: {
                str = "lt";
                break;
            }
            case 2717: {
                str = "ne";
                break;
            }
            case 343421: {
                str = "not";
                break;
            }
            case 11506: {
                str = "or";
                break;
            }
            case 2190935: {
                str = "true";
                break;
            }
            case 308279: {
                str = "xor";
                break;
            }
            case 3388: {
                str = "if";
                break;
            }
            case 5100428: {
                str = "ifelse";
                break;
            }
            case 11240530: {
                str = "copy";
                break;
            }
            case 3249536: {
                str = "exch";
                break;
            }
            case 273119: {
                str = "pop";
                break;
            }
            case 277163: {
                str = "dup";
                break;
            }
            case 1889428: {
                str = "index";
                break;
            }
            case 5229553: {
                str = "roll";
                break;
            }
            default: {
                str = "UNKNOWN";
            }
        }
        return str;
    }

    protected static int getCommandID(byte[] cmds) {
        int id = -1;
        int key = 0;
        int keyLength = cmds.length;
        if (keyLength > 4) {
            keyLength = 4;
        }
        int j = 0;
        while (j < keyLength) {
            key += (cmds[j] - 97) * scale[j];
            ++j;
        }
        switch (key) {
            case 317044: {
                id = 317044;
                break;
            }
            case 54756: {
                id = 54756;
                break;
            }
            case 5953532: {
                id = 5953532;
                break;
            }
            case 5170050: {
                id = 5170050;
                break;
            }
            case 325834: {
                id = 325834;
                break;
            }
            case 154806: {
                id = 154806;
                break;
            }
            case 312990: {
                id = 312990;
                break;
            }
            case 374507: {
                id = 374507;
                break;
            }
            case 279192: {
                id = 279192;
                break;
            }
            case 6651169: {
                id = 6651169;
                break;
            }
            case 9739140: {
                id = 9739140;
                break;
            }
            case 8799: {
                id = 8799;
                break;
            }
            case 114931: {
                id = 114931;
                break;
            }
            case 62204: {
                id = 62204;
                break;
            }
            case 206868: {
                id = 206868;
                break;
            }
            case 108173: {
                id = 108173;
                break;
            }
            case 233914: {
                id = 233914;
                break;
            }
            case 8992170: {
                id = 8992170;
                break;
            }
            case 31114: {
                id = 31114;
                break;
            }
            case 6301689: {
                id = 6301689;
                break;
            }
            case 6303719: {
                id = 6303719;
                break;
            }
            case 61516: {
                id = 61516;
                break;
            }
            case 8564921: {
                id = 8564921;
                break;
            }
            case 10820: {
                id = 10820;
                break;
            }
            case 8418909: {
                id = 8418909;
                break;
            }
            case 2710: {
                id = 2710;
                break;
            }
            case 12850: {
                id = 12850;
                break;
            }
            case 2715: {
                id = 2715;
                break;
            }
            case 12855: {
                id = 12855;
                break;
            }
            case 2717: {
                id = 2717;
                break;
            }
            case 343421: {
                id = 343421;
                break;
            }
            case 11506: {
                id = 11506;
                break;
            }
            case 2190935: {
                id = 2190935;
                break;
            }
            case 308279: {
                id = 308279;
                break;
            }
            case 3388: {
                id = 3388;
                break;
            }
            case 5100428: {
                id = 5100428;
                break;
            }
            case 11240530: {
                id = 11240530;
                break;
            }
            case 3249536: {
                id = 3249536;
                break;
            }
            case 273119: {
                id = 273119;
                break;
            }
            case 277163: {
                id = 277163;
                break;
            }
            case 1889428: {
                id = 1889428;
                break;
            }
            case 5229553: {
                id = 5229553;
            }
        }
        return id;
    }

    protected int execute(int id) {
        int returnValue = 0;
        int fType = 0;
        int sType = 0;
        int firstInt = 0;
        double first = 0.0;
        double second = 0.0;
        switch (id) {
            case 317044: {
                first = this.pop();
                if (first < 0.0) {
                    this.push(-first, 1);
                    break;
                }
                this.push(first, 1);
                break;
            }
            case 54756: {
                if (this.stack.length < 2) {
                    System.err.println("ADD - not enough elements on the stack");
                    System.exit(1);
                }
                first = this.pop();
                fType = this.currentType;
                second = this.pop();
                sType = this.currentType;
                if (fType == 2 || sType == 2) {
                    this.push(first + second, 2);
                    break;
                }
                this.push(first + second, 1);
                break;
            }
            case 61516: {
                first = this.pop();
                fType = this.currentType;
                second = this.pop();
                sType = this.currentType;
                if (fType == 1 && sType == 1) {
                    this.push((int)first & (int)second, 1);
                    break;
                }
                if (fType != 3 || sType != 3) break;
                this.push((int)first & (int)second, 3);
                break;
            }
            case 5953532: {
                this.calculateAtan();
                break;
            }
            case 8564921: {
                int shift = this.popInt();
                fType = this.currentType;
                firstInt = this.popInt();
                sType = this.currentType;
                if (fType == 1) {
                    // empty if block
                }
                if (shift > 0) {
                    firstInt <<= shift;
                }
                if (shift < 0) {
                    firstInt >>= -shift;
                }
                this.push(firstInt, 1);
                break;
            }
            case 5170050: {
                first = this.pop();
                fType = this.currentType;
                if (first < 0.0) {
                    this.push((int)first, fType);
                    break;
                }
                int temp = (int)first;
                if (first > (double)temp) {
                    this.push(temp + 1, fType);
                    break;
                }
                this.push(first, fType);
                break;
            }
            case 11240530: {
                firstInt = this.popInt();
                fType = this.currentType;
                if (fType == 1 && firstInt > 0) {
                    double[] items = new double[firstInt];
                    int[] types = new int[firstInt];
                    int i = 0;
                    while (i < items.length) {
                        items[i] = this.pop();
                        types[i] = this.currentType;
                        ++i;
                    }
                    int ii = items.length;
                    while (ii > 0) {
                        this.push(items[ii - 1], types[ii - 1]);
                        --ii;
                    }
                    ii = items.length;
                    while (ii > 0) {
                        this.push(items[ii - 1], types[ii - 1]);
                        --ii;
                    }
                    break;
                }
                if (fType != 1) break;
                break;
            }
            case 325834: {
                first = this.pop();
                double rad = first / 57.29577951308232;
                double angle = Math.cos(rad);
                if (angle > 0.0 && angle < 1.0E-7) {
                    angle = 0.0;
                } else if (angle < 0.0 && angle > -1.0E-7) {
                    angle = 0.0;
                }
                this.push(angle, 2);
                break;
            }
            case 154806: {
                first = this.pop();
                this.push((int)first, 1);
                break;
            }
            case 312990: {
                first = this.pop();
                this.push(first, 2);
                break;
            }
            case 374507: {
                first = this.pop();
                second = this.pop();
                this.push(second / first, 2);
                break;
            }
            case 277163: {
                this.calculateDup();
                break;
            }
            case 10820: {
                first = this.pop();
                second = this.pop();
                if (first == second) {
                    this.push(1.0, 3);
                    break;
                }
                this.push(0.0, 3);
                break;
            }
            case 3249536: {
                if (this.stack.length < 2) {
                    System.err.println("EXCH - not enough elements on the stack");
                    System.exit(1);
                }
                first = this.pop();
                fType = this.currentType;
                second = this.pop();
                sType = this.currentType;
                this.push(first, fType);
                this.push(second, sType);
                break;
            }
            case 279192: {
                first = this.pop();
                second = this.pop();
                this.push(Math.pow(second, first), 2);
                break;
            }
            case 8418909: {
                this.push(0.0, 3);
                break;
            }
            case 6651169: {
                first = this.pop();
                fType = this.currentType;
                if (first > 0.0) {
                    this.push((int)first, fType);
                    break;
                }
                int temp = (int)first;
                if ((double)temp > first) {
                    this.push(temp - 1, fType);
                    break;
                }
                this.push(first, fType);
                break;
            }
            case 2710: {
                first = this.pop();
                fType = this.currentType;
                second = this.pop();
                sType = this.currentType;
                if (fType != 1 && fType != 2 || sType != 1 && sType != 2) break;
                if (second >= first) {
                    this.push(1.0, 3);
                    break;
                }
                this.push(0.0, 3);
                break;
            }
            case 12850: {
                first = this.pop();
                fType = this.currentType;
                second = this.pop();
                sType = this.currentType;
                if (fType != 1 && fType != 2 || sType != 1 && sType != 2) break;
                if (second > first) {
                    this.push(1.0, 3);
                    break;
                }
                this.push(0.0, 3);
                break;
            }
            case 9739140: {
                int one = this.popInt();
                int two = this.popInt();
                this.push(two / one, 1);
                break;
            }
            case 1889428: {
                this.calculateIndex();
                break;
            }
            case 2715: {
                first = this.pop();
                fType = this.currentType;
                second = this.pop();
                sType = this.currentType;
                if (fType != 1 && fType != 2 || sType != 1 && sType != 2) break;
                if (second <= first) {
                    this.push(1.0, 3);
                    break;
                }
                this.push(0.0, 3);
                break;
            }
            case 12855: {
                first = this.pop();
                fType = this.currentType;
                second = this.pop();
                sType = this.currentType;
                if (fType != 1 && fType != 2 || sType != 1 && sType != 2) break;
                if (second < first) {
                    this.push(1.0, 3);
                    break;
                }
                this.push(0.0, 3);
                break;
            }
            case 8799: {
                first = this.pop();
                this.push(Math.log(first), 2);
                break;
            }
            case 114931: {
                first = this.pop();
                this.push(Math.log10(first), 2);
                break;
            }
            case 62204: {
                if (fType != 1 || sType != 1) {
                    System.err.println("PS_mod - both values must be integers!");
                }
                first = this.pop();
                fType = this.currentType;
                second = this.pop();
                sType = this.currentType;
                this.push(second % first, 1);
                break;
            }
            case 206868: {
                if (this.stack.length < 2) {
                    System.err.println("MUL - not enough elements on the stack");
                    System.exit(1);
                }
                first = this.pop();
                second = this.pop();
                this.push(first * second, 1);
                break;
            }
            case 2717: {
                first = this.pop();
                second = this.pop();
                if (first != second) {
                    this.push(1.0, 3);
                    break;
                }
                this.push(0.0, 3);
                break;
            }
            case 108173: {
                double temp = this.pop();
                fType = this.currentType;
                if (temp != 0.0) {
                    this.push(-temp, fType);
                    break;
                }
                this.push(temp, fType);
                break;
            }
            case 343421: {
                first = this.pop();
                fType = this.currentType;
                if (first == 0.0 && fType == 3) {
                    this.push(1.0, 3);
                    break;
                }
                if (first == 1.0 && fType == 3) {
                    this.push(0.0, 3);
                    break;
                }
                this.push(~((int)first), 1);
                break;
            }
            case 11506: {
                first = this.pop();
                fType = this.currentType;
                second = this.pop();
                fType = this.currentType;
                if (fType == 3 && sType == 3) {
                    this.push((int)first | (int)second, 3);
                    break;
                }
                if (fType != 1 || sType != 1) break;
                this.push((int)first | (int)second, 1);
                break;
            }
            case 273119: {
                this.pop();
                break;
            }
            case 5229553: {
                this.calculateRoll();
                break;
            }
            case 6301689: {
                first = this.pop();
                fType = this.currentType;
                first += 0.5;
                if (first > 0.0) {
                    this.push((int)first, fType);
                    break;
                }
                int tem = (int)first;
                if ((double)tem > first) {
                    this.push(tem - 1, fType);
                    break;
                }
                this.push((int)first, fType);
                break;
            }
            case 233914: {
                first = this.pop();
                this.push(Math.sin(first / 57.29577951308232), 2);
                break;
            }
            case 8992170: {
                first = this.pop();
                if (first >= 0.0) {
                    this.push(Math.sqrt(first), 2);
                    break;
                }
                System.err.println("SQRT - cant sqrt a negative number!");
                break;
            }
            case 31114: {
                if (this.stack.length < 2) {
                    System.err.println("SUB - not enough elements on the stack");
                    System.exit(1);
                }
                first = this.pop();
                fType = this.currentType;
                second = this.pop();
                sType = this.currentType;
                if (fType == 2 || sType == 2) {
                    this.push(second - first, 2);
                    break;
                }
                this.push(second - first, 1);
                break;
            }
            case 6303719: {
                first = this.pop();
                fType = this.currentType;
                this.push((int)first, fType);
                break;
            }
            case 2190935: {
                this.push(1.0, 3);
                break;
            }
            case 308279: {
                firstInt = this.popInt();
                fType = this.currentType;
                int secondInt = this.popInt();
                sType = this.currentType;
                if (fType == 3 && sType == 3) {
                    this.push(firstInt ^ secondInt, 3);
                    break;
                }
                if (fType != 1 || sType != 1) break;
                this.push(firstInt ^ secondInt, 1);
                break;
            }
            default: {
                returnValue = -1;
            }
        }
        return returnValue;
    }

    private void calculateAtan() {
        double first = this.pop();
        double second = this.pop();
        if (first == 0.0 && second == 0.0) {
            System.err.println("ATAN - invalid parameters");
        }
        double tangent = second / first;
        if (first >= 0.0 && second >= 0.0) {
            this.push(Math.toDegrees(Math.atan(tangent)), 2);
        } else if (first > 0.0 && second <= 0.0) {
            double tmp = Math.toDegrees(Math.atan(tangent));
            if (tmp < 0.0) {
                tmp = -tmp;
            }
            this.push(tmp + 90.0, 2);
        } else if (first <= 0.0 && second <= 0.0) {
            double tmp = Math.toDegrees(Math.atan(tangent));
            if (tmp < 0.0) {
                tmp = -tmp;
            }
            this.push(tmp + 180.0, 2);
        } else if (first <= 0.0 && second >= 0.0) {
            double tmp = Math.toDegrees(Math.atan(tangent));
            if (tmp < 0.0) {
                tmp = -tmp;
            }
            this.push(tmp + 270.0, 2);
        }
    }

    private void calculateDup() {
        double value = this.pop();
        int type = this.currentType;
        this.push(value, type);
        this.push(value, type);
    }

    private void calculateIndex() {
        int n = this.popInt();
        if (n == 0) {
            this.calculateDup();
        } else if (n > 0) {
            double[] temp = new double[n];
            int[] types = new int[n];
            int i = 0;
            while (i < temp.length) {
                temp[i] = this.pop();
                types[i] = this.currentType;
                ++i;
            }
            double val = this.pop();
            int fType = this.currentType;
            this.push(val, fType);
            int ii = temp.length;
            while (ii > 0) {
                this.push(temp[ii - 1], types[ii - 1]);
                --ii;
            }
            this.push(val, fType);
        } else if (n < 0) {
            System.err.println("-> Index : critical error, n has to be nonnegative");
        }
    }

    private void calculateRoll() {
        int yy;
        int ii;
        int y;
        int i;
        int[] bottomTypes;
        double[] bottomTemp;
        int[] topTypes;
        double[] topTemp;
        int amount = this.popInt();
        int numberOfElements = this.popInt();
        double elementToBeMoved = 0.0;
        int[] types = new int[numberOfElements - 1];
        if (amount == 1) {
            // empty if block
        }
        if (amount > 0) {
            topTemp = new double[amount];
            topTypes = new int[amount];
            bottomTemp = new double[numberOfElements - amount];
            bottomTypes = new int[numberOfElements - amount];
            i = 0;
            while (i < topTemp.length) {
                topTemp[i] = this.pop();
                topTypes[i] = this.currentType;
                ++i;
            }
            y = 0;
            while (y < bottomTemp.length) {
                bottomTemp[y] = this.pop();
                bottomTypes[y] = this.currentType;
                ++y;
            }
            ii = topTemp.length;
            while (ii > 0) {
                this.push(topTemp[ii - 1], topTypes[ii - 1]);
                --ii;
            }
            yy = bottomTemp.length;
            while (yy > 0) {
                this.push(bottomTemp[yy - 1], bottomTypes[yy - 1]);
                --yy;
            }
        }
        if (amount < 0) {
            amount = -amount;
            topTemp = new double[numberOfElements - amount];
            topTypes = new int[numberOfElements - amount];
            bottomTemp = new double[amount];
            bottomTypes = new int[amount];
            i = 0;
            while (i < topTemp.length) {
                topTemp[i] = this.pop();
                topTypes[i] = this.currentType;
                ++i;
            }
            y = 0;
            while (y < bottomTemp.length) {
                bottomTemp[y] = this.pop();
                bottomTypes[y] = this.currentType;
                ++y;
            }
            ii = topTemp.length;
            while (ii > 0) {
                this.push(topTemp[ii - 1], topTypes[ii - 1]);
                --ii;
            }
            yy = bottomTemp.length;
            while (yy > 0) {
                this.push(bottomTemp[yy - 1], bottomTypes[yy - 1]);
                --yy;
            }
        }
    }

    public double[] executePostscript() {
        this.ptr = 0;
        this.level = 0;
        while (this.ptr < this.streamLength) {
            block7: {
                byte[] nextVal = this.getNextValue();
                if (nextVal != null && (nextVal.length != 1 || nextVal[0] != 123 && nextVal[0] != 125)) {
                    int ID = PostscriptFactory.getCommandID(nextVal);
                    if (ID == -1) {
                        try {
                            double number = this.convertToDouble(nextVal);
                            int numberInt = (int)number;
                            if ((double)numberInt == number) {
                                this.push(number, 1);
                                break block7;
                            }
                            this.push(number, 2);
                        }
                        catch (Exception exception) {}
                    } else {
                        int n = this.execute(ID);
                    }
                }
            }
            if (this.level == 0 || this.ptr >= this.streamLength) break;
        }
        return this.stack;
    }

    private void showStack() {
        String str = "Stack now ";
        int ii = 0;
        while (ii < this.stkPtr) {
            str = String.valueOf(str) + this.stack[ii] + ' ';
            ++ii;
        }
        System.out.println(str);
    }

    private void push(double number, int type) {
        if (this.stkPtr <= 99 && this.stkTypePtr <= 99) {
            this.stack[this.stkPtr] = number;
            this.stackType[this.stkTypePtr] = type;
        }
        ++this.stkPtr;
        ++this.stkTypePtr;
    }

    private double pop() {
        double value = 0.0;
        --this.stkPtr;
        --this.stkTypePtr;
        if (this.stkTypePtr >= 0) {
            this.currentType = this.stackType[this.stkTypePtr];
        }
        if (this.stkPtr >= 0) {
            value = this.stack[this.stkPtr];
        }
        return value;
    }

    private int popInt() {
        return (int)this.pop();
    }

    private double convertToDouble(byte[] stream) {
        int charCount;
        double d = 0.0;
        double dec = 0.0;
        double num = 0.0;
        int start = 0;
        int ptr = charCount = stream.length;
        int intStart = 0;
        boolean isMinus = false;
        int j = charCount - 1;
        while (j > -1) {
            if (stream[start + j] == 46) {
                ptr = j;
                break;
            }
            --j;
        }
        int intChars = ptr;
        if (stream[start] == 43) {
            --intChars;
            ++intStart;
        } else if (stream[start] == 45) {
            ++intStart;
            isMinus = true;
        }
        int intNumbers = intChars - intStart;
        int decNumbers = charCount - ptr;
        if (intNumbers > 3) {
            isMinus = false;
            try {
                d = Double.parseDouble(new String(stream));
            }
            catch (Exception e) {
                d = 0.0;
            }
        } else {
            int c;
            double units = 0.0;
            double tens = 0.0;
            double hundreds = 0.0;
            double tenths = 0.0;
            double hundredths = 0.0;
            double thousands = 0.0;
            double tenthousands = 0.0;
            double hunthousands = 0.0;
            if (intNumbers > 2) {
                c = stream[start + intStart] - 48;
                switch (c) {
                    case 1: {
                        hundreds = 100.0;
                        break;
                    }
                    case 2: {
                        hundreds = 200.0;
                        break;
                    }
                    case 3: {
                        hundreds = 300.0;
                        break;
                    }
                    case 4: {
                        hundreds = 400.0;
                        break;
                    }
                    case 5: {
                        hundreds = 500.0;
                        break;
                    }
                    case 6: {
                        hundreds = 600.0;
                        break;
                    }
                    case 7: {
                        hundreds = 700.0;
                        break;
                    }
                    case 8: {
                        hundreds = 800.0;
                        break;
                    }
                    case 9: {
                        hundreds = 900.0;
                    }
                }
                ++intStart;
            }
            if (intNumbers > 1) {
                c = stream[start + intStart] - 48;
                switch (c) {
                    case 1: {
                        tens = 10.0;
                        break;
                    }
                    case 2: {
                        tens = 20.0;
                        break;
                    }
                    case 3: {
                        tens = 30.0;
                        break;
                    }
                    case 4: {
                        tens = 40.0;
                        break;
                    }
                    case 5: {
                        tens = 50.0;
                        break;
                    }
                    case 6: {
                        tens = 60.0;
                        break;
                    }
                    case 7: {
                        tens = 70.0;
                        break;
                    }
                    case 8: {
                        tens = 80.0;
                        break;
                    }
                    case 9: {
                        tens = 90.0;
                    }
                }
                ++intStart;
            }
            if (intNumbers > 0) {
                c = stream[start + intStart] - 48;
                switch (c) {
                    case 1: {
                        units = 1.0;
                        break;
                    }
                    case 2: {
                        units = 2.0;
                        break;
                    }
                    case 3: {
                        units = 3.0;
                        break;
                    }
                    case 4: {
                        units = 4.0;
                        break;
                    }
                    case 5: {
                        units = 5.0;
                        break;
                    }
                    case 6: {
                        units = 6.0;
                        break;
                    }
                    case 7: {
                        units = 7.0;
                        break;
                    }
                    case 8: {
                        units = 8.0;
                        break;
                    }
                    case 9: {
                        units = 9.0;
                    }
                }
            }
            if (decNumbers > 1) {
                c = stream[start + ++ptr] - 48;
                switch (c) {
                    case 1: {
                        tenths = 0.1;
                        break;
                    }
                    case 2: {
                        tenths = 0.2;
                        break;
                    }
                    case 3: {
                        tenths = 0.3;
                        break;
                    }
                    case 4: {
                        tenths = 0.4;
                        break;
                    }
                    case 5: {
                        tenths = 0.5;
                        break;
                    }
                    case 6: {
                        tenths = 0.6;
                        break;
                    }
                    case 7: {
                        tenths = 0.7;
                        break;
                    }
                    case 8: {
                        tenths = 0.8;
                        break;
                    }
                    case 9: {
                        tenths = 0.9;
                    }
                }
            }
            if (decNumbers > 2) {
                c = stream[start + ++ptr] - 48;
                switch (c) {
                    case 1: {
                        hundredths = 0.01;
                        break;
                    }
                    case 2: {
                        hundredths = 0.02;
                        break;
                    }
                    case 3: {
                        hundredths = 0.03;
                        break;
                    }
                    case 4: {
                        hundredths = 0.04;
                        break;
                    }
                    case 5: {
                        hundredths = 0.05;
                        break;
                    }
                    case 6: {
                        hundredths = 0.06;
                        break;
                    }
                    case 7: {
                        hundredths = 0.07;
                        break;
                    }
                    case 8: {
                        hundredths = 0.08;
                        break;
                    }
                    case 9: {
                        hundredths = 0.09;
                    }
                }
            }
            if (decNumbers > 3) {
                c = stream[start + ++ptr] - 48;
                switch (c) {
                    case 1: {
                        thousands = 0.001;
                        break;
                    }
                    case 2: {
                        thousands = 0.002;
                        break;
                    }
                    case 3: {
                        thousands = 0.003;
                        break;
                    }
                    case 4: {
                        thousands = 0.004;
                        break;
                    }
                    case 5: {
                        thousands = 0.005;
                        break;
                    }
                    case 6: {
                        thousands = 0.006;
                        break;
                    }
                    case 7: {
                        thousands = 0.007;
                        break;
                    }
                    case 8: {
                        thousands = 0.008;
                        break;
                    }
                    case 9: {
                        thousands = 0.009;
                    }
                }
            }
            if (decNumbers > 4) {
                c = stream[start + ++ptr] - 48;
                switch (c) {
                    case 1: {
                        tenthousands = 1.0E-4;
                        break;
                    }
                    case 2: {
                        tenthousands = 2.0E-4;
                        break;
                    }
                    case 3: {
                        tenthousands = 3.0E-4;
                        break;
                    }
                    case 4: {
                        tenthousands = 4.0E-4;
                        break;
                    }
                    case 5: {
                        tenthousands = 5.0E-4;
                        break;
                    }
                    case 6: {
                        tenthousands = 6.0E-4;
                        break;
                    }
                    case 7: {
                        tenthousands = 7.0E-4;
                        break;
                    }
                    case 8: {
                        tenthousands = 8.0E-4;
                        break;
                    }
                    case 9: {
                        tenthousands = 9.0E-4;
                    }
                }
            }
            if (decNumbers > 5) {
                c = stream[start + ++ptr] - 48;
                switch (c) {
                    case 1: {
                        hunthousands = 1.0E-5;
                        break;
                    }
                    case 2: {
                        hunthousands = 2.0E-5;
                        break;
                    }
                    case 3: {
                        hunthousands = 3.0E-5;
                        break;
                    }
                    case 4: {
                        hunthousands = 4.0E-5;
                        break;
                    }
                    case 5: {
                        hunthousands = 5.0E-5;
                        break;
                    }
                    case 6: {
                        hunthousands = 6.0E-5;
                        break;
                    }
                    case 7: {
                        hunthousands = 7.0E-5;
                        break;
                    }
                    case 8: {
                        hunthousands = 8.0E-5;
                        break;
                    }
                    case 9: {
                        hunthousands = 9.0E-5;
                    }
                }
            }
            dec = tenths + hundredths + thousands + tenthousands + hunthousands;
            num = hundreds + tens + units;
            d = num + dec;
        }
        if (isMinus) {
            return -d;
        }
        return d;
    }

    private byte[] getNextValue() {
        byte next = 0;
        byte[] returnValue = null;
        while (this.ptr < this.streamLength && (this.stream[this.ptr] == 10 || this.stream[this.ptr] == 13 || this.stream[this.ptr] == 32)) {
            ++this.ptr;
        }
        int start = this.ptr;
        while (this.ptr < this.streamLength) {
            next = this.stream[this.ptr];
            if (next == 123) break;
            ++this.ptr;
            if (this.ptr >= this.streamLength || (next = this.stream[this.ptr]) == 32 || next == 13 || next == 10 || next == 123 || next == 125) break;
        }
        if (this.stream[start] == 123) {
            ++this.ptr;
            ++this.level;
        } else if (this.stream[start] == 125) {
            --this.level;
        }
        int end = this.ptr;
        if (end >= start) {
            while (end - start > 1 && (this.stream[end - 1] == 48 || this.stream[end - 1] == 46)) {
                --end;
            }
            int len = end - start;
            returnValue = new byte[len];
            System.arraycopy(this.stream, start, returnValue, start - start, end - start);
        }
        return returnValue;
    }

    public void resetStacks(float[] values) {
        this.stack = new double[100];
        this.stackType = new int[100];
        this.stkPtr = 0;
        this.stkTypePtr = 0;
        int ii = 0;
        while (ii < 100) {
            this.stack[ii] = 0.0;
            ++ii;
        }
        int iii = 0;
        while (iii < 100) {
            this.stackType[iii] = 0;
            ++iii;
        }
        int count = values.length;
        int ii2 = 0;
        while (ii2 < count) {
            this.push(values[ii2], 2);
            ++ii2;
        }
    }
}

