/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.function;

import org.jpedal.function.PDFFunction;
import org.jpedal.function.PDFGenericFunction;

public class PDFStitching
extends PDFGenericFunction
implements PDFFunction {
    private PDFFunction[] functions;
    private float[] bounds;
    private int n;

    public PDFStitching(PDFFunction[] functions, float[] encode, float[] bounds, float[] domain, float[] range) {
        super(domain, range);
        if (bounds != null) {
            this.bounds = bounds;
        }
        if (encode != null) {
            this.encode = encode;
        }
        if (functions != null) {
            this.functions = functions;
        }
        this.n = encode.length / 2;
    }

    public float[] compute(float[] values) {
        float x = this.min(this.max(values[0], this.domain[0]), this.domain[1]);
        int subi = this.bounds.length - 1;
        while (subi >= 0) {
            if (x >= this.bounds[subi]) break;
            --subi;
        }
        float[] subinput = new float[1];
        float xmin = this.domain[0];
        float xmax = this.domain[1];
        if (++subi > 0) {
            xmin = this.bounds[subi - 1];
        }
        if (subi < this.bounds.length) {
            xmax = this.bounds[subi];
        }
        float ymin = this.encode[subi * 2];
        float ymax = this.encode[subi * 2 + 1];
        subinput[0] = this.interpolate(x, xmin, xmax, ymin, ymax);
        float[] output = this.functions[subi].computeStitch(subinput);
        float[] result = new float[output.length];
        if (this.range != null) {
            int i = 0;
            while (i != this.range.length / 2) {
                result[i] = this.min(this.max(output[i], this.range[0]), this.range[1]);
                ++i;
            }
        } else {
            int i = 0;
            while (i != output.length) {
                result[i] = output[i];
                ++i;
            }
        }
        return result;
    }

    public float[] computeStitch(float[] values) {
        float x = this.min(this.max(values[0], this.domain[0]), this.domain[1]);
        int subi = this.bounds.length - 1;
        while (subi >= 0) {
            if (x >= this.bounds[subi]) break;
            --subi;
        }
        float[] subinput = new float[1];
        float xmin = this.domain[0];
        float xmax = this.domain[1];
        if (++subi > 0) {
            xmin = this.bounds[subi - 1];
        }
        if (subi < this.bounds.length) {
            xmax = this.bounds[subi];
        }
        float ymin = this.encode[subi * 2];
        float ymax = this.encode[subi * 2 + 1];
        subinput[0] = this.interpolate(x, xmin, xmax, ymin, ymax);
        float[] output = this.functions[subi].compute(subinput);
        float[] result = new float[output.length];
        int i = 0;
        while (i != this.range.length / 2) {
            result[i] = this.range != null ? this.min(this.max(output[i], this.range[0]), this.range[1]) : output[i];
            ++i;
        }
        return result;
    }
}

