/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.function;

import org.jpedal.function.PDFFunction;
import org.jpedal.function.PDFGenericFunction;

public class PDFSampled
extends PDFGenericFunction
implements PDFFunction {
    private int[] size;
    private int BitsPerSample = 0;
    private float[] samples;
    int returnValues;

    public PDFSampled(byte[] stream, int bits, float[] domain, float[] range, float[] encode, float[] decode, int[] size) {
        super(domain, range);
        int count;
        int byteReached;
        int count2;
        int ii;
        int defaultSize;
        this.size = size;
        this.BitsPerSample = bits;
        if (encode != null) {
            this.encode = encode;
        } else {
            defaultSize = size.length;
            this.encode = new float[defaultSize * 2];
            ii = 0;
            while (ii < defaultSize) {
                this.encode[ii * 2 + 1] = size[ii] - 1;
                ++ii;
            }
        }
        if (decode != null) {
            this.decode = decode;
        } else {
            defaultSize = range.length;
            this.decode = new float[defaultSize];
            System.arraycopy(range, 0, this.decode, 0, defaultSize);
        }
        if (this.BitsPerSample == 8) {
            count2 = stream.length;
            this.samples = new float[count2];
            ii = 0;
            while (ii < count2) {
                this.samples[ii] = (float)(stream[ii] & 0xFF) / 256.0f;
                ++ii;
            }
        } else if (this.BitsPerSample == 4) {
            count2 = stream.length * 2;
            this.samples = new float[count2];
            byteReached = 0;
            int ii2 = 0;
            while (ii2 < count2) {
                this.samples[ii2] = (float)((stream[byteReached] & 0xF0) >> 4) / 16.0f;
                this.samples[ii2] = (float)(stream[byteReached] & 0xF) / 16.0f;
                ++byteReached;
                ++ii2;
            }
        } else if (this.BitsPerSample == 2) {
            count2 = stream.length * 4;
            this.samples = new float[count2];
            byteReached = 0;
            int ii3 = 0;
            while (ii3 < count2) {
                this.samples[ii3] = (float)((stream[byteReached] & 0xC0) >> 6) / 4.0f;
                this.samples[ii3] = (float)((stream[byteReached] & 0x30) >> 4) / 4.0f;
                this.samples[ii3] = (float)((stream[byteReached] & 0xC) >> 2) / 4.0f;
                this.samples[ii3] = (float)(stream[byteReached] & 3) / 4.0f;
                ++byteReached;
                ++ii3;
            }
        } else if (this.BitsPerSample == 1) {
            count2 = stream.length * 8;
            this.samples = new float[count2];
            byteReached = 0;
            int ii4 = 0;
            while (ii4 < count2) {
                this.samples[ii4] = (float)((stream[byteReached] & 0x80) >> 7) / 2.0f;
                this.samples[ii4] = (float)((stream[byteReached] & 0x40) >> 6) / 2.0f;
                this.samples[ii4] = (float)((stream[byteReached] & 0x20) >> 5) / 2.0f;
                this.samples[ii4] = (float)((stream[byteReached] & 0x10) >> 4) / 2.0f;
                this.samples[ii4] = (float)((stream[byteReached] & 8) >> 3) / 2.0f;
                this.samples[ii4] = (float)((stream[byteReached] & 4) >> 2) / 2.0f;
                this.samples[ii4] = (float)((stream[byteReached] & 2) >> 1) / 2.0f;
                this.samples[ii4] = (float)(stream[byteReached] & 1) / 2.0f;
                ++byteReached;
                ++ii4;
            }
        } else if (this.BitsPerSample == 12) {
            int samplesPerByte = 16 / this.BitsPerSample;
            count = stream.length * samplesPerByte * 2;
            this.samples = new float[count];
            int byteReached2 = 0;
            int bitsLeft = 0;
            int maxSize = (2 << this.BitsPerSample) - 1;
            int ii5 = 0;
            while (ii5 < count) {
                int jj = 0;
                while (jj < samplesPerByte) {
                    this.samples[ii5] = (((stream[byteReached2] << 8) + stream[byteReached2] & maxSize << 16 - jj * this.BitsPerSample) >> 16 - this.BitsPerSample) / maxSize;
                    ++jj;
                }
                while (bitsLeft > 16) {
                    byteReached2 += 2;
                    bitsLeft -= 16;
                }
                ++ii5;
            }
        } else {
            int bytes = this.BitsPerSample / 8;
            count = stream.length / bytes;
            this.samples = new float[count];
            int byteReached3 = 0;
            long maxSize = 0L;
            if (this.BitsPerSample == 16) {
                maxSize = 65536L;
            } else if (this.BitsPerSample == 24) {
                maxSize = 0x1000000L;
            } else if (this.BitsPerSample == 32) {
                maxSize = 0x19990000L;
            } else {
                System.out.println("Unexpected value in PDFSampled" + this.BitsPerSample);
                System.exit(1);
            }
            int ii6 = 0;
            while (ii6 < count) {
                long val = 0L;
                int aa = 0;
                while (aa < bytes) {
                    val += (long)((stream[byteReached3 + aa] & 0xFF) << 8 * (bytes - aa - 1));
                    ++aa;
                }
                this.samples[ii6] = (float)val / (float)maxSize;
                byteReached3 += bytes;
                ++ii6;
            }
        }
        this.returnValues = range.length / 2;
    }

    public float[] computeStitch(float[] subinput) {
        return this.compute(subinput);
    }

    public float[] compute(float[] input) {
        float[] result = new float[this.returnValues];
        int m = this.domain.length / 2;
        int n = this.range.length / 2;
        float[] e = new float[m * 2];
        float[] x = input;
        int i = 0;
        while (i < m) {
            int j;
            e[i * 2] = this.encodeInput(x[i], i);
            if (n == m) {
                result[this.returnValues - i - 1] = this.decodeSample(e[i * 2], i, n, 0);
            } else if (m < n) {
                j = 0;
                while (j < n) {
                    result[this.returnValues - j - 1] = this.decodeSample(e[i * 2], j, n, j);
                    ++j;
                }
            } else if (n < m) {
                j = 0;
                while (j < n) {
                    result[this.returnValues - j - 1] = this.decodeSample(e[i * 2], j, n, j);
                    ++j;
                }
            }
            ++i;
        }
        return result;
    }

    private float encodeInput(float value, int point) {
        value = this.min(this.max(value, this.domain[point * 2]), this.domain[point * 2 + 1]);
        value = this.interpolate(value, this.domain[point * 2], this.domain[point * 2 + 1], this.encode[point * 2], this.encode[point * 2 + 1]);
        value = this.min(this.max(value, 0.0f), this.size[point] - 1);
        return value;
    }

    private float decodeSample(float value, int j, int n, int modifier) {
        int sample = (int)value;
        if (value - (float)((int)value) > 0.0f) {
            sample = (int)value + 1;
        }
        float frac1 = (float)sample - value;
        float frac0 = 1.0f - frac1;
        int lower = (int)value * n + modifier;
        int upper = sample * n + modifier;
        float output = frac1 * this.samples[lower] + frac0 * this.samples[upper];
        output = this.interpolate(output, 0.0f, 1.0f, this.decode[j * 2], this.decode[j * 2 + 1]);
        output = this.min(this.max(output, this.range[j * 2]), this.range[j * 2 + 1]);
        return output;
    }
}

