/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.function;

import org.jpedal.function.PDFFunction;
import org.jpedal.function.PDFGenericFunction;

public class PDFExponential
extends PDFGenericFunction
implements PDFFunction {
    private float[] C0 = new float[]{0.0f};
    private float[] C1 = new float[]{1.0f};
    private float N;
    int returnValues;

    public PDFExponential(float N, float[] C0, float[] C1, float[] domain, float[] range) {
        super(domain, range);
        this.N = N;
        if (C0 != null) {
            this.C0 = C0;
        }
        if (C1 != null) {
            this.C1 = C1;
        }
        this.returnValues = this.C0.length;
    }

    public float[] computeStitch(float[] subinput) {
        return this.compute(subinput);
    }

    public float[] compute(float[] values) {
        float[] output = new float[this.returnValues];
        float[] result = new float[this.returnValues];
        float x = this.min(this.max(values[0], this.domain[0]), this.domain[1]);
        if (this.N == 1.0f) {
            int i = 0;
            while (i < this.C0.length) {
                output[i] = this.C0[i] + x * (this.C1[i] - this.C0[i]);
                if (this.range != null) {
                    output[i] = this.min(this.max(output[i], this.range[i * 2]), this.range[i * 2 + 1]);
                }
                result[result.length - (i + 1)] = output[i];
                ++i;
            }
        } else {
            int i = 0;
            while (i < this.C0.length) {
                output[i] = this.C0[i] + (float)Math.pow(x, this.N) * (this.C1[i] - this.C0[i]);
                if (this.range != null) {
                    output[i] = this.min(this.max(output[i], this.range[i * 2]), this.range[i * 2 + 1]);
                }
                result[result.length - (i + 1)] = output[i];
                ++i;
            }
        }
        return result;
    }
}

