/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.function;

import org.jpedal.function.PDFFunction;
import org.jpedal.function.PDFGenericFunction;
import org.jpedal.function.PostscriptFactory;

public class PDFCalculator
extends PDFGenericFunction
implements PDFFunction {
    int returnValues;
    byte[] stream;

    public PDFCalculator(byte[] stream, float[] domain, float[] range) {
        super(domain, range);
        this.returnValues = range.length / 2;
        this.stream = stream;
    }

    public float[] computeStitch(float[] subinput) {
        return this.compute(subinput);
    }

    public float[] compute(float[] values) {
        float[] output = new float[this.returnValues];
        float[] result = new float[this.returnValues];
        try {
            PostscriptFactory post = new PostscriptFactory(this.stream);
            post.resetStacks(values);
            double[] stack = post.executePostscript();
            if (this.domain.length / 2 == 1) {
                int i = 0;
                int imax = this.range.length / 2;
                while (i < imax) {
                    output[i] = (float)stack[imax - i - 1];
                    result[this.returnValues - i - 1] = this.min(this.max(output[i], this.range[i * 2]), this.range[i * 2 + 1]);
                    ++i;
                }
            } else {
                int i = 0;
                int imax = this.range.length / 2;
                while (i < imax) {
                    output[i] = (float)stack[i];
                    result[this.returnValues - i - 1] = this.min(this.max(output[i], this.range[i * 2]), this.range[i * 2 + 1]);
                    ++i;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }
}

