/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.function;

import java.util.Map;
import java.util.StringTokenizer;
import org.jpedal.function.PDFCalculator;
import org.jpedal.function.PDFExponential;
import org.jpedal.function.PDFFunction;
import org.jpedal.function.PDFGenericFunction;
import org.jpedal.function.PDFSampled;
import org.jpedal.function.PDFStitching;
import org.jpedal.io.PdfArray;
import org.jpedal.io.PdfObjectReader;
import org.jpedal.utils.Strip;

public class FunctionFactory {
    public static PDFFunction getFunction(byte[] stream, Map tintTransform, float[] domain, float[] range, int type, PdfObjectReader currentPdfFile) {
        PDFGenericFunction newFunction = null;
        String bitsCount = (String)tintTransform.get("BitsPerSample");
        int bits = 0;
        if (bitsCount != null) {
            bits = Integer.parseInt(bitsCount);
        }
        String decodeArray = (String)tintTransform.get("Decode");
        float[] decode = null;
        if (decodeArray != null) {
            decode = PdfArray.convertToFloatArray(currentPdfFile.getValue(decodeArray));
        }
        String C0Array = (String)tintTransform.get("C0");
        float[] C0 = null;
        if (C0Array != null) {
            C0 = PdfArray.convertToFloatArray(currentPdfFile.getValue(C0Array));
        }
        String C1Array = (String)tintTransform.get("C1");
        float[] C1 = null;
        if (C1Array != null) {
            C1 = PdfArray.convertToFloatArray(currentPdfFile.getValue(C1Array));
        }
        String sizeVal = (String)tintTransform.get("Size");
        int[] size = null;
        if (sizeVal != null) {
            size = PdfArray.convertToIntArray(currentPdfFile.getValue(sizeVal));
        }
        String encodeArray = (String)tintTransform.get("Encode");
        float[] encode = null;
        if (encodeArray != null) {
            encode = PdfArray.convertToFloatArray(currentPdfFile.getValue(encodeArray));
        }
        String boundsArray = (String)tintTransform.get("Bounds");
        float[] bounds = null;
        if (boundsArray != null) {
            bounds = PdfArray.convertToFloatArray(currentPdfFile.getValue(boundsArray));
        }
        float N = 0.0f;
        String value = (String)tintTransform.get("N");
        if (value != null) {
            N = Float.parseFloat(value);
        }
        String functionValues = (String)tintTransform.get("Functions");
        PDFFunction[] functions = null;
        if (functionValues != null) {
            if (functionValues.indexOf(91) == -1) {
                functionValues = (String)currentPdfFile.readObject(functionValues, false, null).get("rawValue");
            }
            StringTokenizer functionIDs = new StringTokenizer(Strip.removeArrayDeleminators(functionValues), "R");
            int functionCount = functionIDs.countTokens();
            Map[] subFunction = new Map[functionCount];
            int i = 0;
            while (i < functionCount) {
                String id = (String.valueOf(functionIDs.nextToken()) + 'R').trim();
                Map fn = currentPdfFile.readObject(id, false, null);
                currentPdfFile.readStream(id, true);
                subFunction[i] = fn;
                ++i;
            }
            functions = new PDFFunction[subFunction.length];
            int i1 = 0;
            int imax = subFunction.length;
            while (i1 < imax) {
                if (subFunction[i1].containsKey("CachedStream")) {
                    currentPdfFile.readStreamIntoMemory(subFunction[i1]);
                }
                byte[] subStream = (byte[])subFunction[i1].get("DecodedStream");
                int subFunctionType = Integer.parseInt((String)subFunction[i1].get("FunctionType"));
                float[] subDomain = null;
                float[] subRange = null;
                value = (String)subFunction[i1].get("Domain");
                if (value != null) {
                    subDomain = PdfArray.convertToFloatArray(currentPdfFile.getValue(value));
                }
                if ((value = (String)subFunction[i1].get("Range")) != null) {
                    subRange = PdfArray.convertToFloatArray(currentPdfFile.getValue(value));
                }
                functions[i1] = FunctionFactory.getFunction(subStream, subFunction[i1], subDomain, subRange, subFunctionType, currentPdfFile);
                ++i1;
            }
        }
        switch (type) {
            case 0: {
                newFunction = new PDFSampled(stream, bits, domain, range, encode, decode, size);
                break;
            }
            case 2: {
                newFunction = new PDFExponential(N, C0, C1, domain, range);
                break;
            }
            case 3: {
                newFunction = new PDFStitching(functions, encode, bounds, domain, range);
                break;
            }
            case 4: {
                newFunction = new PDFCalculator(stream, domain, range);
            }
        }
        return newFunction;
    }
}

