/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.fonts.tt;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.ObjectOutput;
import java.io.Serializable;
import org.jpedal.color.PdfPaint;
import org.jpedal.fonts.glyph.PdfGlyph;
import org.jpedal.fonts.tt.FirstPoint;
import org.jpedal.fonts.tt.FontFile2;
import org.jpedal.fonts.tt.Glyf;
import org.jpedal.fonts.tt.Hmtx;
import org.jpedal.gui.ShowGUIMessage;
import org.jpedal.io.PathSerializer;
import org.jpedal.utils.repositories.Vector_Double;
import org.jpedal.utils.repositories.Vector_Int;
import org.jpedal.utils.repositories.Vector_Object;
import org.jpedal.utils.repositories.Vector_Path;
import org.jpedal.utils.repositories.Vector_Short;

public class TTGlyph
implements PdfGlyph,
Serializable {
    private short minX;
    private short minY;
    private short maxX;
    private short maxY;
    private Vector_Int xtranslateValues = new Vector_Int(5);
    private Vector_Int ytranslateValues = new Vector_Int(5);
    private Vector_Double xscaleValues = new Vector_Double(5);
    private Vector_Double yscaleValues = new Vector_Double(5);
    private Vector_Double scale01Values = new Vector_Double(5);
    private Vector_Double scale10Values = new Vector_Double(5);
    private int xtranslate;
    private int ytranslate;
    private double xscale = 1.0;
    private double yscale = 1.0;
    private double scale01 = 0.0;
    private double scale10 = 0.0;
    private Vector_Object glyfX = new Vector_Object(5);
    private Vector_Object glyfY = new Vector_Object(5);
    private Vector_Object curves = new Vector_Object(5);
    private Vector_Object contours = new Vector_Object(5);
    private int contourCount = 0;
    private float unitsPerEm = 64.0f;
    public boolean debug = false;
    private transient Vector_Path paths = new Vector_Path(10);
    private int compCount = 1;
    private boolean isComposite = false;
    String glyfName = "";
    private int idx = 0;
    Area glyphShape = null;

    public void setPaths(Vector_Path vp) {
        this.paths = vp;
    }

    public void writePathsToStream(ObjectOutput os) throws IOException {
        if (this.paths != null) {
            GeneralPath[] generalPaths = this.paths.get();
            int count = 0;
            int i = 0;
            while (i < generalPaths.length) {
                if (generalPaths[i] == null) {
                    count = i;
                    break;
                }
                ++i;
            }
            os.writeObject(new Integer(count));
            i = 0;
            while (i < count) {
                PathIterator pathIterator = generalPaths[i].getPathIterator(new AffineTransform());
                PathSerializer.serializePath(os, pathIterator);
                ++i;
            }
        }
    }

    public TTGlyph() {
    }

    public TTGlyph(String glyfName, boolean debug, Glyf currentGlyf, FontFile2 currentFontFile, Hmtx currentHmtx, int idx, float unitsPerEm) {
        this.debug = debug;
        this.idx = idx;
        this.glyfName = glyfName;
        this.unitsPerEm = unitsPerEm;
        this.readGlyph(currentGlyf, currentFontFile, null);
        int i = 0;
        while (i < this.compCount) {
            int[] pX = (int[])this.glyfX.elementAt(i);
            int[] pY = (int[])this.glyfY.elementAt(i);
            boolean[] onCurve = (boolean[])this.curves.elementAt(i);
            boolean[] endOfContour = (boolean[])this.contours.elementAt(i);
            if (this.isComposite) {
                this.xtranslate = this.xtranslateValues.elementAt(i);
                this.ytranslate = this.ytranslateValues.elementAt(i);
                this.xscale = this.xscaleValues.elementAt(i);
                this.yscale = this.yscaleValues.elementAt(i);
                this.scale01 = this.scale01Values.elementAt(i);
                this.scale10 = this.scale10Values.elementAt(i);
            }
            this.drawGlyf(pX, pY, onCurve, endOfContour, debug);
            if (debug) {
                try {
                    System.out.println("debugging" + idx);
                    BufferedImage img = new BufferedImage(1200, 1200, 2);
                    Graphics2D gg2 = img.createGraphics();
                    int jj = 0;
                    while (jj < this.paths.size() - 1) {
                        if (jj == 1) {
                            gg2.setColor(Color.red);
                        }
                        gg2.fill(this.paths.elementAt(jj));
                        System.out.println(String.valueOf(jj) + " " + this.paths.elementAt(jj).getBounds2D());
                        gg2.draw(this.paths.elementAt(jj).getBounds());
                        ++jj;
                    }
                    ShowGUIMessage.showGUIMessage("glyf /" + this.paths.size(), img, "glyf /" + this.paths.size() + '/' + this.compCount);
                }
                catch (Exception ee) {
                    ee.printStackTrace();
                    System.exit(1);
                }
            }
            ++i;
        }
    }

    private final void readGlyph(Glyf currentGlyf, FontFile2 currentFontFile, FirstPoint fp) {
        this.contourCount = currentFontFile.getNextUint16();
        this.minX = (short)currentFontFile.getNextUint16();
        this.minY = (short)currentFontFile.getNextUint16();
        this.maxX = (short)currentFontFile.getNextUint16();
        this.maxY = (short)currentFontFile.getNextUint16();
        if (this.debug) {
            System.out.println("------------------------------------------------------------");
            System.out.println("minX=" + this.minX + ' ' + this.minY + ' ' + this.minY + " maxX=" + this.maxX + " maxY=" + this.maxY + " contourCount=" + this.contourCount);
        }
        if (this.contourCount != 65535) {
            this.readSimpleGlyph(currentFontFile, fp);
        } else {
            this.readComplexGlyph(currentGlyf, currentFontFile);
        }
    }

    private final void readComplexGlyph(Glyf currentGlyf, FontFile2 currentFontFile) {
        this.isComposite = true;
        FirstPoint fp = null;
        while (true) {
            int dy;
            int dx;
            boolean WE_HAVE_A_TWO_BY_TWO;
            short flag = currentFontFile.getShort();
            short glyphIndex = currentFontFile.getNextInt16();
            if (this.debug) {
                System.out.println("Index=" + glyphIndex + " flag=" + flag);
            }
            boolean ARG_1AND_2_ARE_WORDS = (flag & 1) == 1;
            boolean ARGS_ARE_XY_VALUES = (flag & 2) == 2;
            boolean WE_HAVE_A_SCALE = (flag & 8) == 8;
            boolean WE_HAVE_AN_X_AND_Y_SCALE = (flag & 0x40) == 64;
            boolean bl = WE_HAVE_A_TWO_BY_TWO = (flag & 0x80) == 128;
            if (ARG_1AND_2_ARE_WORDS && ARGS_ARE_XY_VALUES) {
                this.xtranslate = currentFontFile.getNextInt16();
                this.ytranslate = currentFontFile.getNextInt16();
            } else if (!ARG_1AND_2_ARE_WORDS && ARGS_ARE_XY_VALUES) {
                this.xtranslate = currentFontFile.getNextint8();
                this.ytranslate = currentFontFile.getNextint8();
            } else if (ARG_1AND_2_ARE_WORDS && !ARGS_ARE_XY_VALUES) {
                dx = currentFontFile.getNextInt16();
                dy = currentFontFile.getNextInt16();
                this.xtranslate = 0;
                this.ytranslate = 0;
                fp = new FirstPoint(dx, dy);
            } else if (!ARG_1AND_2_ARE_WORDS && !ARGS_ARE_XY_VALUES) {
                dx = currentFontFile.getNextint8();
                dy = currentFontFile.getNextint8();
                this.xtranslate = 0;
                this.ytranslate = 0;
            }
            this.xscale = 1.0;
            this.scale01 = 0.0;
            this.yscale = 1.0;
            this.scale10 = 0.0;
            if (WE_HAVE_A_SCALE || WE_HAVE_AN_X_AND_Y_SCALE || WE_HAVE_A_TWO_BY_TWO) {
                if (WE_HAVE_A_SCALE && !WE_HAVE_AN_X_AND_Y_SCALE && !WE_HAVE_A_TWO_BY_TWO) {
                    this.xscale = currentFontFile.getF2Dot14();
                    this.scale01 = 0.0;
                    this.yscale = this.xscale;
                    this.scale10 = 0.0;
                } else if (!WE_HAVE_A_SCALE && WE_HAVE_AN_X_AND_Y_SCALE && !WE_HAVE_A_TWO_BY_TWO) {
                    this.xscale = currentFontFile.getF2Dot14();
                    this.scale01 = 0.0;
                    this.yscale = currentFontFile.getF2Dot14();
                    this.scale10 = 0.0;
                } else if (!WE_HAVE_A_SCALE && !WE_HAVE_AN_X_AND_Y_SCALE && WE_HAVE_A_TWO_BY_TWO) {
                    this.xscale = currentFontFile.getF2Dot14();
                    this.scale01 = currentFontFile.getF2Dot14();
                    this.yscale = currentFontFile.getF2Dot14();
                    this.scale10 = currentFontFile.getF2Dot14();
                }
            }
            this.xtranslateValues.addElement(this.xtranslate);
            this.ytranslateValues.addElement(this.ytranslate);
            this.xscaleValues.addElement(this.xscale);
            this.yscaleValues.addElement(this.yscale);
            this.scale01Values.addElement(this.scale01);
            this.scale10Values.addElement(this.scale10);
            int pointer = currentFontFile.getPointer();
            int p = currentGlyf.getCharString(glyphIndex);
            if (p != -1) {
                if (p < 0) {
                    p = -p;
                }
                currentFontFile.setPointer(p);
                this.readGlyph(currentGlyf, currentFontFile, fp);
            } else {
                System.err.println("Wrong value in complex");
            }
            currentFontFile.setPointer(pointer);
            if ((flag & 0x20) == 0) break;
            ++this.compCount;
        }
    }

    private final void readSimpleGlyph(FontFile2 currentFontFile, FirstPoint fp) {
        int flag;
        int flagCount = 1;
        short x1 = 0;
        Vector_Int rawFlags = new Vector_Int(50);
        Vector_Int endPts = new Vector_Int(50);
        Vector_Short XX = new Vector_Short(50);
        Vector_Short Y = new Vector_Short(50);
        boolean hasFirstPoint = false;
        if (fp != null) {
            rawFlags.addElement(1);
            XX.addElement((short)fp.x);
            Y.addElement((short)fp.y);
        }
        if (this.debug) {
            System.out.println("endPoints");
            System.out.println("---------");
        }
        int lastPt = 0;
        int i = 0;
        while (i < this.contourCount) {
            lastPt = currentFontFile.getNextUint16();
            if (this.debug) {
                System.out.println(String.valueOf(i) + " " + lastPt);
            }
            if (hasFirstPoint) {
                ++lastPt;
            }
            endPts.addElement(lastPt);
            ++i;
        }
        int instructionLength = currentFontFile.getNextUint16();
        int[] instructions = new int[instructionLength];
        int i2 = 0;
        while (i2 < instructionLength) {
            instructions[i2] = currentFontFile.getNextUint8();
            ++i2;
        }
        if (this.debug) {
            System.out.println("Instructions");
            System.out.println("------------");
            System.out.println("count=" + instructionLength);
        }
        int count = lastPt + 1;
        int i3 = 0;
        while (i3 < count) {
            flag = currentFontFile.getNextUint8();
            rawFlags.addElement(flag);
            ++flagCount;
            if ((flag & 8) == 8) {
                int repeatCount = currentFontFile.getNextUint8();
                int r = 1;
                while (r <= repeatCount) {
                    rawFlags.addElement(flag);
                    ++flagCount;
                    ++r;
                }
                i3 += repeatCount;
            }
            ++i3;
        }
        i3 = 0;
        while (i3 < count) {
            boolean twoByteValue;
            flag = rawFlags.elementAt(i3);
            boolean bl = twoByteValue = (flag & 2) == 0;
            if ((flag & 0x10) != 0) {
                if ((flag & 2) != 0) {
                    x1 = (short)currentFontFile.getNextUint8();
                    XX.addElement(x1);
                } else {
                    XX.addElement((short)0);
                }
            } else if ((flag & 2) != 0) {
                x1 = (short)(-currentFontFile.getNextUint8());
                XX.addElement(x1);
            } else {
                x1 = currentFontFile.getNextSignedInt16();
                XX.addElement(x1);
            }
            ++i3;
        }
        i3 = 0;
        while (i3 < count) {
            flag = rawFlags.elementAt(i3);
            if ((flag & 0x20) != 0) {
                if ((flag & 4) != 0) {
                    Y.addElement((short)currentFontFile.getNextUint8());
                } else {
                    Y.addElement((short)0);
                }
            } else if ((flag & 4) != 0) {
                Y.addElement((short)(-currentFontFile.getNextUint8()));
            } else {
                short val = currentFontFile.getNextSignedInt16();
                Y.addElement(val);
            }
            ++i3;
        }
        int endPtIndex = 0;
        int x = 0;
        int y = 0;
        int[] flags = rawFlags.get();
        int[] endPtsOfContours = endPts.get();
        short[] XPoints = XX.get();
        short[] YPoints = Y.get();
        count = XPoints.length;
        int[] pX = new int[count + 2];
        int[] pY = new int[count + 2];
        boolean[] onCurve = new boolean[count + 2];
        boolean[] endOfContour = new boolean[count + 2];
        if (this.debug) {
            System.out.println("Points");
            System.out.println("------");
        }
        int i4 = 0;
        while (i4 < count) {
            boolean endPt;
            boolean bl = endPt = endPtsOfContours[endPtIndex] == i4;
            if (endPt) {
                ++endPtIndex;
            }
            pX[i4] = x += XPoints[i4];
            pY[i4] = y += YPoints[i4];
            onCurve[i4] = i4 < flagCount ? (flags[i4] & 1) != 0 : false;
            if (this.debug) {
                System.out.println(String.valueOf(i4) + " " + pX[i4] + ' ' + pY[i4] + ' ' + onCurve[i4]);
            }
            endOfContour[i4] = endPt;
            ++i4;
        }
        this.glyfX.addElement(pX);
        this.glyfY.addElement(pY);
        this.curves.addElement(onCurve);
        this.contours.addElement(endOfContour);
    }

    public void render(int type, Graphics2D g2, boolean debug, float scaling) {
        int jj = 0;
        while (jj < this.paths.size() - 1) {
            if ((type & 2) == 2) {
                g2.fill(this.paths.elementAt(jj));
            }
            if ((type & 1) == 1) {
                g2.draw(this.paths.elementAt(jj));
            }
            ++jj;
        }
    }

    public Area getShape() {
        if (this.glyphShape == null) {
            GeneralPath path = this.paths.elementAt(0);
            int jj = 1;
            while (jj < this.paths.size() - 1) {
                path.append(this.paths.elementAt(jj), false);
                ++jj;
            }
            this.glyphShape = new Area(path);
        }
        return this.glyphShape;
    }

    public String getGlyphName() {
        return null;
    }

    public void drawGlyf(int[] pX, int[] pY, boolean[] onCurve, boolean[] endOfContour, boolean debug) {
        GeneralPath current_path = new GeneralPath(1);
        int c = pX.length;
        int fc = -1;
        int jj = 0;
        while (jj < c) {
            if (endOfContour[jj]) {
                fc = jj + 1;
                jj = c;
            }
            ++jj;
        }
        boolean firstIndex = false;
        boolean count = false;
        int x1 = this.convertX(pX[0], pY[0]);
        int y1 = this.convertY(pX[0], pY[0]);
        int x2 = 0;
        int y2 = 0;
        int x3 = 0;
        int y3 = 0;
        current_path.moveTo(x1, y1);
        if (debug) {
            System.out.println("first contour=" + fc + "====================================" + pX[0] + ' ' + pY[0]);
            System.out.println("start=" + x1 + ' ' + y1 + " unitsPerEm=" + this.unitsPerEm);
            int i = 0;
            while (i < c - 2) {
                System.out.println(String.valueOf(i) + " " + this.convertX(pX[i], pY[i]) + ' ' + this.convertY(pX[i], pY[i]) + ' ' + onCurve[i] + ' ' + endOfContour[i] + " raw=" + pX[i] + ' ' + pY[i]);
                ++i;
            }
            System.out.println("Move to " + x1 + ' ' + y1);
        }
        int xs = 0;
        int ys = 0;
        int lc = 0;
        boolean isEnd = false;
        int j = 0;
        while (j < c - 2) {
            int p = j % fc;
            int p1 = (j + 1) % fc;
            int p2 = (j + 2) % fc;
            int pm1 = (j - 1) % fc;
            if (j == 0) {
                pm1 = fc - 1;
            }
            if (p1 < lc) {
                p1 += lc;
            }
            if (p2 < lc) {
                p2 += lc;
            }
            if (debug) {
                System.out.println("points=" + lc + '/' + fc + ' ' + pm1 + ' ' + p + ' ' + p1 + ' ' + p2);
            }
            if (endOfContour[j]) {
                isEnd = true;
                xs = this.convertX(pX[fc], pY[fc]);
                ys = this.convertY(pX[fc], pY[fc]);
                lc = fc;
                int jj2 = j + 1;
                while (jj2 < c) {
                    if (endOfContour[jj2]) {
                        fc = jj2 + 1;
                        jj2 = c;
                    }
                    ++jj2;
                }
                if (debug) {
                    System.out.println("End of contour. next=" + j + ' ' + fc + ' ' + lc);
                }
            }
            if (debug) {
                if (j > 0) {
                    System.out.println(String.valueOf(endOfContour[j - 1]) + " " + endOfContour[j] + ' ' + endOfContour[j + 1]);
                } else {
                    System.out.println(String.valueOf(endOfContour[j]) + " " + endOfContour[j + 1]);
                }
                System.out.println("curves=" + onCurve[p] + ' ' + onCurve[p1] + ' ' + onCurve[p2]);
            }
            if (lc == fc && onCurve[p]) {
                j = c;
                if (debug) {
                    System.out.println("last 2 match");
                }
            } else {
                if (debug) {
                    System.out.println(String.valueOf(fc) + " " + pm1 + ' ' + p + ' ' + p1 + ' ' + p2);
                }
                if (onCurve[p] && onCurve[p1]) {
                    x3 = this.convertX(pX[p1], pY[p1]);
                    y3 = this.convertY(pX[p1], pY[p1]);
                    current_path.lineTo(x3, y3);
                    if (debug) {
                        System.out.println(String.valueOf(p) + " pt,pt " + x3 + ' ' + y3);
                    }
                } else if (j < c - 3 && fc - lc > 1 | fc == lc) {
                    boolean checkEnd = false;
                    if (onCurve[p] && !onCurve[p1] && onCurve[p2]) {
                        x1 = this.convertX(pX[p], pY[p]);
                        y1 = this.convertY(pX[p], pY[p]);
                        x2 = this.convertX(pX[p1], pY[p1]);
                        y2 = this.convertY(pX[p1], pY[p1]);
                        x3 = this.convertX(pX[p2], pY[p2]);
                        y3 = this.convertY(pX[p2], pY[p2]);
                        ++j;
                        checkEnd = true;
                        if (debug) {
                            System.out.println(String.valueOf(p) + " pt,cv,pt " + x1 + ' ' + y1 + ' ' + x2 + ' ' + y2 + ' ' + x3 + ' ' + y3);
                        }
                    } else if (onCurve[p] && !onCurve[p1] && !onCurve[p2]) {
                        x1 = this.convertX(pX[p], pY[p]);
                        y1 = this.convertY(pX[p], pY[p]);
                        x2 = this.convertX(pX[p1], pY[p1]);
                        y2 = this.convertY(pX[p1], pY[p1]);
                        x3 = this.convertX(this.midPt(pX[p1], pX[p2]), this.midPt(pY[p1], pY[p2]));
                        y3 = this.convertY(this.midPt(pX[p1], pX[p2]), this.midPt(pY[p1], pY[p2]));
                        ++j;
                        if (debug) {
                            System.out.println(String.valueOf(p) + " pt,cv,cv " + x1 + ' ' + y1 + ' ' + x2 + ' ' + y2 + ' ' + x3 + ' ' + y3);
                        }
                    } else if (!(onCurve[p] || onCurve[p1] || endOfContour[p2])) {
                        x1 = this.convertX(this.midPt(pX[pm1], pX[p]), this.midPt(pY[pm1], pY[p]));
                        y1 = this.convertY(this.midPt(pX[pm1], pX[p]), this.midPt(pY[pm1], pY[p]));
                        x2 = this.convertX(pX[p], pY[p]);
                        y2 = this.convertY(pY[p], pY[p]);
                        x3 = this.convertX(this.midPt(pX[p], pX[p1]), this.midPt(pY[p], pY[p1]));
                        y3 = this.convertY(this.midPt(pX[p], pX[p1]), this.midPt(pY[p], pY[p1]));
                        if (debug) {
                            System.out.println(String.valueOf(p) + " cv,cv " + x1 + ' ' + y1 + ' ' + x2 + ' ' + y2 + ' ' + x3 + ' ' + y3);
                        }
                    } else if (!onCurve[p] && onCurve[p1]) {
                        x1 = this.convertX(this.midPt(pX[pm1], pX[p]), this.midPt(pY[pm1], pY[p]));
                        y1 = this.convertY(this.midPt(pX[pm1], pX[p]), this.midPt(pY[pm1], pY[p]));
                        x2 = this.convertX(pX[p], pY[p]);
                        y2 = this.convertY(pX[p], pY[p]);
                        x3 = this.convertX(pX[p1], pY[p1]);
                        y3 = this.convertY(pX[p1], pY[p1]);
                        if (debug) {
                            System.out.println(String.valueOf(p) + " cv,pt " + x1 + ' ' + y1 + ' ' + x2 + ' ' + y2 + ' ' + x3 + ' ' + y3);
                        }
                    }
                    current_path.curveTo(x1, y1, x2, y2, x3, y3);
                    if (checkEnd && endOfContour[j]) {
                        isEnd = true;
                        xs = this.convertX(pX[fc], pY[fc]);
                        ys = this.convertY(pX[fc], pY[fc]);
                        lc = fc;
                        int jj3 = j + 1;
                        while (jj3 < c) {
                            if (endOfContour[jj3]) {
                                fc = jj3 + 1;
                                jj3 = c;
                            }
                            ++jj3;
                        }
                        if (debug) {
                            System.out.println("Curve");
                        }
                    }
                }
                if (debug) {
                    System.out.println("x2 " + xs + ' ' + ys + ' ' + isEnd);
                }
                if (isEnd) {
                    current_path.moveTo(xs, ys);
                    isEnd = false;
                    if (debug) {
                        System.out.println("Move to " + x1 + ' ' + y1);
                    }
                }
            }
            ++j;
        }
        this.paths.addElement(current_path);
        if (debug) {
            System.out.println("Ends at " + x1 + ' ' + y1);
        }
    }

    private final int midPt(int a, int b) {
        return a + (b - a) / 2;
    }

    private final int convertX(int x, int y) {
        if (!this.isComposite) {
            return (int)((float)x / this.unitsPerEm);
        }
        return (int)(((double)x * this.xscale + (double)y * this.scale10 + (double)this.xtranslate) / (double)this.unitsPerEm);
    }

    private final int convertY(int x, int y) {
        if (!this.isComposite) {
            return (int)((float)y / this.unitsPerEm);
        }
        return (int)(((double)x * this.scale01 + (double)y * this.yscale + (double)this.ytranslate) / (double)this.unitsPerEm) + 30;
    }

    public float getmaxWidth() {
        return 0.0f;
    }

    public int getmaxHeight() {
        return 0;
    }

    public void lockColors(PdfPaint strokeColor, PdfPaint nonstrokeColor) {
    }

    public boolean ignoreColors() {
        return false;
    }

    public void flushArea() {
        this.glyphShape = null;
    }

    public void setWidth(float width) {
    }
}

