/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.fonts.tt;

import org.jpedal.fonts.tt.FontFile2;
import org.jpedal.fonts.tt.Table;
import org.jpedal.utils.LogWriter;

public class Loca
extends Table {
    int[] glyphIndexStart;

    public Loca(FontFile2 currentFontFile, int glyphCount, int format) {
        int startPointer = currentFontFile.selectTable(3);
        int i = 0;
        int locaLength = currentFontFile.getOffset(3);
        this.glyphIndexStart = new int[glyphCount + 1];
        if (startPointer != 0) {
            this.glyphIndexStart[0] = 0;
            if (format == 1) {
                if (locaLength / 4 != glyphCount + 1) {
                    LogWriter.writeLog("Incorrect length");
                }
                i = 0;
                while (i < glyphCount) {
                    this.glyphIndexStart[i] = currentFontFile.getNextUint32();
                    ++i;
                }
            } else {
                if (locaLength / 2 != glyphCount + 1) {
                    LogWriter.writeLog("Incorrect length");
                }
                i = 0;
                while (i < glyphCount) {
                    this.glyphIndexStart[i] = currentFontFile.getNextUint16() * 2;
                    ++i;
                }
            }
            this.glyphIndexStart[glyphCount] = currentFontFile.getOffset(4);
        }
    }

    public int[] getIndices() {
        return this.glyphIndexStart;
    }
}

