/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.fonts.tt;

import java.io.Serializable;
import org.jpedal.fonts.objects.FontData;

public class FontFile2
implements Serializable {
    private static final long serialVersionUID = -3097990864237320960L;
    public static final int HEAD = 0;
    public static final int MAPX = 1;
    public static final int CMAP = 2;
    public static final int LOCA = 3;
    public static final int GLYF = 4;
    public static final int HHEA = 5;
    public static final int HMTX = 6;
    public static final int NAME = 7;
    public static final int POST = 8;
    public static final int CVT = 9;
    public static final int FPGM = 10;
    public static final int HDMX = 11;
    public static final int KERN = 12;
    public static final int OS2 = 13;
    public static final int PREP = 14;
    public static final int DSIG = 15;
    public static final int CFF = 16;
    public static final int GSUB = 17;
    public static final int BASE = 18;
    public static final int EBDT = 19;
    public static final int EBLC = 20;
    public static final int GASP = 21;
    public static final int VHEA = 22;
    public static final int VMTX = 23;
    public static final int GDEF = 24;
    public static final int JSTF = 25;
    public static final int LTSH = 26;
    public static final int PCLT = 27;
    public static final int VDMX = 28;
    public static final int BSLN = 29;
    public static final int MORT = 30;
    public static final int FDSC = 31;
    private int tableCount = 32;
    private int[][] tables;
    private int[][] offsets;
    private FontData fontDataAsObject = null;
    private byte[] fontDataAsArray = null;
    private boolean useArray = true;
    private int pointer = 0;
    public static final int OPENTYPE = 1;
    public static final int TRUETYPE = 2;
    public static final int TTC = 3;
    int type = 2;
    private int currentFontID = 0;
    private int fontCount = 1;

    public FontFile2(FontData data) {
        this.useArray = false;
        this.fontDataAsObject = data;
        this.readHeader();
    }

    public FontFile2(byte[] data) {
        this.useArray = true;
        this.fontDataAsArray = data;
        this.readHeader();
    }

    public void setSelectedFontIndex(int currentFontID) {
        if (currentFontID < this.fontCount) {
            this.currentFontID = currentFontID;
        }
    }

    private final void readHeader() {
        int scalerType = this.getNextUint32();
        if (scalerType == 0x4F54544F) {
            this.type = 1;
        } else if (scalerType == 1953784678) {
            this.type = 3;
        }
        if (this.type == 3) {
            int version = this.getNextUint32();
            this.fontCount = this.getNextUint32();
            this.tables = new int[this.tableCount][this.fontCount];
            this.offsets = new int[this.tableCount][this.fontCount];
            int[] fontOffsets = new int[this.fontCount];
            int currentFont = 0;
            while (currentFont < this.fontCount) {
                int fontStart;
                this.currentFontID = currentFont;
                fontOffsets[currentFont] = fontStart = this.getNextUint32();
                ++currentFont;
            }
            currentFont = 0;
            while (currentFont < this.fontCount) {
                this.currentFontID = currentFont;
                this.pointer = fontOffsets[currentFont];
                scalerType = this.getNextUint32();
                this.readTablesForFont();
                ++currentFont;
            }
            this.currentFontID = 0;
        } else {
            this.tables = new int[this.tableCount][1];
            this.offsets = new int[this.tableCount][1];
            this.readTablesForFont();
        }
    }

    private void readTablesForFont() {
        int numTables = this.getNextUint16();
        int searchRange = this.getNextUint16();
        int entrySelector = this.getNextUint16();
        int rangeShift = this.getNextUint16();
        int l = 0;
        while (l < numTables) {
            String tag = this.getNextUint32AsTag();
            int checksum = this.getNextUint32();
            int offset = this.getNextUint32();
            int length = this.getNextUint32();
            int id = -1;
            if (tag.equals("maxp")) {
                id = 1;
            } else if (tag.equals("head")) {
                id = 0;
            } else if (tag.equals("cmap")) {
                id = 2;
            } else if (tag.equals("loca")) {
                id = 3;
            } else if (tag.equals("glyf")) {
                id = 4;
            } else if (tag.equals("hhea")) {
                id = 5;
            } else if (tag.equals("hmtx")) {
                id = 6;
            } else if (tag.equals("name")) {
                id = 7;
            } else if (tag.equals("post")) {
                id = 8;
            } else if (tag.equals("cvt ")) {
                id = 9;
            } else if (tag.equals("fpgm")) {
                id = 10;
            } else if (tag.equals("hdmx")) {
                id = 11;
            } else if (tag.equals("kern")) {
                id = 12;
            } else if (tag.equals("OS/2")) {
                id = 13;
            } else if (tag.equals("prep")) {
                id = 14;
            } else if (tag.equals("DSIG")) {
                id = 15;
            } else if (tag.equals("BASE")) {
                id = 18;
            } else if (tag.equals("CFF ")) {
                id = 16;
            } else if (tag.equals("GSUB")) {
                id = 17;
            } else if (tag.equals("EBDT")) {
                id = 19;
            } else if (tag.equals("EBLC")) {
                id = 20;
            } else if (tag.equals("gasp")) {
                id = 21;
            } else if (tag.equals("vhea")) {
                id = 22;
            } else if (tag.equals("vmtx")) {
                id = 23;
            } else if (tag.equals("GDEF")) {
                id = 24;
            } else if (tag.equals("JSTF")) {
                id = 25;
            } else if (tag.equals("LTSH")) {
                id = 26;
            } else if (tag.equals("PCLT")) {
                id = 27;
            } else if (tag.equals("VDMX")) {
                id = 28;
            } else if (tag.equals("mort")) {
                id = 30;
            } else if (tag.equals("bsln")) {
                id = 29;
            } else if (tag.equals("fdsc")) {
                id = 31;
            }
            if (id != -1) {
                this.tables[id][this.currentFontID] = offset;
                this.offsets[id][this.currentFontID] = length;
            }
            ++l;
        }
    }

    public int selectTable(int tableID) {
        this.pointer = this.tables[tableID][this.currentFontID];
        return this.pointer;
    }

    public int getTableSize(int tableID) {
        return this.offsets[tableID][this.currentFontID];
    }

    public final int getNextUint32() {
        int returnValue = 0;
        int nextValue = 0;
        int i = 0;
        while (i < 4) {
            nextValue = this.useArray ? this.fontDataAsArray[this.pointer] & 0xFF : this.fontDataAsObject.getByte(this.pointer) & 0xFF;
            returnValue += nextValue << 8 * (3 - i);
            ++this.pointer;
            ++i;
        }
        return returnValue;
    }

    public final int getNextUint64() {
        int returnValue = 0;
        int nextValue = 0;
        int i = 0;
        while (i < 8) {
            nextValue = this.useArray ? this.fontDataAsArray[this.pointer] : this.fontDataAsObject.getByte(this.pointer);
            if (nextValue < 0) {
                nextValue += 256;
            }
            returnValue += nextValue << 8 * (7 - i);
            ++this.pointer;
            ++i;
        }
        return returnValue;
    }

    public final void setPointer(int p) {
        this.pointer = p;
    }

    public final int getOffset(int tableID) {
        return this.offsets[tableID][this.currentFontID];
    }

    public final int getTable(int tableID) {
        return this.tables[tableID][this.currentFontID];
    }

    public final int getPointer() {
        return this.pointer;
    }

    public final String getNextUint32AsTag() {
        StringBuffer returnValue = new StringBuffer();
        int i = 0;
        while (i < 4) {
            char c = this.useArray ? (char)this.fontDataAsArray[this.pointer] : (char)this.fontDataAsObject.getByte(this.pointer);
            returnValue.append(c);
            ++this.pointer;
            ++i;
        }
        return returnValue.toString();
    }

    public final int getNextUint16() {
        int returnValue = 0;
        int i = 0;
        while (i < 2) {
            int nextValue = this.useArray ? this.fontDataAsArray[this.pointer] & 0xFF : this.fontDataAsObject.getByte(this.pointer) & 0xFF;
            returnValue += nextValue << 8 * (1 - i);
            ++this.pointer;
            ++i;
        }
        return returnValue;
    }

    public final short getShort() {
        int returnValue = 0;
        int i = 0;
        while (i < 2) {
            byte nextValue = this.useArray ? this.fontDataAsArray[this.pointer] : this.fontDataAsObject.getByte(this.pointer);
            returnValue += nextValue << 8 * (1 - i);
            ++this.pointer;
            ++i;
        }
        return (short)returnValue;
    }

    public final int getNextUint8() {
        int nextValue = this.useArray ? this.fontDataAsArray[this.pointer] & 0xFF : this.fontDataAsObject.getByte(this.pointer) & 0xFF;
        ++this.pointer;
        return nextValue;
    }

    public final int getNextint8() {
        byte nextValue = this.useArray ? this.fontDataAsArray[this.pointer] : this.fontDataAsObject.getByte(this.pointer);
        ++this.pointer;
        return nextValue;
    }

    public void skip(int i) {
        this.pointer += i;
    }

    public short getFWord() {
        int returnValue = 0;
        int i = 0;
        while (i < 2) {
            int nextValue = this.useArray ? this.fontDataAsArray[this.pointer] & 0xFF : this.fontDataAsObject.getByte(this.pointer) & 0xFF;
            returnValue += nextValue << 8 * (1 - i);
            ++this.pointer;
            ++i;
        }
        return (short)returnValue;
    }

    public short getNextInt16() {
        int returnValue = 0;
        int i = 0;
        while (i < 2) {
            int nextValue = this.useArray ? this.fontDataAsArray[this.pointer] & 0xFF : this.fontDataAsObject.getByte(this.pointer) & 0xFF;
            returnValue += nextValue << 8 * (1 - i);
            ++this.pointer;
            ++i;
        }
        return (short)returnValue;
    }

    public short getNextSignedInt16() {
        int returnValue = 0;
        int i = 0;
        while (i < 2) {
            int nextValue = this.useArray ? this.fontDataAsArray[this.pointer] & 0xFF : this.fontDataAsObject.getByte(this.pointer) & 0xFF;
            returnValue += nextValue << 8 * (1 - i);
            ++this.pointer;
            ++i;
        }
        return (short)returnValue;
    }

    public short readUFWord() {
        int returnValue = 0;
        int i = 0;
        while (i < 2) {
            int nextValue = this.useArray ? this.fontDataAsArray[this.pointer] & 0xFF : this.fontDataAsObject.getByte(this.pointer) & 0xFF;
            returnValue += nextValue << 8 * (1 - i);
            ++this.pointer;
            ++i;
        }
        return (short)returnValue;
    }

    public float getFixed() {
        int number = this.useArray ? (this.fontDataAsArray[this.pointer] & 0xFF) * 256 + (this.fontDataAsArray[this.pointer + 1] & 0xFF) : (this.fontDataAsObject.getByte(this.pointer) & 0xFF) * 256 + (this.fontDataAsObject.getByte(this.pointer + 1) & 0xFF);
        if (number > 32768) {
            number -= 65536;
        }
        this.pointer += 2;
        int dec = this.useArray ? (this.fontDataAsArray[this.pointer] & 0xFF) * 256 + (this.fontDataAsArray[this.pointer + 1] & 0xFF) : (this.fontDataAsObject.getByte(this.pointer) & 0xFF) * 256 + (this.fontDataAsObject.getByte(this.pointer + 1) & 0xFF);
        this.pointer += 2;
        return (float)number + (float)dec / 65536.0f;
    }

    public String getString() {
        StringBuffer value = new StringBuffer(10);
        int length = 0;
        length = this.useArray ? this.fontDataAsArray[this.pointer] & 0xFF : this.fontDataAsObject.getByte(this.pointer) & 0xFF;
        ++this.pointer;
        int i = 0;
        while (i < length) {
            int nextChar = this.useArray ? this.fontDataAsArray[this.pointer] & 0xFF : this.fontDataAsObject.getByte(this.pointer) & 0xFF;
            ++this.pointer;
            value.append((char)nextChar);
            ++i;
        }
        return value.toString();
    }

    public float getF2Dot14() {
        boolean isNegative;
        int firstValue = this.useArray ? ((this.fontDataAsArray[this.pointer] & 0xFF) << 8) + (this.fontDataAsArray[this.pointer + 1] & 0xFF) : ((this.fontDataAsObject.getByte(this.pointer) & 0xFF) << 8) + (this.fontDataAsObject.getByte(this.pointer + 1) & 0xFF);
        this.pointer += 2;
        if (firstValue == 49152) {
            return -1.0f;
        }
        if (firstValue == 16384) {
            return 1.0f;
        }
        boolean bl = isNegative = (firstValue & 0x8000) == 32768;
        if (isNegative) {
            return -((float)(firstValue & 0x8000) / 16384.0f);
        }
        return (float)firstValue / 16384.0f;
    }

    public byte[] readBytes(int startPointer, int length) {
        if (this.useArray) {
            byte[] block = new byte[length];
            System.arraycopy(this.fontDataAsArray, startPointer, block, 0, length);
            return block;
        }
        return this.fontDataAsObject.getBytes(startPointer, length);
    }

    public int getType() {
        return this.type;
    }

    public int getFontCount() {
        return this.fontCount;
    }
}

